/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.barcode.params;

import com.atid.lib.module.barcode.types.BarcodeType;
import com.atid.lib.util.diagnotics.ATLog;
import java.util.ArrayList;

public class SymbolStateList {
    private static final String TAG = SymbolStateList.class.getSimpleName();
    private static final int INFO = 5;
    private ArrayList<BarcodeParamItem> mTable = new ArrayList();

    public int getCount() {
        return this.mTable.size();
    }

    public BarcodeType getType(int position) {
        return this.mTable.get((int)position).mType;
    }

    public boolean getUsed(int position) {
        return this.mTable.get((int)position).mIsUsed;
    }

    public void setUsed(int position, boolean used) {
        this.mTable.get((int)position).mIsUsed = used;
    }

    public void clear() {
        this.mTable.clear();
        ATLog.i((String)TAG, (int)5, (String)"INFO. clear()");
    }

    public void add(BarcodeType type, boolean used) {
        this.mTable.add(new BarcodeParamItem(type, used));
    }

    public void addAll(SymbolStateList list) {
        this.mTable.addAll(list.mTable);
    }

    private class BarcodeParamItem {
        protected BarcodeType mType;
        protected boolean mIsUsed;

        private BarcodeParamItem(BarcodeType type, boolean used) {
            this.mType = type;
            this.mIsUsed = used;
        }
    }
}

