/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.transport.ble;

import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothManager;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import com.atid.lib.transport.ble.IBluetoothLeEvent;
import com.atid.lib.util.diagnotics.ATLog;
import com.atid.lib.util.diagnotics.Dump;

public class BluetoothLeService
extends Service {
    private final String TAG = BluetoothLeService.class.getSimpleName();
    private final int INFO = 7;
    private final int BLE_INFO_LEVEL = 10;
    private static final int STATE_DISCONNECTED = 0;
    private static final int STATE_CONNECTING = 1;
    private static final int STATE_CONNECTED = 2;
    private static final int STATE_DISCONNECTING = 3;
    private BluetoothManager mBluetoothManager = null;
    private BluetoothAdapter mBluetoothAdapter = null;
    private BluetoothGatt mBluetoothGatt = null;
    private IBluetoothLeEvent mBleEvent;
    private volatile int mConnectState = 0;
    private volatile boolean mIsSendPacket = false;
    private volatile boolean mIsSentPacket = false;
    private byte[] mSendData = null;
    private final IBinder mBinder = new LocalBinder();
    private final BluetoothGattCallback mGattCallback = new BluetoothGattCallback(){

        /*
         * Unable to fully structure code
         */
        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            ATLog.i((String)BluetoothLeService.access$0(BluetoothLeService.this), (int)7, (String)"EVENT. onConnectionStateChange() - status[%d] , newState[%d]", (Object[])new Object[]{status, newState});
            switch (newState) {
                case 2: {
                    BluetoothLeService.access$1(BluetoothLeService.this, 2);
                    BluetoothLeService.access$2(BluetoothLeService.this).cancelDiscovery();
                    try {
                        if (!BluetoothLeService.access$3(BluetoothLeService.this).discoverServices()) {
                            ATLog.e((String)BluetoothLeService.access$0(BluetoothLeService.this), (String)"ERROR. onConnectionStateChange(STATE_CONNECTED) - Failed to start service discovery");
                            return;
                        }
                    }
                    catch (Exception e) {
                        ATLog.e((String)BluetoothLeService.access$0(BluetoothLeService.this), (String)"ERROR. onConnectionStateChange(STATE_CONNECTED) - Failed to start service discovery , exception");
                        return;
                    }
                    ATLog.i((String)BluetoothLeService.access$0(BluetoothLeService.this), (int)7, (String)"EVENT. onConnectionStateChange(STATE_CONNECTED) - mConnectState[%d]", (Object[])new Object[]{BluetoothLeService.access$4(BluetoothLeService.this)});
                    break;
                }
                case 0: {
                    if (BluetoothLeService.access$4(BluetoothLeService.this) == 2) {
                        BluetoothLeService.access$3(BluetoothLeService.this).disconnect();
                    }
                    if (BluetoothLeService.access$3(BluetoothLeService.this) == null) ** GOTO lbl33
                    try {
                        try {
                            BluetoothLeService.access$3(BluetoothLeService.this).close();
                        }
                        catch (Exception e) {
                            ATLog.e((String)BluetoothLeService.access$0(BluetoothLeService.this), (String)"ERROR. onConnectionStateChange() - Failed to close(gatt) , exception");
                            BluetoothLeService.access$5(BluetoothLeService.this, null);
                            ** GOTO lbl33
                        }
                    }
                    catch (Throwable var5_6) {
                        BluetoothLeService.access$5(BluetoothLeService.this, null);
                        throw var5_6;
                    }
                    BluetoothLeService.access$5(BluetoothLeService.this, null);
lbl33:
                    // 3 sources

                    BluetoothLeService.access$1(BluetoothLeService.this, 0);
                    BluetoothLeService.access$6(BluetoothLeService.this).onDisconnected(status);
                    ATLog.i((String)BluetoothLeService.access$0(BluetoothLeService.this), (int)7, (String)"EVENT. onConnectionStateChange(STATE_DISCONNECTED) - state[%d]", (Object[])new Object[]{status});
                    break;
                }
                case 1: {
                    BluetoothLeService.access$1(BluetoothLeService.this, 1);
                    ATLog.i((String)BluetoothLeService.access$0(BluetoothLeService.this), (int)7, (String)"EVENT. onConnectionStateChange(STATE_CONNECTING)");
                    break;
                }
                case 3: {
                    BluetoothLeService.access$1(BluetoothLeService.this, 3);
                    ATLog.i((String)BluetoothLeService.access$0(BluetoothLeService.this), (int)7, (String)"EVENT. onConnectionStateChange(STATE_DISCONNECTING)");
                }
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            if (status != 0) {
                ATLog.e((String)BluetoothLeService.this.TAG, (String)"ERROR. onServicesDiscovered() - Failed to invalid status [0x%08X]", (Object[])new Object[]{status});
                return;
            }
            ATLog.i((String)BluetoothLeService.this.TAG, (int)7, (String)"EVENT. onServicesDiscovered() - status[%d] , mConnectState[%d]", (Object[])new Object[]{status, BluetoothLeService.this.mConnectState});
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            byte[] data = characteristic.getValue();
            ATLog.i((String)BluetoothLeService.this.TAG, (int)7, (String)"EVENT. onCharacteristicRead([%s])", (Object[])new Object[]{Dump.dump((byte[])data)});
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (BluetoothLeService.this.mConnectState == 2) {
                BluetoothLeService.this.mIsSentPacket = true;
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            byte[] data = (byte[])characteristic.getValue().clone();
            ATLog.i((String)BluetoothLeService.this.TAG, (int)7, (String)">>>> RECV. [%04d], [%s]", (Object[])new Object[]{data.length, Dump.dump((byte[])data)});
        }
    };

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public boolean onUnbind(Intent intent) {
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. onUnvind()");
        return super.onUnbind(intent);
    }

    public boolean isOpen() {
        return this.mConnectState == 2;
    }

    public void setBluetoothLeEvent(IBluetoothLeEvent e) {
        this.mBleEvent = e;
    }

    public boolean initialize() {
        if (this.mBluetoothManager == null) {
            this.mBluetoothManager = (BluetoothManager)this.getSystemService("bluetooth");
            if (this.mBluetoothManager == null) {
                ATLog.e((String)this.TAG, (String)"ERROR. initialize() - Unable to initialize BluetoothManager.");
                return false;
            }
        }
        this.mBluetoothAdapter = this.mBluetoothManager.getAdapter();
        if (this.mBluetoothAdapter == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. initialize() - Unable to obtain a BluetoothAdapter.");
            return false;
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. initialize()");
        return true;
    }

    static /* synthetic */ void access$1(BluetoothLeService bluetoothLeService, int n) {
        bluetoothLeService.mConnectState = n;
    }

    static /* synthetic */ BluetoothAdapter access$2(BluetoothLeService bluetoothLeService) {
        return bluetoothLeService.mBluetoothAdapter;
    }

    static /* synthetic */ BluetoothGatt access$3(BluetoothLeService bluetoothLeService) {
        return bluetoothLeService.mBluetoothGatt;
    }

    static /* synthetic */ void access$5(BluetoothLeService bluetoothLeService, BluetoothGatt bluetoothGatt) {
        bluetoothLeService.mBluetoothGatt = bluetoothGatt;
    }

    static /* synthetic */ IBluetoothLeEvent access$6(BluetoothLeService bluetoothLeService) {
        return bluetoothLeService.mBleEvent;
    }

    public class LocalBinder
    extends Binder {
        public BluetoothLeService getService() {
            return BluetoothLeService.this;
        }
    }
}

