/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.atx88.protocol;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.atid.lib.protocol.IProtocolEventListener;
import com.atid.lib.protocol.Response;
import com.atid.lib.reader.protocol.ATProtocol;
import com.atid.lib.transport.ATransport;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.SysUtil;
import com.atid.lib.util.collections.ByteQueue;
import com.atid.lib.util.diagnotics.ATLog;
import com.atid.lib.util.diagnotics.Dump;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Locale;

public class ATProtocolATx88
extends ATProtocol {
    private static final int MAX_BUFFER = 4096;
    private static final byte PACK_PREFIX = 126;
    private static final byte PACK_SUFFIX1 = 13;
    private static final byte PACK_SUFFIX2 = 10;
    private static final byte[] PACK_SUFFIX = new byte[]{13, 10};
    private static final int PREFIX_LENGTH = 1;
    private static final int CMD_LENGTH = 1;
    private static final int SUB_CMD_LENGTH = 1;
    private static final int BARCODE_PARAM_LENGTH = 1;
    private static final int MIN_PACK_LENGTH = 5;
    private static final int MIN_RES_PACK_LENGTH = 5;
    private static final int RES_CODE_LENGTH = 4;
    private static final boolean CHECK_BARCODE_MIX_DATA_FOR_PARSING = true;
    private IProtocolEventListener mListener;
    private final Object syncThread = new Object();
    private volatile ParseThread mRecvThread;
    private ByteQueue mRecvData;
    private ArrayList<Packet> mPackets;
    private EventThread mEventThread;

    public ATProtocolATx88(ATransport transport, IProtocolEventListener listener) {
        super(transport);
        this.TAG = ATProtocolATx88.class.getSimpleName();
        this.mListener = listener;
        this.mRecvThread = null;
        this.mRecvData = new ByteQueue();
        this.mPackets = new ArrayList();
        this.mEventThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        if (this.mRecvThread != null) {
            ATLog.i((String)this.TAG, (int)7, (String)"INFO, start() - Already Thread starting.");
            return true;
        }
        Object object = this.mPackets;
        synchronized (object) {
            this.mPackets.clear();
        }
        object = this.syncThread;
        synchronized (object) {
            this.mRecvThread = new ParseThread();
            this.mRecvThread.start();
            this.mEventThread = new EventThread();
            this.mEventThread.start();
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO, start()");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.mRecvThread == null) {
            return;
        }
        ArrayList<Packet> arrayList = this.syncThread;
        synchronized (arrayList) {
            this.mRecvThread.interrupt();
            this.mRecvThread.cancel();
            this.mRecvThread = null;
            if (this.mEventThread.isAlive()) {
                this.mEventThread.cancel();
                try {
                    this.mEventThread.join();
                }
                catch (InterruptedException e) {
                    ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. stop() - Failed to wait terminate event thread", (Object[])new Object[0]);
                }
            }
            this.mEventThread = null;
        }
        arrayList = this.mPackets;
        synchronized (arrayList) {
            this.mPackets.clear();
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO, stop()");
    }

    public synchronized ResultCode post(byte[] data) {
        if (data == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. post() - Invalid null data");
            return ResultCode.SendFail;
        }
        if (this.mTransport.write(data) <= 0) {
            ATLog.e((String)this.TAG, (String)"ERROR. post([%s]) - Failed to send packet", (Object[])new Object[]{Dump.dump((byte[])data)});
            return ResultCode.SendFail;
        }
        if (ATLog.isLogging((int)8)) {
            ATLog.i((String)this.TAG, (int)8, (String)"<<< SEND. [%4d], [%s]", (Object[])new Object[]{data.length, Dump.dump((byte[])data)});
        }
        return ResultCode.NoError;
    }

    public synchronized ResultCode post(byte cmd, byte sub, byte[] data) {
        byte[] sendBytes = null;
        sendBytes = this.build(cmd, sub, data);
        if (sendBytes == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. post([%c], [%c], [%s]) - Failed to build send packet", (Object[])new Object[]{cmd, sub, Dump.dump((byte[])data)});
            return ResultCode.InvalidSendPacket;
        }
        if (this.mTransport.write(sendBytes) <= 0) {
            ATLog.e((String)this.TAG, (String)"ERROR. post([%c], [%c], [%s]) - Failed to send packet", (Object[])new Object[]{cmd, sub, Dump.dump((byte[])data)});
            return ResultCode.SendFail;
        }
        if (ATLog.isLogging((int)8)) {
            ATLog.i((String)this.TAG, (int)8, (String)"<<< SEND. [%4d], [%s]", (Object[])new Object[]{sendBytes.length, Dump.dump((byte[])sendBytes)});
        }
        return ResultCode.NoError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Response send(byte cmd, byte sub, byte[] data, int timeout) {
        Packet pack = new Packet(cmd, sub, data);
        byte[] sendBytes = null;
        long tick = 0L;
        Response res = null;
        sendBytes = pack.toBytes();
        if (sendBytes == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. send([%c], [%c], [%s], %d) - Failed to build send packet", (Object[])new Object[]{cmd, sub, Dump.dump((byte[])data), timeout});
            return new Response(ResultCode.InvalidSendPacket);
        }
        ArrayList<Packet> arrayList = this.mPackets;
        synchronized (arrayList) {
            this.mPackets.add(pack);
        }
        if (this.mTransport.write(sendBytes) <= 0) {
            ATLog.e((String)this.TAG, (String)"ERROR. send([%c], [%c], [%s], %d) - Failed to send packet", (Object[])new Object[]{cmd, sub, Dump.dump((byte[])data), timeout});
            arrayList = this.mPackets;
            synchronized (arrayList) {
                this.mPackets.remove(pack);
            }
            return new Response(ResultCode.SendFail);
        }
        if (ATLog.isLogging((int)8)) {
            ATLog.i((String)this.TAG, (int)8, (String)"<<< SEND. [%4d], [%s]", (Object[])new Object[]{sendBytes.length, Dump.dump((byte[])sendBytes)});
        }
        tick = System.currentTimeMillis();
        while (!pack.isResponse()) {
            if (System.currentTimeMillis() - tick > (long)timeout) {
                ATLog.e((String)this.TAG, (String)"ERROR. send([%c], [%c], [%s], %d) - Failed to response timeout", (Object[])new Object[]{cmd, sub, Dump.dump((byte[])data), timeout});
                arrayList = this.mPackets;
                synchronized (arrayList) {
                    this.mPackets.remove(pack);
                }
                return new Response(ResultCode.ReceiveTimeout);
            }
            SysUtil.sleep((int)10);
        }
        try {
            res = new Response(pack.getResponse());
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (String)"ERROR. send([%c], [%c], [%s], %d) - Failed to invalid response", (Object[])new Object[]{cmd, sub, Dump.dump((byte[])data), timeout});
            ArrayList<Packet> arrayList2 = this.mPackets;
            synchronized (arrayList2) {
                this.mPackets.remove(pack);
            }
            return new Response(ResultCode.InvalidReceivePacket);
        }
        arrayList = this.mPackets;
        synchronized (arrayList) {
            this.mPackets.remove(pack);
        }
        return res;
    }

    private byte[] build(int cmd, int sub, byte[] data) {
        byte[] pack = new byte[(data == null ? 0 : data.length) + 5];
        int pos = 0;
        try {
            pack[pos++] = 126;
            pack[pos++] = (byte)cmd;
            pack[pos++] = (byte)sub;
            if (data != null && data.length > 0) {
                System.arraycopy(data, 0, pack, 3, data.length);
                pos += data.length;
            }
            pack[pos++] = 13;
            pack[pos++] = 10;
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. build() - Failed to build packet bytes", (Object[])new Object[0]);
            return null;
        }
        return pack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet findPacket(int cmd, int sub) {
        ArrayList<Packet> arrayList = this.mPackets;
        synchronized (arrayList) {
            for (Packet pack : this.mPackets) {
                if (pack.getCommand() != cmd || pack.getSubCode() != sub) continue;
                return pack;
            }
        }
        return null;
    }

    private int parseParam(int pos, int cmd, int sub) {
        int length;
        int sendCmd = 0;
        int end = -1;
        int findPos = 0;
        int size = 0;
        byte[] data = null;
        Packet pack = null;
        if (cmd == 82 && sub == 72) {
            size = this.mRecvData.peek(pos + 4);
            findPos = this.mRecvData.getPos(pos + size + 4 + 1);
        } else {
            findPos = pos;
        }
        if (cmd == 82 && sub == 72 && (length = this.mRecvData.getSize()) < (size += 8 + PACK_SUFFIX.length)) {
            ATLog.e((String)this.TAG, (String)"ERROR. parseParam(%d, [%c], [%c]) - Not enough receive packet length [%d] , [%d]", (Object[])new Object[]{pos, cmd, sub, length, size});
            return 0;
        }
        end = this.mRecvData.findPattern(findPos, PACK_SUFFIX);
        if (end < 0) {
            ATLog.e((String)this.TAG, (String)"ERROR. parseParam(%d, [%c], [%c]) - Failed to find suffix [%d]", (Object[])new Object[]{pos, cmd, sub, end});
            return 0;
        }
        if (this.mRecvData.getSize(pos, end) < 4) {
            ATLog.e((String)this.TAG, (String)"ERROR. parseParam(%d, [%c], [%c]) - Not enough receive packet length", (Object[])new Object[]{pos, cmd, sub});
            return 0;
        }
        sendCmd = cmd + 32;
        pack = this.findPacket(sendCmd, sub);
        if (pack == null) {
            if (cmd == 82 && sub == 101) {
                data = this.mRecvData.peek(pos, end);
                if (data == null) {
                    ATLog.e((String)this.TAG, (String)"ERROR. parseParam(%d, [%c], [%c]) - Failed to get battert data ", (Object[])new Object[]{pos, cmd, sub});
                    return end + PACK_SUFFIX.length;
                }
                this.mEventThread.postEvent(82, sub, data);
            } else {
                ATLog.e((String)this.TAG, (String)"ERROR. parseParam(%d, [%c], [%c]) - Failed to find sub command", (Object[])new Object[]{pos, cmd, sub});
            }
            return end + PACK_SUFFIX.length;
        }
        data = this.mRecvData.peek(pos, end);
        if (data == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. parseParam(%d, [%c], [%c]) - Failed to find suffix", (Object[])new Object[]{pos, cmd, sub});
            return end + PACK_SUFFIX.length;
        }
        pack.setResponse(data);
        if (ATLog.isLogging((int)7)) {
            ATLog.i((String)this.TAG, (int)7, (String)"INFO. parseParam(%d, [%c], [%c]) - [%d]", (Object[])new Object[]{pos, cmd, sub, end + PACK_SUFFIX.length});
        }
        return end + PACK_SUFFIX.length;
    }

    private int parseAction(int pos, int sub) {
        int end = -1;
        byte[] data = null;
        end = this.mRecvData.findPattern(pos, PACK_SUFFIX);
        if (end < 0) {
            ATLog.e((String)this.TAG, (String)"ERROR. parseAction(%d, [%c]) - Failed to find suffix", (Object[])new Object[]{pos, sub});
            return 0;
        }
        if (this.mRecvData.getSize(pos, end) < 4) {
            ATLog.e((String)this.TAG, (String)"ERROR. parseAction(%d, [%c]) - Not enough receive packet length", (Object[])new Object[]{pos, sub});
            return 0;
        }
        data = this.mRecvData.peek(pos, end);
        if (data == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. parseAction(%d, [%c]) - Failed to find suffix", (Object[])new Object[]{pos, sub});
            return end + PACK_SUFFIX.length;
        }
        if (this.mListener != null && this.mEventThread != null) {
            this.mEventThread.postEvent(65, sub, data);
        }
        if (ATLog.isLogging((int)7)) {
            ATLog.i((String)this.TAG, (int)7, (String)"INFO. parseAction(%d, [%c]) - [%d]", (Object[])new Object[]{pos, sub, end + PACK_SUFFIX.length});
        }
        return end + PACK_SUFFIX.length;
    }

    private int parseEvent(int pos, int sub, int length) {
        int dataLength;
        int end = -1;
        byte[] data = null;
        end = this.mRecvData.findPattern(pos, PACK_SUFFIX);
        if (end < 0) {
            ATLog.i((String)this.TAG, (int)7, (String)"INFO. parseEvent(%d, [%c], %d) - suffix not found", (Object[])new Object[]{pos, sub, length});
            return 0;
        }
        data = this.mRecvData.peek(pos, end);
        if (data == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. parseEvent(%d, [%c], %d) - Failed to peek data", (Object[])new Object[]{pos, sub, length});
            return end + PACK_SUFFIX.length;
        }
        if (sub == 67 && (dataLength = data.length + 1 + 1 + 1 + PACK_SUFFIX.length) < length) {
            long TIMEOUT = 500L;
            long startTime = System.currentTimeMillis();
            boolean isFound = false;
            while (!isFound && System.currentTimeMillis() - startTime < 500L) {
                if (data.length + PACK_SUFFIX.length < length) {
                    byte[] temp = this.mRecvData.peek(end + PACK_SUFFIX.length, end + PACK_SUFFIX.length + 1);
                    if (temp[0] != 126) {
                        if ((end = this.mRecvData.findPattern(end + 1, PACK_SUFFIX)) < 0) {
                            ATLog.i((String)this.TAG, (int)7, (String)"INFO. parseEvent(%d, [%c], %d) - suffix not found for Mixed suffix data checking", (Object[])new Object[]{pos, sub, length});
                            return 0;
                        }
                        data = this.mRecvData.peek(pos, end);
                        if (data != null) continue;
                        ATLog.e((String)this.TAG, (String)"ERROR. parseEvent(%d, [%c], %d) - Failed to peek data", (Object[])new Object[]{pos, sub, length});
                        return end + PACK_SUFFIX.length;
                    }
                    dataLength = data.length + 1 + 1 + 1 + PACK_SUFFIX.length;
                    if (dataLength >= length) continue;
                    isFound = true;
                    continue;
                }
                isFound = true;
            }
        }
        if (this.mListener != null && this.mEventThread != null) {
            this.mEventThread.postEvent(101, sub, data);
        }
        if (ATLog.isLogging((int)7)) {
            ATLog.i((String)this.TAG, (int)7, (String)"INFO. parseEvent(%d, [%c], %d) - [%d]", (Object[])new Object[]{pos, sub, length, end + PACK_SUFFIX.length});
        }
        return end + PACK_SUFFIX.length;
    }

    private int parseSetDevice(int pos, int cmd, int sub) {
        int sendCmd = 0;
        int end = -1;
        byte[] data = null;
        Packet pack = null;
        end = this.mRecvData.findPattern(pos, PACK_SUFFIX);
        if (end < 0) {
            ATLog.e((String)this.TAG, (String)"ERROR. parseSetDevice(%d, [%c], [%c]) - Failed to find suffix [%d]", (Object[])new Object[]{pos, cmd, sub, end});
            return 0;
        }
        if (this.mRecvData.getSize(pos, end) < 4) {
            ATLog.e((String)this.TAG, (String)"ERROR. parseSetDevice(%d, [%c], [%c]) - Not enough receive packet length", (Object[])new Object[]{pos, cmd, sub});
            return 0;
        }
        sendCmd = cmd + 32;
        pack = this.findPacket(sendCmd, sub);
        if (pack == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. parseSetDevice(%d, [%c], [%c]) - Failed to find sub command", (Object[])new Object[]{pos, cmd, sub});
            return end + PACK_SUFFIX.length;
        }
        data = this.mRecvData.peek(pos, end);
        if (data == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. parseSetDevice(%d, [%c], [%c]) - Failed to find suffix", (Object[])new Object[]{pos, cmd, sub});
            return end + PACK_SUFFIX.length;
        }
        pack.setResponse(data);
        if (ATLog.isLogging((int)7)) {
            ATLog.i((String)this.TAG, (int)7, (String)"INFO. parseSetDevice(%d, [%c], [%c]) - [%d]", (Object[])new Object[]{pos, cmd, sub, end + PACK_SUFFIX.length});
        }
        return end + PACK_SUFFIX.length;
    }

    private int parseDebug(int pos, int sub) {
        int sendCmd = 0;
        int end = -1;
        byte[] data = null;
        Packet pack = null;
        end = this.mRecvData.findPattern(pos, PACK_SUFFIX);
        if (end < 0) {
            ATLog.e((String)this.TAG, (String)"ERROR. parseDebug(%d, [%c]) - Failed to find suffix", (Object[])new Object[]{pos, sub});
            return 0;
        }
        if (this.mRecvData.getSize(pos, end) < 4) {
            ATLog.e((String)this.TAG, (String)"ERROR. parseDebug(%d, [%c]) - Not enough receive packet length", (Object[])new Object[]{pos, sub});
            return 0;
        }
        sendCmd = 100;
        pack = this.findPacket(sendCmd, sub);
        if (pack == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. parseDebug(%d, [%c]) - Failed to find sub command", (Object[])new Object[]{pos, sub});
            return end + PACK_SUFFIX.length;
        }
        data = this.mRecvData.peek(pos, end);
        if (data == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. parseDebug(%d, [%c]) - Failed to find suffix", (Object[])new Object[]{pos, sub});
            return end + PACK_SUFFIX.length;
        }
        pack.setResponse(data);
        if (ATLog.isLogging((int)7)) {
            ATLog.i((String)this.TAG, (int)7, (String)"INFO. parseDebug(%d, [%c]) - [%d]", (Object[])new Object[]{pos, sub, end + PACK_SUFFIX.length});
        }
        return end + PACK_SUFFIX.length;
    }

    private int parseError(int pos, int sub) {
        int end = -1;
        byte[] data = null;
        String value = "";
        end = this.mRecvData.findPattern(pos, PACK_SUFFIX);
        if (end < 0) {
            ATLog.e((String)this.TAG, (String)"ERROR. parseError(%d, [%c]) - Failed to find suffix", (Object[])new Object[]{pos, sub});
            return 0;
        }
        data = this.mRecvData.peek(pos, end);
        if (data == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. parseError(%d, [%c]) - Failed to find suffix", (Object[])new Object[]{pos, sub});
            return end + PACK_SUFFIX.length;
        }
        value = new String(data, Charset.forName("ASCII"));
        if (ATLog.isLogging((int)7)) {
            ATLog.i((String)this.TAG, (int)7, (String)"INFO. parseError(%d, [%c]) - [%s]", (Object[])new Object[]{pos, sub, value});
        }
        return end + PACK_SUFFIX.length;
    }

    private class EventThread
    extends HandlerThread
    implements Handler.Callback {
        private static final String THREAD_NAME = "EventThread";
        private static final int PROTOCOL_EVENT = 1000;
        private Handler mHandler;

        public EventThread() {
            super(THREAD_NAME);
            this.mHandler = null;
        }

        public void postEvent(int cmd, int sub, byte[] data) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1000, cmd, sub, (Object)data));
        }

        public void cancel() {
            this.mHandler.getLooper().quit();
        }

        public void run() {
            Looper.prepare();
            this.mHandler = new Handler((Handler.Callback)this);
            Looper.loop();
        }

        public boolean handleMessage(Message msg) {
            if (msg.what == 1000) {
                if (ATProtocolATx88.this.mListener != null) {
                    ATProtocolATx88.this.mListener.onEvent(msg.arg1, msg.arg2, (byte[])msg.obj);
                }
                return true;
            }
            return false;
        }
    }

    private class Packet {
        private int mCmd;
        private int mSub;
        private byte[] mData;
        private byte[] mRes;

        private Packet(int cmd, int sub, byte[] data) {
            this.mCmd = cmd;
            this.mSub = sub;
            this.mData = data;
            this.mRes = null;
        }

        public int getCommand() {
            return this.mCmd;
        }

        public int getSubCode() {
            return this.mSub;
        }

        public byte[] getData() {
            return this.mData;
        }

        public synchronized boolean isResponse() {
            return this.mRes != null;
        }

        public synchronized void setResponse(byte[] res) {
            this.mRes = res;
        }

        public synchronized byte[] getResponse() {
            return this.mRes;
        }

        public byte[] toBytes() {
            return ATProtocolATx88.this.build(this.mCmd, this.mSub, this.mData);
        }

        public String toString() {
            return String.format(Locale.US, "[%c], [%c], [%s]", this.mCmd, this.mSub, Dump.dump((byte[])this.mData));
        }
    }

    private class ParseThread
    extends Thread {
        private volatile boolean mIsAlive = false;

        private ParseThread() {
        }

        @Override
        public void run() {
            byte[] recvBuf = new byte[4096];
            int recvBytes = 0;
            int queueSize = 0;
            boolean OFFSET = false;
            int pos = 0;
            int cmd = 0;
            int sub = 0;
            int size = 0;
            int barcodeMixDataSize = 0;
            this.mIsAlive = true;
            ATLog.i((String)ATProtocolATx88.this.TAG, (int)7, (String)"+++ INFO. $ParseThread.run()");
            block10: while (this.mIsAlive && !Thread.currentThread().isInterrupted()) {
                recvBytes = ATProtocolATx88.this.mTransport.read(recvBuf);
                if (recvBytes == 0) continue;
                if (recvBytes < 0) {
                    ATLog.e((String)ATProtocolATx88.this.TAG, (String)"ERROR. $ParseThread.run() - Failed to read the transport");
                    break;
                }
                if (ATLog.isLogging((int)8)) {
                    ATLog.i((String)ATProtocolATx88.this.TAG, (int)8, (String)">>> RECV.[%s,<%s>] [%4d], [%s]", (Object[])new Object[]{ATProtocolATx88.this.mTransport.getDeviceType(), ATProtocolATx88.this.mTransport.getAddress(), recvBytes, Dump.dump((byte[])recvBuf, (int)recvBytes)});
                }
                try {
                    queueSize = ATProtocolATx88.this.mRecvData.enqueue(recvBuf, 0, recvBytes);
                }
                catch (Exception e) {
                    ATLog.e((String)ATProtocolATx88.this.TAG, (Throwable)e, (String)"ERROR. $ParseThread.run() - Failed to enqueue receive data", (Object[])new Object[0]);
                    continue;
                }
                if (queueSize < 5) {
                    if (!ATLog.isLogging((int)9)) continue;
                    ATLog.i((String)ATProtocolATx88.this.TAG, (int)9, (String)"@@@@ DEBUG. $ParseThread.run() - Failed to not enough buffer length");
                    continue;
                }
                pos = ATProtocolATx88.this.mRecvData.findKey(126);
                if (pos < 0) {
                    if (!ATLog.isLogging((int)9)) continue;
                    ATLog.i((String)ATProtocolATx88.this.TAG, (int)9, (String)"@@@@ DEBUG. $ParseThread.run() - Failed to not found prefix");
                    continue;
                }
                size = ATProtocolATx88.this.mRecvData.getSize(pos);
                if (size < 5) {
                    if (!ATLog.isLogging((int)9)) continue;
                    ATLog.i((String)ATProtocolATx88.this.TAG, (int)9, (String)"@@@@ DEBUG. $ParseThread.run() - Failed to not enough packet length");
                    continue;
                }
                barcodeMixDataSize += size;
                while (this.mIsAlive) {
                    ++pos;
                    pos %= ATProtocolATx88.this.mRecvData.getQueueSize();
                    cmd = 0xFF & ATProtocolATx88.this.mRecvData.peek(pos++);
                    pos %= ATProtocolATx88.this.mRecvData.getQueueSize();
                    sub = 0xFF & ATProtocolATx88.this.mRecvData.peek(pos++);
                    pos %= ATProtocolATx88.this.mRecvData.getQueueSize();
                    switch (cmd) {
                        case 82: 
                        case 87: {
                            pos = ATProtocolATx88.this.parseParam(pos, cmd, sub);
                            break;
                        }
                        case 65: {
                            pos = ATProtocolATx88.this.parseAction(pos, sub);
                            break;
                        }
                        case 101: {
                            pos = ATProtocolATx88.this.parseEvent(pos, sub, barcodeMixDataSize);
                            break;
                        }
                        case 72: {
                            pos = ATProtocolATx88.this.parseSetDevice(pos, cmd, sub);
                            break;
                        }
                        case 68: {
                            pos = ATProtocolATx88.this.parseDebug(pos, sub);
                            break;
                        }
                        case 69: {
                            pos = ATProtocolATx88.this.parseError(pos, sub);
                            break;
                        }
                        default: {
                            ATLog.e((String)ATProtocolATx88.this.TAG, (String)"ERROR. Unknown command[0x%02X] %d", (Object[])new Object[]{cmd, pos});
                        }
                    }
                    if (pos <= 0) continue block10;
                    barcodeMixDataSize = 0;
                    ATProtocolATx88.this.mRecvData.setFront(pos);
                    pos = ATProtocolATx88.this.mRecvData.findKey(126);
                    if (pos < 0) {
                        if (!ATLog.isLogging((int)9)) continue block10;
                        ATLog.i((String)ATProtocolATx88.this.TAG, (int)9, (String)"@@@@ DEBUG. $ParseThread.run() - Failed to not found prefix");
                        continue block10;
                    }
                    size = ATProtocolATx88.this.mRecvData.getSize(pos);
                    if (size < 5) {
                        if (!ATLog.isLogging((int)9)) continue block10;
                        ATLog.i((String)ATProtocolATx88.this.TAG, (int)9, (String)"@@@@ DEBUG. $ParseThread.run() - Failed to not enough packet length");
                        continue block10;
                    }
                    SysUtil.sleep((int)0);
                }
            }
            ATLog.i((String)ATProtocolATx88.this.TAG, (int)7, (String)"--- INFO. $ParseThread.run()");
        }

        private void cancel() {
            if (this.isAlive()) {
                this.mIsAlive = false;
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    ATLog.e((String)ATProtocolATx88.this.TAG, (Throwable)e, (String)"ERROR. cancel() - Failed to wait terminate parse thread", (Object[])new Object[0]);
                }
            }
        }
    }
}

