/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.util.diagnotics;

import android.os.Build;
import android.os.Environment;
import android.util.Log;
import com.atid.lib.util.SysUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Queue;
import java.util.Stack;

public class ATLog {
    private static final String TAG = ATLog.class.getSimpleName();
    public static final int ERROR = 0;
    public static final int WARN = 1;
    public static final int DEBUG = 2;
    public static final int L1 = 2;
    public static final int L2 = 3;
    public static final int L3 = 4;
    public static final int L4 = 5;
    public static final int INFO = 6;
    public static final int INTER = 7;
    public static final int IO = 8;
    public static final int DUMP = 9;
    private static final int DEFAULT_LOG_LEVEL = 0;
    private static final String PREFIX_DEBUG = "D";
    private static final String PREFIX_VERBOSE = "V";
    private static final String PREFIX_INFO = "I";
    private static final String PREFIX_WARN = "W";
    private static final String PREFIX_ERROR = "E";
    private static final int REMAIN_FILE_COUNT = 3;
    private static final boolean LOG = false;
    private static volatile int mLevel = 0;
    private static volatile Queue<QueueItem> mQueue = null;
    private static final Object syncLogThread = new Object();
    private static volatile Thread mLogThread = null;
    private static volatile boolean mIsAliveLogThread = false;
    private static String mLogPath = "";
    private static String mLogName = "";
    private static volatile BufferedWriter mWriter = null;
    private static Thread.UncaughtExceptionHandler mUncaughtExceptionHandler = null;
    private static volatile Stack<ILoggingCheckPermissionListener> mListeners = null;
    private static Runnable mLogThreadPoc = new Runnable(){
        int size = 0;
        boolean isEmpty = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block25: {
                ATLog.access$0(true);
                ATLog.access$2(ATLog.access$1(), "INFO. Begin log thread");
                ATLog.access$3();
                while (ATLog.access$4()) {
                    if (ATLog.access$5() == null) {
                        SysUtil.sleep(100);
                        continue;
                    }
                    var1_1 = ATLog.access$5();
                    synchronized (var1_1) {
                        this.size = ATLog.access$5().size();
                        this.isEmpty = ATLog.access$5().isEmpty();
                    }
                    if (this.size > 0 && !this.isEmpty) {
                        var1_1 = ATLog.access$5();
                        synchronized (var1_1) {
                            try {
                                item = (QueueItem)ATLog.access$5().poll();
                                if (item != null) {
                                    ATLog.access$6(item);
                                }
                            }
                            catch (Exception e) {
                                ATLog.access$7(ATLog.access$1(), e, "ERROR. Failed to write log");
                            }
                        }
                        SysUtil.sleep(5);
                        continue;
                    }
                    SysUtil.sleep(100);
                }
                if (ATLog.access$5() == null) break block25;
                var1_1 = ATLog.access$5();
                synchronized (var1_1) {
                    this.size = ATLog.access$5().size();
                    this.isEmpty = ATLog.access$5().isEmpty();
                    // MONITOREXIT @DISABLED, blocks:[3, 7] lbl45 : MonitorExitStatement: MONITOREXIT : var1_1
                    if (true) ** GOTO lbl60
                }
                do {
                    var1_1 = ATLog.access$5();
                    synchronized (var1_1) {
                        try {
                            item = (QueueItem)ATLog.access$5().poll();
                            if (item != null) {
                                ATLog.access$6(item);
                            }
                            this.size = ATLog.access$5().size();
                            this.isEmpty = ATLog.access$5().isEmpty();
                        }
                        catch (Exception e) {
                            ATLog.access$7(ATLog.access$1(), e, "ERROR. Failed to write log");
                        }
                    }
lbl60:
                    // 3 sources

                } while (this.size > 0 && !this.isEmpty);
            }
            if (ATLog.access$8() != null) {
                try {
                    ATLog.access$8().flush();
                    ATLog.access$8().close();
                }
                catch (IOException e) {
                    ATLog.access$7(ATLog.access$1(), e, "ERROR. Failed to close file writer");
                }
            }
            ATLog.access$2(ATLog.access$1(), "INFO. End log thread");
        }
    };

    public static void startUp(String path, String name) {
        ATLog.startUp(0, path, name, null);
    }

    public static void startUp(String path, String name, ILoggingCheckPermissionListener listener) {
        ATLog.startUp(0, path, name, listener);
    }

    public static void startUp(int level, String path, String name) {
        ATLog.startUp(level, path, name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startUp(int level, String path, String name, ILoggingCheckPermissionListener listener) {
        mUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new ATUncaughtExceptionHandler());
        if (listener != null) {
            Stack<ILoggingCheckPermissionListener> stack = mListeners;
            synchronized (stack) {
                mListeners = new Stack();
                mListeners.push(listener);
            }
        }
        mLogPath = path;
        mLogName = name;
        mIsAliveLogThread = false;
        mLogThread = null;
        ATLog.INFO(TAG, String.format("INFO. startUp([%s], [%s])", path, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Stack<ILoggingCheckPermissionListener> stack;
        if (mLogThread == null && mQueue == null) {
            return;
        }
        if (mLogThread != null) {
            stack = syncLogThread;
            synchronized (stack) {
                if (mLogThread.isAlive()) {
                    mIsAliveLogThread = false;
                    try {
                        mLogThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            mLogThread = null;
        }
        if (mListeners != null) {
            stack = mListeners;
            synchronized (stack) {
                mListeners.clear();
            }
        }
        mQueue = null;
        ATLog.INFO(TAG, "INFO. shutdown()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushListener(ILoggingCheckPermissionListener listener) {
        if (listener == null) {
            return;
        }
        if (mListeners != null) {
            Stack<ILoggingCheckPermissionListener> stack = mListeners;
            synchronized (stack) {
                mListeners.push(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void popListener() {
        if (mListeners == null) {
            return;
        }
        Stack<ILoggingCheckPermissionListener> stack = mListeners;
        synchronized (stack) {
            if (mListeners.size() <= 1) {
                return;
            }
            mListeners.pop();
        }
    }

    public static int getLogLevel() {
        return mLevel;
    }

    public static void setLogLevel(int level) {
        mLevel = level;
    }

    public static boolean isLogging(int level) {
        return level <= mLevel;
    }

    public static void v(String tag, int level, String format, Object ... args) {
        if (level > mLevel) {
            return;
        }
        ATLog.v(tag, level, String.format(Locale.US, format, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void v(String tag, int level, String msg) {
        if (level > mLevel) {
            return;
        }
        if (mQueue != null) {
            Queue<QueueItem> queue = mQueue;
            synchronized (queue) {
                mQueue.offer(new QueueItem(System.currentTimeMillis(), PREFIX_VERBOSE, tag, msg));
            }
        }
        Log.v((String)tag, (String)msg);
    }

    public static void d(String tag, int level, String format, Object ... args) {
        if (level > mLevel) {
            return;
        }
        ATLog.d(tag, level, String.format(Locale.US, format, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void d(String tag, int level, String msg) {
        if (level > mLevel) {
            return;
        }
        if (mQueue != null) {
            Queue<QueueItem> queue = mQueue;
            synchronized (queue) {
                mQueue.offer(new QueueItem(System.currentTimeMillis(), PREFIX_DEBUG, tag, msg));
            }
        }
        Log.d((String)tag, (String)msg);
    }

    public static void i(String tag, int level, String format, Object ... args) {
        if (level > mLevel) {
            return;
        }
        ATLog.i(tag, level, String.format(Locale.US, format, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void i(String tag, int level, String msg) {
        if (level > mLevel) {
            return;
        }
        if (mQueue != null) {
            Queue<QueueItem> queue = mQueue;
            synchronized (queue) {
                mQueue.offer(new QueueItem(System.currentTimeMillis(), PREFIX_INFO, tag, msg));
            }
        }
        Log.i((String)tag, (String)msg);
    }

    public static void w(String tag, int level, String format, Object ... args) {
        if (level > mLevel) {
            return;
        }
        ATLog.w(tag, level, String.format(Locale.US, format, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void w(String tag, int level, String msg) {
        if (level > mLevel) {
            return;
        }
        if (mQueue != null) {
            Queue<QueueItem> queue = mQueue;
            synchronized (queue) {
                mQueue.offer(new QueueItem(System.currentTimeMillis(), PREFIX_WARN, tag, msg));
            }
        }
        Log.w((String)tag, (String)msg);
    }

    public static void e(String tag, String format, Object ... args) {
        ATLog.e(tag, String.format(Locale.US, format, args));
    }

    public static void e(String tag, Throwable tr, String format, Object ... args) {
        ATLog.e(tag, String.valueOf(String.format(Locale.US, format, args)) + "\r\n" + ATLog.getStackTraceString(tr));
    }

    public static void e(String tag, String msg) {
        if (mQueue != null) {
            ATLog.enqueLog(PREFIX_ERROR, tag, msg);
        }
        Log.e((String)tag, (String)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enqueLog(String type, String tag, String msg) {
        if (mQueue != null) {
            Queue<QueueItem> queue = mQueue;
            synchronized (queue) {
                mQueue.offer(new QueueItem(System.currentTimeMillis(), type, tag, msg));
            }
        }
    }

    private static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        Throwable t = tr;
        while (t != null) {
            if (t instanceof UnknownHostException) {
                return "";
            }
            t = t.getCause();
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    private static void INFO(String tag, String format, Object ... args) {
        ATLog.INFO(tag, String.format(Locale.US, format, args));
    }

    private static void INFO(String tag, String msg) {
        Log.i((String)tag, (String)msg);
    }

    private static void ERROR(String tag, String format, Object ... args) {
        ATLog.ERROR(tag, String.format(Locale.US, format, args));
    }

    private static void ERROR(String tag, String msg) {
        Log.e((String)tag, (String)msg);
    }

    private static void ERROR(String tag, Throwable tr, String format, Object ... args) {
        ATLog.ERROR(tag, tr, String.format(Locale.US, format, args));
    }

    private static void ERROR(String tag, Throwable tr, String msg) {
        Log.e((String)tag, (String)msg, (Throwable)tr);
    }

    private static synchronized void removeAllFiles() {
        String path = ATLog.getFilePath();
        File dir = new File(path);
        String[] files = dir.list(new LogFileFilter());
        if (files != null && files.length > 3) {
            Arrays.sort(files, String.CASE_INSENSITIVE_ORDER);
            int i = 0;
            while (i < files.length - 3) {
                File f = new File(String.valueOf(path) + files[i]);
                if (f.exists()) {
                    f.delete();
                }
                ++i;
            }
        }
        ATLog.INFO(TAG, "INFO. removeAllFiles()");
    }

    private static synchronized BufferedWriter getLogFile() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.US);
        String path = String.format("%s%s_%s.log", ATLog.getFilePath(), mLogName, sdf.format(new Date(System.currentTimeMillis())));
        File file = new File(path);
        BufferedWriter writer = null;
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                ATLog.ERROR(TAG, e, "ERROR. getLogFile() - Failed to create new file [%s]", path);
                return null;
            }
        }
        try {
            writer = new BufferedWriter(new FileWriter(path, true));
        }
        catch (IOException e) {
            ATLog.ERROR(TAG, e, "ERROR. getLogFile() - Failed to create file writer [%s]", path);
            return null;
        }
        ATLog.INFO(TAG, "INFO. getLogFile() - [%s]", path);
        return writer;
    }

    private static synchronized String getFilePath() {
        String dir;
        String sdcard = Environment.getExternalStorageState();
        File file = null;
        file = !sdcard.equals("mounted") ? Environment.getRootDirectory() : Environment.getExternalStorageDirectory();
        if (!mLogPath.startsWith("/")) {
            mLogPath = "/" + mLogPath;
        }
        if (!mLogPath.endsWith("/")) {
            mLogPath = String.valueOf(mLogPath) + "/";
        }
        if (!(file = new File(dir = String.valueOf(file.getAbsolutePath()) + mLogPath)).exists()) {
            if (!file.mkdirs()) {
                ATLog.ERROR(TAG, "ERROR. getFilePath() - Failed to make directory [%s]", file.getAbsoluteFile());
            }
            if (!file.setExecutable(true)) {
                ATLog.ERROR(TAG, "ERROR. getFilePath() - Failed to set executeable [%s]", file.getAbsoluteFile());
            }
            if (!file.setReadable(true)) {
                ATLog.ERROR(TAG, "ERROR. getFilePath() - Failed to set readable [%s]", file.getAbsoluteFile());
            }
            if (!file.setWritable(true)) {
                ATLog.ERROR(TAG, "ERROR. getFilePath() - Failed to set writable [%s]", file.getAbsoluteFile());
            }
        }
        ATLog.INFO(TAG, "INFO. getFilePath() - [%s]", dir);
        return dir;
    }

    private static synchronized void writeLog(QueueItem item) {
        if (mWriter == null) {
            mWriter = ATLog.getLogFile();
        }
        if (mWriter == null) {
            return;
        }
        try {
            mWriter.write(String.valueOf(item.toString()) + "\r\n");
        }
        catch (IOException e) {
            ATLog.ERROR(TAG, e, "ERROR. writeLog([%s]) - Failed to write log", item.toString());
            mWriter = ATLog.getLogFile();
            if (mWriter != null) {
                try {
                    mWriter.write(String.valueOf(item.toString()) + "\r\n");
                }
                catch (IOException e1) {
                    ATLog.ERROR(TAG, e, "ERROR. writeLog([%s]) - Failed to rewrite log", item.toString());
                    return;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean checkPermission() {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        if (mListeners != null) {
            Stack<ILoggingCheckPermissionListener> stack = mListeners;
            synchronized (stack) {
                block7: {
                    if (!mListeners.isEmpty()) break block7;
                    return false;
                }
                ILoggingCheckPermissionListener listener = (ILoggingCheckPermissionListener)mListeners.lastElement();
                if (listener != null) {
                    return listener.onCheckPermission();
                }
            }
        }
        return false;
    }

    static /* synthetic */ void access$0(boolean bl) {
        mIsAliveLogThread = bl;
    }

    static /* synthetic */ void access$2(String string, String string2) {
        ATLog.INFO(string, string2);
    }

    static /* synthetic */ void access$3() {
        ATLog.removeAllFiles();
    }

    static /* synthetic */ boolean access$4() {
        return mIsAliveLogThread;
    }

    static /* synthetic */ Queue access$5() {
        return mQueue;
    }

    static /* synthetic */ void access$6(QueueItem queueItem) {
        ATLog.writeLog(queueItem);
    }

    static /* synthetic */ BufferedWriter access$8() {
        return mWriter;
    }

    private static class ATUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private ATUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable ex) {
            ATLog.ERROR(TAG, ex, "ERROR. System Error");
            mUncaughtExceptionHandler.uncaughtException(thread, ex);
        }
    }

    private static interface ILoggingCheckPermissionListener {
        public boolean onCheckPermission();
    }

    private static class LogFileFilter
    implements FilenameFilter {
        private LogFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toUpperCase(Locale.US).startsWith(mLogName.toUpperCase(Locale.US)) && name.toUpperCase(Locale.US).endsWith(".LOG");
        }
    }

    private static class QueueItem {
        private long mTime;
        private String mType;
        private String mTag;
        private String mMsg;

        private QueueItem(long time, String type, String tag, String msg) {
            this.mTime = time;
            this.mType = type;
            this.mTag = tag;
            this.mMsg = msg;
        }

        private String getTime() {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS", Locale.US);
            return sdf.format(new Date(this.mTime));
        }

        public String toString() {
            return String.format(Locale.US, "%s: %s/%s: %s", this.getTime(), this.mType, this.mTag, this.mMsg);
        }
    }
}

