/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.atx88.types;

import com.atid.lib.types.IEnumType;

public enum DeviceOptionType implements IEnumType
{
    Unknown(0, "", "Unknown"),
    Barcode1D(1, "br1d", "Barcode(1D)"),
    Barcode2D(2, "br2d", "Barcode(2D)"),
    RFID_HF(3, "hfrfid", "RFID HF Reader"),
    RFID_UHF(4, "uhfrfid", "RFID UHF Reader"),
    BT_HID(5, "bthid", "Bluetooth (HID)"),
    BT_SPP(6, "btspp", "Bluetooth (SPP)"),
    BT_BLE(7, "btble", "Bluetooth (BLE)"),
    BT_IAP(8, "btiap", "Bluetooth (IAP)"),
    USB_HID(9, "usbhid", "USB (HID)"),
    USB_VCP(10, "usbvcp", "USB (VCP)"),
    GPS(11, "gps", "GPS"),
    RTC(12, "rtc", "Real Time Clock"),
    Memory(13, "nvmem", "NV Memory"),
    LCD(14, "lcd", "LCD"),
    WLAN(15, "wlan", "Wireless LAN"),
    Customer(16, "customer", "Customer"),
    HW_Revision(17, "hwrevision", "H/W Revision");

    private final int mCode;
    private final String mType;
    private final String mName;

    private DeviceOptionType(int code, String type, String name) {
        this.mCode = code;
        this.mType = type;
        this.mName = name;
    }

    public int getCode() {
        return this.mCode;
    }

    public String getType() {
        return this.mType;
    }

    public String toString() {
        return this.mName;
    }

    public static DeviceOptionType valueOf(String string) {
        return Enum.valueOf(DeviceOptionType.class, string);
    }
}

