/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.atx88.device;

import android.annotation.SuppressLint;
import com.atid.lib.atx88.protocol.ATProtocolATx88;
import com.atid.lib.atx88.types.DeviceOptionType;
import com.atid.lib.diagnostics.ATException;
import com.atid.lib.protocol.IProtocolEventListener;
import com.atid.lib.protocol.Response;
import com.atid.lib.reader.device.ATDevice;
import com.atid.lib.reader.params.StoredDataList;
import com.atid.lib.reader.types.KeyState;
import com.atid.lib.reader.types.KeyType;
import com.atid.lib.reader.types.NotificationState;
import com.atid.lib.reader.types.OperationMode;
import com.atid.lib.reader.types.UsbChargerState;
import com.atid.lib.reader.types.UsbChargerType;
import com.atid.lib.transport.ATransport;
import com.atid.lib.transport.types.ConnectState;
import com.atid.lib.types.ActionType;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.StringUtil;
import com.atid.lib.util.converts.BitConvert;
import com.atid.lib.util.diagnotics.ATLog;
import com.atid.lib.util.diagnotics.Dump;
import java.nio.charset.Charset;
import java.util.Locale;

@SuppressLint(value={"NewApi", "SimpleDateFormat"})
public class ATDeviceATx88
extends ATDevice
implements ATransport.IBufferControlEventListener,
IProtocolEventListener {
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int MIN_BUFFER_CONTROL_SIZE = 1024;
    private static final int MAX_BUFFER_CONTROL_SIZE = 2048;
    private static final boolean mIsUseFlowControl = true;
    private static volatile boolean mIsXoff;
    private IDeviceEventListener mListener;
    private int mTimeout;

    public ATDeviceATx88(ATransport transport, IDeviceEventListener listener) {
        super(transport);
        this.TAG = ATDeviceATx88.class.getSimpleName();
        this.mListener = listener;
        transport.setBufferControlListener(1024, 2048, (ATransport.IBufferControlEventListener)this);
        this.mProtocol = new ATProtocolATx88(transport, this);
        this.mTimeout = 3000;
        mIsXoff = false;
    }

    public ATProtocolATx88 getProtocol() {
        return (ATProtocolATx88)this.mProtocol;
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public void setTimeout(int timeout) {
        this.mTimeout = timeout;
    }

    public ResultCode loadStoredTag() {
        ResultCode res = ResultCode.NoError;
        res = this.getProtocol().post((byte)97, (byte)76, null);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. loadStoredTag() - Failed to send action [%s]", (Object[])new Object[]{res});
            return res;
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. loadStoredTag()");
        return ResultCode.NoError;
    }

    public ResultCode saveStoredTag(StoredDataList datas) {
        ResultCode res = ResultCode.NoError;
        if (datas == null || datas.size() == 0) {
            ATLog.e((String)this.TAG, (String)"ERROR. saveStoredTag(%d) - Failed to invalid parameter [%s]", (Object[])new Object[]{datas.size(), ResultCode.InvalidParameter});
            return ResultCode.InvalidParameter;
        }
        res = this.getProtocol().post((byte)97, (byte)84, null);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. saveStoredTag(%d) - Failed to send action [%s]", (Object[])new Object[]{datas.size(), res});
            return res;
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. saveStoredTag(%d)", (Object[])new Object[]{datas.size()});
        return ResultCode.NoError;
    }

    public ResultCode removeAllStoredTag() {
        ResultCode res = ResultCode.NoError;
        res = this.getProtocol().post((byte)97, (byte)68, null);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. removeAllStoredTag() - Failed to send action [%s]", (Object[])new Object[]{res});
            return res;
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. removeAllStoredTag()");
        return ResultCode.NoError;
    }

    public ResultCode releaseHost() {
        ResultCode res = ResultCode.NoError;
        res = this.getProtocol().post((byte)97, (byte)98, null);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. releaseHost() - Failed to send action [%s]", (Object[])new Object[]{res});
            return res;
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. releaseHost()");
        return ResultCode.NoError;
    }

    public ResultCode reset() {
        ResultCode res = ResultCode.NoError;
        res = this.getProtocol().post((byte)97, (byte)104, null);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. reset() - Failed to send action [%s]", (Object[])new Object[]{res});
            return res;
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. reset()");
        return ResultCode.NoError;
    }

    public ResultCode resetParams() {
        ResultCode res = ResultCode.NoError;
        res = this.getProtocol().post((byte)97, (byte)97, null);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. resetParams() - Failed to send action [%s]", (Object[])new Object[]{res});
            return res;
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. resetParams()");
        return ResultCode.NoError;
    }

    public String getVersion() {
        String version = "";
        Response res = null;
        res = this.getProtocol().send((byte)114, (byte)118, null, this.mTimeout);
        if (res.getCode() == ResultCode.NoError) {
            version = BitConvert.toString((byte[])res.getData());
            ATLog.i((String)this.TAG, (int)7, (String)"INFO. getVersion() - [%s]", (Object[])new Object[]{version});
            return version;
        }
        ATLog.e((String)this.TAG, (String)"ERROR. getVersion() - Failed to response error [%s]", (Object[])new Object[]{res.getCode()});
        return "";
    }

    public int getBuzzer() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)98, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getBuzzer() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getBuzzer() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setBuzzer(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)98, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setBuzzer(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setBuzzer(%d)", (Object[])new Object[]{value});
    }

    public String getBleVersion() throws ATException {
        String value = "";
        byte[] data = BitConvert.toBytes((String)"etIlogicF");
        Response res = this.getProtocol().send((byte)100, (byte)103, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getBleVersion() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toString((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getBleVersion() - [%s]", (Object[])new Object[]{value});
        return value;
    }

    public int getDisplayOffTime() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)121, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getDisplayOffTime() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getDisplayOffTime() - [%s]", (Object[])new Object[]{value});
        return value;
    }

    public void setDisplayOffTime(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)121, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setDisplayOffTime(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setDisplayOffTime(%d)", (Object[])new Object[]{value});
    }

    public int getAutoOffTime() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)116, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getAutoOffTime() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getAutoOffTime() - [%s]", (Object[])new Object[]{value});
        return value;
    }

    public void setAutoOffTime(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)116, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setAutoOffTime(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setAutoOffTime(%d)", (Object[])new Object[]{value});
    }

    public int getNotifyTerm() throws ATException {
        byte[] data = BitConvert.toBytes((String)"notmode");
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)38, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getNotifyTerm() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        try {
            String[] values = BitConvert.toString((byte[])res.getData()).split(",");
            if (!values[0].equals("notmode")) {
                ATLog.e((String)this.TAG, (String)"ERROR. getNotifyTerm() - Failed to invalid response extend parameter [%s]", (Object[])new Object[]{res.getCode()});
                throw new ATException(ResultCode.InvalidResponseExParam);
            }
            value = StringUtil.toInteger((String)values[1]);
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (String)"ERROR. getNotifyTerm() - Failed to invalid response data [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(ResultCode.InvalidResponse);
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getNotifyTerm() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setNotifyTerm(int value) throws ATException {
        byte[] data = BitConvert.toBytes((String)String.format(Locale.US, "%s,%d", "notmode", value));
        Response res = this.getProtocol().send((byte)119, (byte)38, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setNotifyTerm(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        try {
            String ext = BitConvert.toString((byte[])res.getData());
            if (!ext.equals("notmode")) {
                ATLog.e((String)this.TAG, (String)"ERROR. setNotifyTerm(%d) - Failed to invalid response extend parameter [%s]", (Object[])new Object[]{value, res.getCode()});
                throw new ATException(ResultCode.InvalidResponseExParam);
            }
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (String)"ERROR. setNotifyTerm(%d) - Failed to invalid response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(ResultCode.InvalidResponse);
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setNotifyTerm(%d)", (Object[])new Object[]{value});
    }

    public int getButtonNotify() throws ATException {
        byte[] data = BitConvert.toBytes((String)"buttonnot");
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)38, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getButtonNotify() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        try {
            String[] values = BitConvert.toString((byte[])res.getData()).split(",");
            if (!values[0].equals("buttonnot")) {
                ATLog.e((String)this.TAG, (String)"ERROR. getButtonNotify() - Failed to invalid response extend parameter [%s]", (Object[])new Object[]{res.getCode()});
                throw new ATException(ResultCode.InvalidResponseExParam);
            }
            value = StringUtil.toInteger((String)values[1]);
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (String)"ERROR. getButtonNotify() - Failed to invalid response data [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(ResultCode.InvalidResponse);
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getButtonNotify() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setButtonNotify(int value) throws ATException {
        byte[] data = BitConvert.toBytes((String)String.format(Locale.US, "%s,%d", "buttonnot", value));
        Response res = this.getProtocol().send((byte)119, (byte)38, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setButtonNotify(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        try {
            String ext = BitConvert.toString((byte[])res.getData());
            if (!ext.equals("buttonnot")) {
                ATLog.e((String)this.TAG, (String)"ERROR. setButtonNotify(%d) - Failed to invalid response extend parameter [%s]", (Object[])new Object[]{value, res.getCode()});
                throw new ATException(ResultCode.InvalidResponseExParam);
            }
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (String)"ERROR. setButtonNotify(%d) - Failed to invalid response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(ResultCode.InvalidResponse);
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setButtonNotify(%d)", (Object[])new Object[]{value});
    }

    public int getAlertNotify() throws ATException {
        byte[] data = BitConvert.toBytes((String)"alertnot");
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)38, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getAlertNotify() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        try {
            String[] values = BitConvert.toString((byte[])res.getData()).split(",");
            if (!values[0].equals("alertnot")) {
                ATLog.e((String)this.TAG, (String)"ERROR. getAlertNotify() - Failed to invalid response extend parameter [%s]", (Object[])new Object[]{res.getCode()});
                throw new ATException(ResultCode.InvalidResponseExParam);
            }
            value = StringUtil.toInteger((String)values[1]);
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (String)"ERROR. getAlertNotify() - Failed to invalid response data [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(ResultCode.InvalidResponse);
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getAlertNotify() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setAlertNotify(int value) throws ATException {
        byte[] data = BitConvert.toBytes((String)String.format(Locale.US, "%s,%d", "alertnot", value));
        Response res = this.getProtocol().send((byte)119, (byte)38, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setAlertNotify(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        try {
            String ext = BitConvert.toString((byte[])res.getData());
            if (!ext.equals("alertnot")) {
                ATLog.e((String)this.TAG, (String)"ERROR. setAlertNotify(%s) - Failed to invalid response extend parameter [%s]", (Object[])new Object[]{value, res.getCode()});
                throw new ATException(ResultCode.InvalidResponseExParam);
            }
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (String)"ERROR. setAlertNotify(%s) - Failed to invalid response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(ResultCode.InvalidResponse);
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setAlertNotify(%d)", (Object[])new Object[]{value});
    }

    public int getKeyAction() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)107, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getKeyAction() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getKeyAction() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setKeyAction(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)107, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setKeyAction(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setKeyAction(%d)", (Object[])new Object[]{value});
    }

    public boolean getBatteryRemains() throws ATException {
        ResultCode res = this.getProtocol().post((byte)114, (byte)101, null);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getBatteryRemains() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res);
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getBatteryRemains() ");
        return true;
    }

    public String getTime() throws ATException {
        String value = null;
        Response res = this.getProtocol().send((byte)114, (byte)114, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getTime() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toString((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getTime() - [%s]", (Object[])new Object[]{value});
        return value;
    }

    public void setTime(String value) throws ATException {
        byte[] data = BitConvert.toBytes((String)value);
        Response res = this.getProtocol().send((byte)119, (byte)114, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setTime([%s]) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setTime([%s])", (Object[])new Object[]{value});
    }

    public String getSerialNo() throws ATException {
        String value = "";
        Response res = this.getProtocol().send((byte)114, (byte)83, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getSerialNo() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toString((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getSerialNo() - [%s]", (Object[])new Object[]{value});
        return value;
    }

    public void setSerialNo(String value) throws ATException {
        byte[] data = BitConvert.toBytes((String)value);
        Response res = this.getProtocol().send((byte)119, (byte)83, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setSerialNo([%s]) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setSerialNo([%s])", (Object[])new Object[]{value});
    }

    public int getStoredMode() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)73, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getStoredMode() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getStoredMode() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setStoredMode(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)73, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setStoredMode(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setStoredMode(%d)", (Object[])new Object[]{value});
    }

    public int getAutoSaveMode() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)74, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getAutoSaveMode() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getAutoSaveMode() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setAutoSaveMode(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)74, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setAutoSaveMode(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setAutoSaveMode(%d)", (Object[])new Object[]{value});
    }

    public int getStoredDataCount() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)67, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getStoredDataCount() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getStoredDataCount() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public String getRegister() throws ATException {
        String value = "";
        Response res = this.getProtocol().send((byte)114, (byte)106, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getRegister() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toString((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getRegister() - [%s]", (Object[])new Object[]{value});
        return value;
    }

    public void setRegister(String value) throws ATException {
        byte[] data = BitConvert.toBytes((String)value);
        Response res = this.getProtocol().send((byte)119, (byte)106, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setRegister([%s]) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setRegister([%s])", (Object[])new Object[]{value});
    }

    public int getBarocdePowerState() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)82, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getBarocdePowerState() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getBarocdePowerState() - [%s]", (Object[])new Object[]{value});
        return value;
    }

    public void setBarocdePowerState(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)82, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setBarocdePowerState(%s) - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setBarocdePowerState(%s)", (Object[])new Object[]{value});
    }

    public int getBarcodeState() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)120, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getBarcodeState() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getBarcodeState() - [%s]", (Object[])new Object[]{value});
        return value;
    }

    public void setBarcodeState(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)120, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setBarcodeState(%s) - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setBarcodeState(%s)", (Object[])new Object[]{value});
    }

    public int getOperationMode() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)111, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getOperationMode() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getOperationMode() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setOperationMode(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)111, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setOperationMode(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setOperationMode(%d)", (Object[])new Object[]{value});
    }

    public int getRemoteMode() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)104, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getRemoteMode() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getRemoteMode() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setRemoteMode(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)104, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setRemoteMode(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setRemoteMode(%d)", (Object[])new Object[]{value});
    }

    public int getCommType() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)35, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getCommType() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getCommType() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setCommType(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)35, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setCommType(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setCommType(%d)", (Object[])new Object[]{value});
    }

    public void setUsbChargingPhone(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        ResultCode res = this.getProtocol().post((byte)104, (byte)122, data);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setUsbChargingPhone(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res);
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setUsbChargingPhone(%d)", (Object[])new Object[]{value});
    }

    public void initModuleInfo() throws ATException {
        byte[] data = BitConvert.toBytes((String)"actoryGetCrc");
        Response res = this.getProtocol().send((byte)100, (byte)70, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. initModuleInfo() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        String crc = BitConvert.toString((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. initModuleInfo() - [%s]", (Object[])new Object[]{crc});
    }

    public int getModuleInfo(DeviceOptionType type) throws ATException {
        int value = 0;
        byte[] data = BitConvert.toBytes((String)String.format(Locale.US, "config %s=?", type.getType()));
        Response res = this.getProtocol().send((byte)100, (byte)49, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getModuleInfo(%s) - Failed to response [%s]", (Object[])new Object[]{type, res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData(), (int)16);
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getModuleInfo(%s) - [%s]", (Object[])new Object[]{type, value});
        return value;
    }

    public void onOverflow() throws ATException {
        if (mIsXoff) {
            return;
        }
        byte[] data = new byte[]{126, 120, 111, 102, 102, 13, 10};
        ResultCode res = this.getProtocol().post(data);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. onOverflow() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res);
        }
        mIsXoff = true;
        if (ATLog.isLogging((int)7)) {
            ATLog.i((String)this.TAG, (int)7, (String)"EVENT. onOverflow()");
        }
    }

    public void onUnderflow() throws ATException {
        if (!mIsXoff) {
            return;
        }
        byte[] data = new byte[]{126, 120, 111, 110, 13, 10};
        ResultCode res = this.getProtocol().post(data);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. onOverflow() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res);
        }
        mIsXoff = false;
        if (ATLog.isLogging((int)7)) {
            ATLog.i((String)this.TAG, (int)7, (String)"EVENT. onUnderflow()");
        }
    }

    public void onEvent(int cmd, int sub, byte[] data) {
        switch (cmd) {
            case 82: {
                if (sub != 101) break;
                int value = BitConvert.toInteger((byte[])data) * 25;
                this.mListener.onBatteryState(value, null);
                break;
            }
            case 65: {
                this.procAction(sub, data);
                break;
            }
            case 101: {
                this.procEvent(sub, data);
            }
        }
        if (ATLog.isLogging((int)7)) {
            ATLog.i((String)this.TAG, (int)7, (String)"EVENT. onEvent([%c], [%c], [%s])", (Object[])new Object[]{cmd, sub, Dump.dump((byte[])data)});
        }
    }

    private void procAction(int sub, byte[] data) {
        try {
            ResultCode res = Response.getResultCode((byte[])data);
            ActionType action = ActionType.valueOf((int)sub);
            if (this.mListener != null) {
                this.mListener.onActionChanged(res, action, null);
            }
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. procAction([%c], [%s]) - Failed to process action response", (Object[])new Object[]{sub, Dump.dump((byte[])data)});
            return;
        }
        if (ATLog.isLogging((int)7)) {
            ATLog.i((String)this.TAG, (int)7, (String)"INFO. procAction([%c], [%s])", (Object[])new Object[]{sub, Dump.dump((byte[])data)});
        }
    }

    private void procEvent(int sub, byte[] data) {
        switch (sub) {
            case 66: {
                if (this.mListener == null) break;
                String value = new String(data, Charset.forName("UTF-8"));
                String[] values = value.split(",");
                int type = StringUtil.toInteger((String)values[0]);
                int state = StringUtil.toInteger((String)values[1]);
                this.mListener.onKeyEvent(KeyType.valueOf((int)type), KeyState.valueOf((int)state), null);
                break;
            }
            case 111: {
                if (this.mListener == null) break;
                int value = StringUtil.toInteger((String)new String(data, Charset.forName("UTF-8")));
                this.mListener.onOperationModeChanged(OperationMode.valueOf((int)value), null);
                break;
            }
            case 85: {
                if (this.mListener == null) break;
                String value = new String(data, Charset.forName("UTF-8"));
                String[] values = value.split(",");
                int type = StringUtil.toInteger((String)values[0]);
                int state = StringUtil.toInteger((String)values[1]);
                this.mListener.onUsbChargerChanged(UsbChargerType.valueOf((int)type), UsbChargerState.valueOf((int)state), null);
                break;
            }
            case 82: {
                if (this.mListener == null) break;
                String value = new String(data, Charset.forName("UTF-8"));
                int type = StringUtil.toInteger((String)value);
                this.mListener.onNotificationState(NotificationState.valueOf((int)type), null);
                break;
            }
            default: {
                if (this.mListener == null) break;
                this.mListener.onEvent(sub, data);
            }
        }
        if (ATLog.isLogging((int)7)) {
            ATLog.i((String)this.TAG, (int)7, (String)"INFO. procEvent([%c], [%s])", (Object[])new Object[]{sub, Dump.dump((byte[])data)});
        }
    }

    public static interface IDeviceEventListener {
        public void onStateChanged(ConnectState var1, Object var2);

        public void onActionChanged(ResultCode var1, ActionType var2, Object var3);

        public void onOperationModeChanged(OperationMode var1, Object var2);

        public void onBatteryState(int var1, Object var2);

        public void onEvent(int var1, byte[] var2);

        public void onKeyEvent(KeyType var1, KeyState var2, Object var3);

        public void onUsbChargerChanged(UsbChargerType var1, UsbChargerState var2, Object var3);

        public void onNotificationState(NotificationState var1, Object var2);
    }
}

