/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.atx88;

import android.annotation.SuppressLint;
import com.atid.lib.atx88.device.ATDeviceATx88;
import com.atid.lib.atx88.types.DeviceOptionType;
import com.atid.lib.device.IReader;
import com.atid.lib.diagnostics.ATException;
import com.atid.lib.module.barcode.spc.ATBarcodeSpcN36XX;
import com.atid.lib.module.barcode.ssi.ATBarcodeSsiSE4710;
import com.atid.lib.module.barcode.ssi.ATBarcodeSsiSE965;
import com.atid.lib.module.rfid.uhf.atm.ATRfidUhfATM;
import com.atid.lib.module.rfid.uhf.types.GlobalBandType;
import com.atid.lib.reader.ATEAReader;
import com.atid.lib.reader.device.ATDevice;
import com.atid.lib.reader.event.IATEAReaderEventListener;
import com.atid.lib.reader.params.StoredDataList;
import com.atid.lib.reader.types.BuzzerState;
import com.atid.lib.reader.types.KeyState;
import com.atid.lib.reader.types.KeyType;
import com.atid.lib.reader.types.NotificationState;
import com.atid.lib.reader.types.OperationMode;
import com.atid.lib.reader.types.UsbChargerControl;
import com.atid.lib.reader.types.UsbChargerState;
import com.atid.lib.reader.types.UsbChargerType;
import com.atid.lib.transport.ATransport;
import com.atid.lib.transport.types.ConnectState;
import com.atid.lib.transport.types.ConnectType;
import com.atid.lib.types.ActionState;
import com.atid.lib.types.ActionType;
import com.atid.lib.types.DeviceType;
import com.atid.lib.types.ModuleRfidUhfType;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.ActionUtil;
import com.atid.lib.util.StringUtil;
import com.atid.lib.util.SysUtil;
import com.atid.lib.util.diagnotics.ATLog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

@SuppressLint(value={"SimpleDateFormat", "NewApi"})
public abstract class ATx88Reader
extends ATEAReader
implements ATDeviceATx88.IDeviceEventListener {
    private static final int CHECK_INTERVAL = 200;
    private Thread mKeepAliveThread;
    private boolean mIsThreadAlive;
    private int mBatteryState;
    private final Object mLockBattery;
    private Runnable mBackground = new Runnable(){

        @Override
        public void run() {
            boolean result = true;
            ATx88Reader.this.mIsThreadAlive = true;
            int tick = 0;
            ATLog.i((String)ATx88Reader.this.TAG, (int)6, (String)"+++ INFO. mBackground.run()");
            ATDeviceATx88 module = (ATDeviceATx88)ATx88Reader.this.mDevice;
            while (ATx88Reader.this.mIsThreadAlive) {
                if (ATx88Reader.this.mAction == ActionState.Stop) {
                    tick = (int)(System.currentTimeMillis() - ATx88Reader.this.mLastTime);
                    if (tick > ATx88Reader.this.mCheckInterval) {
                        try {
                            result = module.getBatteryRemains();
                            if (!result) {
                                ATLog.e((String)ATx88Reader.this.TAG, (String)"ERROR. mBackground.run() - Failed to send battery state command");
                            }
                        }
                        catch (ATException e) {
                            ATx88Reader.this.mLastError = e.getCode();
                            ATx88Reader.this.checkError();
                            ATLog.e((String)ATx88Reader.this.TAG, (Throwable)e, (String)"ERROR. mBackground.run() - Failed to get battery state [%s]", (Object[])new Object[]{ATx88Reader.this.mLastError});
                        }
                        ATx88Reader.this.resetError();
                        continue;
                    }
                    SysUtil.sleep((int)200);
                    continue;
                }
                SysUtil.sleep((int)200);
            }
            ATLog.i((String)ATx88Reader.this.TAG, (int)6, (String)"--- INFO. mBackground.run()");
        }
    };

    public ATx88Reader(ATransport transport) {
        super(transport);
        this.TAG = ATx88Reader.class.getSimpleName();
        this.mDevice = new ATDeviceATx88(transport, this);
        this.mLockBattery = new Object();
        this.mIsThreadAlive = false;
        this.mKeepAliveThread = null;
        this.mBatteryState = 0;
    }

    public ATx88Reader(int sessionId, ATransport transport) {
        super(sessionId, transport);
        this.TAG = ATx88Reader.class.getSimpleName();
        this.mDevice = new ATDeviceATx88(transport, this);
        this.mLockBattery = new Object();
        this.mIsThreadAlive = false;
        this.mKeepAliveThread = null;
        this.mBatteryState = 0;
    }

    public void destroy() {
        if (this.mDevice == null) {
            this.mLastError = ResultCode.InvalidModule;
            ATLog.e((String)this.TAG, (String)"ERROR. destroy() - Failed to invalid module object");
            return;
        }
        this.disconnect();
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. destroy()");
        super.destroy();
    }

    public void wakeUp() {
        super.wakeUp();
        this.OnWakeUp();
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. wakeUp()");
    }

    public void wakeUp(IATEAReaderEventListener listener) {
        super.wakeUp(listener);
        this.OnWakeUp();
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. wakeUp()");
    }

    public void sleep() {
        super.sleep();
        this.OnSleep();
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. sleep()");
    }

    public void sleep(IATEAReaderEventListener listener) {
        super.sleep(listener);
        this.OnSleep();
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. sleep()");
    }

    private void OnWakeUp() {
        if (this.mDevice == null) {
            this.mLastError = ResultCode.InvalidModule;
            ATLog.e((String)this.TAG, (String)"ERROR. OnWakeUp() - Failed to invalid module object");
            return;
        }
        switch (this.getBackupState()) {
            case Connecting: 
            case Connected: {
                if (this.connect()) break;
                this.mLastError = ResultCode.ConnectFail;
                ATLog.e((String)this.TAG, (String)"ERROR. OnWakeUp() - Failed to reconnect");
                return;
            }
            case Listen: {
                this.listen();
                break;
            }
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. OnWakeUp()");
    }

    private void OnSleep() {
        if (this.mDevice == null) {
            this.mLastError = ResultCode.InvalidModule;
            ATLog.e((String)this.TAG, (String)"ERROR. OnSleep() - Failed to invalid module object");
            return;
        }
        this.disconnect();
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. OnSleep()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultCode reset() {
        try {
            this.assertAction();
        }
        catch (ATException e) {
            this.mLastError = e.getCode();
            this.checkError();
            ATLog.e((String)this.TAG, (String)"ERROR. reset() - Failed to assert action");
            return this.mLastError;
        }
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            this.mLastError = ((ATDeviceATx88)this.mDevice).reset();
            if (this.mLastError != ResultCode.NoError) {
                this.checkError();
                ATLog.e((String)this.TAG, (String)"ERROR. reset() - Failed to start reset");
                return this.mLastError;
            }
            this.resetError();
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. reset()");
            return ResultCode.NoError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultCode defaultParameter() {
        if (this.getDeviceType() == DeviceType.ATD100) {
            ATLog.e((String)this.TAG, (String)"ERROR. defaultParameter() - not supported the device[%s]", (Object[])new Object[]{this.getDeviceType()});
            return ResultCode.NotSupported;
        }
        try {
            this.assertAction();
        }
        catch (ATException e) {
            this.mLastError = e.getCode();
            this.checkError();
            ATLog.e((String)this.TAG, (String)"ERROR. defaultParameter() - Failed to assert action");
            return this.mLastError;
        }
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            this.mLastError = ((ATDeviceATx88)this.mDevice).resetParams();
            if (this.mLastError != ResultCode.NoError) {
                this.checkError();
                ATLog.e((String)this.TAG, (String)"ERROR. defaultParameter() - Failed to start default parameters");
                return this.mLastError;
            }
            this.resetError();
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. defaultParameter()");
            return ResultCode.NoError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultCode loadStoredData() {
        if (this.getDeviceType() == DeviceType.ATS100 || this.getDeviceType() == DeviceType.ATD100) {
            ATLog.e((String)this.TAG, (String)"ERROR. loadStoredData() - not supported the device[%s]", (Object[])new Object[]{this.getDeviceType()});
            return ResultCode.NotSupported;
        }
        try {
            this.assertAction();
        }
        catch (ATException e) {
            this.mLastError = e.getCode();
            this.checkError();
            ATLog.e((String)this.TAG, (String)"ERROR. loadStoredTags() - Failed to assert action");
            return this.mLastError;
        }
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            this.mAction = ActionState.LoadStoredData;
            this.mLastError = ((ATDeviceATx88)this.mDevice).loadStoredTag();
            if (this.mLastError != ResultCode.NoError) {
                this.checkError();
                ATLog.e((String)this.TAG, (String)"ERROR. loadStoredTags() - Failed to start load stored data");
                return this.mLastError;
            }
            this.resetError();
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. loadStoredData()");
            return ResultCode.NoError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultCode saveStoredData(StoredDataList datas) {
        if (this.getDeviceType() == DeviceType.ATS100 || this.getDeviceType() == DeviceType.ATD100) {
            ATLog.e((String)this.TAG, (String)"ERROR. saveStoredData(%d) - not supported the device[%s]", (Object[])new Object[]{datas == null ? 0 : datas.size(), this.getDeviceType()});
            return ResultCode.NotSupported;
        }
        try {
            this.assertAction();
        }
        catch (ATException e) {
            this.mLastError = e.getCode();
            this.checkError();
            ATLog.e((String)this.TAG, (String)"ERROR. saveStoredData(%d) - Failed to assert action", (Object[])new Object[]{datas == null ? 0 : datas.size()});
            return this.mLastError;
        }
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            this.mAction = ActionState.SaveStoredData;
            this.mLastError = ((ATDeviceATx88)this.mDevice).saveStoredTag(datas);
            if (this.mLastError != ResultCode.NoError) {
                this.checkError();
                ATLog.e((String)this.TAG, (String)"ERROR. saveStoredData(%d) - Failed to start save stored data", (Object[])new Object[]{datas == null ? 0 : datas.size()});
                return this.mLastError;
            }
            this.resetError();
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. saveStoredData(%d)", (Object[])new Object[]{datas == null ? 0 : datas.size()});
            return ResultCode.NoError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultCode removeAllStoreadData() {
        if (this.getDeviceType() == DeviceType.ATS100 || this.getDeviceType() == DeviceType.ATD100) {
            ATLog.e((String)this.TAG, (String)"ERROR. removeAllStoreadData() - not supported the device[%s]", (Object[])new Object[]{this.getDeviceType()});
            return ResultCode.NotSupported;
        }
        try {
            this.assertAction();
        }
        catch (ATException e) {
            this.mLastError = e.getCode();
            this.checkError();
            ATLog.e((String)this.TAG, (String)"ERROR. removeAllStoreadData() - Failed to assert action");
            return this.mLastError;
        }
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            this.mAction = ActionState.RemoveAllStoredData;
            this.mLastError = ((ATDeviceATx88)this.mDevice).removeAllStoredTag();
            if (this.mLastError != ResultCode.NoError) {
                this.checkError();
                ATLog.e((String)this.TAG, (String)"ERROR. removeAllStoreadData() - Failed to start remove all stored data");
                return this.mLastError;
            }
            this.resetError();
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. removeAllStoreadData()");
            return ResultCode.NoError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuzzerState getBuzzer() throws ATException {
        BuzzerState state = BuzzerState.Off;
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                state = BuzzerState.valueOf((int)((ATDeviceATx88)this.mDevice).getBuzzer());
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getBuzzer() - Failed to get buzzer [%s]", (Object[])new Object[]{this.mLastError});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getBuzzer() - [%s]", (Object[])new Object[]{state});
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBuzzer(BuzzerState state) throws ATException {
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                ((ATDeviceATx88)this.mDevice).setBuzzer(state.getCode());
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setBuzzer(%s) - Failed to set buzzer [%s]", (Object[])new Object[]{state, this.mLastError});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setBuzzer(%s)", (Object[])new Object[]{state});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getUseActionKey() throws ATException {
        if (this.getDeviceType() == DeviceType.ATD100) {
            ATLog.e((String)this.TAG, (String)"ERROR. getUseActionKey() - not supported the device[%s]", (Object[])new Object[]{this.getDeviceType()});
            throw new ATException(ResultCode.NotSupported);
        }
        boolean enabled = false;
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                enabled = ((ATDeviceATx88)this.mDevice).getKeyAction() > 0;
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getUseActionKey() - Failed to get use action key [%s]", (Object[])new Object[]{this.mLastError});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getUseActionKey() - [%s]", (Object[])new Object[]{enabled});
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseActionKey(boolean enabled) throws ATException {
        if (this.getDeviceType() == DeviceType.ATD100) {
            ATLog.e((String)this.TAG, (String)"ERROR. setUseActionKey(%s) - not supported the device[%s]", (Object[])new Object[]{enabled, this.getDeviceType()});
            throw new ATException(ResultCode.NotSupported);
        }
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                ((ATDeviceATx88)this.mDevice).setKeyAction(enabled ? 1 : 0);
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setUseActionKey(%s) - Failed to set use action key [%s]", (Object[])new Object[]{enabled, this.mLastError});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setUseActionKey(%s)", (Object[])new Object[]{enabled});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBatteryState() throws ATException {
        int state;
        Object object = this.mLockBattery;
        synchronized (object) {
            state = this.mBatteryState;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getBatteryState() - [%d]", (Object[])new Object[]{state});
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDisplayOffTime() throws ATException {
        if (this.getDeviceType() == DeviceType.ATS100 || this.getDeviceType() == DeviceType.ATD100) {
            ATLog.e((String)this.TAG, (String)"ERROR. getDisplayOffTime() - not supported the device[%s]", (Object[])new Object[]{this.getDeviceType()});
            throw new ATException(ResultCode.NotSupported);
        }
        int time = 0;
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                time = ((ATDeviceATx88)this.mDevice).getDisplayOffTime();
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getDisplayOffTime() - Failed to get display off time [%s]", (Object[])new Object[]{this.mLastError});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getDisplayOffTime() - [%d]", (Object[])new Object[]{time});
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayOffTime(int time) throws ATException {
        if (this.getDeviceType() == DeviceType.ATS100 || this.getDeviceType() == DeviceType.ATD100) {
            ATLog.e((String)this.TAG, (String)"ERROR. setDisplayOffTime(%d) - not supported the device[%s]", (Object[])new Object[]{time, this.getDeviceType()});
            throw new ATException(ResultCode.NotSupported);
        }
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                ((ATDeviceATx88)this.mDevice).setDisplayOffTime(time);
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setDisplayOffTime(%d) - Failed to set display off time [%s]", (Object[])new Object[]{time, this.mLastError});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setDisplayOffTime(%d)", (Object[])new Object[]{time});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAutoOffTime() throws ATException {
        int time = 0;
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                time = ((ATDeviceATx88)this.mDevice).getAutoOffTime();
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getAutoOffTime() - Failed to get auto off time [%s]", (Object[])new Object[]{this.mLastError});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getAutoOffTime() - [%d]", (Object[])new Object[]{time});
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoOffTime(int time) throws ATException {
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                ((ATDeviceATx88)this.mDevice).setAutoOffTime(time);
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setAutoOffTime(%d) - Failed to set auto off time [%s]", (Object[])new Object[]{time, this.mLastError});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setAutoOffTime(%d)", (Object[])new Object[]{time});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationMode getOperationMode() throws ATException {
        OperationMode mode = OperationMode.Normal;
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                mode = OperationMode.valueOf((int)((ATDeviceATx88)this.mDevice).getOperationMode());
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getOperationMode() - Failed to get operation mode [%s]", (Object[])new Object[]{this.mLastError});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getOperationMode() - [%s]", (Object[])new Object[]{mode});
        return mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOperationMode(OperationMode mode) throws ATException {
        if (this.getDeviceType() == DeviceType.ATD100 && mode != OperationMode.Normal) {
            ATLog.e((String)this.TAG, (String)"ERROR. setOperationMode(%s) - Only %s is supported the normal mode", (Object[])new Object[]{mode, this.getDeviceType()});
            if (mode == OperationMode.Barcode) {
                throw new ATException(ResultCode.NotSupportedBarcodeMode);
            }
            if (mode == OperationMode.KeyEventOnly) {
                throw new ATException(ResultCode.NotSupportedKeyMode);
            }
        }
        if (mode == OperationMode.KeyEventOnly && this.getDeviceType() != DeviceType.ATS100) {
            ATLog.e((String)this.TAG, (String)"ERROR. setOperationMode(%s) - Only %s is not supported the key mode", (Object[])new Object[]{mode, this.getDeviceType()});
            throw new ATException(ResultCode.NotSupportedKeyMode);
        }
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                ((ATDeviceATx88)this.mDevice).setOperationMode(mode.getCode());
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setOperationMode(%s) - Failed to set operation mode [%s]", (Object[])new Object[]{mode, this.mLastError});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setOperationMode(%s)", (Object[])new Object[]{mode});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getTime() throws ATException {
        Date time;
        if (this.getDeviceType() == DeviceType.ATS100 || this.getDeviceType() == DeviceType.ASR250G || this.getDeviceType() == DeviceType.ATD100) {
            ATLog.e((String)this.TAG, (String)"ERROR. getTime() - not supported the device[%s]", (Object[])new Object[]{this.getDeviceType()});
            throw new ATException(ResultCode.NotSupported);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            String resTime = "";
            try {
                resTime = ((ATDeviceATx88)this.mDevice).getTime();
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getTime() - Failed to get time [%s]", (Object[])new Object[]{this.mLastError});
                throw e;
            }
            try {
                time = sdf.parse(resTime);
            }
            catch (ParseException e) {
                this.mLastError = ResultCode.InvalidResponseData;
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getTime() - Failed to invalid response date [%s]", (Object[])new Object[]{resTime});
                throw new ATException(this.mLastError);
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getTime() - [%s]", (Object[])new Object[]{time.toString()});
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(Date time) throws ATException {
        if (this.getDeviceType() == DeviceType.ATS100 || this.getDeviceType() == DeviceType.ASR250G || this.getDeviceType() == DeviceType.ATD100) {
            ATLog.e((String)this.TAG, (String)"ERROR. setTime(%s) - not supported the device[%s]", (Object[])new Object[]{time.toString(), this.getDeviceType()});
            throw new ATException(ResultCode.NotSupported);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                ((ATDeviceATx88)this.mDevice).setTime(sdf.format(time));
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setTime(%s) - Failed to set time [%s]", (Object[])new Object[]{time.toString(), this.mLastError});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setTime(%s)", (Object[])new Object[]{time.toString()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerialNo() throws ATException {
        String serialNo = "";
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                serialNo = ((ATDeviceATx88)this.mDevice).getSerialNo();
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSerialNo() - Failed to get serial no [%s]", (Object[])new Object[]{this.mLastError});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSerialNo() - [%s]", (Object[])new Object[]{serialNo});
        return serialNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSerialNo(String serialNo) throws ATException {
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                ((ATDeviceATx88)this.mDevice).setSerialNo(serialNo);
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSerialNo([%s]) - Failed to set serial no [%s]", (Object[])new Object[]{serialNo, this.mLastError});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setSerialNo([%s])", (Object[])new Object[]{serialNo});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStoredTagCount() throws ATException {
        if (this.getDeviceType() == DeviceType.ATS100 || this.getDeviceType() == DeviceType.ASR250G || this.getDeviceType() == DeviceType.ATD100) {
            ATLog.e((String)this.TAG, (String)"ERROR. getStoreadTagCount() - not supported the device[%s]", (Object[])new Object[]{this.getDeviceType()});
            throw new ATException(ResultCode.NotSupported);
        }
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            int count = 0;
            try {
                count = ((ATDeviceATx88)this.mDevice).getStoredDataCount();
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getStoreadTagCount() - Failed to get stored tag count [%s]", (Object[])new Object[]{this.mLastError});
                throw e;
            }
            this.resetError();
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. getStoreadTagCount() - [%d]", (Object[])new Object[]{count});
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAutoSaveMode() throws ATException {
        if (this.getDeviceType() == DeviceType.ATS100 || this.getDeviceType() == DeviceType.ASR250G || this.getDeviceType() == DeviceType.ATD100) {
            ATLog.e((String)this.TAG, (String)"ERROR. getAutoSaveMode() - not supported the device[%s]", (Object[])new Object[]{this.getDeviceType()});
            throw new ATException(ResultCode.NotSupported);
        }
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            boolean enabled = false;
            try {
                enabled = ((ATDeviceATx88)this.mDevice).getAutoSaveMode() > 0;
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getAutoSaveMode() - Failed to get auto save mode [%s]", (Object[])new Object[]{this.mLastError});
                throw e;
            }
            this.resetError();
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. getAutoSaveMode() - [%s]", (Object[])new Object[]{enabled});
            return enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoSaveMode(boolean enabled) throws ATException {
        if (this.getDeviceType() == DeviceType.ATS100 || this.getDeviceType() == DeviceType.ASR250G || this.getDeviceType() == DeviceType.ATD100) {
            ATLog.e((String)this.TAG, (String)"ERROR. setAutoSaveMode(%s) - not supported the device[%s]", (Object[])new Object[]{enabled, this.getDeviceType()});
            throw new ATException(ResultCode.NotSupported);
        }
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                ((ATDeviceATx88)this.mDevice).setAutoSaveMode(enabled ? 1 : 0);
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setAutoSaveMode(%s) - Failed to set auto save mode [%s]", (Object[])new Object[]{enabled, this.mLastError});
                throw e;
            }
            this.resetError();
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. setAutoSaveMode(%s)", (Object[])new Object[]{enabled});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUsbChargingPhone(UsbChargerControl contorl) throws ATException {
        if (this.getDeviceType() != DeviceType.ATS100) {
            ATLog.e((String)this.TAG, (String)"ERROR. setUsbChargingPhone(%s) - not supported the device[%s]", (Object[])new Object[]{contorl, this.getDeviceType()});
            throw new ATException(ResultCode.NotSupported);
        }
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                ((ATDeviceATx88)this.mDevice).setUsbChargingPhone(contorl.getCode());
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setUsbChargingPhone(%s) - Failed to set usb charging [%s]", (Object[])new Object[]{contorl, this.mLastError});
                throw e;
            }
            this.resetError();
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. setUsbChargingPhone(%s)", (Object[])new Object[]{contorl});
        }
    }

    @Override
    public void onStateChanged(ConnectState state, Object params) {
        switch (state) {
            case Connected: {
                if (!this.mDevice.start()) {
                    ATLog.e((String)this.TAG, (String)"ERROR. onStateChnaged(%s) - Failed to start module", (Object[])new Object[]{state});
                    this.disconnect();
                    return;
                }
                if (!this.initReader()) {
                    ATLog.e((String)this.TAG, (String)"ERROR. onStateChnaged(%s) - Failed to initialize reader", (Object[])new Object[]{state});
                    this.disconnect();
                    return;
                }
                this.mFailCount = 0;
                this.mLastTime = System.currentTimeMillis();
                if (this.mCheckInterval > 0) {
                    this.mKeepAliveThread = new Thread(this.mBackground);
                    this.mKeepAliveThread.start();
                    break;
                }
                this.mKeepAliveThread = null;
                break;
            }
            case Disconnected: {
                this.mIsThreadAlive = false;
                if (this.mKeepAliveThread != null && this.mKeepAliveThread.isAlive()) {
                    try {
                        this.mKeepAliveThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.mKeepAliveThread = null;
                this.mDevice.stop();
                this.mAction = ActionState.Stop;
            }
        }
        this.onReaderStateChanged(state, params);
        ATLog.i((String)this.TAG, (int)6, (String)"EVENT. onStateChanged(%s)", (Object[])new Object[]{state});
    }

    @Override
    public void onActionChanged(ResultCode code, ActionType action, Object params) {
        this.mFailCount = 0;
        this.mLastTime = System.currentTimeMillis();
        this.mAction = ActionUtil.getAction((ActionType)action);
        this.onReaderActionChanged(code, this.mAction, params);
        if (code == ResultCode.NoError && action == ActionType.DefaultParameter) {
            if (this.mRfidUhf != null) {
                this.mRfidUhf.stop();
            } else if (this.mBarcode != null) {
                this.mBarcode.stop();
            }
        }
        ATLog.i((String)this.TAG, (int)6, (String)"EVENT. onActionChanged([%s], %s)", (Object[])new Object[]{code, action});
    }

    @Override
    public void onOperationModeChanged(OperationMode mode, Object params) {
        this.mFailCount = 0;
        this.mLastTime = System.currentTimeMillis();
        this.onReaderOperationModeChanged(mode, params);
        ATLog.i((String)this.TAG, (int)6, (String)"EVENT. onOperationModeChanged(%s)", (Object[])new Object[]{mode});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBatteryState(int batteryState, Object params) {
        this.mFailCount = 0;
        this.mLastTime = System.currentTimeMillis();
        Object object = this.mLockBattery;
        synchronized (object) {
            this.mBatteryState = batteryState;
        }
        this.onReaderBatteryState(batteryState, params);
        ATLog.i((String)this.TAG, (int)6, (String)"EVENT. onBatteryState(%d)", (Object[])new Object[]{batteryState});
    }

    @Override
    public void onKeyEvent(KeyType type, KeyState state, Object params) {
        this.mFailCount = 0;
        this.mLastTime = System.currentTimeMillis();
        this.onReaderKeyChanged(type, state, params);
        ATLog.i((String)this.TAG, (int)6, (String)"EVENT. onKeyEvent(%s, %s)", (Object[])new Object[]{type, state});
    }

    @Override
    public void onUsbChargerChanged(UsbChargerType type, UsbChargerState state, Object params) {
        this.mFailCount = 0;
        this.mLastTime = System.currentTimeMillis();
        this.onReaderUsbChargerChanged(type, state, params);
        ATLog.i((String)this.TAG, (int)6, (String)"EVENT. onUsbChargerChanged(%s)", (Object[])new Object[]{state});
    }

    @Override
    public void onNotificationState(NotificationState state, Object params) {
        this.mFailCount = 0;
        this.mLastTime = System.currentTimeMillis();
        this.onReaderNotificationState(state, params);
        ATLog.i((String)this.TAG, (int)6, (String)"EVENT. onReaderNotificationState(%s)", (Object[])new Object[]{state});
    }

    @Override
    public void onEvent(int sub, byte[] data) {
        switch (sub) {
            case 65: 
            case 70: 
            case 84: 
            case 112: {
                if (this.mRfidUhf == null) break;
                this.mRfidUhf.PumpEvent(sub, data);
                break;
            }
            case 67: {
                if (this.mBarcode == null) break;
                this.mBarcode.PumpEvent(sub, data);
            }
        }
    }

    public synchronized boolean initReader() {
        ATDeviceATx88 module = (ATDeviceATx88)this.mDevice;
        int value = 0;
        String version = this.mDevice.getVersion();
        if (StringUtil.isNullOrEmpty((String)version)) {
            ATLog.e((String)this.TAG, (String)"ERROR. initReader() - Failed to unknown firmware version");
            return false;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. Version : [%s]", (Object[])new Object[]{version});
        this.mDeviceVersion.setVersion(version);
        String serialNo = "";
        try {
            serialNo = module.getSerialNo();
            this.mDeviceVersion.setSerialNo(serialNo);
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. initReader() - Failed to get serial number", (Object[])new Object[0]);
            return false;
        }
        if (this.mTransport.getConnectType() == ConnectType.USB) {
            this.mTransport.setDeviceType(this.mDeviceVersion.getDeviceType());
            this.mTransport.setDeviceName(this.mDeviceVersion.getDeviceType().toString());
            this.mTransport.setAddress(serialNo);
        }
        if (this.getDeviceType() != DeviceType.ATD100) {
            try {
                module.setKeyAction(0);
            }
            catch (ATException e) {
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. initReader() - Failed to disable key action", (Object[])new Object[0]);
                return false;
            }
        }
        try {
            module.initModuleInfo();
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. initReader() - Failed to initialize device option", (Object[])new Object[0]);
            return false;
        }
        try {
            value = module.getModuleInfo(DeviceOptionType.RFID_UHF);
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. initReader() - Failed to get RFID UHF module", (Object[])new Object[0]);
            return false;
        }
        if (value == 0) {
            try {
                value = module.getModuleInfo(DeviceOptionType.RFID_HF);
            }
            catch (ATException e) {
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. initReader() - Failed to get RFID HF module", (Object[])new Object[0]);
                return false;
            }
        }
        this.allocateRfid(value);
        try {
            value = module.getModuleInfo(DeviceOptionType.Barcode2D);
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. initReader() - Failed to get 2D barcode", (Object[])new Object[0]);
            return false;
        }
        if (value == 0) {
            try {
                value = module.getModuleInfo(DeviceOptionType.Barcode1D);
            }
            catch (ATException e2) {
                ATLog.e((String)this.TAG, (Throwable)e2, (String)"ERROR. initReader() - Failed to get 1D barcode", (Object[])new Object[0]);
                return false;
            }
        }
        this.allocateBarcode(value);
        if (this.mBarcode != null && !this.mBarcode.initMoudle()) {
            ATLog.e((String)this.TAG, (String)"ERROR. initReader() - Failed to initialize barcode module");
            return false;
        }
        if (this.mRfidHf != null && !this.mRfidHf.initMoudle()) {
            ATLog.e((String)this.TAG, (String)"ERROR. initReader() - Failed to initialize rfid hf module");
            return false;
        }
        if (this.mRfidUhf != null) {
            int e3;
            if (!this.mRfidUhf.initMoudle()) {
                ATLog.e((String)this.TAG, (String)"ERROR. initReader() - Failed to initialize rfid uhf module");
                return false;
            }
            try {
                GlobalBandType e2 = this.mRfidUhf.getGlobalBand();
            }
            catch (ATException e3) {
                ATLog.e((String)this.TAG, (String)"ERROR. initReader() - Failed to get global band of the rfid uhf module");
                return false;
            }
            try {
                e3 = this.mRfidUhf.getReportRssi();
            }
            catch (ATException e4) {
                ATLog.e((String)this.TAG, (String)"ERROR. initReader() - Failed to get global band of the rfid uhf module");
                return false;
            }
            try {
                e3 = this.mRfidUhf.getInventoryTime();
            }
            catch (ATException e5) {
                ATLog.e((String)this.TAG, (String)"ERROR. initReader() - Failed to get global band of the rfid uhf module");
                return false;
            }
            try {
                e3 = this.mRfidUhf.getIdleTime();
            }
            catch (ATException e6) {
                ATLog.e((String)this.TAG, (String)"ERROR. initReader() - Failed to get global band of the rfid uhf module");
                return false;
            }
        }
        try {
            boolean result = module.getBatteryRemains();
            if (!result) {
                ATLog.e((String)this.TAG, (String)"ERROR. initReader() - Failed to send battery state command");
                return false;
            }
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. initReader() - Failed to get battery state", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    private void allocateRfid(int value) {
        switch (value) {
            case 1: {
                this.mRfidUhf = new ATRfidUhfATM(ModuleRfidUhfType.I2000MI, (IReader)this);
                break;
            }
            case 5: {
                this.mRfidUhf = null;
                break;
            }
            case 2: {
                this.mRfidUhf = new ATRfidUhfATM(ModuleRfidUhfType.ATR500S, (IReader)this);
                break;
            }
            case 3: {
                this.mRfidUhf = new ATRfidUhfATM(ModuleRfidUhfType.ATR2000S, (IReader)this);
                break;
            }
            case 4: {
                this.mRfidHf = null;
                break;
            }
            default: {
                this.mRfidUhf = null;
            }
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. allocateRfidUhf(%d)", (Object[])new Object[]{value});
    }

    private void allocateBarcode(int value) {
        switch (value) {
            case 14: {
                this.mBarcode = new ATBarcodeSsiSE965((IReader)this);
                break;
            }
            case 13: {
                this.mBarcode = new ATBarcodeSsiSE965((IReader)this);
                break;
            }
            case 11: {
                this.mBarcode = new ATBarcodeSsiSE4710((IReader)this);
                break;
            }
            case 12: {
                this.mBarcode = new ATBarcodeSpcN36XX((IReader)this);
                break;
            }
            default: {
                this.mBarcode = null;
            }
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. allocateBarcode(%d)", (Object[])new Object[]{value});
    }

    protected void assertAction() throws ATException {
        if (this.mDevice == null) {
            this.mLastError = ResultCode.InvalidModule;
            ATLog.e((String)this.TAG, (String)"ERROR. assertAction() - Failed to invalid module object");
            throw new ATException(ResultCode.InvalidModule);
        }
        if (this.mAction != ActionState.Stop) {
            this.mLastError = ResultCode.InOperation;
            ATLog.e((String)this.TAG, (String)"ERROR. assertAction() - Failed to in operation");
            throw new ATException(this.mLastError);
        }
    }
}

