/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.rfid.uhf.params;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;

public class FreqTableList {
    private static final int MAX_TABLE_COUNT = 50;
    private ArrayList<FreqTableItem> mTable;
    private long mMask;

    public FreqTableList(long table, long mask) {
        this.mMask = mask;
        this.mTable = new ArrayList();
        long val = 0L;
        int i = 0;
        while (i < 50) {
            val = 1L << i;
            if ((this.mMask & val) > 0L) {
                this.mTable.add(new FreqTableItem(i, (table & val) > 0L));
            }
            ++i;
        }
    }

    public int getCount() {
        return this.mTable.size();
    }

    public int getSlot(int index) {
        return this.mTable.get((int)index).mSlot;
    }

    public int getFrequency(int index) {
        return this.mTable.get((int)index).mFreq;
    }

    public String getFreqName(int index) {
        return this.mTable.get(index).getFreqName();
    }

    public String[] getFreqNames() {
        String[] names = new String[this.mTable.size()];
        int i = 0;
        while (i < this.mTable.size()) {
            names[i] = this.mTable.get(i).getFreqName();
            ++i;
        }
        return names;
    }

    public void setFrequency(int index, int freq) {
        this.mTable.get((int)index).mFreq = freq;
    }

    public boolean isUsed(int index) {
        return this.mTable.get((int)index).mIsUsed;
    }

    public void setUsed(int index, boolean used) {
        this.mTable.get((int)index).mIsUsed = used;
    }

    public long getTable() {
        long table = 0L;
        for (FreqTableItem item : this.mTable) {
            if (!item.mIsUsed) continue;
            table |= (long)(1 << item.mSlot);
        }
        return table;
    }

    public void sort() {
        Collections.sort(this.mTable, new Comparator<FreqTableItem>(){

            @Override
            public int compare(FreqTableItem o1, FreqTableItem o2) {
                return o1.mFreq - o2.mFreq;
            }
        });
    }

    public String toString() {
        return String.format(Locale.US, "0x%016X, 0x%016X", this.getTable(), this.mMask);
    }

    private class FreqTableItem {
        protected final int mSlot;
        protected int mFreq;
        protected boolean mIsUsed;

        private FreqTableItem(int slot, boolean used) {
            this.mSlot = slot;
            this.mFreq = 0;
            this.mIsUsed = used;
        }

        public String getFreqName() {
            String name = "";
            name = this.mFreq > 1000000000 ? String.format(Locale.US, "%.2f GHz", (double)this.mFreq / 1.0E9) : (this.mFreq > 1000000 ? String.format(Locale.US, "%.2f MHz", (double)this.mFreq / 1000000.0) : (this.mFreq > 1000 ? String.format(Locale.US, "%.2f KHz", (double)this.mFreq / 1000.0) : String.format(Locale.US, "%d Hz", this.mFreq)));
            return name;
        }

        public String toString() {
            return String.format(Locale.US, "%d, %d, %s", this.mSlot, this.mFreq, this.mIsUsed);
        }
    }
}

