/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.util.diagnotics;

import java.util.Locale;

public class Dump {
    public static String dump(byte[] buf) {
        if (buf == null) {
            return "[NULL]";
        }
        if (buf.length <= 0) {
            return "";
        }
        return Dump.dump(buf, 0, buf.length);
    }

    public static String dump(byte[] buf, int length) {
        if (buf == null) {
            return "[NULL]";
        }
        if (buf.length <= 0) {
            return "";
        }
        return Dump.dump(buf, 0, length);
    }

    public static String dump(byte[] buf, int offset, int length) {
        if (buf == null) {
            return "[NULL]";
        }
        if (buf.length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (offset < 0 || offset >= buf.length) {
            return "";
        }
        if (offset + length > buf.length) {
            length = buf.length - offset;
        }
        int i = offset;
        while (i < length) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(String.format(Locale.US, "%02X", buf[i]));
            ++i;
        }
        return sb.toString();
    }

    public static String dump(int[] buf) {
        if (buf == null) {
            return "[NULL]";
        }
        if (buf.length <= 0) {
            return "";
        }
        return Dump.dump(buf, 0, buf.length);
    }

    public static String dump(int[] buf, int length) {
        if (buf == null) {
            return "[NULL]";
        }
        if (buf.length <= 0) {
            return "";
        }
        return Dump.dump(buf, 0, length);
    }

    public static String dump(int[] buf, int offset, int length) {
        if (buf == null) {
            return "[NULL]";
        }
        if (buf.length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (offset < 0 || offset >= buf.length) {
            return "";
        }
        if (offset + length > buf.length) {
            length = buf.length - offset;
        }
        int i = offset;
        while (i < length) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(String.format(Locale.US, "%d", buf[i]));
            ++i;
        }
        return String.format(Locale.US, "{%s}", sb.toString());
    }

    public static String dump(Object[] buf) {
        if (buf == null) {
            return "[NULL]";
        }
        return Dump.dump(buf, 0, buf.length);
    }

    public static String dump(Object[] buf, int length) {
        if (buf == null) {
            return "[NULL]";
        }
        return Dump.dump(buf, 0, length);
    }

    public static String dump(Object[] buf, int offset, int length) {
        if (buf == null) {
            return "[NULL]";
        }
        StringBuilder sb = new StringBuilder();
        if (offset < 0 || offset >= buf.length) {
            return "";
        }
        if (offset + length > buf.length) {
            length = buf.length - offset;
        }
        int i = offset;
        while (i < length) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (buf[i] instanceof Integer) {
                sb.append(String.format(Locale.US, "%d", (Integer)buf[i]));
            } else if (buf[i] instanceof String) {
                sb.append(String.format(Locale.US, "%s", (String)buf[i]));
            } else if (buf[i] instanceof Byte) {
                sb.append(String.format(Locale.US, "%02X", (Byte)buf[i]));
            }
            ++i;
        }
        return String.format(Locale.US, "{%s}", sb.toString());
    }
}

