/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.transport;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import com.atid.lib.transport.ATransport;
import com.atid.lib.transport.types.ConnectState;
import com.atid.lib.transport.types.ConnectType;
import com.atid.lib.transport.usbserial.UsbSerialDriver;
import com.atid.lib.transport.usbserial.UsbSerialPort;
import com.atid.lib.transport.usbserial.UsbSerialProber;
import com.atid.lib.types.DeviceType;
import com.atid.lib.util.SysUtil;
import com.atid.lib.util.collections.ByteQueue;
import com.atid.lib.util.diagnotics.ATLog;
import com.atid.lib.util.diagnotics.Dump;
import java.io.IOException;
import java.util.List;

public class ATransportUsb
extends ATransport {
    private static final int ENABLE_USB_INFO_LEVEL = 10;
    private static final long serialVersionUID = -9121214999146122429L;
    private static final String ACTION_USB_PERMISSION = "com.android.example.USB_PERMISSION";
    private static final boolean DEFAULT_USER_PERMISSION_GRANTED = false;
    private static final int MAX_BUFFER_SIZE = 4096;
    private static UsbSerialProber mUsbProber;
    private volatile UsbManager mUsbManager;
    private UsbSerialDriver mUsbDriver;
    private UsbSerialPort mUsbPort;
    private PendingIntent mPermissionIntent;
    private volatile boolean mIsUsbPermission;
    private volatile boolean mIsUsbOpened;
    private volatile boolean mIsWaitUserGrantAction;
    private volatile boolean mIsUserGrantAction;
    private volatile ConnectThread mConnectThread;
    private volatile ReceiveThread mReceiveThread;
    private volatile Context mContext;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            ATLog.i((String)ATransportUsb.this.TAG, (int)7, (String)"INFO. $mUsbReceiver.onReceiver() - action [%s] AutoConnect[%s] Attach[%s] Open[%s]", (Object[])new Object[]{action, ATransportUsb.this.mIsAutoConnect, ATransportUsb.this.mIsDeviceAttached, ATransportUsb.this.mIsUsbOpened});
            if (ATransportUsb.ACTION_USB_PERMISSION.equals(action)) {
                ATransportUsb.this.mIsUserGrantAction = intent.getBooleanExtra("permission", false);
                ATransportUsb.this.mIsWaitUserGrantAction = false;
                if (!ATransportUsb.this.mIsUserGrantAction) {
                    ATLog.e((String)ATransportUsb.this.TAG, (String)"ERROR. $mUsbReceiver.onReceiver() - Failed to obtain permission for USB Device");
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                if (ATransportUsb.this.mIsAutoConnect) {
                    try {
                        if (ATransportUsb.this.mIsDeviceAttached && ATransportUsb.this.mIsUsbOpened) {
                            ATransportUsb.this.disconnect();
                        }
                    }
                    catch (Exception e) {
                        ATLog.e((String)ATransportUsb.this.TAG, (String)"ERROR. $mUsbReceiver.onReceiver() - Failed to disconnect the USB Port");
                        ATransportUsb.this.mIsDeviceAttached = false;
                    }
                }
                ATransportUsb.this.mIsDeviceAttached = false;
            } else if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                ATransportUsb.this.mIsDeviceAttached = true;
                if (ATransportUsb.this.mIsAutoConnect) {
                    try {
                        if (ATransportUsb.this.mIsDeviceAttached && !ATransportUsb.this.mIsUsbOpened) {
                            ATransportUsb.this.connect();
                        }
                    }
                    catch (Exception e) {
                        ATLog.e((String)ATransportUsb.this.TAG, (String)"ERROR. $mUsbReceiver.onReceiver() - Failed to connect the USB Port");
                    }
                }
            }
        }
    };

    public ATransportUsb() {
        this.TAG = ATransportUsb.class.getSimpleName();
        this.mConnType = ConnectType.USB;
        this.mIsUsbPermission = false;
        this.mIsUsbOpened = false;
        this.mIsWaitUserGrantAction = true;
        this.mIsUserGrantAction = false;
        this.mConnectThread = null;
        this.mReceiveThread = null;
        try {
            mUsbProber = UsbSerialProber.getDefaultProber();
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (String)"ERROR. ATransportUsb() - Failed to initialize USB Serial Prober");
        }
        this.mContext = SysUtil.getContext();
        if (this.mContext != null) {
            this.mUsbManager = (UsbManager)this.mContext.getSystemService("usb");
            this.mPermissionIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
            IntentFilter filter = new IntentFilter();
            filter.addAction(ACTION_USB_PERMISSION);
            filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
            filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
            this.mContext.registerReceiver(this.mUsbReceiver, filter);
        } else {
            ATLog.e((String)this.TAG, (String)"ERROR. ATransportUsb() - Failed to initialize USB Broadcast Receiver");
        }
        try {
            String deviceName = this.detectCdcDevice();
            if (deviceName != null) {
                this.mIsDeviceAttached = true;
            }
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (String)"ERROR. ATransportUsb() - Failed to detect the USB device");
        }
    }

    public ATransportUsb(DeviceType type, String name, String address) {
        super(type, name, address);
        this.TAG = ATransportUsb.class.getSimpleName();
        this.mConnType = ConnectType.USB;
        this.mIsUsbPermission = false;
        this.mIsUsbOpened = false;
        this.mIsWaitUserGrantAction = true;
        this.mIsUserGrantAction = false;
        this.mDevType = type;
        this.mDevName = name;
        this.mAddress = address;
        this.mConnectThread = null;
        this.mReceiveThread = null;
        try {
            mUsbProber = UsbSerialProber.getDefaultProber();
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (String)"ERROR. ATransportUsb(%s, %s, %s) - Failed to initialize USB Serial Prober", (Object[])new Object[]{type, name, address});
        }
        this.mContext = SysUtil.getContext();
        if (this.mContext != null) {
            this.mUsbManager = (UsbManager)this.mContext.getSystemService("usb");
            this.mPermissionIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
            IntentFilter filter = new IntentFilter();
            filter.addAction(ACTION_USB_PERMISSION);
            filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
            filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
            this.mContext.registerReceiver(this.mUsbReceiver, filter);
        } else {
            ATLog.e((String)this.TAG, (String)"ERROR. ATransportUsb(%s, %s, %s) - Failed to initialize USB Broadcast Receiver", (Object[])new Object[]{type, name, address});
        }
        try {
            String deviceName = this.detectCdcDevice();
            if (deviceName != null) {
                this.mIsDeviceAttached = true;
            }
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (String)"ERROR. ATransportUsb(%s, %s, %s) - Failed to detect the USB device", (Object[])new Object[]{type, name, address});
        }
    }

    public ATransportUsb(final DeviceType type, final String name, final String address, final boolean autoConnect) {
        super(type, name, address, autoConnect);
        this.TAG = ATransportUsb.class.getSimpleName();
        this.mConnType = ConnectType.USB;
        this.mIsUsbPermission = false;
        this.mIsUsbOpened = false;
        this.mIsWaitUserGrantAction = true;
        this.mIsUserGrantAction = false;
        this.mDevType = type;
        this.mDevName = name;
        this.mAddress = address;
        this.mConnectThread = null;
        this.mReceiveThread = null;
        try {
            mUsbProber = UsbSerialProber.getDefaultProber();
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (String)"ERROR. ATransportUsb(%s, %s, %s, %s) - Failed to initialize USB Serial Prober", (Object[])new Object[]{type, name, address, autoConnect});
        }
        this.mContext = SysUtil.getContext();
        if (this.mContext != null) {
            this.mUsbManager = (UsbManager)this.mContext.getSystemService("usb");
            this.mPermissionIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
            IntentFilter filter = new IntentFilter();
            filter.addAction(ACTION_USB_PERMISSION);
            filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
            filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
            this.mContext.registerReceiver(this.mUsbReceiver, filter);
        } else {
            ATLog.e((String)this.TAG, (String)"ERROR. ATransportUsb(%s, %s, %s, %s) - Failed to initialize USB Broadcast Receiver", (Object[])new Object[]{type, name, address, autoConnect});
        }
        try {
            String deviceName = this.detectCdcDevice();
            if (deviceName != null) {
                this.mIsDeviceAttached = true;
            }
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (String)"ERROR. ATransportUsb(%s, %s, %s, %s) - Failed to detect the USB device", (Object[])new Object[]{type, name, address, autoConnect});
        }
        if (this.mIsAutoConnect && this.mIsDeviceAttached) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!ATransportUsb.this.mIsUsbOpened) {
                            ATransportUsb.this.connect();
                        }
                    }
                    catch (Exception e) {
                        ATLog.e((String)ATransportUsb.this.TAG, (String)"ERROR. ATransportUsb(%s, %s, %s, %s) - Failed to connect the USB Port", (Object[])new Object[]{type, name, address, autoConnect});
                    }
                }
            }).start();
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. ATransportUsb(%s, %s, %s, %s) - AutoConnect[%s] Attach[%s]", (Object[])new Object[]{type, name, address, autoConnect, this.mIsAutoConnect, this.mIsDeviceAttached});
    }

    @Override
    public void destroy() {
        if (this.mUsbReceiver != null) {
            if (this.mContext != null) {
                this.mContext.unregisterReceiver(this.mUsbReceiver);
            } else {
                ATLog.e((String)this.TAG, (String)"ERROR. destroy() - Failed to deinitialize USB Broadcast Receiver");
            }
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. destroy()");
    }

    @Override
    public void setAutoConnect(boolean enabled) {
        this.mIsAutoConnect = enabled;
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setAutoConnect(%s)", (Object[])new Object[]{this.mIsAutoConnect});
    }

    @Override
    public boolean getAutoConnect() {
        return this.mIsAutoConnect;
    }

    @Override
    public boolean getDeviceAttached() {
        return this.mIsDeviceAttached;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized boolean connect() {
        if (this.mState == ConnectState.Connected) {
            ATLog.i((String)this.TAG, (int)9, (String)"DUMP. connect() - Already usb is connected");
            return true;
        }
        if (this.mState == ConnectState.Connecting) {
            ATLog.i((String)this.TAG, (int)9, (String)"DUMP. connect() - Already usb is connecting");
            return true;
        }
        this.stopReceiveThread();
        this.setState(ConnectState.Connecting, null);
        try {
            this.mConnectThread = new ConnectThread();
            this.mConnectThread.start();
            if (true) ** GOTO lbl20
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. connect() - Failed to create connect thread", (Object[])new Object[0]);
            this.setState(ConnectState.Disconnected, null);
            this.mConnectThread = null;
            return false;
        }
        do {
            SysUtil.sleep((int)100);
lbl20:
            // 2 sources

        } while (!this.mConnectThread.isAlive());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. connect()");
        return true;
    }

    @Override
    public synchronized void listen() {
    }

    @Override
    public synchronized void disconnect() {
        this.stopReceiveThread();
        this.stopConnectThread();
        this.setState(ConnectState.Disconnected, null);
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. disconnect()");
    }

    @Override
    public synchronized int write(byte[] data, int offset, int length) {
        if (this.mReceiveThread == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. write(%s) - Failed to invalid receive", (Object[])new Object[]{Dump.dump((byte[])data, (int)offset, (int)length)});
            return 0;
        }
        return this.mReceiveThread.write(data, offset, length);
    }

    @Override
    public synchronized int write(byte[] data, int offset, int length, int timeout) {
        if (this.mReceiveThread == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. write(%s) - Failed to invalid receive", (Object[])new Object[]{Dump.dump((byte[])data, (int)offset, (int)length)});
            return 0;
        }
        return this.mReceiveThread.write(data, offset, length, timeout);
    }

    @Override
    public int available() {
        return this.mQueue.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] data, int offset, int length) {
        int recvBytes = 0;
        ByteQueue byteQueue = this.mQueue;
        synchronized (byteQueue) {
            while (this.mQueue.getSize() == 0) {
                try {
                    this.mQueue.wait();
                }
                catch (InterruptedException e) {
                    ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. read(%d) - Failed to read data , Interrupted Excepton", (Object[])new Object[]{length});
                    return -2;
                }
            }
        }
        if (this.mQueue.getSize() <= 0) return recvBytes;
        try {
            return this.mQueue.dequeue(data, offset + recvBytes, length - recvBytes);
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. read(%d) - Failed to read data", (Object[])new Object[]{length});
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] data, int offset, int length, int timeout) {
        int recvBytes = 0;
        int readBytes = 0;
        long tick = System.currentTimeMillis();
        while (recvBytes >= length) {
            ByteQueue byteQueue = this.mQueue;
            synchronized (byteQueue) {
                while (this.mQueue.getSize() == 0) {
                    try {
                        this.mQueue.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. read(%d) - Failed to read data , Interrupted Excepton", (Object[])new Object[]{length});
                        return -2;
                    }
                }
            }
            try {
                if (this.mQueue.getSize() > 0) {
                    readBytes = this.mQueue.dequeue(data, offset + recvBytes, length - recvBytes);
                } else if (System.currentTimeMillis() - tick >= (long)timeout) {
                    ATLog.e((String)this.TAG, (String)"ERROR. read(%d) - Failed to read data, timeout[%d]", (Object[])new Object[]{length, timeout});
                    return recvBytes;
                }
            }
            catch (Exception e) {
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. read(%d) - Failed to read data", (Object[])new Object[]{length});
                return -1;
            }
            recvBytes += readBytes;
        }
        return recvBytes;
    }

    private synchronized void stopConnectThread() {
        if (this.mConnectThread == null) {
            return;
        }
        this.mConnectThread.cancel();
        this.mConnectThread = null;
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. stopConnectThread()");
    }

    private synchronized void startReceiveThread() {
        this.stopConnectThread();
        try {
            this.mReceiveThread = new ReceiveThread(this.mUsbPort);
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. startReceiveThread() - Failed to start recieve thread", (Object[])new Object[0]);
            this.setState(ConnectState.Disconnected, null);
            return;
        }
        this.mReceiveThread.start();
        while (!this.mReceiveThread.isAlive()) {
            SysUtil.sleep((int)100);
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. startReceiveThread()");
    }

    private synchronized void stopReceiveThread() {
        if (this.mReceiveThread == null) {
            return;
        }
        this.mReceiveThread.cancel();
        this.mReceiveThread = null;
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. stopReceiveThread()");
    }

    private boolean getUserPermission(UsbDevice device) {
        boolean isHasPermission = false;
        this.mUsbManager.requestPermission(device, this.mPermissionIntent);
        this.mIsWaitUserGrantAction = true;
        while (!this.mIsUserGrantAction && this.mIsWaitUserGrantAction || isHasPermission != this.mIsUserGrantAction) {
            isHasPermission = this.mUsbManager.hasPermission(device);
            SysUtil.sleep((int)100);
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getUserPermission(%s) - [%s]", (Object[])new Object[]{device.getProductName() == null ? "" : device.getProductName(), this.mIsUserGrantAction});
        return this.mIsUserGrantAction;
    }

    private UsbSerialDriver getUsbCdcDevice() throws Exception {
        UsbDevice device;
        List<UsbSerialDriver> list = null;
        try {
            list = mUsbProber.findAllDrivers(this.mUsbManager);
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (String)"INFO. getUsbCdcDevice() - Failed to found usb driver - exception error");
        }
        if (list.size() == 0) {
            ATLog.e((String)this.TAG, (String)"ERROR. getUsbCdcDevice() - Failed to found the usb driver");
            throw new NullPointerException("Failed to found the usb driver");
        }
        UsbSerialDriver driver = list.get(0);
        if (driver == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. getUsbCdcDevice() - usb driver is null");
            throw new NullPointerException("usb driver is null");
        }
        if (ATLog.isLogging((int)10)) {
            for (UsbSerialDriver item : list) {
                ATLog.i((String)this.TAG, (int)7, (String)"INFO. getUsbCdcDevice() - Detect USB : [%s, %s(%04X), %s(%04X), %s]", (Object[])new Object[]{item.getDevice().getDeviceName() == null ? "" : item.getDevice().getDeviceName(), item.getDevice().getManufacturerName() == null ? "" : item.getDevice().getManufacturerName(), item.getDevice().getVendorId(), item.getDevice().getProductName() == null ? "" : item.getDevice().getProductName(), item.getDevice().getProductId(), item.getDevice().getSerialNumber() == null ? "" : item.getDevice().getSerialNumber()});
            }
        }
        if ((device = driver.getDevice()) == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. getUsbCdcDevice() - USB Device is null");
            throw new NullPointerException("usb device is null");
        }
        int index = 0;
        while (index < device.getInterfaceCount()) {
            UsbInterface usbInterface = device.getInterface(index);
            if (ATLog.isLogging((int)10)) {
                ATLog.i((String)this.TAG, (int)7, (String)"INFO. getUsbCdcDevice() - Interface [%s] , Class [%d] , Sub Class [%d]", (Object[])new Object[]{usbInterface.getName() == null ? "" : usbInterface.getName(), usbInterface.getInterfaceClass(), usbInterface.getInterfaceSubclass()});
            }
            if (usbInterface.getInterfaceClass() == 10) {
                ATLog.d((String)this.TAG, (int)7, (String)"INFO. getUsbCdcDevice() - Detected USB CDC Device.");
            }
            ++index;
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. getUsbCdcDevice()");
        return driver;
    }

    private String detectCdcDevice() throws Exception {
        if (this.mUsbDriver != null) {
            ATLog.i((String)this.TAG, (int)7, (String)"INFO. detectCdcDevice() - Already USB Driver is opened");
            return this.mUsbDriver.getDevice().getDeviceName();
        }
        UsbSerialDriver driver = null;
        try {
            driver = this.getUsbCdcDevice();
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (String)"ERROR. detectCdcDevice() - Failed to found the usb drvier");
        }
        if (driver == null) {
            return null;
        }
        String name = driver.getDevice().getDeviceName();
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. detectCdcDevice() - %s", (Object[])new Object[]{name == null ? "" : name});
        return name;
    }

    private boolean open(String id) throws Exception {
        int result = 0;
        if (this.mUsbDriver != null && this.mIsUsbPermission && this.mIsUsbOpened) {
            ATLog.i((String)this.TAG, (int)7, (String)"INFO. open(%s) - Already USB Driver is opened", (Object[])new Object[]{id});
            return true;
        }
        try {
            this.mUsbDriver = this.getUsbCdcDevice();
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (String)"ERROR. open(%s) - Failed to found the usb drvier", (Object[])new Object[]{id});
            return false;
        }
        if (this.mUsbDriver == null) {
            ATLog.e((String)this.TAG, (String)"INFO. open(%s) - USB Driver is null", (Object[])new Object[]{id});
            return false;
        }
        this.mIsUsbPermission = this.mUsbManager.hasPermission(this.mUsbDriver.getDevice());
        if (!this.mIsUsbPermission) {
            ATLog.i((String)this.TAG, (int)7, (String)"INFO. open(%s) - request USB Permission", (Object[])new Object[]{id});
            this.mIsUsbPermission = this.getUserPermission(this.mUsbDriver.getDevice());
        }
        if (!this.mIsUsbPermission) {
            this.mUsbDriver = null;
            ATLog.e((String)this.TAG, (String)"ERROR. open(%s) - USB Port don't get permission", (Object[])new Object[]{id});
            return false;
        }
        List<UsbSerialPort> list = this.mUsbDriver.getPorts();
        this.mUsbPort = list.get(0);
        if (this.mUsbPort == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. open(%s) - USB Port is null", (Object[])new Object[]{id});
            return false;
        }
        UsbDeviceConnection usbConnection = this.mUsbManager.openDevice(this.mUsbDriver.getDevice());
        if (usbConnection == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. open(%s) - USB Connection is null", (Object[])new Object[]{id});
            return false;
        }
        try {
            this.mUsbPort.open(usbConnection);
        }
        catch (IOException e) {
            ATLog.e((String)this.TAG, (String)"ERROR. open(%s) - Failed to open the USB Port", (Object[])new Object[]{id});
            this.mUsbDriver = null;
            usbConnection.close();
            return false;
        }
        try {
            result = this.mUsbPort.setDTR(true);
        }
        catch (IOException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. open(%s) - Failed to set DTR of the USB Port", (Object[])new Object[]{id});
            this.mUsbDriver = null;
            usbConnection.close();
            return false;
        }
        if (result < 0) {
            ATLog.e((String)this.TAG, (String)"ERROR. open(%s) - Failed to set DTR of the USB Port [%d]", (Object[])new Object[]{id, result});
            this.mUsbDriver = null;
            usbConnection.close();
            return false;
        }
        try {
            result = this.mUsbPort.setRTS(true);
        }
        catch (IOException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. open(%s) - Failed to set RTS of the USB Port", (Object[])new Object[]{id});
            this.mUsbDriver = null;
            usbConnection.close();
            return false;
        }
        if (result < 0) {
            ATLog.e((String)this.TAG, (String)"ERROR. open(%s) - Failed to set RTS of the USB Port[%d]", (Object[])new Object[]{id, result});
            this.mUsbDriver = null;
            usbConnection.close();
            return false;
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. open(%s)", (Object[])new Object[]{id});
        return true;
    }

    private void close() throws Exception {
        int result = 0;
        try {
            if (this.mUsbPort != null && (result = this.mUsbPort.setRTS(false)) < 0) {
                ATLog.e((String)this.TAG, (String)"ERROR. close() - Failed to clear RTS of the USB Port[%d]", (Object[])new Object[]{result});
            }
        }
        catch (IOException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. close() - Failed to clear RTS of the USB Port - IOException", (Object[])new Object[0]);
        }
        try {
            if (this.mUsbPort != null && (result = this.mUsbPort.setDTR(false)) < 0) {
                ATLog.e((String)this.TAG, (String)"ERROR. close() - Failed to clear DTR of the USB Port[%d]", (Object[])new Object[]{result});
            }
        }
        catch (IOException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. close() - Failed to clear DTR of the USB Port - IOException", (Object[])new Object[0]);
        }
        try {
            if (this.mUsbPort != null) {
                this.mUsbPort.close();
                this.mUsbPort = null;
            }
        }
        catch (IOException e) {
            ATLog.e((String)this.TAG, (String)"ERROR. close() - Failed to close the USB Port");
        }
        this.mIsUsbOpened = false;
        this.mUsbDriver = null;
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. close()");
    }

    private class ConnectThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ATLog.i((String)ATransportUsb.this.TAG, (int)7, (String)"+++ INFO. $ConnectThread.run()");
            try {
                ATransportUsb.this.mIsUsbOpened = ATransportUsb.this.open("");
            }
            catch (Exception e) {
                ATLog.e((String)ATransportUsb.this.TAG, (String)"ERROR. $ConnectThread.run() - Failed to open the USB Port");
                try {
                    ATransportUsb.this.close();
                }
                catch (Exception e1) {
                    ATLog.e((String)ATransportUsb.this.TAG, (Throwable)e1, (String)"ERROR. $ConnectThread.run() - Failed to close the USB Port", (Object[])new Object[0]);
                }
                ATransportUsb.this.setState(ConnectState.Disconnected, null);
                return;
            }
            ATransportUsb e = ATransportUsb.this;
            synchronized (e) {
                ATransportUsb.this.mConnectThread = null;
            }
            if (ATransportUsb.this.mIsUsbOpened) {
                ATransportUsb.this.startReceiveThread();
            } else {
                try {
                    ATransportUsb.this.close();
                }
                catch (Exception e2) {
                    ATLog.e((String)ATransportUsb.this.TAG, (Throwable)e2, (String)"ERROR. $ConnectThread.run() - Failed to close the USB Port", (Object[])new Object[0]);
                }
                ATransportUsb.this.setState(ConnectState.Disconnected, null);
            }
            ATLog.i((String)ATransportUsb.this.TAG, (int)7, (String)"--- INFO. $ConnectThread.run()");
        }

        public void cancel() {
            if (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    ATLog.e((String)ATransportUsb.this.TAG, (Throwable)e, (String)"ERROR. $ConnectThread.cancel() - Failed to wait terminate receive thread", (Object[])new Object[0]);
                }
            }
            ATLog.i((String)ATransportUsb.this.TAG, (int)7, (String)"INFO. $ConnectThread.cancel()");
        }
    }

    private class ReceiveThread
    extends Thread {
        private final UsbSerialPort mPort;

        public ReceiveThread(UsbSerialPort port) {
            this.mPort = port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int recvBytes = 0;
            int queueSize = 0;
            boolean OFFSET = false;
            byte[] recvBuf = new byte[4096];
            ATLog.i((String)ATransportUsb.this.TAG, (int)7, (String)"+++ INFO. $ReceiveThread.run()");
            ATransportUsb.this.setState(ConnectState.Connected, null);
            while (true) {
                block10: {
                    try {
                        recvBytes = this.mPort.read(recvBuf);
                        if (!ATLog.isLogging((int)9)) break block10;
                        ATLog.i((String)ATransportUsb.this.TAG, (int)9, (String)"RECV. [%4d] [%s]", (Object[])new Object[]{recvBytes, Dump.dump((byte[])recvBuf, (int)recvBytes)});
                    }
                    catch (Exception e) {
                        try {
                            ATransportUsb.this.close();
                        }
                        catch (Exception e1) {
                            ATLog.e((String)ATransportUsb.this.TAG, (Throwable)e, (String)"ERROR. $ReceiveThread.run() - Failed to close the usb port", (Object[])new Object[0]);
                        }
                        ATransportUsb.this.setState(ConnectState.Disconnected, null);
                        ATransportUsb.this.mReceiveThread = null;
                        break;
                    }
                }
                if (recvBytes <= 0) continue;
                try {
                    ByteQueue e = ATransportUsb.this.mQueue;
                    synchronized (e) {
                        queueSize = ATransportUsb.this.mQueue.enqueue(recvBuf, 0, recvBytes);
                        ATransportUsb.this.mQueue.notifyAll();
                    }
                    ATransportUsb.this.checkBufferSize(queueSize);
                }
                catch (Exception e) {
                    ATLog.e((String)ATransportUsb.this.TAG, (Throwable)e, (String)"ERROR. $ReceiveThread.run() - Failed to enqueue", (Object[])new Object[0]);
                }
            }
            ATLog.i((String)ATransportUsb.this.TAG, (int)7, (String)"--- INFO. $ReceiveThread.run()");
        }

        public void cancel() {
            try {
                ATransportUsb.this.close();
            }
            catch (Exception e) {
                ATLog.e((String)ATransportUsb.this.TAG, (Throwable)e, (String)"ERROR. $ReceiveThread.cancel() - Failed to close the usb port", (Object[])new Object[0]);
            }
            if (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    ATLog.e((String)ATransportUsb.this.TAG, (Throwable)e, (String)"ERROR. $ReceiveThread.cancel() - Failed to wait terminate receive thread", (Object[])new Object[0]);
                }
            }
            ATLog.i((String)ATransportUsb.this.TAG, (int)7, (String)"INFO. $ReceiveThread.cancel()");
        }

        public int write(byte[] data, int offset, int length) {
            if (data == null) {
                ATLog.e((String)ATransportUsb.this.TAG, (String)"ERROR. write() - Data is null");
                return 0;
            }
            if (this.mPort == null) {
                ATLog.e((String)ATransportUsb.this.TAG, (String)"ERROR. write(%s, %d, %d) - Failed to initialize the usb port", (Object[])new Object[]{Dump.dump((byte[])data, (int)offset, (int)length), offset, length});
                return -1;
            }
            try {
                this.mPort.write(data, offset, length);
            }
            catch (Exception e) {
                ATLog.e((String)ATransportUsb.this.TAG, (Throwable)e, (String)"ERROR. write(%s, %d, %d) - Failed to write data", (Object[])new Object[]{Dump.dump((byte[])data, (int)offset, (int)length), offset, length});
                return -2;
            }
            if (ATLog.isLogging((int)9)) {
                ATLog.i((String)ATransportUsb.this.TAG, (int)9, (String)"SEND. [%s<%s>] [%04d][%s]", (Object[])new Object[]{ATransportUsb.this.getDeviceType(), ATransportUsb.this.getAddress(), length, Dump.dump((byte[])data, (int)offset, (int)length)});
            }
            return length;
        }

        public int write(byte[] data, int offset, int length, int timeout) {
            if (data == null) {
                ATLog.e((String)ATransportUsb.this.TAG, (String)"ERROR. write() - Data is null");
                return 0;
            }
            if (this.mPort == null) {
                ATLog.e((String)ATransportUsb.this.TAG, (String)"ERROR. write(%s, %d, %d, %d) - Failed to initialize the usb port", (Object[])new Object[]{Dump.dump((byte[])data, (int)offset, (int)length), offset, length, timeout});
                return -1;
            }
            try {
                this.mPort.write(data, offset, length, timeout);
            }
            catch (Exception e) {
                ATLog.e((String)ATransportUsb.this.TAG, (Throwable)e, (String)"ERROR. write(%s, %d, %d, %d) - Failed to write data", (Object[])new Object[]{Dump.dump((byte[])data, (int)offset, (int)length), offset, length, timeout});
                return -2;
            }
            if (ATLog.isLogging((int)9)) {
                ATLog.i((String)ATransportUsb.this.TAG, (int)9, (String)"SEND. [%s<%s>] [%04d][%s]", (Object[])new Object[]{ATransportUsb.this.getDeviceType(), ATransportUsb.this.getAddress(), length, Dump.dump((byte[])data, (int)offset, (int)length)});
            }
            return length;
        }
    }
}

