/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.protocol;

import com.atid.lib.types.ResultCode;
import com.atid.lib.util.converts.BitConvert;
import com.atid.lib.util.diagnotics.ATLog;
import com.atid.lib.util.diagnotics.Dump;
import java.util.Locale;

public class Response {
    private static final String TAG = Response.class.getSimpleName();
    private static final int INFO = 8;
    private static final byte RES_CODE_LENGTH = 4;
    private ResultCode mCode;
    private byte[] mData;

    public Response(int code) {
        this.mCode = ResultCode.valueOf(code);
        this.mData = null;
    }

    public Response(ResultCode code) {
        this.mCode = code;
        this.mData = null;
    }

    public Response(byte[] data) throws Exception {
        this.mCode = Response.getResultCode(data);
        if (data.length > 4) {
            this.mData = new byte[data.length - 4];
            System.arraycopy(data, 4, this.mData, 0, data.length - 4);
        } else {
            this.mData = null;
        }
    }

    public ResultCode getCode() {
        return this.mCode;
    }

    public byte[] getData() {
        return this.mData;
    }

    public String toString() {
        return String.format(Locale.US, "%04X, [%s]", this.mCode, Dump.dump((byte[])this.mData));
    }

    public static ResultCode getResultCode(byte[] data) throws Exception {
        if (data == null || data.length < 4) {
            throw new Exception("Invalid response data");
        }
        int code = BitConvert.toInteger((byte[])data, (int)0, (int)4, (int)16);
        ResultCode res = ResultCode.valueOf(code);
        ATLog.i((String)TAG, (int)8, (String)"INFO. getResultCode([%s]) - [%s]", (Object[])new Object[]{Dump.dump((byte[])data), res});
        return res;
    }
}

