/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.util;

import com.atid.lib.types.DeviceType;
import com.atid.lib.util.diagnotics.ATLog;

public class Version {
    private static final String TAG = Version.class.getSimpleName();
    private static final int MASK = 0xFFFFFF;
    private static final int HW_MASK = -16777216;
    private static final int MAX_VERSION = 4;
    private static final String PREFIX_RFBLASTER = "bl-";
    private static final String PREFIX_AT188 = "df-";
    private static final String PREFIX_AT388_OLD = "sp-";
    private static final String PREFIX_AT388 = "bd-";
    private static final String PREFIX_ATS100_OLD = "at-";
    private static final String PREFIX_ATS100_NEW = "ats-";
    private static final String PREFIX_ASR250G = "ar-";
    private static final String PREFIX_ATD100 = "dt-";
    public static final int ATS100_V_X_1_0_5 = 65541;
    public static final int V_5_2_2_28 = 84017692;
    public static final int V_6_0_0_00 = 0x6000000;
    public static final int V_X_2_2_1 = 131585;
    public static final int V_X_2_2_5 = 131589;
    public static final int V_X_2_2_20 = 131604;
    public static final int V_X_2_2_18 = 131602;
    public static final int V_X_2_2_29 = 131613;
    public static final int V_7_2_5_2 = 117572866;
    public static final int V_7_2_5_13 = 117572877;
    private int mVersionHexa = 0;
    private int mFullVersion = 0;
    private DeviceType mType = DeviceType.Unknown;
    private String mVersionString;
    private String mSerialNo = "";

    public void setVersion(String version) {
        this.mVersionString = version;
        String ver = "";
        String[] vers = null;
        int verNo = 0;
        int temp = 0;
        int length = 0;
        if (version.startsWith(PREFIX_RFBLASTER)) {
            this.mType = DeviceType.RFPrisma;
            ver = version.replace(PREFIX_RFBLASTER, "");
        } else if (version.startsWith(PREFIX_AT188)) {
            this.mType = DeviceType.AT188N;
            ver = version.replace(PREFIX_AT188, "");
        } else if (version.startsWith(PREFIX_AT388)) {
            this.mType = DeviceType.AT388;
            ver = version.replace(PREFIX_AT388, "");
        } else if (version.startsWith(PREFIX_AT388_OLD)) {
            this.mType = DeviceType.AT388;
            ver = version.replace(PREFIX_AT388_OLD, "");
        } else if (version.startsWith(PREFIX_ATS100_OLD)) {
            this.mType = DeviceType.ATS100;
            ver = version.replace(PREFIX_ATS100_OLD, "");
        } else if (version.startsWith(PREFIX_ATS100_NEW)) {
            this.mType = DeviceType.ATS100;
            ver = version.replace(PREFIX_ATS100_NEW, "");
        } else if (version.startsWith(PREFIX_ASR250G)) {
            this.mType = DeviceType.ASR250G;
            ver = version.replace(PREFIX_ASR250G, "");
        } else if (version.startsWith(PREFIX_ATD100)) {
            this.mType = DeviceType.ATD100;
            ver = version.replace(PREFIX_ATD100, "");
        } else {
            this.mType = DeviceType.Unknown;
            ATLog.e((String)TAG, (String)"ERROR. setVersion([%s]) - Failed to not supported device", (Object[])new Object[]{version});
            return;
        }
        vers = ver.split("[.-]");
        length = vers.length > 4 ? 4 : vers.length;
        int i = 0;
        while (i < length) {
            try {
                temp = Integer.parseInt(vers[i]);
            }
            catch (Exception e) {
                temp = 0;
            }
            verNo |= temp << (length - (i + 1)) * 8;
            ++i;
        }
        this.mFullVersion = verNo;
        this.mVersionHexa = verNo & 0xFFFFFF;
    }

    public DeviceType getDeviceType() {
        return this.mType;
    }

    public int getVersionHexa() {
        return this.mVersionHexa;
    }

    public int getFullVersion() {
        return this.mFullVersion;
    }

    public String getVersionString() {
        return this.mVersionString;
    }

    public String getSerialNo() {
        return this.mSerialNo;
    }

    public void setSerialNo(String serialNo) {
        this.mSerialNo = serialNo;
    }
}

