/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.transport;

import com.atid.lib.diagnostics.ATException;
import com.atid.lib.transport.types.ConnectState;
import com.atid.lib.transport.types.ConnectType;
import com.atid.lib.types.DeviceType;
import com.atid.lib.util.collections.ByteQueue;
import java.util.Locale;

public abstract class ATransport {
    protected static final int INFO = 7;
    protected static final int IO = 8;
    protected static final int DUMP = 9;
    protected String TAG = ATransport.class.getSimpleName();
    private IConnectStateEventListener mStateListener = null;
    private IBufferControlEventListener mBufferListener = null;
    protected volatile ConnectState mState = ConnectState.Disconnected;
    protected volatile ConnectType mConnType = ConnectType.Unknown;
    protected volatile DeviceType mDevType;
    protected volatile String mDevName;
    protected volatile String mMacAddress;
    protected volatile String mAddress;
    protected volatile boolean mIsAutoConnect;
    protected volatile boolean mIsDeviceAttached;
    private int mBufMin;
    private int mBufMax;
    protected ByteQueue mQueue;

    public ATransport() {
        this.mDevType = DeviceType.Unknown;
        this.mDevName = "";
        this.mMacAddress = "";
        this.mAddress = "";
        this.mIsAutoConnect = false;
        this.mIsDeviceAttached = false;
        this.mBufMin = 0;
        this.mBufMax = 0;
        this.mQueue = new ByteQueue();
    }

    public ATransport(DeviceType type, String name, String address) {
        this.mDevType = type;
        this.mDevName = name;
        this.mMacAddress = "";
        this.mAddress = address;
        this.mIsAutoConnect = false;
        this.mIsDeviceAttached = false;
        this.mBufMin = 0;
        this.mBufMax = 0;
        this.mQueue = new ByteQueue();
    }

    public ATransport(DeviceType type, String name, String address, boolean autoConnect) {
        this.mDevType = type;
        this.mDevName = name;
        this.mMacAddress = "";
        this.mAddress = address;
        this.mIsAutoConnect = autoConnect;
        this.mIsDeviceAttached = false;
        this.mBufMin = 0;
        this.mBufMax = 0;
        this.mQueue = new ByteQueue();
    }

    public ATransport(DeviceType type, String name, String mac, String address) {
        this.mDevType = type;
        this.mDevName = name;
        this.mMacAddress = mac;
        this.mAddress = address;
        this.mIsAutoConnect = false;
        this.mIsDeviceAttached = false;
        this.mBufMin = 0;
        this.mBufMax = 0;
        this.mQueue = new ByteQueue();
    }

    public ATransport(DeviceType type, String name, String mac, String address, boolean autoConnect) {
        this.mDevType = type;
        this.mDevName = name;
        this.mMacAddress = mac;
        this.mAddress = address;
        this.mIsAutoConnect = autoConnect;
        this.mIsDeviceAttached = false;
        this.mBufMin = 0;
        this.mBufMax = 0;
        this.mQueue = new ByteQueue();
    }

    public abstract void destroy();

    public abstract void setAutoConnect(boolean var1);

    public abstract boolean getAutoConnect();

    public abstract boolean getDeviceAttached();

    public abstract boolean connect();

    public abstract void listen();

    public abstract void disconnect();

    public int write(byte[] data) {
        return this.write(data, 0, data.length);
    }

    public int write(byte[] data, int length) {
        return this.write(data, 0, length);
    }

    public abstract int write(byte[] var1, int var2, int var3);

    public abstract int write(byte[] var1, int var2, int var3, int var4);

    public abstract int available();

    public int read(byte[] data) {
        return this.read(data, 0, data.length);
    }

    public int read(byte[] data, int length) {
        return this.read(data, 0, length);
    }

    public abstract int read(byte[] var1, int var2, int var3);

    public abstract int read(byte[] var1, int var2, int var3, int var4);

    public void setStateListener(IConnectStateEventListener listener) {
        this.mStateListener = listener;
    }

    public void setBufferControlListener(int min, IBufferControlEventListener listener) {
        this.mBufMin = min;
        this.mBufMax = this.mQueue.getQueueSize();
        this.mBufferListener = listener;
    }

    public void setBufferControlListener(int min, int max, IBufferControlEventListener listener) {
        this.mBufMin = min;
        this.mBufMax = max;
        this.mBufferListener = listener;
    }

    public ConnectType getConnectType() {
        return this.mConnType;
    }

    public DeviceType getDeviceType() {
        return this.mDevType;
    }

    public void setDeviceType(DeviceType type) {
        this.mDevType = type;
    }

    public String getDeviceName() {
        return this.mDevName;
    }

    public void setDeviceName(String name) {
        this.mDevName = name;
    }

    public String getMacAddress() {
        return this.mMacAddress;
    }

    public void setMacAddress(String mac) {
        this.mMacAddress = mac;
    }

    public String getAddress() {
        return this.mAddress;
    }

    public void setAddress(String address) {
        this.mAddress = address;
    }

    public ConnectState getState() {
        return this.mState;
    }

    protected void setState(ConnectState state, final Object params) {
        if (this.mState == state) {
            return;
        }
        this.mState = state;
        if (this.mStateListener == null) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                ATransport.this.mStateListener.onStateChanged(ATransport.this.mState, params);
            }
        }).start();
    }

    protected void checkBufferSize(int size) {
        if (this.mBufferListener == null) {
            return;
        }
        if (size < this.mBufMin) {
            try {
                this.mBufferListener.onUnderflow();
            }
            catch (ATException aTException) {}
        } else if (size > this.mBufMax) {
            try {
                this.mBufferListener.onOverflow();
            }
            catch (ATException aTException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return String.format(Locale.US, "[%s], [%s], [%s], %s, %s, %s", new Object[]{this.mDevName, this.mMacAddress, this.mAddress, this.mDevType, this.mConnType, this.mState});
    }

    public static interface IBufferControlEventListener {
        public void onOverflow() throws ATException;

        public void onUnderflow() throws ATException;
    }

    public static interface IConnectStateEventListener {
        public void onStateChanged(ConnectState var1, Object var2);
    }
}

