/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.rfid.uhf.params;

import java.util.Locale;

public class PermaLock6cParam {
    private static final int KILL_PASSWORD = 0;
    private static final int ACCESS_PASSWORD = 1;
    private static final int EPC = 2;
    private static final int TID = 3;
    private static final int USER = 4;
    private static final int MAX_LOCK = 5;
    private LockState[] mLocks;

    public PermaLock6cParam() {
        this.mLocks = new LockState[]{LockState.NoChanged, LockState.NoChanged, LockState.NoChanged, LockState.NoChanged, LockState.NoChanged};
    }

    public PermaLock6cParam(LockState killPassword, LockState accessPassword, LockState epc, LockState tid, LockState user) {
        this.mLocks = new LockState[]{killPassword, accessPassword, epc, tid, user};
    }

    public LockState getKillPassword() {
        return this.mLocks[0];
    }

    public void setKillPassword(LockState value) {
        this.mLocks[0] = value;
    }

    public LockState getAccessPassword() {
        return this.mLocks[1];
    }

    public void setAccessPassword(LockState value) {
        this.mLocks[1] = value;
    }

    public LockState getEpc() {
        return this.mLocks[2];
    }

    public void setEpc(LockState value) {
        this.mLocks[2] = value;
    }

    public LockState getTid() {
        return this.mLocks[3];
    }

    public void setTid(LockState value) {
        this.mLocks[3] = value;
    }

    public LockState getUser() {
        return this.mLocks[4];
    }

    public void setUser(LockState value) {
        this.mLocks[4] = value;
    }

    public int getAction() {
        int action = 0;
        int code = 0;
        int i = 0;
        while (i < 5) {
            action <<= 2;
            code = this.mLocks[i].getAction();
            action |= code;
            ++i;
        }
        return action;
    }

    public int getMask() {
        int mask = 0;
        int code = 0;
        int i = 0;
        while (i < 5) {
            mask <<= 2;
            code = this.mLocks[i].getMask();
            mask |= code;
            ++i;
        }
        return mask;
    }

    public int getPermalock() {
        int value = 0;
        int code = 0;
        int i = 0;
        while (i < 5) {
            value <<= 1;
            code = this.mLocks[i] == LockState.PermalLock ? 1 : 0;
            value |= code;
            ++i;
        }
        return value;
    }

    public String toString() {
        return String.format(Locale.US, "%s, %s, %s, %s, %s", new Object[]{this.mLocks[0], this.mLocks[1], this.mLocks[2], this.mLocks[3], this.mLocks[4]});
    }

    public static enum LockState {
        NoChanged(0, 0, 0, "No Chaged"),
        PermalLock(1, 1, 1, "Perma Lock");

        private final int mCode;
        private final int mAction;
        private final int mMask;
        private final String mName;

        private LockState(int code, int action, int mask, String name) {
            this.mCode = code;
            this.mAction = action;
            this.mMask = mask;
            this.mName = name;
        }

        public int getCode() {
            return this.mCode;
        }

        public int getAction() {
            return this.mAction;
        }

        public int getMask() {
            return this.mMask;
        }

        public String toString() {
            return this.mName;
        }

        public static LockState valueOf(int action, int mask) {
            LockState[] lockStateArray = LockState.values();
            int n = lockStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                LockState item = lockStateArray[n2];
                if (item.getAction() == action && item.getMask() == mask) {
                    return item;
                }
                ++n2;
            }
            return NoChanged;
        }

        public static LockState valueOf(String string) {
            return Enum.valueOf(LockState.class, string);
        }
    }
}

