/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.rfid.uhf.params;

import java.util.Locale;

public class TagExtParam {
    private static final float KHz = 1000.0f;
    private final float mRssi;
    private final float mPhase;
    private final float mFrequency;

    public TagExtParam(int rssi, int phase) {
        this.mRssi = (float)rssi / 10.0f;
        this.mPhase = (float)((phase &= 0x7F) > 64 ? (128 - phase) * -1 : phase) / 64.0f * 180.0f;
        this.mFrequency = 0.0f;
    }

    public TagExtParam(int rssi, int phase, int frequency) {
        this.mRssi = (float)rssi / 10.0f;
        this.mPhase = (float)((phase &= 0x7F) > 64 ? (128 - phase) * -1 : phase) / 64.0f * 180.0f;
        this.mFrequency = (float)frequency / 1000000.0f;
    }

    public float getRssi() {
        return this.mRssi;
    }

    public float getPhase() {
        return this.mPhase;
    }

    public float getFrequency() {
        return this.mFrequency;
    }

    public String toString() {
        return String.format(Locale.US, "%.2f, %.2f, %.3f", Float.valueOf(this.mRssi), Float.valueOf(this.mPhase), Float.valueOf(this.mFrequency));
    }
}

