/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.barcode.module;

import com.atid.lib.diagnostics.ATException;
import com.atid.lib.protocol.IProtocol;
import com.atid.lib.protocol.Response;
import com.atid.lib.types.ModuleBarcodeType;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.StringUtil;
import com.atid.lib.util.converts.BitConvert;
import com.atid.lib.util.diagnotics.ATLog;
import com.atid.lib.util.diagnotics.Dump;
import java.nio.charset.Charset;

public class ATModuleBarcode {
    protected static final int INFO = 6;
    protected static final int DEFAULT_TIMEOUT = 3000;
    private static final int MAX_PARAM_LENGTH = 190;
    protected String TAG = ATModuleBarcode.class.getSimpleName();
    private ModuleBarcodeType mType;
    private IProtocol mProtocol;
    private Charset mCharset;
    protected int mTimeout;
    protected IModuleBarcodeEventListener mListener;

    public ATModuleBarcode(ModuleBarcodeType type, IProtocol protocol, IModuleBarcodeEventListener listener) {
        this.mType = type;
        this.mProtocol = protocol;
        this.mTimeout = 3000;
        this.mListener = listener;
        this.mCharset = Charset.defaultCharset();
    }

    public ModuleBarcodeType getType() {
        return this.mType;
    }

    public IProtocol getProtocol() {
        return this.mProtocol;
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public void setTimeout(int timeout) {
        this.mTimeout = timeout;
    }

    public ResultCode startDecode() {
        ResultCode res = ResultCode.NoError;
        res = this.getProtocol().post((byte)97, (byte)100, null);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. startDecode() - Failed to send action [%s]", (Object[])new Object[]{res});
            return res;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. startDecode()");
        return ResultCode.NoError;
    }

    public ResultCode stopAction() {
        ResultCode res = ResultCode.NoError;
        res = this.getProtocol().post((byte)97, (byte)115, null);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. stopAction() - Failed to send action [%s]", (Object[])new Object[]{res});
            return res;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. stopAction()");
        return ResultCode.NoError;
    }

    public String getVersion() throws ATException {
        String value = "";
        Response res = this.getProtocol().send((byte)114, (byte)75, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getVersion() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toString((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getVersion() - [%s]", (Object[])new Object[]{value});
        return value;
    }

    public byte[] getBarcodeParam(byte[] names) throws ATException {
        int len = 0;
        byte[] sendBytes = null;
        byte[] resBytes = null;
        len = names.length > 190 ? 190 : names.length;
        sendBytes = new byte[len + 1];
        sendBytes[0] = (byte)len;
        System.arraycopy(names, 0, sendBytes, 1, len);
        Response res = null;
        res = this.getProtocol().send((byte)114, (byte)72, sendBytes, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getBarcodeParam([%s]) - Failed to response [%s]", (Object[])new Object[]{Dump.dump((byte[])names), res.getCode()});
            throw new ATException(res.getCode());
        }
        resBytes = res.getData();
        if (resBytes.length != (len = resBytes[0]) + 1) {
            ATLog.e((String)this.TAG, (String)"ERROR. getBarcodeParam([%s]) - Failed to invalid response data length", (Object[])new Object[]{Dump.dump((byte[])names)});
            throw new ATException(ResultCode.InvalidResponseData);
        }
        byte[] params = new byte[len];
        System.arraycopy(resBytes, 1, params, 0, len);
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getBarcodeParam([%s]) - [%s]", (Object[])new Object[]{Dump.dump((byte[])names), Dump.dump((byte[])params)});
        return params;
    }

    public void setBarcodeParam(byte[] params) throws ATException {
        int len = 0;
        byte[] data = null;
        len = params.length > 190 ? 190 : params.length;
        data = new byte[len + 1];
        data[0] = (byte)len;
        System.arraycopy(params, 0, data, 1, len);
        Response res = null;
        res = this.getProtocol().send((byte)119, (byte)72, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setBarcodeParam([%s]) - Failed to response [%s]", (Object[])new Object[]{Dump.dump((byte[])params), res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setBarcodeParam(%s)", (Object[])new Object[]{Dump.dump((byte[])params)});
    }

    public Charset getCharset() {
        return this.mCharset;
    }

    public void setCharset(Charset charset) throws ATException {
        if (!Charset.isSupported(charset.name())) {
            ATLog.e((String)this.TAG, (String)"ERROR. setCharset() - Not supported [%s]", (Object[])new Object[]{charset.name()});
            throw new ATException(ResultCode.NotSupported);
        }
        this.mCharset = charset;
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setCharset(%s)", (Object[])new Object[]{charset.name()});
    }

    public void PumpEvent(int event, byte[] data) {
        if (event != 67) {
            return;
        }
        String value = new String(data, this.mCharset);
        byte type = StringUtil.toByte((String)value.substring(0, 2), (int)16);
        String barcode = value.substring(2);
        if (this.mListener != null) {
            this.mListener.onReadBarcode(type, barcode, null);
        }
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. PumpEvent([%c], [%s])", (Object[])new Object[]{event, Dump.dump((byte[])data)});
        }
    }

    public static interface IModuleBarcodeEventListener {
        public void onReadBarcode(int var1, String var2, Object var3);
    }
}

