/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.barcode.types;

import com.atid.lib.types.IEnumType;

public enum BarcodeType implements IEnumType
{
    NoRead(0, "No Read"),
    StateUS(1, "4State US"),
    StateUS4(2, "4State US4"),
    AztecCode(3, "Aztec Code"),
    AztecRuneCode(4, "Aztec Rune Code"),
    Bookland(5, "Bookland"),
    ChinaPost(6, "Chinese 2 of 5"),
    Codabar(7, "Codabar"),
    CodablockA(8, "Codablock A"),
    CodablockF(9, "Codablock F"),
    Code11(10, "Code 11"),
    Code128(11, "Code 128"),
    Code16K(12, "Code 16K"),
    Code32(13, "Code 32"),
    Code39(14, "Code 39"),
    Code39FullASCII(15, "Code 39 Full ASCII"),
    Code49(16, "Code 49"),
    Code93(17, "Code 93"),
    CouponCode(18, "Coupon Code"),
    CueCATCode(19, "Cue CAT Code"),
    DataMatrix(20, "Data Matrix"),
    D2of5(21, "Discrete 2 of 5"),
    EAN13(22, "EAN-13"),
    EAN13_2(23, "EAN-13 + 2"),
    EAN13_5(24, "EAN-13 + 5"),
    EAN8(25, "EAN-8"),
    EAN8_2(26, "EAN-8 + 2"),
    EAN8_5(27, "EAN-8 + 5"),
    FrenchLottery(28, "French Lottery"),
    GS1_Composite(29, "GS1 Composite Code"),
    GS1_Expanded(30, "GS1 DataBar Expanded"),
    GS1_Limited(31, "GS1 DataBar Limited"),
    GS1_14(32, "GS1 DataBar-14"),
    GS1_Datamatrix(33, "GS1 Datamatrix"),
    GS1_QR(34, "GS1 QR"),
    GS1_128(35, "GS1-128"),
    HanXin(36, "Han Xin"),
    IATA(37, "IATA"),
    InfoMail(38, "InfoMail"),
    IntelMail(39, "Intelligent Mail Bar Code "),
    I2of5(40, "Interleaved 2 of 5"),
    ISBT_128(41, "ISBT-128"),
    ISBT_128Concat(42, "ISBT-128 Concat."),
    ISSN(43, "ISSN"),
    ITF(44, "ITF"),
    KixPost(45, "KIX Post"),
    KoreaPost(46, "Korean 3 of 5"),
    MacroMicroPDF(47, "Macro Micro PDF"),
    MacroPDF417(48, "Macro PDF-417"),
    MacroQRCode(49, "Macro QR Code"),
    M2of5(50, "Matrix 2 of 5"),
    Maxicode(51, "Maxicode"),
    MicroPDF(52, "Micro PDF"),
    MicroPDF_CCA(53, "Micro PDF CCA"),
    MicroQRCode(54, "Micro QR Code"),
    MSI(55, "MSI"),
    MultipacketFormat(56, "Multipacket Format"),
    N2of5(57, "NEC 2 of 5"),
    NW7(58, "NW7"),
    OCRB(59, "OCRB"),
    FNC3(60, "Parameter (FNC3)"),
    PDF417(61, "PDF-417"),
    Planet_US(62, "Planet (US)"),
    Postal_Australia(63, "Postal (Australia)"),
    Postal_Canadian(64, "Postal (Canadian)"),
    Postal_Dutch(65, "Postal (Dutch)"),
    Postal_Japan(66, "Postal (Japan)"),
    Postal_UK(67, "Postal (UK)"),
    Postal4i(68, "Postal-4i"),
    Postbar_CA(69, "Postbar (CA)"),
    Postnet_US(70, "Postnet (US)"),
    QRCode(71, "QR Code"),
    RFIDRaw(72, "RFID Raw"),
    RFIDURI(73, "RFID URI"),
    RSS_ExpandedCoupon(74, "RSS (GS1 Databar) Expanded Coupon"),
    ScanletWebcode(75, "Scanlet Webcode"),
    Signature(76, "Signature"),
    R2of5(77, "Straight 2 of 5 IATA"),
    Telepen(78, "Telepen"),
    TLC39(79, "TLC-39"),
    Trioptic(80, "Trioptic"),
    UPCA(81, "UPCA"),
    UPCA_2(82, "UPCA + 2"),
    UPCA_5(83, "UPCA + 5"),
    UPCE(84, "UPCE"),
    UPCE_2(85, "UPCE + 2"),
    UPCE_5(86, "UPCE + 5"),
    UPCE1(87, "UPCE1"),
    UPCE1_2(88, "UPCE1 + 2"),
    UPCE1_5(89, "UPCE1 + 5"),
    Composite_CCA_EAN13(90, "Composite (CC-A + EAN-13)"),
    Composite_CCA_EAN8(91, "Composite (CC-A + EAN-8)"),
    Composite_CCA_GS1Expanded(92, "Composite (CC-A + GS1 DataBar Expanded)"),
    Composite_CCA_GS1Limited(93, "Composite (CC-A + GS1 DataBar Limited)"),
    Composite_CCA_GS1(94, "Composite (CC-A + GS1 DataBar-14)"),
    Composite_CCA_GS1128(95, "Composite (CC-A + GS1-128)"),
    Composite_CCA_UPCA(96, "Composite (CC-A + UPC-A)"),
    Composite_CCA_UPCE(97, "Composite (CC-A + UPC-E)"),
    Composite_CCB_EAN13(98, "Composite (CC-B + EAN-13)"),
    Composite_CCB_EAN8(99, "Composite (CC-B + EAN-8)"),
    Composite_CCB_GS1Expanded(100, "Composite (CC-B + GS1 DataBar Expanded)"),
    Composite_CCB_GS1Limited(101, "Composite (CC-B + GS1 DataBar Limited)"),
    Composite_CCB_GS1(102, "Composite (CC-B + GS1 DataBar-14)"),
    Composite_CCB_GS1128(103, "Composite (CC-B + GS1-128)"),
    Composite_CCB_UPCA(104, "Composite (CC-B + UPC-A)"),
    Composite_CCB_UPCE(105, "Composite (CC-B + UPC-E)"),
    Composite_CCC_GS1128(106, "Composite (CC-C + GS1-128)"),
    Composite_CCAB(107, "Composite CC-A/B"),
    Composite_CCC(108, "Composite CC-C"),
    USPS_One_IntelMail(109, "USPS 4CB/One Code/Intelligent Mail"),
    UPUFICSPostal(110, "UPU FICS Postal"),
    PostalSel(111, "Postal Select"),
    Unknown(-1, "Unknown type");

    private final int mCode;
    private final String mName;
    private static final BarcodeType[] mItems;

    static {
        mItems = BarcodeType.values();
    }

    private BarcodeType(int code, String name) {
        this.mCode = code;
        this.mName = name;
    }

    public int getCode() {
        return this.mCode;
    }

    public String toString() {
        return this.mName;
    }

    public static BarcodeType valueOf(String string) {
        return Enum.valueOf(BarcodeType.class, string);
    }
}

