/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.barcode.spc.param;

import com.atid.lib.diagnostics.ATException;
import com.atid.lib.module.barcode.spc.param.SPCParamName;
import com.atid.lib.module.barcode.spc.param.SPCParamValue;
import com.atid.lib.module.barcode.spc.type.AustralianPostInterpretation;
import com.atid.lib.module.barcode.spc.type.CheckDigit;
import com.atid.lib.module.barcode.spc.type.CodabarCheckCharacter;
import com.atid.lib.module.barcode.spc.type.CodabarConcatenation;
import com.atid.lib.module.barcode.spc.type.Code11CheckDigitsRequired;
import com.atid.lib.module.barcode.spc.type.Code39CheckCharacter;
import com.atid.lib.module.barcode.spc.type.CodePages;
import com.atid.lib.module.barcode.spc.type.GS1Emulation;
import com.atid.lib.module.barcode.spc.type.MSICheckCharacter;
import com.atid.lib.module.barcode.spc.type.ResponseType;
import com.atid.lib.module.barcode.spc.type.UPCAEAN13ExtendedCouponCode;
import com.atid.lib.module.barcode.spc.type.VideoReverse;
import com.atid.lib.module.barcode.types.BarcodePostType;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.diagnotics.ATLog;
import java.util.ArrayList;

public class SPCParamValueList {
    private static final String TAG = SPCParamValueList.class.getSimpleName();
    private static final int INFO = 6;
    private static final int DEBUG = 2;
    private ArrayList<SPCParamValue> mList = new ArrayList();

    public SPCParamValueList() {
    }

    public SPCParamValueList(SPCParamValue item) {
        this.add(item);
    }

    public SPCParamValueList(SPCParamValue[] items) {
        this.add(items);
    }

    public synchronized int getCount() {
        return this.mList.size();
    }

    public synchronized boolean add(SPCParamValue item) {
        if (item == null) {
            ATLog.e((String)TAG, (String)"ERROR. add(item) - Invalid parameter");
            return false;
        }
        return this.mList.add(item);
    }

    public synchronized boolean add(SPCParamValue[] items) {
        boolean result = true;
        if (items == null) {
            ATLog.e((String)TAG, (String)"ERROR. add(item) - Invalid parameter");
            return false;
        }
        SPCParamValue[] sPCParamValueArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            SPCParamValue item = sPCParamValueArray[n2];
            result &= this.mList.add(item);
            ++n2;
        }
        return result;
    }

    public synchronized SPCParamValue getAt(SPCParamName name) throws ATException {
        if (name == null) {
            ATLog.e((String)TAG, (String)"ERROR. getAt() - Invalid parameter");
            throw new ATException(ResultCode.InvalidParameter);
        }
        for (SPCParamValue item : this.mList) {
            if (!item.getName().equals((Object)name)) continue;
            return item;
        }
        throw new ATException(ResultCode.NotFoundParameter);
    }

    public synchronized SPCParamValue get(int index) throws ATException {
        if (index < 0 || index > this.mList.size()) {
            ATLog.e((String)TAG, (String)"ERROR. get() - out of range !!");
            throw new ATException(ResultCode.InvalidParameter);
        }
        return this.mList.get(index);
    }

    public synchronized Object getValueAt(SPCParamName name) throws ATException {
        if (name == null) {
            ATLog.e((String)TAG, (String)"ERROR. getAt() - Invalid parameter");
            throw new ATException(ResultCode.InvalidParameter);
        }
        for (SPCParamValue item : this.mList) {
            if (!item.getName().equals((Object)name)) continue;
            return item.getValue();
        }
        throw new ATException(ResultCode.NotFoundParameter);
    }

    public synchronized Object getValue(int index) throws ATException {
        if (index < 0 || index > this.mList.size()) {
            ATLog.e((String)TAG, (String)"ERROR. get() - out of range !!");
            throw new ATException(ResultCode.InvalidParameter);
        }
        return this.mList.get(index).getValue();
    }

    public String getCommand(int engine) throws ATException {
        StringBuilder cmd = new StringBuilder();
        SPCParamName name = null;
        if (this.mList == null || this.mList.size() == 0) {
            ATLog.e((String)TAG, (String)"ERROR. Parameter is null or zero !!!");
            throw new ATException(ResultCode.InvalidParameter);
        }
        for (SPCParamValue item : this.mList) {
            if (cmd.length() > 0) {
                cmd.append(";");
            }
            name = item.getName();
            cmd.append(name.getCommand());
            switch (name) {
                case CodabarStartStopCharacters: 
                case Code39StartStopCharacters: 
                case Code39Append: 
                case Code39FullASCII: 
                case Code93Append: 
                case ISBT128Concatenation: 
                case Code128Append: 
                case UPCACheckDigit: 
                case UPCANumberSystem: 
                case UPCAAddenda2Digit: 
                case UPCAAddenda5Digit: 
                case UPCAAddendaRequired: 
                case UPCAAddendaSeparator: 
                case CouponGS1DataBarOutput: 
                case UPCE0Expand: 
                case UPCE0AddendaRequired: 
                case UPCE0AddendaSeparator: 
                case UPCE0CheckDigit: 
                case UPCE0LeadingZero: 
                case UPCE0Addenda2Digit: 
                case UPCE0Addenda5Digit: 
                case ConvertUPCAtoEAN13: 
                case EANJAN13CheckDigit: 
                case EANJAN13Addenda2Digit: 
                case EANJAN13Addenda5Digit: 
                case EANJAN13AddendaRequired: 
                case EANJAN13AddendaSeparator: 
                case ISBNTranslate: 
                case EANJAN8CheckDigit: 
                case EANJAN8Addenda2Digit: 
                case EANJAN8Addenda5Digit: 
                case EANJAN8AddendaRequired: 
                case EANJAN8AddendaSeparator: 
                case GS1CompositeCodes: 
                case UPCEANVersion: 
                case QRCodeAppend: 
                case AztecAppend: 
                case PlanetCodeCheckDigit: 
                case PostnetCheckDigit: 
                case KoreaPostCheckDigit: {
                    cmd.append((Boolean)item.getValue() != false ? "1" : "0");
                    break;
                }
                case CodabarMessageLengthMin: 
                case CodabarMessageLengthMax: 
                case Code39MessageLengthMin: 
                case Code39MessageLengthMax: 
                case I2of5MessageLengthMin: 
                case I2of5MessageLengthMax: 
                case NEC2of5MessageLengthMin: 
                case NEC2of5MessageLengthMax: 
                case Code93MessageLengthMin: 
                case Code93MessageLengthMax: 
                case Straight2of5IndustrialMessageLengthMin: 
                case Straight2of5IndustrialMessageLengthMax: 
                case Straight2of5IATAMessageLengthMin: 
                case Straight2of5IATAMessageLengthMax: 
                case Matrix2of5MessageLengthMin: 
                case Matrix2of5MessageLengthMax: 
                case Code11MessageLengthMin: 
                case Code11MessageLengthMax: 
                case Code128MessageLengthMin: 
                case Code128MessageLengthMax: 
                case GS1128MessageLengthMin: 
                case GS1128MessageLengthMax: 
                case MSIMessageLengthMin: 
                case MSIMessageLengthMax: 
                case GS1DataBarExpandedMessageLengthMin: 
                case GS1DataBarExpandedMessageLengthMax: 
                case CodablockAMessageLengthMin: 
                case CodablockAMessageLengthMax: 
                case CodablockFMessageLengthMin: 
                case CodablockFMessageLengthMax: 
                case PDF417MessageLengthMin: 
                case PDF417MessageLengthMax: 
                case MicroPDF417MessageLengthMin: 
                case MicroPDF417MessageLengthMax: 
                case GS1CompositeCodeMessageLengthMin: 
                case GS1CompositeCodeMessageLengthMax: 
                case QRCodeMessageLengthMin: 
                case QRCodeMessageLengthMax: 
                case DataMatrixMessageLengthMin: 
                case DataMatrixMessageLengthMax: 
                case MaxiCodeMessageLengthMin: 
                case MaxiCodeMessageLengthMax: 
                case AztecCodeMessageLengthMin: 
                case AztecCodeMessageLengthMax: 
                case HanXinCodeMessageLengthMin: 
                case HanXinCodeMessageLengthMax: 
                case ChinaPostMessageLengthMin: 
                case ChinaPostMessageLengthMax: 
                case KoreaPostMessageLengthMin: 
                case KoreaPostMessageLengthMax: {
                    cmd.append(Integer.toString((Integer)item.getValue()));
                    break;
                }
                case CodabarCheckCharacter: {
                    cmd.append(Integer.toString(((CodabarCheckCharacter)((Object)item.getValue())).getCode()));
                    break;
                }
                case CodabarConcatenation: {
                    cmd.append(Integer.toString(((CodabarConcatenation)((Object)item.getValue())).getCode()));
                    break;
                }
                case Code39CheckCharacter: {
                    cmd.append(Integer.toString(((Code39CheckCharacter)((Object)item.getValue())).getCode()));
                    break;
                }
                case Code39CodePage: 
                case Code93CodePage: 
                case Code128CodePage: 
                case QRCodePage: 
                case DataMatrixCodePage: 
                case AztecCodePage: {
                    cmd.append(Integer.toString(((CodePages)((Object)item.getValue())).getCode()));
                    break;
                }
                case I2of5CheckDigit: 
                case NEC2of5CheckDigit: {
                    cmd.append(Integer.toString(((CheckDigit)((Object)item.getValue())).getCode()));
                    break;
                }
                case Code11CheckDigitsRequired: {
                    cmd.append(Integer.toString(((Code11CheckDigitsRequired)((Object)item.getValue())).getCode()));
                    break;
                }
                case UPCAEAN13ExtendedCouponCode: {
                    cmd.append(Integer.toString(((UPCAEAN13ExtendedCouponCode)((Object)item.getValue())).getCode()));
                    break;
                }
                case MSICheckCharacter: {
                    cmd.append(Integer.toString(((MSICheckCharacter)((Object)item.getValue())).getCode()));
                    break;
                }
                case GS1Emulation: {
                    cmd.append(Integer.toString(((GS1Emulation)((Object)item.getValue())).getCode()));
                    break;
                }
                case AustralianPostInterpretation: {
                    cmd.append(Integer.toString(((AustralianPostInterpretation)((Object)item.getValue())).getCode()));
                    break;
                }
                case PostalCodes2D: {
                    cmd.append(Integer.toString(((BarcodePostType)((Object)item.getValue())).getCode()));
                    break;
                }
                case VideoReverse: {
                    cmd.append(Integer.toString(((VideoReverse)((Object)item.getValue())).getCode()));
                    break;
                }
                default: {
                    ATLog.d((String)TAG, (int)2, (String)"DEBUG. getCommand() - Unknown parameter name [%s] ", (Object[])new Object[]{name.toString()});
                }
            }
        }
        return cmd.toString();
    }

    public static SPCParamValueList parseParams(String data, int engine) throws ATException {
        String[] items;
        SPCParamValueList list = new SPCParamValueList();
        SPCParamName name = null;
        Object value = null;
        String val = "";
        int code = 0;
        if (data == null || data.isEmpty()) {
            ATLog.e((String)TAG, (String)"ERROR. parseParams() - Invalid parameter");
            throw new ATException(ResultCode.InvalidParameter);
        }
        ATLog.i((String)TAG, (int)6, (String)"INFO. parseParams(%s, %d)", (Object[])new Object[]{data, engine});
        String[] stringArray = items = data.split(";");
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            block20: {
                String item = stringArray[n2];
                try {
                    name = SPCParamName.valueOf(item, 0);
                }
                catch (ATException e) {
                    break block20;
                }
                ResponseType response = ResponseType.valueOf(item.charAt(item.length() - 1));
                val = item.substring(6, item.length() - 1);
                code = Integer.parseInt(val);
                ATLog.d((String)TAG, (int)2, (String)"DEBUG. getCommand() - name [%s] ", (Object[])new Object[]{name.toString()});
                switch (name) {
                    case CodabarStartStopCharacters: 
                    case Code39StartStopCharacters: 
                    case Code39Append: 
                    case Code39FullASCII: 
                    case Code93Append: 
                    case ISBT128Concatenation: 
                    case Code128Append: 
                    case UPCACheckDigit: 
                    case UPCANumberSystem: 
                    case UPCAAddenda2Digit: 
                    case UPCAAddenda5Digit: 
                    case UPCAAddendaRequired: 
                    case UPCAAddendaSeparator: 
                    case CouponGS1DataBarOutput: 
                    case UPCE0Expand: 
                    case UPCE0AddendaRequired: 
                    case UPCE0AddendaSeparator: 
                    case UPCE0CheckDigit: 
                    case UPCE0LeadingZero: 
                    case UPCE0Addenda2Digit: 
                    case UPCE0Addenda5Digit: 
                    case ConvertUPCAtoEAN13: 
                    case EANJAN13CheckDigit: 
                    case EANJAN13Addenda2Digit: 
                    case EANJAN13Addenda5Digit: 
                    case EANJAN13AddendaRequired: 
                    case EANJAN13AddendaSeparator: 
                    case ISBNTranslate: 
                    case EANJAN8CheckDigit: 
                    case EANJAN8Addenda2Digit: 
                    case EANJAN8Addenda5Digit: 
                    case EANJAN8AddendaRequired: 
                    case EANJAN8AddendaSeparator: 
                    case GS1CompositeCodes: 
                    case UPCEANVersion: 
                    case QRCodeAppend: 
                    case AztecAppend: 
                    case PlanetCodeCheckDigit: 
                    case PostnetCheckDigit: 
                    case KoreaPostCheckDigit: {
                        value = code == 1;
                        break;
                    }
                    case CodabarMessageLengthMin: 
                    case CodabarMessageLengthMax: 
                    case Code39MessageLengthMin: 
                    case Code39MessageLengthMax: 
                    case I2of5MessageLengthMin: 
                    case I2of5MessageLengthMax: 
                    case NEC2of5MessageLengthMin: 
                    case NEC2of5MessageLengthMax: 
                    case Code93MessageLengthMin: 
                    case Code93MessageLengthMax: 
                    case Straight2of5IndustrialMessageLengthMin: 
                    case Straight2of5IndustrialMessageLengthMax: 
                    case Straight2of5IATAMessageLengthMin: 
                    case Straight2of5IATAMessageLengthMax: 
                    case Matrix2of5MessageLengthMin: 
                    case Matrix2of5MessageLengthMax: 
                    case Code11MessageLengthMin: 
                    case Code11MessageLengthMax: 
                    case Code128MessageLengthMin: 
                    case Code128MessageLengthMax: 
                    case GS1128MessageLengthMin: 
                    case GS1128MessageLengthMax: 
                    case MSIMessageLengthMin: 
                    case MSIMessageLengthMax: 
                    case GS1DataBarExpandedMessageLengthMin: 
                    case GS1DataBarExpandedMessageLengthMax: 
                    case CodablockAMessageLengthMin: 
                    case CodablockAMessageLengthMax: 
                    case CodablockFMessageLengthMin: 
                    case CodablockFMessageLengthMax: 
                    case PDF417MessageLengthMin: 
                    case PDF417MessageLengthMax: 
                    case MicroPDF417MessageLengthMin: 
                    case MicroPDF417MessageLengthMax: 
                    case GS1CompositeCodeMessageLengthMin: 
                    case GS1CompositeCodeMessageLengthMax: 
                    case QRCodeMessageLengthMin: 
                    case QRCodeMessageLengthMax: 
                    case DataMatrixMessageLengthMin: 
                    case DataMatrixMessageLengthMax: 
                    case MaxiCodeMessageLengthMin: 
                    case MaxiCodeMessageLengthMax: 
                    case AztecCodeMessageLengthMin: 
                    case AztecCodeMessageLengthMax: 
                    case HanXinCodeMessageLengthMin: 
                    case HanXinCodeMessageLengthMax: 
                    case ChinaPostMessageLengthMin: 
                    case ChinaPostMessageLengthMax: 
                    case KoreaPostMessageLengthMin: 
                    case KoreaPostMessageLengthMax: {
                        ATLog.d((String)TAG, (int)2, (String)"DEBUG. getCommand() - code [%d] ", (Object[])new Object[]{code});
                        value = code;
                        break;
                    }
                    case CodabarCheckCharacter: {
                        value = CodabarCheckCharacter.valueOf(code);
                        break;
                    }
                    case CodabarConcatenation: {
                        value = CodabarConcatenation.valueOf(code);
                        break;
                    }
                    case Code39CheckCharacter: {
                        value = Code39CheckCharacter.valueOf(code);
                        break;
                    }
                    case Code39CodePage: 
                    case Code93CodePage: 
                    case Code128CodePage: 
                    case QRCodePage: 
                    case DataMatrixCodePage: 
                    case AztecCodePage: {
                        value = CodePages.valueOf(code);
                        break;
                    }
                    case I2of5CheckDigit: 
                    case NEC2of5CheckDigit: {
                        value = CheckDigit.valueOf(code);
                        break;
                    }
                    case Code11CheckDigitsRequired: {
                        value = Code11CheckDigitsRequired.valueOf(code);
                        break;
                    }
                    case UPCAEAN13ExtendedCouponCode: {
                        value = UPCAEAN13ExtendedCouponCode.valueOf(code);
                        break;
                    }
                    case MSICheckCharacter: {
                        value = MSICheckCharacter.valueOf(code);
                        break;
                    }
                    case GS1Emulation: {
                        value = GS1Emulation.valueOf(code);
                        break;
                    }
                    case AustralianPostInterpretation: {
                        value = AustralianPostInterpretation.valueOf(code);
                        break;
                    }
                    case PostalCodes2D: {
                        value = BarcodePostType.valueOf(code);
                        break;
                    }
                    case VideoReverse: {
                        value = VideoReverse.valueOf(code);
                        break;
                    }
                    default: {
                        ATLog.d((String)TAG, (int)2, (String)"DEBUG. getCommand() - Unknown parameter name [%s] ", (Object[])new Object[]{name.toString()});
                    }
                }
                list.add(new SPCParamValue(name, value, response));
            }
            ++n2;
        }
        return list;
    }
}

