/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.rfid.uhf.module.atm;

import android.util.Pair;
import com.atid.lib.device.IReader;
import com.atid.lib.diagnostics.ATException;
import com.atid.lib.module.rfid.uhf.module.ATModuleRfidUhf;
import com.atid.lib.module.rfid.uhf.params.TagExtParam;
import com.atid.lib.protocol.IProtocol;
import com.atid.lib.protocol.Response;
import com.atid.lib.types.ActionType;
import com.atid.lib.types.DeviceType;
import com.atid.lib.types.ModuleRfidUhfType;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.StringUtil;
import com.atid.lib.util.converts.BitConvert;
import com.atid.lib.util.diagnotics.ATLog;
import com.atid.lib.util.diagnotics.Dump;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Locale;

public class ATModuleRfidUhfATM
extends ATModuleRfidUhf {
    private static int NIBBLE_UNIT = 4;
    private boolean mIsReportRssi;

    public ATModuleRfidUhfATM(IReader reader, ModuleRfidUhfType type, IProtocol protocol, ATModuleRfidUhf.IModuleRfidUhfEventListener listener) {
        super(reader, type, protocol, listener);
        this.TAG = ATModuleRfidUhfATM.class.getSimpleName();
        this.mIsReportRssi = false;
    }

    public ResultCode inventory() {
        ResultCode res = ResultCode.NoError;
        res = this.getProtocol().post((byte)97, (byte)102, null);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. inventory() - Failed to send action [%s]", (Object[])new Object[]{res});
            return res;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. inventory()");
        return ResultCode.NoError;
    }

    public ResultCode readMemory(int bank, int offset, int length) {
        byte[] data = BitConvert.toBytes((String)String.format(Locale.US, "%d,%x,%x", bank, offset, length));
        ResultCode res = ResultCode.NoError;
        res = this.getProtocol().post((byte)97, (byte)114, data);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. readMemory(%d, %d, %d) - Failed to send action [%s]", (Object[])new Object[]{bank, offset, length, res});
            return res;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. readMemory(%d, %d, %d)", (Object[])new Object[]{bank, offset, length});
        return ResultCode.NoError;
    }

    public ResultCode writeMemory(int bank, int offset, String value) {
        if (StringUtil.isNullOrEmpty((String)value)) {
            ATLog.e((String)this.TAG, (String)"ERROR. writeMemory(%d, %d, [%s]) - Failed to invalid parameter [%s]", (Object[])new Object[]{bank, offset, value, ResultCode.InvalidParameter});
            return ResultCode.InvalidParameter;
        }
        int count = (int)Math.ceil((double)value.length() / (double)NIBBLE_UNIT);
        String param = String.format(Locale.US, "%d,%x,%x", bank, offset, count);
        String format = String.format(Locale.US, "%%-%ds", count * NIBBLE_UNIT);
        int padLen = (value = String.format(Locale.US, format, value).replace(" ", "")).length() % NIBBLE_UNIT;
        if (padLen != 0) {
            value = StringUtil.padLeft((String)value, (int)(value.length() + (NIBBLE_UNIT - padLen)), (char)'0');
        }
        int i = 0;
        while (i < count) {
            param = String.valueOf(param) + "," + value.substring(i * NIBBLE_UNIT, (i + 1) * NIBBLE_UNIT);
            ++i;
        }
        byte[] data = BitConvert.toBytes((String)param);
        ResultCode res = ResultCode.NoError;
        res = this.getProtocol().post((byte)97, (byte)119, data);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. writeMemory(%d, %d, [%s]) - Failed to send action [%s]", (Object[])new Object[]{bank, offset, value, res});
            return res;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. writeMemory(%d, %d, [%s])", (Object[])new Object[]{bank, offset, value});
        return ResultCode.NoError;
    }

    public ResultCode lock(int action, int mask) {
        byte[] data = BitConvert.toBytes((String)String.format(Locale.US, "%02x,%02x", action, mask));
        ResultCode res = ResultCode.NoError;
        res = this.getProtocol().post((byte)97, (byte)108, data);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. lock(%02X, %02X) - Failed to send action [%s]", (Object[])new Object[]{action, mask, res});
            return res;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. lock(%02X, %02X)", (Object[])new Object[]{action, mask});
        return ResultCode.NoError;
    }

    public ResultCode permaLock(int action, int mask) {
        byte[] data = BitConvert.toBytes((String)String.format(Locale.US, "%02x,%02x", action, mask));
        ResultCode res = ResultCode.NoError;
        res = this.getProtocol().post((byte)97, (byte)112, data);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. permaLock(%02X, %02X) - Failed to send action [%s]", (Object[])new Object[]{action, mask, res});
            return res;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. permaLock(%02X, %02X)", (Object[])new Object[]{action, mask});
        return ResultCode.NoError;
    }

    public ResultCode blockWrite(int bank, int offset, String value) {
        if (StringUtil.isNullOrEmpty((String)value)) {
            ATLog.e((String)this.TAG, (String)"ERROR. blockWrite(%d, %d, [%s]) - Failed to invalid parameter [%s]", (Object[])new Object[]{bank, offset, value, ResultCode.InvalidParameter});
            return ResultCode.InvalidParameter;
        }
        int count = (int)Math.ceil((double)value.length() / (double)NIBBLE_UNIT);
        String param = String.format(Locale.US, "%d,%x,%x", bank, offset, count);
        String format = String.format(Locale.US, "%%-%ds", count * NIBBLE_UNIT);
        value = String.format(Locale.US, format, value).replace(" ", "");
        int i = 0;
        while (i < count) {
            param = String.valueOf(param) + "," + value.substring(i * NIBBLE_UNIT, (i + 1) * NIBBLE_UNIT);
            ++i;
        }
        byte[] data = BitConvert.toBytes((String)param);
        ResultCode res = ResultCode.NoError;
        res = this.getProtocol().post((byte)97, (byte)87, data);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. blockWrite(%d, %d, [%s]) - Failed to send action [%s]", (Object[])new Object[]{bank, offset, value, res});
            return res;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. blockWrite(%d, %d, [%s])", (Object[])new Object[]{bank, offset, value});
        return ResultCode.NoError;
    }

    public ResultCode blockErase(int bank, int offset, int length) {
        byte[] data = BitConvert.toBytes((String)String.format(Locale.US, "%d,%x,%x", bank, offset, length));
        ResultCode res = ResultCode.NoError;
        res = this.getProtocol().post((byte)97, (byte)69, data);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. blockErase(%d, %d, %d) - Failed to send action [%s]", (Object[])new Object[]{bank, offset, length, res});
            return res;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. blockErase(%d, %d, %d)", (Object[])new Object[]{bank, offset, length});
        return ResultCode.NoError;
    }

    public ResultCode kill(String password) {
        if (StringUtil.isNullOrEmpty((String)password)) {
            ATLog.e((String)this.TAG, (String)"ERROR. kill([%s]) - Failed to invalid parameter [%s]", (Object[])new Object[]{password, ResultCode.InvalidParameter});
            return ResultCode.InvalidParameter;
        }
        byte[] data = BitConvert.toBytes((String)password);
        ResultCode res = ResultCode.NoError;
        res = this.getProtocol().post((byte)97, (byte)107, data);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. kill([%s]) - Failed to send action [%s]", (Object[])new Object[]{password, res});
            return res;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. kill([%s])", (Object[])new Object[]{password});
        return ResultCode.NoError;
    }

    public ResultCode stopAction() {
        ResultCode res = ResultCode.NoError;
        res = this.getProtocol().post((byte)97, (byte)115, null);
        if (res != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. stopAction() - Failed to send action [%s]", (Object[])new Object[]{res});
            return res;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. stopAction()");
        return ResultCode.NoError;
    }

    public String getVersion() throws ATException {
        String value = "";
        Response res = this.getProtocol().send((byte)114, (byte)86, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getRfidVersion() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toString((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getRfidVersion() - [%s]", (Object[])new Object[]{value});
        return value;
    }

    public int getContinuousMode() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)99, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setContinuousMode() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getContinuousMode() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setContinuousMode(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)99, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setContinuousMode(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setContinuousMode(%d)", (Object[])new Object[]{value});
    }

    public int getLimitTagCount() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)99, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getLimitTagCount() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getLimitTagCount() - [%s]", (Object[])new Object[]{value});
        return value;
    }

    public void setLimitTagCount(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)99, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setLimitTagCount(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setLimitTagCount(%d)", (Object[])new Object[]{value});
    }

    public int getPowerGain() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)112, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getPowerGain() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getPowerGain() - [%s]", (Object[])new Object[]{value});
        return value;
    }

    public void setPowerGain(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)112, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setPowerGain(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setPowerGain(%d)", (Object[])new Object[]{value});
    }

    public Pair<Integer, Integer> getPowerGainRange() throws ATException {
        Response res = this.getProtocol().send((byte)114, (byte)97, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getPowerGainRange() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        Pair value = null;
        try {
            String[] values = BitConvert.toString((byte[])res.getData()).split(",");
            int min = StringUtil.toInteger((String)values[0].trim());
            int max = StringUtil.toInteger((String)values[1].trim());
            value = new Pair((Object)min, (Object)max);
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getPowerGainRange() - Failed to Invalid response data [%s]", (Object[])new Object[]{ResultCode.InvalidResponse});
            throw new ATException(ResultCode.InvalidResponse);
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getPowerGainRange() - [%d, %d]", (Object[])new Object[]{value.first, value.second});
        return value;
    }

    public int getOperationTime() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)105, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getOperationTime() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getOperationTime() - [%s]", (Object[])new Object[]{value});
        return value;
    }

    public void setOperationTime(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)105, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setOperationTime(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setOperationTime(%d)", (Object[])new Object[]{value});
    }

    public int getInventoryTime() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)50, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getInventoryTime() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getInventoryTime() - [%s]", (Object[])new Object[]{value});
        return value;
    }

    public void setInventoryTime(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)50, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setInventoryTime(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setInventoryTime(%d)", (Object[])new Object[]{value});
    }

    public int getIdleTime() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)48, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getIdleTime() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getIdleTime() - [%s]", (Object[])new Object[]{value});
        return value;
    }

    public void setIdleTime(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)48, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setIdleTime(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setIdleTime(%d)", (Object[])new Object[]{value});
    }

    public int getTagReportTime() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)49, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getTagReportTime() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getTagReportTime() - [%s]", (Object[])new Object[]{value});
        return value;
    }

    public void setTagReportTime(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)49, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setTagReportTime(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setTagReportTime(%d)", (Object[])new Object[]{value});
    }

    public String getAccessPassword() throws ATException {
        String value = "";
        Response res = this.getProtocol().send((byte)114, (byte)119, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getAccessPassword() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toString((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getAccessPassword() - [%s]", (Object[])new Object[]{value});
        return value;
    }

    public void setAccessPassword(String value) throws ATException {
        byte[] data = BitConvert.toBytes((String)value);
        Response res = this.getProtocol().send((byte)119, (byte)119, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setAccessPassword([%s]) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setAccessPassword([%s])", (Object[])new Object[]{value});
    }

    public int getRegion() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)103, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getRegion() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getRegion() - [%s]", (Object[])new Object[]{value});
        return value;
    }

    public void setRegion(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)103, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setRegion(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setRegion(%d)", (Object[])new Object[]{value});
    }

    public int getSessionTarget() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)115, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getSessionType() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSessionType() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setSessionTarget(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)115, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setSessionType(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setSessionType(%d)", (Object[])new Object[]{value});
    }

    public int getSessionFalg() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)102, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getSessionFalg() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSessionFalg() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setSessionFlag(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)102, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setSessionFlag(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setSessionFlag(%d)", (Object[])new Object[]{value});
    }

    public int getMask6cTarget(int index) throws ATException {
        byte[] data = BitConvert.toBytes((int)index);
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)84, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getMask6cTarget(%d) - Failed to response [%s]", (Object[])new Object[]{index, res.getCode()});
            throw new ATException(res.getCode());
        }
        try {
            String[] values = BitConvert.toString((byte[])res.getData()).split(",");
            if (StringUtil.toInteger((String)values[0].trim()) != index) {
                ATLog.e((String)this.TAG, (String)"ERROR. getMask6cTarget(%d) - Failed to Invalid response Index [%s]", (Object[])new Object[]{index, ResultCode.InvalidResponseIndex});
                throw new ATException(ResultCode.InvalidResponseIndex);
            }
            value = StringUtil.toInteger((String)values[1].trim());
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getMask6cTarget(%d) - Failed to Invalid response data [%s]", (Object[])new Object[]{index, ResultCode.InvalidResponse});
            throw new ATException(ResultCode.InvalidResponse);
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getMask6cTarget(%d) - [%d]", (Object[])new Object[]{index, value});
        return value;
    }

    public void setMask6cTarget(int index, int value) throws ATException {
        byte[] data = BitConvert.toBytes((String)String.format(Locale.US, "%d,%d", index, value));
        Response res = this.getProtocol().send((byte)119, (byte)84, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setMask6cTarget(%d, %d) - Failed to response [%s]", (Object[])new Object[]{index, value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setMask6cTarget(%d, %d)", (Object[])new Object[]{index, value});
    }

    public int getMask6cAction(int index) throws ATException {
        byte[] data = BitConvert.toBytes((int)index);
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)65, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getMask6cAction(%d) - Failed to response [%s]", (Object[])new Object[]{index, res.getCode()});
            throw new ATException(res.getCode());
        }
        try {
            String[] values = BitConvert.toString((byte[])res.getData()).split(",");
            if (StringUtil.toInteger((String)values[0].trim()) != index) {
                ATLog.e((String)this.TAG, (String)"ERROR. getMask6cAction(%d) - Failed to Invalid response Index [%s]", (Object[])new Object[]{index, ResultCode.InvalidResponseIndex});
                throw new ATException(ResultCode.InvalidResponseIndex);
            }
            value = StringUtil.toInteger((String)values[1].trim());
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getMask6cAction(%d) - Failed to Invalid response data [%s]", (Object[])new Object[]{index, ResultCode.InvalidResponse});
            throw new ATException(ResultCode.InvalidResponse);
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getMask6cAction(%d) - [%d]", (Object[])new Object[]{index, value});
        return value;
    }

    public void setMask6cAction(int index, int value) throws ATException {
        byte[] data = BitConvert.toBytes((String)String.format(Locale.US, "%d,%d", index, value));
        Response res = this.getProtocol().send((byte)119, (byte)65, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setMask6cAction(%d, %d) - Failed to response [%s]", (Object[])new Object[]{index, value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setMask6cAction(%d, %d)", (Object[])new Object[]{index, value});
    }

    public int getMask6cBank(int index) throws ATException {
        byte[] data = BitConvert.toBytes((int)index);
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)66, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getMask6cBank(%d) - Failed to response [%s]", (Object[])new Object[]{index, res.getCode()});
            throw new ATException(res.getCode());
        }
        try {
            String[] values = BitConvert.toString((byte[])res.getData()).split(",");
            if (StringUtil.toInteger((String)values[0].trim()) != index) {
                ATLog.e((String)this.TAG, (String)"ERROR. getMask6cBank(%d) - Failed to Invalid response Index [%s]", (Object[])new Object[]{index, ResultCode.InvalidResponseIndex});
                throw new ATException(ResultCode.InvalidResponseIndex);
            }
            value = StringUtil.toInteger((String)values[1].trim());
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getMask6cBank(%d) - Failed to Invalid response data [%s]", (Object[])new Object[]{index, ResultCode.InvalidResponse});
            throw new ATException(ResultCode.InvalidResponse);
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getMask6cBank(%d) - [%d]", (Object[])new Object[]{index, value});
        return value;
    }

    public void setMask6cBank(int index, int value) throws ATException {
        byte[] data = BitConvert.toBytes((String)String.format(Locale.US, "%d,%d", index, value));
        Response res = this.getProtocol().send((byte)119, (byte)66, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setMask6cBank(%d, %d) - Failed to response [%s]", (Object[])new Object[]{index, value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setMask6cBank(%d, %d)", (Object[])new Object[]{index, value});
    }

    public int getMask6cOffset(int index) throws ATException {
        byte[] data = BitConvert.toBytes((int)index);
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)79, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getMask6cOffset(%d) - Failed to response [%s]", (Object[])new Object[]{index, res.getCode()});
            throw new ATException(res.getCode());
        }
        try {
            String[] values = BitConvert.toString((byte[])res.getData()).split(",");
            if (StringUtil.toInteger((String)values[0].trim()) != index) {
                ATLog.e((String)this.TAG, (String)"ERROR. getMask6cOffset(%d) - Failed to Invalid response Index [%s]", (Object[])new Object[]{index, ResultCode.InvalidResponseIndex});
                throw new ATException(ResultCode.InvalidResponseIndex);
            }
            value = StringUtil.toInteger((String)values[1].trim());
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getMask6cOffset(%d) - Failed to Invalid response data [%s]", (Object[])new Object[]{index, ResultCode.InvalidResponse});
            throw new ATException(ResultCode.InvalidResponse);
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getMask6cOffset(%d) - [%s]", (Object[])new Object[]{index, value});
        return value;
    }

    public void setMask6cOffset(int index, int value) throws ATException {
        byte[] data = BitConvert.toBytes((String)String.format(Locale.US, "%d,%d", index, value));
        Response res = this.getProtocol().send((byte)119, (byte)79, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setMask6cOffset(%d, %d) - Failed to response [%s]", (Object[])new Object[]{index, value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setMask6cOffset(%d, %d)", (Object[])new Object[]{index, value});
    }

    public Pair<String, Integer> getMask6cPattern(int index) throws ATException {
        byte[] data = BitConvert.toBytes((int)index);
        Pair value = null;
        Response res = this.getProtocol().send((byte)114, (byte)77, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getMask6cPattern(%d) - Failed to response [%s]", (Object[])new Object[]{index, res.getCode()});
            throw new ATException(res.getCode());
        }
        try {
            String[] values = BitConvert.toString((byte[])res.getData()).split(",");
            if (StringUtil.toInteger((String)values[0].trim()) != index) {
                ATLog.e((String)this.TAG, (String)"ERROR. getMask6cPattern(%d) - Failed to Invalid response Index [%s]", (Object[])new Object[]{index, ResultCode.InvalidResponseIndex});
                throw new ATException(ResultCode.InvalidResponseIndex);
            }
            int length = StringUtil.toInteger((String)values[2].trim());
            value = new Pair((Object)values[1].trim(), (Object)length);
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getMask6cPattern(%d) - Failed to Invalid response data [%s]", (Object[])new Object[]{index, ResultCode.InvalidResponse});
            throw new ATException(ResultCode.InvalidResponse);
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getMask6cPattern(%d) - [%s]", (Object[])new Object[]{index, value});
        return value;
    }

    public void setMask6cPattern(int index, String pattern, int length) throws ATException {
        byte[] data = BitConvert.toBytes((String)String.format(Locale.US, "%d,%s,%d", index, pattern, length));
        Response res = this.getProtocol().send((byte)119, (byte)77, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setMask6cPattern(%d, [%s], %d) - Failed to response [%s]", (Object[])new Object[]{index, pattern, length, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setMask6cPattern(%d, [%s], %d)", (Object[])new Object[]{index, pattern, length});
    }

    public int getMask6cUsed(int index) throws ATException {
        byte[] data = BitConvert.toBytes((int)index);
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)69, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getMask6cUsed(%d) - Failed to response [%s]", (Object[])new Object[]{index, res.getCode()});
            throw new ATException(res.getCode());
        }
        try {
            String[] values = BitConvert.toString((byte[])res.getData()).split(",");
            if (StringUtil.toInteger((String)values[0].trim()) != index) {
                ATLog.e((String)this.TAG, (String)"ERROR. getMask6cUsed(%d) - Failed to Invalid response Index [%s]", (Object[])new Object[]{index, ResultCode.InvalidResponseIndex});
                throw new ATException(ResultCode.InvalidResponseIndex);
            }
            value = StringUtil.toInteger((String)values[1].trim());
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getMask6cUsed(%d) - Failed to Invalid response data [%s]", (Object[])new Object[]{index, ResultCode.InvalidResponse});
            throw new ATException(ResultCode.InvalidResponse);
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getMask6cUsed(%d) - [%d]", (Object[])new Object[]{index, value});
        return value;
    }

    public void setMask6cUsed(int index, int value) throws ATException {
        byte[] data = BitConvert.toBytes((String)String.format(Locale.US, "%d,%d", index, value));
        Response res = this.getProtocol().send((byte)119, (byte)69, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setMask6cUsed(%d, %d) - Failed to response [%s]", (Object[])new Object[]{index, value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setMask6cUsed(%d, %d)", (Object[])new Object[]{index, value});
    }

    public int getSelectFalg() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)85, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getSelectFalg() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSelectFalg() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setSelectFlag(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)85, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setSelectFlag(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setSelectFlag(%d)", (Object[])new Object[]{value});
    }

    public int getReportMode() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)109, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getReportMode() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getReportMode() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setReportMode(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)109, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setReportMode(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setReportMode(%d)", (Object[])new Object[]{value});
    }

    public int getAlgorithm() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)71, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getAlgorithm() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getAlgorithm() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setAlgorithm(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)71, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setAlgorithm(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setAlgorithm(%d)", (Object[])new Object[]{value});
    }

    public int getStartQ() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)81, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getStartQ() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getStartQ() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setStartQ(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)81, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setStartQ(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setStartQ(%d)", (Object[])new Object[]{value});
    }

    public int getMinQ() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)78, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getMinQ() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getMinQ() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setMinQ(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)78, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setMinQ(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setMinQ(%d)", (Object[])new Object[]{value});
    }

    public int getMaxQ() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)88, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getMaxQ() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getMaxQ() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setMaxQ(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)88, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setMaxQ(%d) - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setMaxQ(%d)", (Object[])new Object[]{value});
    }

    public void clearEpcMask() throws ATException {
        byte[] data = BitConvert.toBytes((boolean)false);
        Response res = this.getProtocol().send((byte)119, (byte)100, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. clearEpcMask() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. clearEpcMask()");
    }

    public void saveEpcMask() throws ATException {
        byte[] data = BitConvert.toBytes((boolean)true);
        Response res = this.getProtocol().send((byte)119, (byte)100, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. saveEpcMask() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. saveEpcMask()");
    }

    public int getEpcMaskCount() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)68, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getEpcMaskCount() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getEpcMaskCount() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public int getEpcMaskMatchMode() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)117, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getEpcMaskMatchMode() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getEpcMaskMatchMode() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setEpcMaskMatchMode(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)117, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setEpcMaskMatchMode(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setEpcMaskMatchMode(%d)", (Object[])new Object[]{value});
    }

    public void addEpcMask(int offset, int length, String pattern) throws ATException {
        byte[] data = BitConvert.toBytes((String)String.format(Locale.US, "%d,%d,%s", offset, length, pattern));
        Response res = this.getProtocol().send((byte)119, (byte)68, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. addEpcMask(%d, %d, [%s]) - Failed to response [%s]", (Object[])new Object[]{offset, length, pattern, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. addEpcMask(%d, %d, [%s])", (Object[])new Object[]{offset, length, pattern});
    }

    public ArrayList<Object> getEpcMask(int index) throws ATException {
        byte[] data = BitConvert.toBytes((int)index);
        ArrayList<Object> value = null;
        Response res = this.getProtocol().send((byte)114, (byte)100, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getEpcMask(%d) - Failed to response [%s]", (Object[])new Object[]{index, res.getCode()});
            throw new ATException(res.getCode());
        }
        try {
            String val = BitConvert.toString((byte[])res.getData());
            if (val.charAt(0) == ',') {
                val = val.substring(1);
            }
            String[] values = val.split(",");
            int offset = StringUtil.toInteger((String)values[0].trim());
            int length = StringUtil.toInteger((String)values[1].trim());
            value = new ArrayList<Object>();
            value.add(offset);
            value.add(length);
            value.add(values[2].trim());
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getEpcMask(%d) - Failed to Invalid response data [%s]", (Object[])new Object[]{index, ResultCode.InvalidResponse});
            throw new ATException(ResultCode.InvalidResponse);
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getEpcMask(%d) - [%d, %d, [%s]]", (Object[])new Object[]{index, (Integer)value.get(0), (Integer)value.get(1), (String)value.get(2)});
        return value;
    }

    public int getReportRssi() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)56, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getReportRssi() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        this.mIsReportRssi = value > 0;
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getReportRssi() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setReportRssi(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)56, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setReportRssi(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        this.mIsReportRssi = value > 0;
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setReportRssi(%d)", (Object[])new Object[]{value});
    }

    public long getFreqTable() throws ATException {
        long value = 0L;
        Response res = this.getProtocol().send((byte)114, (byte)76, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getFreqTable() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toLong((byte[])res.getData(), (int)16);
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getFreqTable() - [0x%013X]", (Object[])new Object[]{value});
        return value;
    }

    public void setFreqTable(long value) throws ATException {
        byte[] data = BitConvert.toBytes((String)String.format(Locale.US, "0x%013X", value));
        Response res = this.getProtocol().send((byte)119, (byte)76, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setFreqTable(0x%013X) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setFreqTable(0x%013X)", (Object[])new Object[]{value});
    }

    public long getFreqTableMask() throws ATException {
        long value = 0L;
        Response res = this.getProtocol().send((byte)114, (byte)57, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getFreqTableMask() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toLong((byte[])res.getData(), (int)16);
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getFreqTableMask() - [0x%013X]", (Object[])new Object[]{value});
        return value;
    }

    public int getFreqValue(int index) throws ATException {
        byte[] data = BitConvert.toBytes((int)index);
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)70, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getFreqValue(%d) - Failed to response [%s]", (Object[])new Object[]{index, res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData(), (int)16);
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getFreqValue(%d) - [%d]", (Object[])new Object[]{index, value});
        return value;
    }

    public int getTidReadLength() throws ATException {
        int value = 0;
        Response res = this.getProtocol().send((byte)114, (byte)112, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getTidReadLength() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getTidReadLength() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setTidReadLength(int value) throws ATException {
        byte[] data = BitConvert.toBytes((int)value);
        Response res = this.getProtocol().send((byte)119, (byte)112, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setTidReadLength(%d) - Failed to response [%s]", (Object[])new Object[]{value, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setTidReadLength(%d)", (Object[])new Object[]{value});
    }

    public int getCurrentLinkProfile() throws ATException {
        int value = 1;
        Response res = this.getProtocol().send((byte)114, (byte)52, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getCurrentLinkProfile() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getCurrentLinkProfile() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setCurrentLinkProfile(int index) throws ATException {
        byte[] data = BitConvert.toBytes((int)index);
        Response res = this.getProtocol().send((byte)119, (byte)52, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setCurrentLinkProfile(%d) - Failed to response [%s]", (Object[])new Object[]{index, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setCurrentLinkProfile(%d)", (Object[])new Object[]{index});
    }

    public int getDefaultLinkProfile() throws ATException {
        int value = 1;
        Response res = this.getProtocol().send((byte)114, (byte)53, null, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. getDefaultLinkProfile() - Failed to response [%s]", (Object[])new Object[]{res.getCode()});
            throw new ATException(res.getCode());
        }
        value = BitConvert.toInteger((byte[])res.getData());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getDefaultLinkProfile() - [%d]", (Object[])new Object[]{value});
        return value;
    }

    public void setDefaultLinkProfile(int index) throws ATException {
        byte[] data = BitConvert.toBytes((int)index);
        Response res = this.getProtocol().send((byte)119, (byte)53, data, this.mTimeout);
        if (res.getCode() != ResultCode.NoError) {
            ATLog.e((String)this.TAG, (String)"ERROR. setDefaultLinkProfile(%d) - Failed to response [%s]", (Object[])new Object[]{index, res.getCode()});
            throw new ATException(res.getCode());
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setDefaultLinkProfile(%d)", (Object[])new Object[]{index});
    }

    @Override
    public void PumpEvent(int event, byte[] data) {
        String tag = "";
        String epc = "";
        String value = new String(data, Charset.forName("UTF-8"));
        String[] values = null;
        int val = 0;
        int pos = 0;
        short rssi = 0;
        short phase = 0;
        int frequency = 0;
        TagExtParam param = null;
        ResultCode code = ResultCode.NoError;
        ActionType action = ActionType.Stop;
        switch (event) {
            case 70: 
            case 84: {
                values = value.split(",");
                if (values.length > 0) {
                    tag = (this.mReader.getDeviceType() == DeviceType.RFBlaster || this.mReader.getDeviceType() == DeviceType.RFPrisma) && this.mReader.getVersionHexa() <= 131589 && values[pos].length() > 4 ? values[pos].substring(0, values[pos].length() - 4) : values[pos];
                    ++pos;
                }
                if (values.length > 2 && this.mIsReportRssi) {
                    rssi = StringUtil.toShort((String)values[pos++], (int)16);
                    phase = StringUtil.toShort((String)values[pos++], (int)16);
                    frequency = StringUtil.toInteger((String)values[pos++], (int)16);
                    param = this.mReader.getDeviceType() == DeviceType.ATS100 && this.mReader.getVersionHexa() >= 65541 ? new TagExtParam(rssi, phase, frequency) : new TagExtParam(rssi, phase);
                }
                if (this.mListener == null) break;
                this.mListener.onReadTag(tag, param);
                break;
            }
            case 65: {
                values = value.split(",");
                if (values.length > 0) {
                    code = ResultCode.valueOf((int)StringUtil.toInteger((String)values[pos++], (int)16));
                }
                if (values.length > 1) {
                    action = ActionType.valueOf((int)values[pos++].charAt(0));
                }
                if (values.length > 2) {
                    epc = values[pos++];
                }
                if (this.mIsReportRssi) {
                    rssi = StringUtil.toShort((String)values[pos++], (int)16);
                    phase = StringUtil.toShort((String)values[pos++], (int)16);
                    if (this.mReader.getDeviceType() == DeviceType.ATS100 && this.mReader.getVersionHexa() >= 65541) {
                        frequency = StringUtil.toInteger((String)values[pos++], (int)16);
                        param = new TagExtParam(rssi, phase, frequency);
                    } else {
                        param = new TagExtParam(rssi, phase);
                    }
                }
                while (pos < values.length) {
                    tag = String.valueOf(tag) + values[pos];
                    ++pos;
                }
                if (this.mListener == null) break;
                this.mListener.onAccessResult(code, action, epc, tag, param);
                break;
            }
            case 112: {
                val = StringUtil.toInteger((String)value);
                if (this.mListener == null) break;
                this.mListener.onPowerGainChanged(val, null);
            }
        }
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. PumpEvent([%c], [%s])", (Object[])new Object[]{event, Dump.dump((byte[])data)});
        }
    }
}

