/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.util;

import com.atid.lib.util.converts.BitConvert;
import com.atid.lib.util.diagnotics.ATLog;
import java.util.Locale;

public class StringUtil {
    private static final String TAG = StringUtil.class.getSimpleName();
    private static final int EVEN = 2;

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String getNull(String str) {
        return str == null ? "" : str;
    }

    public static int toInteger(String value) {
        int val = 0;
        try {
            long temp = Long.parseLong(value);
            val = (int)(temp & 0xFFFFFFFFFFFFFFFFL);
        }
        catch (Exception e) {
            ATLog.e(TAG, "ERROR. toInteger([%s]) - Failed to convert string", value);
            return 0;
        }
        return val;
    }

    public static int toInteger(String value, int radix) {
        int val = 0;
        try {
            long temp = Long.parseLong(value, radix);
            val = (int)(temp & 0xFFFFFFFFFFFFFFFFL);
        }
        catch (Exception e) {
            ATLog.e(TAG, "ERROR. toInteger([%s]) - Failed to convert string", value);
            return 0;
        }
        return val;
    }

    public static short toShort(String value) {
        short val = 0;
        try {
            int temp = Integer.parseInt(value);
            val = (short)(temp & 0xFFFF);
        }
        catch (Exception e) {
            ATLog.e(TAG, "ERROR. toShort([%s]) - Failed to convert string", value);
            return 0;
        }
        return val;
    }

    public static short toShort(String value, int radix) {
        short val = 0;
        try {
            int temp = Integer.parseInt(value, radix);
            val = (short)(temp & 0xFFFF);
        }
        catch (Exception e) {
            ATLog.e(TAG, "ERROR. toShort([%s]) - Failed to convert string", value);
            return 0;
        }
        return val;
    }

    public static byte toByte(String value) {
        byte val = 0;
        try {
            int temp = Integer.parseInt(value);
            val = (byte)(temp & 0xFF);
        }
        catch (Exception e) {
            ATLog.e(TAG, "ERROR. toByte([%s]) - Failed to convert string", value);
            return 0;
        }
        return val;
    }

    public static byte toByte(String value, int radix) {
        byte val = 0;
        try {
            int temp = Integer.parseInt(value, radix);
            val = (byte)(temp & 0xFF);
        }
        catch (Exception e) {
            ATLog.e(TAG, "ERROR. toByte([%s]) - Failed to convert string", value);
            return 0;
        }
        return val;
    }

    public static byte[] toBytes(String hex) {
        if (StringUtil.isNullOrEmpty(hex)) {
            return null;
        }
        byte[] result = null;
        if (hex.length() % 2 != 0) {
            hex = String.valueOf(hex) + "0";
        }
        int length = hex.length() / 2;
        result = new byte[length];
        int i = 0;
        while (i < length) {
            result[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
            ++i;
        }
        return result;
    }

    public static String toAscii(String hex) {
        return BitConvert.toString(StringUtil.toBytes(hex));
    }

    public static String toHex(String ascii) {
        byte[] data = BitConvert.toBytes(ascii);
        if (data == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte c = byArray[n2];
            builder.append(String.format(Locale.US, "%2X", c));
            ++n2;
        }
        return builder.toString();
    }

    public static String padLeft(String str, int length, char pad) {
        try {
            if (str.length() >= length) {
                return str;
            }
            int padLen = length - str.length();
            int i = 0;
            while (i < padLen) {
                str = String.valueOf(pad) + str;
                ++i;
            }
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. padLeft([%s], %d, [%c]) - Failed to pad left", str, length, Character.valueOf(pad));
            return str;
        }
        return str;
    }

    public static String padRight(String str, int length, char pad) {
        try {
            if (str.length() >= length) {
                return str;
            }
            int padLen = length - str.length();
            int i = 0;
            while (i < padLen) {
                str = String.valueOf(str) + pad;
                ++i;
            }
        }
        catch (Exception e) {
            ATLog.e(TAG, e, "ERROR. padRight([%s], %d, [%c]) - Failed to pad right", str, length, Character.valueOf(pad));
            return str;
        }
        return str;
    }
}

