/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.rfid.uhf.event;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.atid.lib.module.rfid.uhf.ATRfidUhf;
import com.atid.lib.module.rfid.uhf.event.IATRfidUhfEventListener;
import com.atid.lib.types.ActionState;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.diagnotics.ATLog;
import java.util.ArrayList;
import java.util.Locale;

public class ATRfidUhfEventManager {
    private static final String TAG = ATRfidUhfEventManager.class.getSimpleName();
    private static final int EVENT_READ_TAG = 4000;
    private static final int EVENT_ACCESS_RESULT = 4001;
    private static final int EVENT_POWER_GAIN_CHANGED = 4002;
    private ArrayList<IATRfidUhfEventListener> mListeners;
    private Handler mHandler;
    private Handler.Callback mEventCallback = new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 4000: {
                    ATRfidUhfEventManager.this.onReadTag((ReadTagEventArgs)msg.obj);
                    return true;
                }
                case 4001: {
                    ATRfidUhfEventManager.this.onAccessResult((AccessResultEventArgs)msg.obj);
                    return true;
                }
                case 4002: {
                    ATRfidUhfEventManager.this.onPowerGainChanged((PowerGainChangedEventArgs)msg.obj);
                    return true;
                }
            }
            return false;
        }
    };

    public ATRfidUhfEventManager() {
        this.mListeners = new ArrayList();
        this.mHandler = new Handler(Looper.getMainLooper(), this.mEventCallback);
    }

    public void destroy() {
        if (this.mListeners == null) {
            return;
        }
        if (this.mListeners != null) {
            this.mListeners.clear();
            this.mListeners = null;
        }
    }

    public void addListener(IATRfidUhfEventListener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(IATRfidUhfEventListener listener) {
        this.mListeners.remove(listener);
    }

    public void clear() {
        this.mListeners.clear();
    }

    public void generateRfidUhfReadTag(ATRfidUhf uhf, String tag, Object params) {
        if (this.mListeners.isEmpty()) {
            return;
        }
        ReadTagEventArgs args = new ReadTagEventArgs(uhf, tag, params);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4000, (Object)args));
    }

    public void generateRfidUhfAccessResult(ATRfidUhf uhf, ResultCode code, ActionState action, String epc, String data, Object params) {
        if (this.mListeners.isEmpty()) {
            return;
        }
        AccessResultEventArgs args = new AccessResultEventArgs(uhf, code, action, epc, data, params);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4001, (Object)args));
    }

    public void generateRfidUhfPowerGainChangedEventArgs(ATRfidUhf uhf, int power, Object params) {
        if (this.mListeners.isEmpty()) {
            return;
        }
        PowerGainChangedEventArgs args = new PowerGainChangedEventArgs(uhf, power, params);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4002, (Object)args));
    }

    private IATRfidUhfEventListener getLastListener() {
        int index = this.mListeners.size() - 1;
        if (index < 0) {
            return null;
        }
        return this.mListeners.get(index);
    }

    private void onReadTag(ReadTagEventArgs args) {
        IATRfidUhfEventListener listener = null;
        listener = this.getLastListener();
        if (listener == null) {
            return;
        }
        try {
            listener.onRfidUhfReadTag(args.Uhf, args.Tag, args.Params);
        }
        catch (Exception e) {
            ATLog.e((String)TAG, (Throwable)e, (String)"ERROR. onReaderReadTag([%s])", (Object[])new Object[]{args});
        }
    }

    private void onAccessResult(AccessResultEventArgs args) {
        IATRfidUhfEventListener listener = null;
        listener = this.getLastListener();
        if (listener == null) {
            return;
        }
        try {
            listener.onRfidUhfAccessResult(args.Uhf, args.Code, args.Action, args.Epc, args.Data, args.Params);
        }
        catch (Exception e) {
            ATLog.e((String)TAG, (Throwable)e, (String)"ERROR. onReaderStateChange([%s])", (Object[])new Object[]{args});
        }
    }

    private void onPowerGainChanged(PowerGainChangedEventArgs args) {
        IATRfidUhfEventListener listener = null;
        listener = this.getLastListener();
        if (listener == null) {
            return;
        }
        try {
            listener.onRfidUhfPowerGainChanged(args.Uhf, args.Power, args.Params);
        }
        catch (Exception e) {
            ATLog.e((String)TAG, (Throwable)e, (String)"ERROR. onPowerGainChanged([%s])", (Object[])new Object[]{args});
        }
    }

    private class AccessResultEventArgs {
        private final ATRfidUhf Uhf;
        private final ResultCode Code;
        private final ActionState Action;
        private final String Epc;
        private final String Data;
        private final Object Params;

        protected AccessResultEventArgs(ATRfidUhf uhf, ResultCode code, ActionState action, String epc, String data, Object params) {
            this.Uhf = uhf;
            this.Code = code;
            this.Action = action;
            this.Epc = epc;
            this.Data = data;
            this.Params = params;
        }

        public String toString() {
            return String.format(Locale.US, "[%s], %s, %s, [%s], [%s], [%s]", this.Uhf, this.Code, this.Action, this.Epc, this.Data, this.Params == null ? "NULL" : this.Params);
        }
    }

    private class PowerGainChangedEventArgs {
        private final ATRfidUhf Uhf;
        private final int Power;
        private final Object Params;

        protected PowerGainChangedEventArgs(ATRfidUhf uhf, int power, Object params) {
            this.Uhf = uhf;
            this.Power = power;
            this.Params = params;
        }

        public String toString() {
            return String.format(Locale.US, "[%s], %d, [%s]", this.Uhf, this.Power, this.Params == null ? "NULL" : this.Params);
        }
    }

    private class ReadTagEventArgs {
        private final ATRfidUhf Uhf;
        private final String Tag;
        private final Object Params;

        protected ReadTagEventArgs(ATRfidUhf uhf, String tag, Object params) {
            this.Uhf = uhf;
            this.Tag = tag;
            this.Params = params;
        }

        public String toString() {
            return String.format(Locale.US, "[%s], [%s], [%s]", this.Uhf, this.Tag, this.Params == null ? "NULL" : this.Params);
        }
    }
}

