/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.rfid.uhf.params;

import android.util.Pair;
import com.atid.lib.module.rfid.uhf.types.BankType;
import com.atid.lib.module.rfid.uhf.types.Mask6cAction;
import com.atid.lib.module.rfid.uhf.types.Mask6cTarget;
import java.util.Locale;

public class SelectMask6cParam {
    private boolean mIsUsed;
    private Mask6cTarget mTarget;
    private Mask6cAction mAction;
    private BankType mBank;
    private int mOffset;
    private String mPattern;
    private int mLength;

    public SelectMask6cParam() {
        this.clear();
    }

    public SelectMask6cParam(boolean used, Mask6cTarget target, Mask6cAction action, BankType bank, int offset, String pattern, int length) {
        this.mIsUsed = used;
        this.mTarget = target;
        this.mAction = action;
        this.mBank = bank == BankType.Reserved ? BankType.EPC : bank;
        this.mOffset = offset;
        this.mPattern = pattern;
        this.mLength = length;
    }

    public SelectMask6cParam(boolean used, Mask6cTarget target, Mask6cAction action, BankType bank, int offset, Pair<String, Integer> pattern) {
        this.mIsUsed = used;
        this.mTarget = target;
        this.mAction = action;
        this.mBank = bank == BankType.Reserved ? BankType.EPC : bank;
        this.mOffset = offset;
        this.mPattern = (String)pattern.first;
        this.mLength = (Integer)pattern.second;
    }

    public void copy(SelectMask6cParam param) {
        this.mIsUsed = param.isUsed();
        this.mTarget = param.getTarget();
        this.mAction = param.getAction();
        this.mBank = param.getBank() == BankType.Reserved ? BankType.EPC : param.getBank();
        this.mOffset = param.getOffset();
        this.mPattern = param.getPattern();
        this.mLength = param.getLength();
    }

    public void clear() {
        this.mIsUsed = false;
        this.mTarget = Mask6cTarget.SL;
        this.mAction = Mask6cAction.AB;
        this.mBank = BankType.EPC;
        this.mOffset = 0;
        this.mPattern = "";
        this.mLength = 0;
    }

    public boolean isUsed() {
        return this.mIsUsed;
    }

    public void setUsed(boolean used) {
        this.mIsUsed = used;
    }

    public Mask6cTarget getTarget() {
        return this.mTarget;
    }

    public void setTarget(Mask6cTarget target) {
        this.mTarget = target;
    }

    public Mask6cAction getAction() {
        return this.mAction;
    }

    public void setAction(Mask6cAction action) {
        this.mAction = action;
    }

    public BankType getBank() {
        return this.mBank == BankType.Reserved ? BankType.EPC : this.mBank;
    }

    public void setBank(BankType bank) {
        this.mBank = bank == BankType.Reserved ? BankType.EPC : bank;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public void setOffset(int offset) {
        this.mOffset = offset;
    }

    public String getPattern() {
        return this.mPattern;
    }

    public void setPattern(String pattern) {
        this.mPattern = pattern;
    }

    public int getLength() {
        return this.mLength;
    }

    public void setLength(int length) {
        this.mLength = length;
    }

    public String toString() {
        return String.format(Locale.US, "%s, %s, %s, %s, %d, [%s], %d", new Object[]{this.mIsUsed, this.mTarget, this.mAction, this.mBank, this.mOffset, this.mPattern, this.mLength});
    }
}

