/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.atx88;

import com.atid.lib.atx88.ATx88Reader;
import com.atid.lib.atx88.device.ATDeviceATx88;
import com.atid.lib.diagnostics.ATException;
import com.atid.lib.reader.device.ATDevice;
import com.atid.lib.reader.params.NotifyMethod;
import com.atid.lib.reader.types.NotifyTimeType;
import com.atid.lib.transport.ATransport;
import com.atid.lib.types.DeviceType;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.diagnotics.ATLog;

public abstract class ATn88Reader
extends ATx88Reader {
    public ATn88Reader(ATransport transport) {
        super(transport);
        this.TAG = ATn88Reader.class.getSimpleName();
    }

    public ATn88Reader(int sessionId, ATransport transport) {
        super(sessionId, transport);
        this.TAG = ATn88Reader.class.getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotifyTimeType getButtonNotifyTime() throws ATException {
        NotifyTimeType mode = NotifyTimeType.No;
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                mode = NotifyTimeType.valueOf((int)((ATDeviceATx88)this.mDevice).getNotifyTerm());
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getButtonNotifyTime() - Failed to get button notify time [%s]", (Object[])new Object[]{e.getCode()});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getButtonNotifyTime() - [%s]", (Object[])new Object[]{mode});
        return mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setButtonNotifyTime(NotifyTimeType time) throws ATException {
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                ((ATDeviceATx88)this.mDevice).setNotifyTerm(time.getCode());
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setButtonNotifyTime([%s]) - Failed to set button notify time [%s]", (Object[])new Object[]{time, e.getCode()});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setButtonNotifyTime([%s])", (Object[])new Object[]{time});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotifyMethod getButtonNotify() throws ATException {
        NotifyMethod method = null;
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                method = new NotifyMethod(((ATDeviceATx88)this.mDevice).getButtonNotify());
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getButtonNotify() - Failed to get button notify [%s]", (Object[])new Object[]{e.getCode()});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getButtonNotify() - [%s]", (Object[])new Object[]{method});
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setButtonNotify(NotifyMethod method) throws ATException {
        if (this.getDeviceType() == DeviceType.ATD100) {
            if (method.getMethod(1)) {
                ATLog.e((String)this.TAG, (String)"ERROR. setButtonNotify() - not supported vibration function [%s]", (Object[])new Object[]{this.getDeviceType()});
                throw new ATException(ResultCode.NotSupportedVibrate);
            }
        } else {
            this.getDeviceType();
        }
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                ((ATDeviceATx88)this.mDevice).setButtonNotify(method.getValue());
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setButtonNotify([%s]) - Failed to set button notify [%s]", (Object[])new Object[]{method, e.getCode()});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setButtonNotify([%s])", (Object[])new Object[]{method});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotifyMethod getAlertNotify() throws ATException {
        NotifyMethod method = null;
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                method = new NotifyMethod(((ATDeviceATx88)this.mDevice).getAlertNotify());
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getAlertNotify() - Failed to get alert notify [%s]", (Object[])new Object[]{e.getCode()});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getAlertNotify() - [%s]", (Object[])new Object[]{method});
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlertNotify(NotifyMethod method) throws ATException {
        if (this.getDeviceType() == DeviceType.ATD100) {
            if (method.getMethod(1)) {
                ATLog.e((String)this.TAG, (String)"ERROR. setAlertNotify() - not supported vibration function [%s]", (Object[])new Object[]{this.getDeviceType()});
                throw new ATException(ResultCode.NotSupportedVibrate);
            }
        } else {
            this.getDeviceType();
        }
        this.assertAction();
        ATDevice aTDevice = this.mDevice;
        synchronized (aTDevice) {
            try {
                ((ATDeviceATx88)this.mDevice).setAlertNotify(method.getValue());
            }
            catch (ATException e) {
                this.mLastError = e.getCode();
                this.checkError();
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setAlertNotify([%s]) - Failed to set alert notify [%s]", (Object[])new Object[]{method, e.getCode()});
                throw e;
            }
            this.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setAlertNotify([%s])", (Object[])new Object[]{method});
    }
}

