/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.barcode.event;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.atid.lib.module.barcode.ATBarcode;
import com.atid.lib.module.barcode.event.IATBarcodeEventListener;
import com.atid.lib.module.barcode.types.BarcodeType;
import com.atid.lib.util.diagnotics.ATLog;
import java.util.ArrayList;
import java.util.Locale;

public class ATBarcodeEventManager {
    private static final String TAG = ATBarcodeEventManager.class.getSimpleName();
    private static final int EVENT_READ_BARCODE = 2000;
    private ArrayList<IATBarcodeEventListener> mListeners;
    private Handler mHandler;
    private Handler.Callback mEventCallback = new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 2000: {
                    ATBarcodeEventManager.this.onReadBarcode((ReadBarcodeEventArgs)msg.obj);
                    return true;
                }
            }
            return false;
        }
    };

    public ATBarcodeEventManager() {
        this.mListeners = new ArrayList();
        this.mHandler = new Handler(Looper.getMainLooper(), this.mEventCallback);
    }

    public void destroy() {
        if (this.mListeners == null) {
            return;
        }
        if (this.mListeners != null) {
            this.mListeners.clear();
            this.mListeners = null;
        }
    }

    public void addListener(IATBarcodeEventListener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(IATBarcodeEventListener listener) {
        this.mListeners.remove(listener);
    }

    public void clear() {
        this.mListeners.clear();
    }

    public void generateBarcodeReadData(ATBarcode barcode, BarcodeType type, String codeId, String data, Object params) {
        if (this.mListeners.isEmpty()) {
            return;
        }
        ReadBarcodeEventArgs args = new ReadBarcodeEventArgs(barcode, type, codeId, data, params);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2000, (Object)args));
    }

    private IATBarcodeEventListener getLastListener() {
        int index = this.mListeners.size() - 1;
        if (index < 0) {
            return null;
        }
        return this.mListeners.get(index);
    }

    private void onReadBarcode(ReadBarcodeEventArgs args) {
        IATBarcodeEventListener listener = null;
        listener = this.getLastListener();
        if (listener == null) {
            return;
        }
        try {
            listener.onBarcodeReadData(args.Barcode, args.Type, args.CodeId, args.Data, args.Params);
        }
        catch (Exception e) {
            ATLog.e((String)TAG, (Throwable)e, (String)"ERROR. onReaderReadBarcode([%s])", (Object[])new Object[]{args});
        }
    }

    private class ReadBarcodeEventArgs {
        private final ATBarcode Barcode;
        private final BarcodeType Type;
        private final String CodeId;
        private final String Data;
        private final Object Params;

        protected ReadBarcodeEventArgs(ATBarcode barcode, BarcodeType type, String codeId, String data, Object params) {
            this.Barcode = barcode;
            this.Type = type;
            this.CodeId = codeId;
            this.Data = data;
            this.Params = params;
        }

        public String toString() {
            return String.format(Locale.US, "[%s], %s, [%s], [%s], [%s]", new Object[]{this.Barcode, this.Type, this.CodeId, this.Data, this.Params == null ? "NULL" : this.Params});
        }
    }
}

