/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.transport.usbserial;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.os.Build;
import com.atid.lib.transport.usbserial.CommonUsbSerialPort;
import com.atid.lib.transport.usbserial.UsbSerialDriver;
import com.atid.lib.transport.usbserial.UsbSerialPort;
import com.atid.lib.util.diagnotics.ATLog;
import com.atid.lib.util.diagnotics.Dump;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CdcAcmSerialDriver
implements UsbSerialDriver {
    private static final String TAG = CdcAcmSerialDriver.class.getSimpleName();
    private static final int INFO = 7;
    private static final int USB_INFO_LEVEL = 11;
    private static final int TIMEOUT_INFINITE = 0;
    private UsbDevice mDevice;
    private UsbSerialPort mPort;

    public CdcAcmSerialDriver(UsbDevice device) {
        this.mDevice = device;
    }

    @Override
    public UsbDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public List<UsbSerialPort> getPorts() {
        this.mPort = new CdcAcmSerialPort(this.mDevice, 0);
        return Collections.singletonList(this.mPort);
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(1003, new int[]{24857});
        return supportedDevices;
    }

    class CdcAcmSerialPort
    extends CommonUsbSerialPort {
        private final boolean mEnableAsyncReads;
        private UsbInterface mControlInterface;
        private UsbInterface mDataInterface;
        private UsbRequest[] mUsbReadRequest;
        private UsbEndpoint mControlEndpoint;
        private UsbEndpoint mReadEndpoint;
        private UsbEndpoint mWriteEndpoint;
        private volatile boolean mIsRTS;
        private volatile boolean mIsDTR;
        private static final int USB_REQUEST_BUFFER_COUNT = 2;
        private static final int CONTROL_TRANSFER_TIMEOUT = 5000;
        private static final int USB_RECIP_INTERFACE = 1;
        private static final int USB_RT_ACM = 33;
        private static final int SET_LINE_CODING = 32;
        private static final int GET_LINE_CODING = 33;
        private static final int SET_CONTROL_LINE_STATE = 34;
        private static final int SEND_BREAK = 35;

        public CdcAcmSerialPort(UsbDevice device, int portNumber) {
            super(device, portNumber);
            this.mControlInterface = null;
            this.mDataInterface = null;
            this.mUsbReadRequest = new UsbRequest[2];
            int i = 0;
            while (i < 2) {
                this.mUsbReadRequest[i] = new UsbRequest();
                ++i;
            }
            this.mControlEndpoint = null;
            this.mReadEndpoint = null;
            this.mWriteEndpoint = null;
            this.mIsRTS = false;
            this.mIsDTR = false;
            this.mEnableAsyncReads = Build.VERSION.SDK_INT >= 17;
        }

        @Override
        public UsbSerialDriver getDriver() {
            return CdcAcmSerialDriver.this;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void open(UsbDeviceConnection connection) throws IOException {
            block13: {
                block14: {
                    if (this.mConnection != null) {
                        ATLog.i((String)CdcAcmSerialDriver.access$0(), (int)7, (String)"INFO. open() - Already usb device is opened");
                        throw new IOException("Already usb device is opened");
                    }
                    this.mConnection = connection;
                    isOpened = false;
                    try {
                        try {
                            if (1 == this.mDevice.getInterfaceCount()) {
                                this.openSingleInterface();
                            } else {
                                this.openInterface();
                            }
                            isOpened = true;
                            bufferSize = this.mReadEndpoint.getMaxPacketSize();
                            i = 0;
                            while (i < 2) {
                                if (this.mUsbReadRequest[i] != null) {
                                    this.mUsbReadRequest[i].initialize(this.mConnection, this.mReadEndpoint);
                                    buffer = ByteBuffer.allocate(bufferSize);
                                    this.mUsbReadRequest[i].setClientData((Object)buffer);
                                    if (!this.mUsbReadRequest[i].queue(buffer, buffer.capacity())) {
                                        isOpened = false;
                                        ATLog.e((String)CdcAcmSerialDriver.access$0(), (String)"ERROR. open() - Failed to open the usb interface");
                                        throw new IOException("Failed to open the usb interface");
                                    }
                                }
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            ATLog.e((String)CdcAcmSerialDriver.access$0(), (Throwable)e, (String)"ERROR. open() - Failed to open the usb interface", (Object[])new Object[0]);
                            throw new IOException("Failed to open the usb interface");
                        }
                    }
                    finally {
                        if (isOpened) break block13;
                        if (this.mUsbReadRequest == null) break block14;
                        i = 0;
                        ** while (i < 2)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (this.mUsbReadRequest[i] != null) {
                            this.mUsbReadRequest[i].close();
                            this.mUsbReadRequest[i] = null;
                        }
                        ++i;
                        continue;
                    }
                }
                this.mConnection = null;
                this.mControlEndpoint = null;
                this.mReadEndpoint = null;
                this.mWriteEndpoint = null;
            }
            ATLog.i((String)CdcAcmSerialDriver.access$0(), (int)7, (String)"INFO. open() - Asynchronous[%s]", (Object[])new Object[]{this.mEnableAsyncReads});
        }

        private void openSingleInterface() throws IOException {
            this.mControlInterface = this.mDevice.getInterface(0);
            this.mDataInterface = this.mDevice.getInterface(0);
            if (!this.mConnection.claimInterface(this.mControlInterface, true)) {
                ATLog.e((String)TAG, (String)"ERROR. openSingleInterface() - Could not claim shared control/data interface.");
                throw new IOException("Could not claim shared control/data interface.");
            }
            int endCount = this.mControlInterface.getEndpointCount();
            if (endCount < 3) {
                ATLog.e((String)TAG, (String)"ERROR. openSingleInterface() - not enough endpoints - need 3. count[%d]", (Object[])new Object[]{this.mControlInterface.getEndpointCount()});
                throw new IOException(String.format(Locale.US, "Insufficient number of endpoints [%d]", this.mControlInterface.getEndpointCount()));
            }
            this.mControlEndpoint = null;
            this.mReadEndpoint = null;
            this.mWriteEndpoint = null;
            int i = 0;
            while (i < endCount) {
                UsbEndpoint ep = this.mControlInterface.getEndpoint(i);
                if (ep.getDirection() == 128 && ep.getType() == 3) {
                    this.mControlEndpoint = ep;
                } else if (ep.getDirection() == 128 && ep.getType() == 2) {
                    this.mReadEndpoint = ep;
                } else if (ep.getDirection() == 0 && ep.getType() == 2) {
                    this.mWriteEndpoint = ep;
                }
                if (this.mControlEndpoint != null && this.mReadEndpoint != null && this.mWriteEndpoint != null) break;
                ++i;
            }
            if (this.mControlEndpoint == null) {
                ATLog.e((String)TAG, (String)"ERROR. openSingleInterface() - Falied to found control endpoints");
                throw new IOException("Could not establish all endpoints");
            }
            if (this.mReadEndpoint == null) {
                ATLog.e((String)TAG, (String)"ERROR. openSingleInterface() - Falied to found read endpoints");
                throw new IOException("Could not establish all endpoints");
            }
            if (this.mWriteEndpoint == null) {
                ATLog.e((String)TAG, (String)"ERROR. openSingleInterface() - Falied to found write endpoints");
                throw new IOException("Could not establish all endpoints");
            }
            if (ATLog.isLogging((int)11)) {
                ATLog.i((String)TAG, (int)7, (String)"INFO. openSingleInterface() - Control [%s]", (Object[])new Object[]{this.mControlInterface.toString()});
                ATLog.i((String)TAG, (int)7, (String)"INFO. openSingleInterface() - Data [%s]", (Object[])new Object[]{this.mDataInterface.toString()});
                ATLog.i((String)TAG, (int)7, (String)"INFO. openSingleInterface() - Endpoint direction : Control[%X], Read[%X], Write[%X]", (Object[])new Object[]{this.mControlEndpoint.getDirection(), this.mReadEndpoint.getDirection(), this.mWriteEndpoint.getDirection()});
            }
            ATLog.i((String)TAG, (int)7, (String)"INFO. openSingleInterface()");
        }

        private void openInterface() throws IOException {
            this.mControlInterface = this.mDevice.getInterface(0);
            if (!this.mConnection.claimInterface(this.mControlInterface, true)) {
                ATLog.e((String)TAG, (String)"ERROR. openInterface() - Could not claim control interface");
                throw new IOException("Could not claim control interface");
            }
            this.mControlEndpoint = this.mControlInterface.getEndpoint(0);
            this.mDataInterface = this.mDevice.getInterface(1);
            if (!this.mConnection.claimInterface(this.mDataInterface, true)) {
                ATLog.e((String)TAG, (String)"ERROR. openInterface() - Could not claim data interface");
                throw new IOException("Could not claim data interface");
            }
            this.mReadEndpoint = this.mDataInterface.getEndpoint(1);
            this.mWriteEndpoint = this.mDataInterface.getEndpoint(0);
            if (ATLog.isLogging((int)11)) {
                ATLog.i((String)TAG, (int)7, (String)"INFO. openInterface() - interfaces count[%d]", (Object[])new Object[]{this.mDevice.getInterfaceCount()});
                ATLog.i((String)TAG, (int)7, (String)"INFO. openInterface() - Control [%s]", (Object[])new Object[]{this.mControlInterface.toString()});
                ATLog.i((String)TAG, (int)7, (String)"INFO. openInterface() - Data [%s]", (Object[])new Object[]{this.mDataInterface.toString()});
                ATLog.i((String)TAG, (int)7, (String)"INFO. openInterface() - Endpoint direction : Control[%X], Read[%X], Write[%X]", (Object[])new Object[]{this.mControlEndpoint.getDirection(), this.mReadEndpoint.getDirection(), this.mWriteEndpoint.getDirection()});
                ATLog.i((String)TAG, (int)7, (String)"INFO. openInterface() - Read Endpoint : Interval [%d], Max Packet Size[%d]", (Object[])new Object[]{this.mReadEndpoint.getInterval(), this.mReadEndpoint.getMaxPacketSize()});
            }
            ATLog.i((String)TAG, (int)7, (String)"INFO. openInterface()");
        }

        private int sendAcmControlMessage(int request, int value, byte[] buf) throws Exception {
            if (this.mConnection == null) {
                ATLog.e((String)TAG, (String)"ERROR. sendAcmControlMessage() - USB Connection is NULL");
                throw new IOException("Error USB Connection is NULL");
            }
            int result = this.mConnection.controlTransfer(33, request, value, 0, buf, buf != null ? buf.length : 0, 5000);
            ATLog.i((String)TAG, (int)7, (String)"INFO. sendAcmControlMessage(%d, %d, %s) - result[%d, %s]", (Object[])new Object[]{request, value, buf != null ? Dump.dump((byte[])buf, (int)0, (int)buf.length) : "", result, result == 0 ? "Success" : "Fail"});
            return result;
        }

        @Override
        public void close() throws IOException {
            if (this.mUsbReadRequest != null) {
                int i = 0;
                while (i < 2) {
                    if (this.mUsbReadRequest[i] != null) {
                        this.mUsbReadRequest[i].close();
                        this.mUsbReadRequest[i] = null;
                    }
                    ++i;
                }
            }
            if (this.mConnection == null) {
                this.mControlEndpoint = null;
                this.mReadEndpoint = null;
                this.mWriteEndpoint = null;
                ATLog.e((String)TAG, (String)"ERROR. close() - USB Connection is NULL");
                throw new IOException("Error USB Connection is NULL");
            }
            if (this.mDataInterface != null) {
                this.mConnection.releaseInterface(this.mDataInterface);
            }
            if (this.mControlInterface != null) {
                this.mConnection.releaseInterface(this.mControlInterface);
            }
            if (this.mConnection != null) {
                this.mConnection.close();
                this.mConnection = null;
            }
            this.mControlEndpoint = null;
            this.mReadEndpoint = null;
            this.mWriteEndpoint = null;
            ATLog.i((String)TAG, (int)7, (String)"INFO. close()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] dest) throws Exception {
            if (this.mEnableAsyncReads) {
                int count = 0;
                try {
                    if (this.mConnection == null) {
                        ATLog.e((String)TAG, (String)"ERROR. read() - USB Connection is NULL");
                        throw new IOException("Error USB Connection is NULL");
                    }
                    if (this.mReadEndpoint == null) {
                        ATLog.e((String)TAG, (String)"ERROR. read() - USB read endpoint is NULL");
                        throw new IOException("Error USB read endpoint is NULL");
                    }
                    UsbRequest response = this.mConnection.requestWait();
                    if (response == null) {
                        ATLog.e((String)TAG, (String)"ERROR. read() - Null response");
                        throw new IOException("Null response");
                    }
                    ByteBuffer buf = (ByteBuffer)response.getClientData();
                    count = buf.position();
                    if (!response.queue(buf, buf.capacity())) {
                        ATLog.e((String)TAG, (String)"ERROR. read() - Error queueing request");
                        throw new IOException("Error queueing request");
                    }
                    if (count < 0) {
                        count = 0;
                    } else {
                        System.arraycopy(buf.array(), 0, dest, 0, count);
                        if (ATLog.isLogging((int)7)) {
                            ATLog.i((String)TAG, (int)7, (String)"INFO. read() - [%d][%s]", (Object[])new Object[]{count, Dump.dump((byte[])dest, (int)0, (int)count)});
                        }
                    }
                    return count;
                }
                catch (Exception e) {
                    ATLog.e((String)TAG, (Throwable)e, (String)"ERROR. read() - Failed to read the usb port", (Object[])new Object[0]);
                    throw new IOException("Error read the usb port");
                }
            }
            int numBytesRead = 0;
            int timeout = 0;
            Object object = this.mReadBufferLock;
            synchronized (object) {
                block18: {
                    block19: {
                        int readAmt = Math.min(dest.length, this.mReadBuffer.length);
                        try {
                            numBytesRead = this.mConnection.bulkTransfer(this.mReadEndpoint, this.mReadBuffer, readAmt, timeout);
                        }
                        catch (Exception e) {
                            ATLog.e((String)TAG, (String)"ERROR. read() - Failed to read(bulktransfer) the usb port");
                            throw new IOException("Error read(bulktransfer) the usb port");
                        }
                        if (numBytesRead >= 0) break block18;
                        if (timeout != Integer.MAX_VALUE) break block19;
                        return -1;
                    }
                    return 0;
                }
                System.arraycopy(this.mReadBuffer, 0, dest, 0, numBytesRead);
            }
            if (ATLog.isLogging((int)7)) {
                ATLog.i((String)TAG, (int)7, (String)"INFO. read() - [%d][%s]", (Object[])new Object[]{numBytesRead, Dump.dump((byte[])dest, (int)0, (int)numBytesRead)});
            }
            return numBytesRead;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] dest, int offset, int size, int timeout) throws Exception {
            if (this.mEnableAsyncReads) {
                if (Build.VERSION.SDK_INT < 26) {
                    ATLog.e((String)TAG, (String)"ERROR. read() - not supported android api ( minimum level 26 )");
                    throw new IOException("Error not supported android api ( minimum level 26 )");
                }
                int count = 0;
                try {
                    if (this.mConnection == null) {
                        ATLog.e((String)TAG, (String)"ERROR. read() - USB Connection is NULL");
                        throw new IOException("Error USB Connection is NULL");
                    }
                    if (this.mReadEndpoint == null) {
                        ATLog.e((String)TAG, (String)"ERROR. read() - USB read endpoint is NULL");
                        throw new IOException("Error USB read endpoint is NULL");
                    }
                    UsbRequest response = this.mConnection.requestWait((long)timeout);
                    if (response == null) {
                        ATLog.e((String)TAG, (String)"ERROR. read() - Null response");
                        throw new IOException("Null response");
                    }
                    ByteBuffer buf = (ByteBuffer)response.getClientData();
                    count = buf.position();
                    if (!response.queue(buf, buf.capacity())) {
                        ATLog.e((String)TAG, (String)"ERROR. read() - Error queueing request");
                        throw new IOException("Error queueing request");
                    }
                    if (count < 0) {
                        count = 0;
                    } else {
                        System.arraycopy(buf.array(), 0, dest, 0, count);
                        if (ATLog.isLogging((int)7)) {
                            ATLog.i((String)TAG, (int)7, (String)"INFO. read() - [%d][%s]", (Object[])new Object[]{count, Dump.dump((byte[])dest, (int)0, (int)count)});
                        }
                    }
                    return count;
                }
                catch (Exception e) {
                    ATLog.e((String)TAG, (Throwable)e, (String)"ERROR. read() - Failed to read the usb port", (Object[])new Object[0]);
                    throw new IOException("Error read the usb port");
                }
            }
            int numBytesRead = 0;
            Object object = this.mReadBufferLock;
            synchronized (object) {
                block19: {
                    block20: {
                        int readAmt = Math.min(dest.length, this.mReadBuffer.length);
                        try {
                            numBytesRead = this.mConnection.bulkTransfer(this.mReadEndpoint, this.mReadBuffer, readAmt, timeout);
                        }
                        catch (Exception e) {
                            ATLog.e((String)TAG, (String)"ERROR. read() - Failed to read(bulktransfer) the usb port");
                            throw new IOException("Error read(bulktransfer) the usb port");
                        }
                        if (numBytesRead >= 0) break block19;
                        if (timeout != Integer.MAX_VALUE) break block20;
                        return -1;
                    }
                    return 0;
                }
                System.arraycopy(this.mReadBuffer, 0, dest, 0, numBytesRead);
            }
            if (ATLog.isLogging((int)7)) {
                ATLog.i((String)TAG, (int)7, (String)"INFO. read() - [%d][%s]", (Object[])new Object[]{numBytesRead, Dump.dump((byte[])dest, (int)0, (int)numBytesRead)});
            }
            return numBytesRead;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(byte[] src, int offset, int size) throws Exception {
            int position = offset;
            if (src == null) {
                ATLog.e((String)TAG, (String)"ERROR. write() - buffer is NULL");
                return 0;
            }
            if (this.mConnection == null) {
                ATLog.e((String)TAG, (String)"ERROR. write() - USB Connection is NULL");
                throw new IOException("Error USB Connection is NULL");
            }
            if (this.mWriteEndpoint == null) {
                ATLog.e((String)TAG, (String)"ERROR. write() - USB write endpoint is NULL");
                throw new IOException("Error USB write endpoint is NULL");
            }
            int maxSize = this.mWriteEndpoint.getMaxPacketSize();
            int writeLength = 0;
            int amtWritten = 0;
            while (position < src.length) {
                Object object = this.mWriteBufferLock;
                synchronized (object) {
                    byte[] writeBuffer;
                    writeLength = Math.min(size - position, maxSize);
                    if (position == 0) {
                        writeBuffer = src;
                    } else {
                        System.arraycopy(src, position, this.mWriteBuffer, 0, writeLength);
                        writeBuffer = this.mWriteBuffer;
                    }
                    try {
                        amtWritten = this.mConnection.bulkTransfer(this.mWriteEndpoint, writeBuffer, writeLength, 0);
                    }
                    catch (Exception e) {
                        ATLog.e((String)TAG, (String)"Error. write() - USB Connection or Write Endpoint occur error");
                        throw new IOException("ERROR USB Connection or Write Endpoint occur error");
                    }
                }
                if (amtWritten <= 0) {
                    ATLog.e((String)TAG, (String)"Error. write() - Writting %d bytes at offset %d length %d", (Object[])new Object[]{writeLength, position, src.length});
                    throw new IOException(String.format(Locale.US, "Error Writting %d bytes at offset %d length %d", writeLength, position, src.length));
                }
                if (ATLog.isLogging((int)7) && ATLog.isLogging((int)7)) {
                    ATLog.i((String)TAG, (int)7, (String)"INFO. write([%s], %d, %d) - [%04d]", (Object[])new Object[]{Dump.dump((byte[])src, (int)position, (int)writeLength), position, size, writeLength});
                }
                position += amtWritten;
            }
            return position;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(byte[] src, int offset, int size, int timeout) throws Exception {
            int position = offset;
            if (src == null) {
                ATLog.e((String)TAG, (String)"ERROR. write() - buffer is NULL");
                return 0;
            }
            if (this.mConnection == null) {
                ATLog.e((String)TAG, (String)"ERROR. write() - USB Connection is NULL");
                throw new IOException("Error USB Connection is NULL");
            }
            if (this.mWriteEndpoint == null) {
                ATLog.e((String)TAG, (String)"ERROR. write() - USB write endpoint is NULL");
                throw new IOException("Error USB write endpoint is NULL");
            }
            int maxSize = this.mWriteEndpoint.getMaxPacketSize();
            int writeLength = 0;
            int amtWritten = 0;
            while (position < src.length) {
                Object object = this.mWriteBufferLock;
                synchronized (object) {
                    byte[] writeBuffer;
                    writeLength = Math.min(size - position, maxSize);
                    if (position == 0) {
                        writeBuffer = src;
                    } else {
                        System.arraycopy(src, position, this.mWriteBuffer, 0, writeLength);
                        writeBuffer = this.mWriteBuffer;
                    }
                    try {
                        amtWritten = this.mConnection.bulkTransfer(this.mWriteEndpoint, writeBuffer, writeLength, timeout);
                    }
                    catch (Exception e) {
                        ATLog.e((String)TAG, (String)"Error. write() - USB Connection or Write Endpoint occur error");
                        throw new IOException("ERROR USB Connection or Write Endpoint occur error");
                    }
                }
                if (amtWritten <= 0) {
                    ATLog.e((String)TAG, (String)"Error. write() - Writting %d bytes at offset %d length %d", (Object[])new Object[]{writeLength, position, src.length});
                    throw new IOException(String.format(Locale.US, "Error Writting %d bytes at offset %d length %d", writeLength, position, src.length));
                }
                if (ATLog.isLogging((int)7) && ATLog.isLogging((int)7)) {
                    ATLog.i((String)TAG, (int)7, (String)"INFO. write([%s], %d, %d, %d) - [%04d]", (Object[])new Object[]{Dump.dump((byte[])src, (int)position, (int)writeLength), position, size, timeout, writeLength});
                }
                position += amtWritten;
            }
            return position;
        }

        @Override
        public int setParameters(int baudRate, int dataBits, int stopBits, int parity) throws IOException {
            byte parityBitesByte;
            byte stopBitsByte;
            int result = -1;
            switch (stopBits) {
                case 1: {
                    stopBitsByte = 0;
                    break;
                }
                case 3: {
                    stopBitsByte = 1;
                    break;
                }
                case 2: {
                    stopBitsByte = 2;
                    break;
                }
                default: {
                    ATLog.e((String)TAG, (String)"Bad value for stopBits : %d", (Object[])new Object[]{stopBits});
                    throw new IllegalArgumentException(String.format(Locale.US, "Bad value for stopBits : %d", stopBits));
                }
            }
            switch (parity) {
                case 0: {
                    parityBitesByte = 0;
                    break;
                }
                case 1: {
                    parityBitesByte = 1;
                    break;
                }
                case 2: {
                    parityBitesByte = 2;
                    break;
                }
                case 3: {
                    parityBitesByte = 3;
                    break;
                }
                case 4: {
                    parityBitesByte = 4;
                    break;
                }
                default: {
                    ATLog.e((String)TAG, (String)"Bad value for parity : %d", (Object[])new Object[]{parity});
                    throw new IllegalArgumentException(String.format(Locale.US, "Bad value for parity : %d", parity));
                }
            }
            byte[] msg = new byte[]{(byte)(baudRate & 0xFF), (byte)(baudRate >> 8 & 0xFF), (byte)(baudRate >> 16 & 0xFF), (byte)(baudRate >> 24 & 0xFF), stopBitsByte, parityBitesByte, (byte)dataBits};
            try {
                result = this.sendAcmControlMessage(32, 0, msg);
            }
            catch (Exception e) {
                ATLog.e((String)TAG, (Throwable)e, (String)"ERROR. setParameters(%d, %d, %d, %d) - Failed to set parameter", (Object[])new Object[]{baudRate, dataBits, stopBits, parity});
                throw new IOException("Failed to set parameter");
            }
            ATLog.i((String)TAG, (int)7, (String)"INFO. setParameters(%d, %d, %d, %d)", (Object[])new Object[]{baudRate, dataBits, stopBits, parity});
            return result;
        }

        @Override
        public boolean getCD() throws IOException {
            return false;
        }

        @Override
        public boolean getCTS() throws IOException {
            return false;
        }

        @Override
        public boolean getDSR() throws IOException {
            return false;
        }

        @Override
        public boolean getDTR() throws IOException {
            return this.mIsDTR;
        }

        @Override
        public int setDTR(boolean value) throws IOException {
            this.mIsDTR = value;
            return this.setDtrRts();
        }

        @Override
        public boolean getRI() throws IOException {
            return false;
        }

        @Override
        public boolean getRTS() throws IOException {
            return this.mIsRTS;
        }

        @Override
        public int setRTS(boolean value) throws IOException {
            this.mIsRTS = value;
            return this.setDtrRts();
        }

        private int setDtrRts() throws IOException {
            int value = (this.mIsRTS ? 2 : 0) | (this.mIsDTR ? 1 : 0);
            try {
                return this.sendAcmControlMessage(34, value, null);
            }
            catch (Exception e) {
                ATLog.e((String)TAG, (Throwable)e, (String)"ERROR. setDtrRts() - Failed to control DTR or RTS", (Object[])new Object[0]);
                throw new IOException("Failed to control DTR or RTS");
            }
        }
    }
}

