/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.transport.usbserial;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import com.atid.lib.transport.usbserial.CdcAcmSerialDriver;
import com.atid.lib.transport.usbserial.ProbeTable;
import com.atid.lib.transport.usbserial.UsbSerialDriver;
import com.atid.lib.util.diagnotics.ATLog;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class UsbSerialProber {
    private static final String TAG = UsbSerialProber.class.getSimpleName();
    private static final int INFO = 7;
    private final ProbeTable mProbeTable;

    public UsbSerialProber(ProbeTable probeTable) {
        this.mProbeTable = probeTable;
    }

    public static UsbSerialProber getDefaultProber() throws Exception {
        return new UsbSerialProber(UsbSerialProber.getDefaultProbeTable());
    }

    public static ProbeTable getDefaultProbeTable() throws Exception {
        ProbeTable probeTable = new ProbeTable();
        probeTable.addDriver(CdcAcmSerialDriver.class);
        return probeTable;
    }

    public List<UsbSerialDriver> findAllDrivers(UsbManager usbManager) throws Exception {
        ArrayList<UsbSerialDriver> result = new ArrayList<UsbSerialDriver>();
        if (usbManager == null) {
            ATLog.e((String)TAG, (String)"ERROR. findAllDrivers() - USB manager is null");
            throw new IllegalArgumentException("USB manager is null");
        }
        for (UsbDevice usbDevice : usbManager.getDeviceList().values()) {
            try {
                UsbSerialDriver driver = this.probeDevice(usbDevice);
                if (driver == null) continue;
                ATLog.i((String)TAG, (int)7, (String)"INFO. findAllDrivers() - Found Driver [%s]", (Object[])new Object[]{usbDevice.getProductName()});
                result.add(driver);
            }
            catch (Exception e) {
                ATLog.e((String)TAG, (String)"ERROR. findAllDrivers() - Failed to probe the usb device.");
            }
        }
        ATLog.i((String)TAG, (int)7, (String)"INFO. findAllDrivers()");
        return result;
    }

    public UsbSerialDriver probeDevice(UsbDevice usbDevice) throws Exception {
        Class<CdcAcmSerialDriver> driverClass;
        if (usbDevice == null) {
            ATLog.e((String)TAG, (String)"probeDevice() - parameter is null !!!");
            throw new RuntimeException(new NullPointerException());
        }
        int vendorId = usbDevice.getVendorId();
        int productId = usbDevice.getProductId();
        int deviceClass = usbDevice.getDeviceClass();
        boolean isCdcAcmSerialDriver = false;
        if (deviceClass == 2) {
            isCdcAcmSerialDriver = true;
        }
        Class clazz = driverClass = isCdcAcmSerialDriver ? CdcAcmSerialDriver.class : this.mProbeTable.findDriver(vendorId, productId);
        if (driverClass != null) {
            UsbSerialDriver driver;
            try {
                Constructor ctor = driverClass.getConstructor(UsbDevice.class);
                try {
                    driver = (UsbSerialDriver)ctor.newInstance(usbDevice);
                }
                catch (InstantiationException e) {
                    ATLog.e((String)TAG, (String)"ERROR. probeDevice() - Instantiation Exception");
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    ATLog.e((String)TAG, (String)"ERROR. probeDevice() - Illegal Access Exception");
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    ATLog.e((String)TAG, (String)"ERROR. probeDevice() - Invocation Target Exception");
                    throw new RuntimeException(e);
                }
            }
            catch (NoSuchMethodException e) {
                ATLog.e((String)TAG, (String)"ERROR. probeDevice() - No Such Method Exception");
                throw new RuntimeException(e);
            }
            ATLog.i((String)TAG, (int)7, (String)"INFO. probeDevice()");
            return driver;
        }
        ATLog.e((String)TAG, (String)"ERROR. probeDevice() - driver class is null !!!");
        throw new RuntimeException(new NullPointerException());
    }
}

