/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.transport;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import com.atid.lib.transport.ATransport;
import com.atid.lib.transport.types.ConnectState;
import com.atid.lib.transport.types.ConnectType;
import com.atid.lib.types.DeviceType;
import com.atid.lib.util.SysUtil;
import com.atid.lib.util.collections.ByteQueue;
import com.atid.lib.util.diagnotics.ATLog;
import com.atid.lib.util.diagnotics.Dump;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class ATransportBluetooth
extends ATransport {
    private static final String NAME = "ATBluetoothDevice";
    private static final UUID VCP_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private static final int MAX_BUF_SIZE = 4096;
    private BluetoothAdapter mAdapter;
    private volatile ListenThread mListenThread;
    private volatile ConnectThread mConnectThread;
    private volatile ReceiveThread mReceiveThread;

    public ATransportBluetooth() {
        this.TAG = ATransportBluetooth.class.getSimpleName();
        this.mConnType = ConnectType.Bluetooth;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mListenThread = null;
        this.mConnectThread = null;
        this.mReceiveThread = null;
    }

    public ATransportBluetooth(DeviceType type, String name, String address) {
        super(type, name, address);
        this.TAG = ATransportBluetooth.class.getSimpleName();
        this.mConnType = ConnectType.Bluetooth;
        this.mDevType = type;
        this.mDevName = name;
        this.mAddress = address;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mListenThread = null;
        this.mConnectThread = null;
        this.mReceiveThread = null;
    }

    @Override
    public void destroy() {
        this.stopListenThread();
        this.stopConnectThread();
        this.stopReceiveThread();
    }

    @Override
    public void setAutoConnect(boolean enabled) {
        this.mIsAutoConnect = enabled;
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. setAutoConnect(%s)", (Object[])new Object[]{this.mIsAutoConnect});
    }

    @Override
    public boolean getAutoConnect() {
        return this.mIsAutoConnect;
    }

    @Override
    public boolean getDeviceAttached() {
        return this.mIsDeviceAttached;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized boolean connect() {
        if (this.mState == ConnectState.Connected) {
            ATLog.i((String)this.TAG, (int)9, (String)"DUMP. connect() - Already bluetooth is connected");
            return true;
        }
        if (this.mState == ConnectState.Connecting) {
            this.stopConnectThread();
        }
        this.stopReceiveThread();
        this.setState(ConnectState.Connecting, null);
        try {
            this.mConnectThread = new ConnectThread();
            this.mConnectThread.start();
            if (true) ** GOTO lbl19
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. connect() - Failed to create connect thread", (Object[])new Object[0]);
            this.setState(ConnectState.Disconnected, null);
            this.mConnectThread = null;
            return false;
        }
        do {
            SysUtil.sleep((int)100);
lbl19:
            // 2 sources

        } while (!this.mConnectThread.isAlive());
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. connect()");
        return true;
    }

    @Override
    public synchronized void listen() {
        this.stopConnectThread();
        this.stopReceiveThread();
        if (this.mListenThread == null) {
            this.mListenThread = new ListenThread();
            this.mListenThread.start();
        }
        while (!this.mListenThread.isAlive()) {
            SysUtil.sleep((int)100);
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. listen()");
        this.setState(ConnectState.Listen, null);
    }

    @Override
    public synchronized void disconnect() {
        this.stopReceiveThread();
        this.stopConnectThread();
        this.stopListenThread();
        this.setState(ConnectState.Disconnected, null);
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. disconnect()");
    }

    @Override
    public synchronized int write(byte[] data, int offset, int length) {
        if (this.mReceiveThread == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. write(%s) - Failed to invalid receive thread", (Object[])new Object[]{Dump.dump((byte[])data, (int)offset, (int)length)});
            return 0;
        }
        return this.mReceiveThread.write(data, offset, length);
    }

    @Override
    public synchronized int write(byte[] data, int offset, int length, int timeout) {
        if (this.mReceiveThread == null) {
            ATLog.e((String)this.TAG, (String)"ERROR. write(%s) - Failed to invalid receive thread", (Object[])new Object[]{Dump.dump((byte[])data, (int)offset, (int)length)});
            return 0;
        }
        return this.mReceiveThread.write(data, offset, length, timeout);
    }

    @Override
    public int available() {
        return this.mQueue.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] data, int offset, int length) {
        int recvBytes = 0;
        ByteQueue byteQueue = this.mQueue;
        synchronized (byteQueue) {
            while (this.mQueue.getSize() == 0) {
                try {
                    this.mQueue.wait();
                }
                catch (InterruptedException e) {
                    ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. read(%d) - Failed to read data , Interrupted Excepton", (Object[])new Object[]{length});
                    return -2;
                }
            }
        }
        try {
            if (this.mQueue.getSize() <= 0) return recvBytes;
            return this.mQueue.dequeue(data, offset + recvBytes, length - recvBytes);
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. read(%d) - Failed to read data , Exception", (Object[])new Object[]{length});
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] data, int offset, int length, int timeout) {
        int recvBytes = 0;
        int readBytes = 0;
        long tick = System.currentTimeMillis();
        while (recvBytes >= length) {
            ByteQueue byteQueue = this.mQueue;
            synchronized (byteQueue) {
                while (this.mQueue.getSize() == 0) {
                    try {
                        this.mQueue.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. read(%d) - Failed to read data , Interrupted Excepton", (Object[])new Object[]{length});
                        return -2;
                    }
                }
            }
            try {
                if (this.mQueue.getSize() > 0) {
                    readBytes = this.mQueue.dequeue(data, offset + recvBytes, length - recvBytes);
                } else if (System.currentTimeMillis() - tick >= (long)timeout) {
                    ATLog.e((String)this.TAG, (String)"ERROR. read(%d) - Failed to read data , timeout[%d]", (Object[])new Object[]{length, timeout});
                    return recvBytes;
                }
            }
            catch (Exception e) {
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. read(%d) - Failed to read data", (Object[])new Object[]{length});
                return -1;
            }
            recvBytes += readBytes;
        }
        return recvBytes;
    }

    private synchronized void stopListenThread() {
        if (this.mListenThread == null) {
            return;
        }
        this.mListenThread.cancel();
        this.mListenThread = null;
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. stopListenThread()");
    }

    private synchronized void stopConnectThread() {
        if (this.mConnectThread == null) {
            return;
        }
        this.mConnectThread.cancel();
        this.mConnectThread = null;
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. stopConnectThread()");
    }

    private synchronized void startReceiveThread(BluetoothSocket sock) {
        if (this.mState != ConnectState.Listen && this.mState != ConnectState.Connecting) {
            try {
                sock.close();
            }
            catch (Exception e) {
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. startReceiveThread() - Failed to close bluetooth socket", (Object[])new Object[0]);
                return;
            }
            ATLog.e((String)this.TAG, (String)"ERROR. startReceiveThread() - Failed to invalid connect state [%s]", (Object[])new Object[]{this.mState});
            return;
        }
        this.stopListenThread();
        this.stopConnectThread();
        this.stopReceiveThread();
        try {
            this.mReceiveThread = new ReceiveThread(sock);
        }
        catch (Exception e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. startReceiveThread() - Failed to start recieve thread", (Object[])new Object[0]);
            this.setState(ConnectState.Disconnected, null);
            return;
        }
        this.mReceiveThread.start();
        while (!this.mReceiveThread.isAlive()) {
            SysUtil.sleep((int)100);
        }
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. startReceiveThread()");
    }

    private synchronized void stopReceiveThread() {
        if (this.mReceiveThread == null) {
            return;
        }
        this.mReceiveThread.cancel();
        this.mReceiveThread = null;
        ATLog.i((String)this.TAG, (int)7, (String)"INFO. stopReceiveThread()");
    }

    private class ConnectThread
    extends Thread {
        private BluetoothSocket mSock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConnectThread() throws Exception {
            BluetoothDevice device = null;
            BluetoothSocket sock = null;
            try {
                BluetoothAdapter bluetoothAdapter = ATransportBluetooth.this.mAdapter;
                synchronized (bluetoothAdapter) {
                    device = ATransportBluetooth.this.mAdapter.getRemoteDevice(ATransportBluetooth.this.mAddress);
                }
            }
            catch (Exception e) {
                ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e, (String)"ERROR. $ConnectThread.Constructor() - Failed to get remote bluetooth device [%s]", (Object[])new Object[]{ATransportBluetooth.this.mAddress});
                throw e;
            }
            try {
                sock = device.createInsecureRfcommSocketToServiceRecord(VCP_UUID);
            }
            catch (Exception e) {
                ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e, (String)"ERROR. $ConnectThread.Constructor() - Failed to create bluetooth socket [%s]", (Object[])new Object[]{ATransportBluetooth.this.mAddress});
                throw e;
            }
            this.mSock = sock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            block22: {
                ATLog.i((String)ATransportBluetooth.this.TAG, (int)7, (String)"+++ INFO. $ConnectThread.run()");
                try {
                    object = ATransportBluetooth.this.mAdapter;
                    synchronized (object) {
                        if (ATransportBluetooth.this.mAdapter.isDiscovering()) {
                            ATransportBluetooth.this.mAdapter.cancelDiscovery();
                        }
                    }
                }
                catch (Exception e) {
                    ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e, (String)"--- ERROR. $ConnectThread.run() - Failed to process bluetooth adaptor", (Object[])new Object[0]);
                }
                try {
                    if (this.mSock == null) break block22;
                    BluetoothSocket e = this.mSock;
                    synchronized (e) {
                        this.mSock.connect();
                    }
                }
                catch (Exception e) {
                    block24: {
                        block23: {
                            try {
                                try {
                                    if (this.mSock == null) break block23;
                                    BluetoothSocket bluetoothSocket = this.mSock;
                                    synchronized (bluetoothSocket) {
                                        this.mSock.close();
                                        this.mSock = null;
                                    }
                                }
                                catch (Exception e1) {
                                    ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e1, (String)"--- ERROR. $ConnectThread.run() - Failed to cloase bluetooth socket [%s]", (Object[])new Object[]{ATransportBluetooth.this.mAddress});
                                    ATransportBluetooth.this.setState(ConnectState.Disconnected, null);
                                    break block24;
                                }
                            }
                            catch (Throwable throwable) {
                                ATransportBluetooth.this.setState(ConnectState.Disconnected, null);
                                throw throwable;
                            }
                        }
                        ATransportBluetooth.this.setState(ConnectState.Disconnected, null);
                    }
                    ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e, (String)"--- ERROR. $ConnectThread.run() - Failed to connect bluetooth socket [%s]", (Object[])new Object[]{ATransportBluetooth.this.mAddress});
                    return;
                }
            }
            object = ATransportBluetooth.this;
            synchronized (object) {
                ATransportBluetooth.this.mConnectThread = null;
            }
            ATransportBluetooth.this.startReceiveThread(this.mSock);
            ATLog.i((String)ATransportBluetooth.this.TAG, (int)7, (String)"--- INFO. $ConnectThread.run()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            block5: {
                try {
                    if (this.mSock == null) break block5;
                    BluetoothSocket bluetoothSocket = this.mSock;
                    synchronized (bluetoothSocket) {
                        this.mSock.close();
                        this.mSock = null;
                    }
                }
                catch (Exception e) {
                    ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e, (String)"ERROR. $ConnectThread.cancel() - Failed to cloase bluetooth socket", (Object[])new Object[0]);
                    return;
                }
            }
            ATLog.i((String)ATransportBluetooth.this.TAG, (int)7, (String)"INFO. $ConnectThread.cancel()");
        }
    }

    private class ListenThread
    extends Thread {
        private BluetoothServerSocket mListenSock = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListenThread() {
            BluetoothServerSocket listen = null;
            try {
                BluetoothAdapter bluetoothAdapter = ATransportBluetooth.this.mAdapter;
                synchronized (bluetoothAdapter) {
                    listen = ATransportBluetooth.this.mAdapter.listenUsingRfcommWithServiceRecord(ATransportBluetooth.NAME, VCP_UUID);
                }
            }
            catch (Exception e) {
                ATLog.e((String)ATransportBluetooth.this.TAG, (String)"ERROR. $ListenThread.Constructor() - Failed to get listen bluetooth server socket");
            }
            this.mListenSock = listen;
        }

        @Override
        public void run() {
            BluetoothSocket sock = null;
            ATLog.i((String)ATransportBluetooth.this.TAG, (int)7, (String)"+++ INFO. $ListenThread.run()");
            while (ATransportBluetooth.this.mState != ConnectState.Connected) {
                try {
                    sock = this.mListenSock.accept();
                }
                catch (Exception e) {
                    if (this.mListenSock != null) {
                        try {
                            this.mListenSock.close();
                            this.mListenSock = null;
                        }
                        catch (IOException e1) {
                            ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e, (String)"ERROR. $ListenThread.cancel() - Failed to close listen bluetooth server socket", (Object[])new Object[0]);
                        }
                    }
                    ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e, (String)"ERROR. $ListenThread.run() - Failed to accept client socket", (Object[])new Object[0]);
                    break;
                }
                ATransportBluetooth.this.startReceiveThread(sock);
            }
            ATLog.i((String)ATransportBluetooth.this.TAG, (int)7, (String)"--- INFO. $ListenThread.run()");
        }

        public void cancel() {
            try {
                if (this.mListenSock != null) {
                    this.mListenSock.close();
                    this.mListenSock = null;
                }
            }
            catch (Exception e) {
                ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e, (String)"ERROR. $ListenThread.cancel() - Failed to close listen bluetooth server socket", (Object[])new Object[0]);
                return;
            }
            ATLog.i((String)ATransportBluetooth.this.TAG, (int)7, (String)"INFO. $ListenThread.cancel()");
        }
    }

    private class ReceiveThread
    extends Thread {
        private BluetoothSocket mSock = null;
        private InputStream mInput = null;
        private OutputStream mOutput = null;

        public ReceiveThread(BluetoothSocket sock) throws Exception {
            InputStream input = null;
            OutputStream output = null;
            try {
                input = sock.getInputStream();
                output = sock.getOutputStream();
            }
            catch (Exception e) {
                try {
                    sock.close();
                }
                catch (Exception e1) {
                    ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e1, (String)"ERROR $ReceiveThread.Constructor() - Failed to close bluetooth socket", (Object[])new Object[0]);
                    throw e1;
                }
                ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e, (String)"ERROR $ReceiveThread.Constructor() - Failed to get input/output stream", (Object[])new Object[0]);
                throw e;
            }
            this.mSock = sock;
            this.mInput = input;
            this.mOutput = output;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int recvBytes = 0;
            int queueSize = 0;
            boolean OFFSET = false;
            byte[] recvBuf = new byte[4096];
            ATLog.i((String)ATransportBluetooth.this.TAG, (int)7, (String)"+++ INFO. $ReceiveThread.run()");
            ATransportBluetooth.this.setState(ConnectState.Connected, null);
            while (true) {
                block23: {
                    try {
                        recvBytes = this.mInput.read(recvBuf);
                        if (!ATLog.isLogging((int)9)) break block23;
                        ATLog.i((String)ATransportBluetooth.this.TAG, (int)9, (String)"RECV. [%4d] [%s]", (Object[])new Object[]{recvBytes, Dump.dump((byte[])recvBuf, (int)recvBytes)});
                    }
                    catch (Exception e) {
                        block26: {
                            Closeable e12;
                            block25: {
                                block24: {
                                    try {
                                        if (this.mSock == null) break block24;
                                        BluetoothSocket bluetoothSocket = this.mSock;
                                        synchronized (bluetoothSocket) {
                                            this.mSock.close();
                                            this.mSock = null;
                                        }
                                    }
                                    catch (Exception e12) {
                                        ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e12, (String)"ERROR. $ReceiveThread.run() - Failed to close bluetooth socket", (Object[])new Object[0]);
                                    }
                                }
                                try {
                                    if (this.mInput == null) break block25;
                                    e12 = this.mInput;
                                    synchronized (e12) {
                                        this.mInput.close();
                                        this.mInput = null;
                                    }
                                }
                                catch (Exception e13) {
                                    ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e13, (String)"ERROR. $ReceiveThread.run() - Failed to close input stream", (Object[])new Object[0]);
                                }
                            }
                            try {
                                if (this.mOutput == null) break block26;
                                e12 = this.mOutput;
                                synchronized (e12) {
                                    this.mOutput.close();
                                    this.mOutput = null;
                                }
                            }
                            catch (Exception e14) {
                                ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e14, (String)"ERROR. $ReceiveThread.run() - Failed to close output stream", (Object[])new Object[0]);
                            }
                        }
                        ATransportBluetooth.this.mReceiveThread = null;
                        ATransportBluetooth.this.setState(ConnectState.Disconnected, null);
                        break;
                    }
                }
                try {
                    ByteQueue e = ATransportBluetooth.this.mQueue;
                    synchronized (e) {
                        queueSize = ATransportBluetooth.this.mQueue.enqueue(recvBuf, 0, recvBytes);
                        ATransportBluetooth.this.mQueue.notify();
                    }
                    ATransportBluetooth.this.checkBufferSize(queueSize);
                }
                catch (Exception e) {
                    ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e, (String)"ERROR. $ReceiveThread.run() - Failed to enqueue", (Object[])new Object[0]);
                }
            }
            ATLog.i((String)ATransportBluetooth.this.TAG, (int)7, (String)"--- INFO. $ReceiveThread.run()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            block20: {
                Closeable e2;
                block19: {
                    block18: {
                        try {
                            if (this.mSock == null) break block18;
                            BluetoothSocket bluetoothSocket = this.mSock;
                            synchronized (bluetoothSocket) {
                                this.mSock.close();
                                this.mSock = null;
                            }
                        }
                        catch (Exception e2) {
                            ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e2, (String)"ERROR. $ReceiveThread.cancel() - Failed to close bluetooth socket", (Object[])new Object[0]);
                        }
                    }
                    try {
                        if (this.mInput == null) break block19;
                        e2 = this.mInput;
                        synchronized (e2) {
                            this.mInput.close();
                            this.mInput = null;
                        }
                    }
                    catch (Exception e3) {
                        ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e3, (String)"ERROR. $ReceiveThread.cancel() - Failed to close input stream", (Object[])new Object[0]);
                    }
                }
                try {
                    if (this.mOutput == null) break block20;
                    e2 = this.mOutput;
                    synchronized (e2) {
                        this.mOutput.close();
                        this.mOutput = null;
                    }
                }
                catch (Exception e4) {
                    ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e4, (String)"ERROR. $ReceiveThread.cancel() - Failed to close output stream", (Object[])new Object[0]);
                }
            }
            if (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e, (String)"ERROR. $ReceiveThread.cancel() - Failed to wait terminate receive thread", (Object[])new Object[0]);
                }
            }
            ATLog.i((String)ATransportBluetooth.this.TAG, (int)7, (String)"INFO. $ReceiveThread.cancel()");
        }

        public int write(byte[] data, int offset, int length) {
            if (data == null) {
                ATLog.e((String)ATransportBluetooth.this.TAG, (String)"ERROR. write() - Data is null");
                return 0;
            }
            if (this.mOutput == null) {
                ATLog.e((String)ATransportBluetooth.this.TAG, (String)"ERROR. write(%s, %d, %d) - Failed to initialize the bluetooth", (Object[])new Object[]{Dump.dump((byte[])data, (int)offset, (int)length), offset, length});
                return -1;
            }
            try {
                this.mOutput.write(data, offset, length);
            }
            catch (IOException e) {
                ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e, (String)"ERROR. write(%s, %d, %d) - Failed to write data", (Object[])new Object[]{Dump.dump((byte[])data, (int)offset, (int)length), offset, length});
                return -2;
            }
            if (ATLog.isLogging((int)9)) {
                ATLog.i((String)ATransportBluetooth.this.TAG, (int)9, (String)"SEND.[%s<%s>] [%4d] [%s]", (Object[])new Object[]{ATransportBluetooth.this.getDeviceType(), ATransportBluetooth.this.getAddress(), length, Dump.dump((byte[])data, (int)offset, (int)length)});
            }
            return length;
        }

        public int write(byte[] data, int offset, int length, int timeout) {
            if (data == null) {
                ATLog.e((String)ATransportBluetooth.this.TAG, (String)"ERROR. write() - Data is null");
                return 0;
            }
            if (this.mOutput == null) {
                ATLog.e((String)ATransportBluetooth.this.TAG, (String)"ERROR. write(%s, %d, %d, %d) - Failed to initialize the bluetooth", (Object[])new Object[]{Dump.dump((byte[])data, (int)offset, (int)length), offset, length, timeout});
                return -1;
            }
            try {
                this.mOutput.write(data, offset, length);
            }
            catch (IOException e) {
                ATLog.e((String)ATransportBluetooth.this.TAG, (Throwable)e, (String)"ERROR. write(%s, %d, %d, %d) - Failed to write data", (Object[])new Object[]{Dump.dump((byte[])data, (int)offset, (int)length), offset, length, timeout});
                return -2;
            }
            if (ATLog.isLogging((int)9)) {
                ATLog.i((String)ATransportBluetooth.this.TAG, (int)9, (String)"SEND.[%s<%s>] [%4d] [%s]", (Object[])new Object[]{ATransportBluetooth.this.getDeviceType(), ATransportBluetooth.this.getAddress(), length, Dump.dump((byte[])data, (int)offset, (int)length)});
            }
            return length;
        }
    }
}

