/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.transport.usbserial;

import android.util.Pair;
import com.atid.lib.transport.usbserial.UsbSerialDriver;
import com.atid.lib.util.diagnotics.ATLog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProbeTable {
    private static final String TAG = ProbeTable.class.getSimpleName();
    private final Map<Pair<Integer, Integer>, Class<? extends UsbSerialDriver>> mProbeTable = new LinkedHashMap<Pair<Integer, Integer>, Class<? extends UsbSerialDriver>>();

    public ProbeTable addProduct(int vendorId, int productId, Class<? extends UsbSerialDriver> driverClass) {
        this.mProbeTable.put((Pair<Integer, Integer>)Pair.create((Object)vendorId, (Object)productId), driverClass);
        return this;
    }

    ProbeTable addDriver(Class<? extends UsbSerialDriver> driverClass) throws Exception {
        Map devices;
        Method method;
        try {
            method = driverClass.getMethod("getSupportedDevices", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            ATLog.e((String)TAG, (String)"ERROR. addDriver() - No Such Method Exception");
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            ATLog.e((String)TAG, (String)"ERROR. addDriver() - Security Exception");
            throw new RuntimeException(e);
        }
        try {
            devices = (Map)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            ATLog.e((String)TAG, (String)"ERROR. addDriver() - Illegal Access Exception");
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            ATLog.e((String)TAG, (String)"ERROR. addDriver() - Illegal Argument Exception");
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            ATLog.e((String)TAG, (String)"ERROR. addDriver() - Invocation Target Exception");
            throw new RuntimeException(e);
        }
        for (Map.Entry entry : devices.entrySet()) {
            int vendorId = (Integer)entry.getKey();
            int[] nArray = (int[])entry.getValue();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int productId = nArray[n2];
                this.addProduct(vendorId, productId, driverClass);
                ++n2;
            }
        }
        return this;
    }

    public Class<? extends UsbSerialDriver> findDriver(int vendorId, int productId) throws NullPointerException {
        Pair pair = Pair.create((Object)vendorId, (Object)productId);
        return this.mProbeTable.get(pair);
    }
}

