/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.rfid.uhf;

import com.atid.lib.device.IReader;
import com.atid.lib.diagnostics.ATException;
import com.atid.lib.module.rfid.uhf.event.ATRfidUhfEventManager;
import com.atid.lib.module.rfid.uhf.event.IATRfidUhfEventListener;
import com.atid.lib.module.rfid.uhf.module.ATModuleRfidUhf;
import com.atid.lib.module.rfid.uhf.params.EpcMaskParam;
import com.atid.lib.module.rfid.uhf.params.FreqTableList;
import com.atid.lib.module.rfid.uhf.params.Lock6bParam;
import com.atid.lib.module.rfid.uhf.params.Lock6cParam;
import com.atid.lib.module.rfid.uhf.params.Mask6cPattern;
import com.atid.lib.module.rfid.uhf.params.PermaLock6cParam;
import com.atid.lib.module.rfid.uhf.params.PowerRange;
import com.atid.lib.module.rfid.uhf.params.SelectMask6cParam;
import com.atid.lib.module.rfid.uhf.types.AlgorithmType;
import com.atid.lib.module.rfid.uhf.types.BankType;
import com.atid.lib.module.rfid.uhf.types.GlobalBandType;
import com.atid.lib.module.rfid.uhf.types.Mask6cAction;
import com.atid.lib.module.rfid.uhf.types.Mask6cTarget;
import com.atid.lib.module.rfid.uhf.types.SelectFlag;
import com.atid.lib.module.rfid.uhf.types.SessionFlag;
import com.atid.lib.module.rfid.uhf.types.SessionTarget;
import com.atid.lib.types.ModuleRfidUhfType;
import com.atid.lib.types.ResultCode;

public abstract class ATRfidUhf {
    protected static final int INFO = 6;
    protected String TAG = ATRfidUhf.class.getSimpleName();
    protected ATModuleRfidUhf mModule = null;
    protected IReader mReader;
    protected ATRfidUhfEventManager mListeners;

    public ATRfidUhf(IReader reader) {
        this.mReader = reader;
        this.mListeners = new ATRfidUhfEventManager();
    }

    public void destroy() {
        if (this.mListeners != null) {
            this.mListeners.destroy();
        }
    }

    public ModuleRfidUhfType getType() {
        return this.mModule == null ? ModuleRfidUhfType.None : this.mModule.getType();
    }

    public void addListener(IATRfidUhfEventListener listener) {
        this.mListeners.addListener(listener);
    }

    public void removeListener(IATRfidUhfEventListener listener) {
        this.mListeners.removeListener(listener);
    }

    public void clearListener() {
        this.mListeners.clear();
    }

    public abstract boolean initMoudle();

    public abstract ResultCode inventory6c();

    public abstract ResultCode inventory6b();

    public abstract ResultCode readMemory6c(BankType var1, int var2, int var3, String var4);

    public abstract ResultCode readMemory6b(int var1, int var2, String var3);

    public abstract ResultCode writeMemory6c(BankType var1, int var2, String var3, String var4);

    public abstract ResultCode writememory6b(int var1, String var2, String var3);

    public abstract ResultCode lock6c(Lock6cParam var1, String var2);

    public abstract ResultCode permaLock6c(PermaLock6cParam var1, String var2);

    public abstract ResultCode lock6b(Lock6bParam var1, String var2);

    public abstract ResultCode kill6c(String var1);

    public abstract ResultCode stop();

    public abstract String getVersion() throws ATException;

    public abstract PowerRange getPowerRange() throws ATException;

    public abstract int getPower() throws ATException;

    public abstract void setPower(int var1) throws ATException;

    public abstract boolean getContinuousMode() throws ATException;

    public abstract void setContinuousMode(boolean var1) throws ATException;

    public abstract String getAccessPassword() throws ATException;

    public abstract void setAccessPassword(String var1) throws ATException;

    public abstract GlobalBandType getGlobalBand() throws ATException;

    public abstract void setGlobalBand(GlobalBandType var1) throws ATException;

    public abstract boolean getReportRssi() throws ATException;

    public abstract void setReportRssi(boolean var1) throws ATException;

    public abstract int getOperationTime() throws ATException;

    public abstract void setOperationTime(int var1) throws ATException;

    public abstract int getInventoryTime() throws ATException;

    public abstract void setInventoryTime(int var1) throws ATException;

    public abstract int getIdleTime() throws ATException;

    public abstract void setIdleTime(int var1) throws ATException;

    public abstract int getLimitTagCount() throws ATException;

    public abstract void setLimitTagCount(int var1) throws ATException;

    public abstract int getSameTagReportTime() throws ATException;

    public abstract void setSameTagReportTime(int var1) throws ATException;

    public abstract boolean getReportMode() throws ATException;

    public abstract void setReportMode(boolean var1) throws ATException;

    public abstract int getReadTidLength() throws ATException;

    public abstract void setReadTidLength(int var1) throws ATException;

    public abstract AlgorithmType getAlgorithmType() throws ATException;

    public abstract void setAlgorithmType(AlgorithmType var1) throws ATException;

    public abstract int getStartQ() throws ATException;

    public abstract void setStartQ(int var1) throws ATException;

    public abstract int getMinQ() throws ATException;

    public abstract void setMinQ(int var1) throws ATException;

    public abstract int getMaxQ() throws ATException;

    public abstract void setMaxQ(int var1) throws ATException;

    public abstract FreqTableList getFreqTable() throws ATException;

    public abstract void setFreqTable(FreqTableList var1) throws ATException;

    public abstract SelectFlag getSelectFlag() throws ATException;

    public abstract void setSelectFlag(SelectFlag var1) throws ATException;

    public abstract SessionFlag getSessionFlag() throws ATException;

    public abstract void setSessionFlag(SessionFlag var1) throws ATException;

    public abstract SessionTarget getSessionTarget() throws ATException;

    public abstract void setSessionTarget(SessionTarget var1) throws ATException;

    public abstract boolean getSelectMask6cEnabled(int var1) throws ATException;

    public abstract void setSelectMask6cEnabled(int var1, boolean var2) throws ATException;

    public abstract Mask6cTarget getSelectMask6cTarget(int var1) throws ATException;

    public abstract void setSelectMask6cTarget(int var1, Mask6cTarget var2) throws ATException;

    public abstract Mask6cAction getSelectMask6cAction(int var1) throws ATException;

    public abstract void setSelectMask6cAction(int var1, Mask6cAction var2) throws ATException;

    public abstract BankType getSelectMask6cBank(int var1) throws ATException;

    public abstract void setSelectMask6cBank(int var1, BankType var2) throws ATException;

    public abstract int getSelectMask6cOffset(int var1) throws ATException;

    public abstract void setSelectMask6cOffset(int var1, int var2) throws ATException;

    public abstract Mask6cPattern getSelectMask6cPattern(int var1) throws ATException;

    public abstract void setSelectMask6cPattern(int var1, Mask6cPattern var2) throws ATException;

    public abstract void setSelectMask6c(int var1, SelectMask6cParam var2) throws ATException;

    public abstract SelectMask6cParam getSelectMask6c(int var1) throws ATException;

    public abstract int getEpcMaskCount() throws ATException;

    public abstract boolean getEpcMaskMatchMode() throws ATException;

    public abstract void setEpcMaskMatchMode(boolean var1) throws ATException;

    public abstract void clearEpcMask() throws ATException;

    public abstract void addEpcMask(EpcMaskParam var1) throws ATException;

    public abstract EpcMaskParam getEpcMask(int var1) throws ATException;

    public abstract int getCurrentLinkProfile() throws ATException;

    public abstract void setCurrentLinkProfile(int var1) throws ATException;

    public abstract int getDefaultLinkProfile() throws ATException;

    public abstract void setDefaultLinkProfile(int var1) throws ATException;

    public void PumpEvent(int event, byte[] data) {
        if (this.mModule == null) {
            return;
        }
        this.mModule.PumpEvent(event, data);
    }
}

