/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.util;

import android.content.Context;
import android.content.pm.PackageManager;
import com.atid.lib.util.diagnotics.ATLog;

public class SysUtil {
    private static final String TAG = SysUtil.class.getSimpleName();
    private static Context mContext;

    public static void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            ATLog.e(TAG, e, "ERROR. sleep(%d) - Failed to sleep thread", new Object[0]);
        }
    }

    public static String getVersion(Context context) {
        String packageName = context.getPackageName();
        String versionName = "";
        try {
            versionName = context.getPackageManager().getPackageInfo((String)packageName, (int)128).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            ATLog.e(TAG, e, "ERROR. getVersion() - Failed to get package version", new Object[0]);
            versionName = "";
        }
        return versionName;
    }

    public static String getAppName(Context context) {
        String packageName = context.getPackageName();
        String appName = "";
        try {
            PackageManager packageManager = context.getPackageManager();
            appName = (String)packageManager.getApplicationLabel(packageManager.getApplicationInfo(packageName, 8192));
        }
        catch (PackageManager.NameNotFoundException e) {
            ATLog.e(TAG, e, "ERROR. getAppName() - Failed to get application name", new Object[0]);
            appName = "";
        }
        return appName;
    }

    public static synchronized void setContext(Context context) {
        mContext = context;
    }

    public static synchronized Context getContext() {
        return mContext;
    }
}

