/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.barcode.ssi;

import com.atid.lib.device.IReader;
import com.atid.lib.diagnostics.ATException;
import com.atid.lib.module.barcode.ATBarcode;
import com.atid.lib.module.barcode.module.ATModuleBarcode;
import com.atid.lib.module.barcode.params.SymbolStateList;
import com.atid.lib.module.barcode.types.BarcodePostType;
import com.atid.lib.module.barcode.types.BarcodeType;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.diagnotics.ATLog;
import com.atid.lib.util.diagnotics.Dump;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ATBarcodeSsi
extends ATBarcode
implements ATModuleBarcode.IModuleBarcodeEventListener {
    public ATBarcodeSsi(IReader reader) {
        super(reader);
        this.TAG = ATBarcodeSsi.class.getSimpleName();
    }

    @Override
    public boolean initMoudle() {
        try {
            this.mModule.setBarcodeParam(new byte[]{45, 2, 94, 1, -15, -4, 1});
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. initReader() - Failed to set barcode param init SSI code", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() throws ATException {
        String version = "";
        this.assertAction();
        ATModuleBarcode aTModuleBarcode = this.mModule;
        synchronized (aTModuleBarcode) {
            try {
                version = this.mModule.getVersion();
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getVersion() - Failed to get barcode version [%s]", (Object[])new Object[]{this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getVersion() - [%s]", (Object[])new Object[]{version});
        return version;
    }

    @Override
    public boolean isSuportSelPost() {
        return false;
    }

    @Override
    public BarcodePostType getSymbolPostState() throws ATException {
        ATLog.e((String)this.TAG, (String)"ERROR. getSymbolPostState() - Failed to not supported method");
        throw new ATException(ResultCode.NotSupported);
    }

    @Override
    public void setSymbolPostState(BarcodePostType post) throws ATException {
        ATLog.e((String)this.TAG, (String)"ERROR. setSymbolPostState(%s) - Failed to not supported method", (Object[])new Object[]{post});
        throw new ATException(ResultCode.NotSupported);
    }

    protected boolean getBytes(BarcodeType type, OutputStream writer) {
        try {
            switch (type) {
                case UPCA: {
                    writer.write(new byte[]{1});
                    break;
                }
                case UPCE: {
                    writer.write(new byte[]{2});
                    break;
                }
                case UPCE1: {
                    writer.write(new byte[]{12});
                    break;
                }
                case EAN8: {
                    writer.write(new byte[]{4});
                    break;
                }
                case EAN13: {
                    writer.write(new byte[]{3});
                    break;
                }
                case Bookland: {
                    writer.write(new byte[]{83});
                    break;
                }
                case CouponCode: {
                    writer.write(new byte[]{85});
                    break;
                }
                case ISSN: {
                    writer.write(new byte[]{-15, 105});
                    break;
                }
                case Code128: {
                    writer.write(new byte[]{8});
                    break;
                }
                case GS1_128: {
                    writer.write(new byte[]{14});
                    break;
                }
                case ISBT_128: {
                    writer.write(new byte[]{84});
                    break;
                }
                case Code39: {
                    writer.write(new byte[1]);
                    break;
                }
                case Trioptic: {
                    writer.write(new byte[]{13});
                    break;
                }
                case Code32: {
                    writer.write(new byte[]{86});
                    break;
                }
                case Code93: {
                    writer.write(new byte[]{9});
                    break;
                }
                case Code11: {
                    writer.write(new byte[]{10});
                    break;
                }
                case I2of5: {
                    writer.write(new byte[]{6});
                    break;
                }
                case D2of5: {
                    writer.write(new byte[]{5});
                    break;
                }
                case Codabar: {
                    writer.write(new byte[]{7});
                    break;
                }
                case MSI: {
                    writer.write(new byte[]{11});
                    break;
                }
                case ChinaPost: {
                    writer.write(new byte[]{-16, -104});
                    break;
                }
                case M2of5: {
                    writer.write(new byte[]{-15, 106});
                    break;
                }
                case KoreaPost: {
                    writer.write(new byte[]{-15, 69});
                    break;
                }
                case GS1_14: {
                    writer.write(new byte[]{-16, 82});
                    break;
                }
                case GS1_Limited: {
                    writer.write(new byte[]{-16, 83});
                    break;
                }
                case GS1_Expanded: {
                    writer.write(new byte[]{-16, 84});
                    break;
                }
                case Composite_CCC: {
                    writer.write(new byte[]{-16, 85});
                    break;
                }
                case Composite_CCAB: {
                    writer.write(new byte[]{-16, 86});
                    break;
                }
                case TLC39: {
                    writer.write(new byte[]{-16, 115});
                    break;
                }
                case Postnet_US: {
                    writer.write(new byte[]{89});
                    break;
                }
                case Planet_US: {
                    writer.write(new byte[]{90});
                    break;
                }
                case Postal_UK: {
                    writer.write(new byte[]{91});
                    break;
                }
                case Postal_Japan: {
                    writer.write(new byte[]{-16, 34});
                    break;
                }
                case Postal_Australia: {
                    writer.write(new byte[]{-16, 35});
                    break;
                }
                case KixPost: {
                    writer.write(new byte[]{-16, 70});
                    break;
                }
                case USPS_One_IntelMail: {
                    writer.write(new byte[]{-15, 80});
                    break;
                }
                case UPUFICSPostal: {
                    writer.write(new byte[]{-15, 99});
                    break;
                }
                case PDF417: {
                    writer.write(new byte[]{15});
                    break;
                }
                case MicroPDF: {
                    writer.write(new byte[]{-29});
                    break;
                }
                case DataMatrix: {
                    writer.write(new byte[]{-16, 36});
                    break;
                }
                case Maxicode: {
                    writer.write(new byte[]{-16, 38});
                    break;
                }
                case QRCode: {
                    writer.write(new byte[]{-16, 37});
                    break;
                }
                case MicroQRCode: {
                    writer.write(new byte[]{-15, 61});
                    break;
                }
                case AztecCode: {
                    writer.write(new byte[]{-15, 62});
                    break;
                }
                case HanXin: {
                    writer.write(new byte[]{-8, 4, -113});
                    break;
                }
            }
        }
        catch (IOException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getBytes([%s]) - Failed to convert barcode type to byte array", (Object[])new Object[]{type});
            return false;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getBytes([%s])", (Object[])new Object[]{type});
        return true;
    }

    protected BarcodeType getBarcodeType(InputStream reader) {
        BarcodeType type = BarcodeType.Unknown;
        try {
            block1 : switch (reader.read()) {
                case 0: {
                    type = BarcodeType.Code39;
                    break;
                }
                case 1: {
                    type = BarcodeType.UPCA;
                    break;
                }
                case 2: {
                    type = BarcodeType.UPCE;
                    break;
                }
                case 3: {
                    type = BarcodeType.EAN13;
                    break;
                }
                case 4: {
                    type = BarcodeType.EAN8;
                    break;
                }
                case 5: {
                    type = BarcodeType.D2of5;
                    break;
                }
                case 6: {
                    type = BarcodeType.I2of5;
                    break;
                }
                case 7: {
                    type = BarcodeType.Codabar;
                    break;
                }
                case 8: {
                    type = BarcodeType.Code128;
                    break;
                }
                case 9: {
                    type = BarcodeType.Code93;
                    break;
                }
                case 10: {
                    type = BarcodeType.Code11;
                    break;
                }
                case 11: {
                    type = BarcodeType.MSI;
                    break;
                }
                case 12: {
                    type = BarcodeType.UPCE1;
                    break;
                }
                case 13: {
                    type = BarcodeType.Trioptic;
                    break;
                }
                case 14: {
                    type = BarcodeType.GS1_128;
                    break;
                }
                case 15: {
                    type = BarcodeType.PDF417;
                    break;
                }
                case 83: {
                    type = BarcodeType.Bookland;
                    break;
                }
                case 84: {
                    type = BarcodeType.ISBT_128;
                    break;
                }
                case 85: {
                    type = BarcodeType.CouponCode;
                    break;
                }
                case 86: {
                    type = BarcodeType.Code32;
                    break;
                }
                case 89: {
                    type = BarcodeType.Postnet_US;
                    break;
                }
                case 90: {
                    type = BarcodeType.Planet_US;
                    break;
                }
                case 91: {
                    type = BarcodeType.Postal_UK;
                    break;
                }
                case 227: {
                    type = BarcodeType.MicroPDF;
                    break;
                }
                case 240: {
                    switch (reader.read()) {
                        case 34: {
                            type = BarcodeType.Postal_Japan;
                            break block1;
                        }
                        case 35: {
                            type = BarcodeType.Postal_Australia;
                            break block1;
                        }
                        case 36: {
                            type = BarcodeType.DataMatrix;
                            break block1;
                        }
                        case 37: {
                            type = BarcodeType.QRCode;
                            break block1;
                        }
                        case 38: {
                            type = BarcodeType.Maxicode;
                            break block1;
                        }
                        case 70: {
                            type = BarcodeType.KixPost;
                            break block1;
                        }
                        case 82: {
                            type = BarcodeType.GS1_14;
                            break block1;
                        }
                        case 83: {
                            type = BarcodeType.GS1_Limited;
                            break block1;
                        }
                        case 84: {
                            type = BarcodeType.GS1_Expanded;
                            break block1;
                        }
                        case 85: {
                            type = BarcodeType.Composite_CCC;
                            break block1;
                        }
                        case 86: {
                            type = BarcodeType.Composite_CCAB;
                            break block1;
                        }
                        case 115: {
                            type = BarcodeType.TLC39;
                            break block1;
                        }
                        case 152: {
                            type = BarcodeType.ChinaPost;
                        }
                    }
                    break;
                }
                case 241: {
                    switch (reader.read()) {
                        case 61: {
                            type = BarcodeType.MicroQRCode;
                            break block1;
                        }
                        case 62: {
                            type = BarcodeType.AztecCode;
                            break block1;
                        }
                        case 69: {
                            type = BarcodeType.KoreaPost;
                            break block1;
                        }
                        case 80: {
                            type = BarcodeType.USPS_One_IntelMail;
                            break block1;
                        }
                        case 99: {
                            type = BarcodeType.UPUFICSPostal;
                            break block1;
                        }
                        case 105: {
                            type = BarcodeType.ISSN;
                            break block1;
                        }
                        case 106: {
                            type = BarcodeType.M2of5;
                        }
                    }
                    break;
                }
                case 248: {
                    switch (reader.read()) {
                        case 4: {
                            switch (reader.read()) {
                                case 143: {
                                    type = BarcodeType.HanXin;
                                }
                            }
                        }
                    }
                    break;
                }
            }
        }
        catch (IOException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getBarcodeType() - Failed to convert byte array to barcode type", (Object[])new Object[0]);
            return BarcodeType.Unknown;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getBarcodeType() - [%s]", (Object[])new Object[]{type.toString()});
        return type;
    }

    protected BarcodeType getBarcodeType(byte type) {
        switch (type) {
            case 1: {
                return BarcodeType.Code39;
            }
            case 2: {
                return BarcodeType.Codabar;
            }
            case 3: {
                return BarcodeType.Code128;
            }
            case 4: {
                return BarcodeType.D2of5;
            }
            case 5: {
                return BarcodeType.IATA;
            }
            case 6: {
                return BarcodeType.ITF;
            }
            case 7: {
                return BarcodeType.Code93;
            }
            case 8: {
                return BarcodeType.UPCA;
            }
            case 10: {
                return BarcodeType.EAN8;
            }
            case 11: {
                return BarcodeType.EAN13;
            }
            case 12: {
                return BarcodeType.Code11;
            }
            case 13: {
                return BarcodeType.Code49;
            }
            case 14: {
                return BarcodeType.MSI;
            }
            case 15: {
                return BarcodeType.GS1_128;
            }
            case 16: {
                return BarcodeType.UPCE1;
            }
            case 17: {
                return BarcodeType.PDF417;
            }
            case 18: {
                return BarcodeType.Code16K;
            }
            case 19: {
                return BarcodeType.Code39FullASCII;
            }
            case 9: {
                return BarcodeType.UPCE;
            }
            case 21: {
                return BarcodeType.Trioptic;
            }
            case 22: {
                return BarcodeType.Bookland;
            }
            case 23: {
                return BarcodeType.CouponCode;
            }
            case 24: {
                return BarcodeType.NW7;
            }
            case 25: {
                return BarcodeType.ISBT_128;
            }
            case 26: {
                return BarcodeType.MicroPDF;
            }
            case 27: {
                return BarcodeType.DataMatrix;
            }
            case 28: {
                return BarcodeType.QRCode;
            }
            case 29: {
                return BarcodeType.MicroPDF_CCA;
            }
            case 30: {
                return BarcodeType.Postnet_US;
            }
            case 31: {
                return BarcodeType.Planet_US;
            }
            case 32: {
                return BarcodeType.Code32;
            }
            case 33: {
                return BarcodeType.ISBT_128Concat;
            }
            case 34: {
                return BarcodeType.Postal_Japan;
            }
            case 35: {
                return BarcodeType.Postal_Australia;
            }
            case 36: {
                return BarcodeType.Postal_Dutch;
            }
            case 37: {
                return BarcodeType.Maxicode;
            }
            case 38: {
                return BarcodeType.Postbar_CA;
            }
            case 39: {
                return BarcodeType.Postal_UK;
            }
            case 40: {
                return BarcodeType.MacroPDF417;
            }
            case 41: {
                return BarcodeType.MacroQRCode;
            }
            case 44: {
                return BarcodeType.MicroQRCode;
            }
            case 45: {
                return BarcodeType.AztecCode;
            }
            case 46: {
                return BarcodeType.AztecRuneCode;
            }
            case 47: {
                return BarcodeType.FrenchLottery;
            }
            case 48: {
                return BarcodeType.GS1_14;
            }
            case 49: {
                return BarcodeType.GS1_Limited;
            }
            case 50: {
                return BarcodeType.GS1_Expanded;
            }
            case 51: {
                return BarcodeType.FNC3;
            }
            case 52: {
                return BarcodeType.StateUS;
            }
            case 53: {
                return BarcodeType.StateUS4;
            }
            case 54: {
                return BarcodeType.ISSN;
            }
            case 55: {
                return BarcodeType.ScanletWebcode;
            }
            case 56: {
                return BarcodeType.CueCATCode;
            }
            case 57: {
                return BarcodeType.M2of5;
            }
            case 72: {
                return BarcodeType.UPCA_2;
            }
            case 73: {
                return BarcodeType.UPCE_2;
            }
            case 74: {
                return BarcodeType.EAN8_2;
            }
            case 75: {
                return BarcodeType.EAN13_2;
            }
            case 80: {
                return BarcodeType.UPCE1_2;
            }
            case 81: {
                return BarcodeType.Composite_CCA_GS1128;
            }
            case 82: {
                return BarcodeType.Composite_CCA_EAN13;
            }
            case 83: {
                return BarcodeType.Composite_CCA_EAN8;
            }
            case 84: {
                return BarcodeType.Composite_CCA_GS1Expanded;
            }
            case 85: {
                return BarcodeType.Composite_CCA_GS1Limited;
            }
            case 86: {
                return BarcodeType.Composite_CCA_GS1;
            }
            case 87: {
                return BarcodeType.Composite_CCA_UPCA;
            }
            case 88: {
                return BarcodeType.Composite_CCA_UPCE;
            }
            case 89: {
                return BarcodeType.Composite_CCC_GS1128;
            }
            case 90: {
                return BarcodeType.TLC39;
            }
            case 97: {
                return BarcodeType.Composite_CCB_GS1128;
            }
            case 98: {
                return BarcodeType.Composite_CCB_EAN13;
            }
            case 99: {
                return BarcodeType.Composite_CCB_EAN8;
            }
            case 100: {
                return BarcodeType.Composite_CCB_GS1Expanded;
            }
            case 101: {
                return BarcodeType.Composite_CCB_GS1Limited;
            }
            case 102: {
                return BarcodeType.Composite_CCB_GS1;
            }
            case 103: {
                return BarcodeType.Composite_CCB_UPCA;
            }
            case 104: {
                return BarcodeType.Composite_CCB_UPCE;
            }
            case 105: {
                return BarcodeType.Signature;
            }
            case 114: {
                return BarcodeType.ChinaPost;
            }
            case 115: {
                return BarcodeType.KoreaPost;
            }
            case -120: {
                return BarcodeType.UPCA_5;
            }
            case -119: {
                return BarcodeType.UPCE_5;
            }
            case -118: {
                return BarcodeType.EAN8_5;
            }
            case -117: {
                return BarcodeType.EAN13_5;
            }
            case -112: {
                return BarcodeType.UPCE1_5;
            }
            case -103: {
                return BarcodeType.MultipacketFormat;
            }
            case -102: {
                return BarcodeType.MacroMicroPDF;
            }
            case -96: {
                return BarcodeType.OCRB;
            }
            case -76: {
                return BarcodeType.RSS_ExpandedCoupon;
            }
            case -73: {
                return BarcodeType.HanXin;
            }
            case -63: {
                return BarcodeType.GS1_Datamatrix;
            }
            case -62: {
                return BarcodeType.GS1_QR;
            }
            case -32: {
                return BarcodeType.RFIDRaw;
            }
            case -31: {
                return BarcodeType.RFIDURI;
            }
        }
        return BarcodeType.NoRead;
    }

    @Override
    protected byte[] getBytes(BarcodeType[] names, int start, int end) {
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        int i = start;
        while (i < end) {
            if (!this.getBytes(names[i], writer)) {
                ATLog.e((String)this.TAG, (String)"ERROR. getBytes(%d, %d, %d) - Failed to convert barcode type [%s, %d]", (Object[])new Object[]{names.length, start, end, names[i], i});
                return null;
            }
            ++i;
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getBytes(%d, %d, %d) - Failed to flush barcode type", (Object[])new Object[]{names.length, start, end});
            return null;
        }
        try {
            writer.close();
        }
        catch (IOException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getBytes(%d, %d, %d) - Failed to close barcode type", (Object[])new Object[]{names.length, start, end});
            return null;
        }
        byte[] data = writer.toByteArray();
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. getBytes(%d, %d, %d) - [%s]", (Object[])new Object[]{names.length, start, end, Dump.dump((byte[])data)});
        }
        return data;
    }

    @Override
    protected byte[] getBytes(BarcodeType[] names, boolean[] enabled, int start, int end) {
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        int i = start;
        while (i < end) {
            if (!this.getBytes(names[i], writer)) {
                ATLog.e((String)this.TAG, (String)"ERROR. getBytes(%d, %d, %d) - Failed to convert barcode type [%s, %d]", (Object[])new Object[]{names.length, start, end, names[i], i});
                return null;
            }
            writer.write(enabled[i] ? 1 : 0);
            ++i;
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getBytes(%d, %d, %d) - Failed to flush barcode type", (Object[])new Object[]{names.length, start, end});
            return null;
        }
        try {
            writer.close();
        }
        catch (IOException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getBytes(%d, %d, %d) - Failed to close barcode type", (Object[])new Object[]{names.length, start, end});
            return null;
        }
        byte[] data = writer.toByteArray();
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. getBytes(%d, %d, %d) - [%s]", (Object[])new Object[]{names.length, start, end, Dump.dump((byte[])data)});
        }
        return data;
    }

    @Override
    protected byte[] getBytes(BarcodeType[] names, boolean enabled, int start, int end) {
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        int i = start;
        while (i < end) {
            if (!this.getBytes(names[i], writer)) {
                ATLog.e((String)this.TAG, (String)"ERROR. getBytes(%d, %d, %d) - Failed to convert barcode type [%s, %d]", (Object[])new Object[]{names.length, start, end, names[i], i});
                return null;
            }
            writer.write(enabled ? 1 : 0);
            ++i;
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getBytes(%d, %d, %d) - Failed to flush barcode type", (Object[])new Object[]{names.length, start, end});
            return null;
        }
        try {
            writer.close();
        }
        catch (IOException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getBytes(%d, %d, %d) - Failed to close barcode type", (Object[])new Object[]{names.length, start, end});
            return null;
        }
        byte[] data = writer.toByteArray();
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. getBytes(%d, %d, %d) - [%s]", (Object[])new Object[]{names.length, start, end, Dump.dump((byte[])data)});
        }
        return data;
    }

    @Override
    protected byte[] getBytes(SymbolStateList list, int start, int end) {
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        int i = start;
        while (i < end) {
            if (!this.getBytes(list.getType(i), writer)) {
                ATLog.e((String)this.TAG, (String)"ERROR. getBytes(%d, %d, %d) - Failed to convert symbol state list [%s, %d]", (Object[])new Object[]{list.getCount(), start, end, list.getType(i), i});
                return null;
            }
            writer.write(list.getUsed(i) ? 1 : 0);
            ++i;
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getBytes(%d, %d, %d) - Failed to flush symbol state list", (Object[])new Object[]{list.getCount(), start, end});
            return null;
        }
        try {
            writer.close();
        }
        catch (IOException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getBytes(%d, %d, %d) - Failed to close symbol state list", (Object[])new Object[]{list.getCount(), start, end});
            return null;
        }
        byte[] data = writer.toByteArray();
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. getBytes(%d, %d, %d) - [%s]", (Object[])new Object[]{list.getCount(), start, end, Dump.dump((byte[])data)});
        }
        return data;
    }

    @Override
    protected SymbolStateList getSymbolState(byte[] data) {
        SymbolStateList list = new SymbolStateList();
        ByteArrayInputStream reader = new ByteArrayInputStream(data);
        while (reader.available() > 0) {
            BarcodeType type = this.getBarcodeType(reader);
            if (type == BarcodeType.Unknown || type == BarcodeType.NoRead) continue;
            list.add(type, reader.read() > 0);
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSymbolState([%s]) - Failed to close symbol state list", (Object[])new Object[]{Dump.dump((byte[])data)});
            return list;
        }
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSymbolState([%s]) - [%d]", (Object[])new Object[]{Dump.dump((byte[])data), list.getCount()});
        }
        return list;
    }

    @Override
    public void onReadBarcode(int code, String data, Object params) {
        BarcodeType type = this.getBarcodeType((byte)code);
        String codeId = "";
        String barcode = "";
        switch (type) {
            case StateUS: 
            case StateUS4: 
            case DataMatrix: 
            case GS1_Datamatrix: 
            case GS1_QR: 
            case HanXin: 
            case Maxicode: 
            case MicroQRCode: 
            case Planet_US: 
            case Postal_Australia: 
            case Postal_Dutch: 
            case Postal_Japan: 
            case Postal_UK: 
            case Postbar_CA: 
            case Postnet_US: 
            case QRCode: 
            case Signature: {
                codeId = data.substring(0, 3);
                barcode = data.substring(3);
                break;
            }
            case MultipacketFormat: 
            case FNC3: {
                codeId = "";
                barcode = data;
                break;
            }
            default: {
                codeId = data.substring(0, 1);
                barcode = data.substring(1);
            }
        }
        this.mListeners.generateBarcodeReadData(this, type, codeId, barcode, null);
        if (ATLog.isLogging((int)6)) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. onReadBarcode(%02X, [%s])", (Object[])new Object[]{code, data});
        }
    }
}

