/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.barcode.ssi.param;

import com.atid.lib.diagnostics.ATException;
import com.atid.lib.module.barcode.ssi.param.SSI1DParamName;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.diagnotics.ATLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class SSI1DParamNameList {
    private static final String TAG = SSI1DParamNameList.class.getSimpleName();
    private ArrayList<SSI1DParamName> mList = new ArrayList();

    public SSI1DParamNameList() {
    }

    public SSI1DParamNameList(SSI1DParamName item) {
        this.add(item);
    }

    public SSI1DParamNameList(SSI1DParamName[] items) {
        this.add(items);
    }

    public synchronized int getCount() {
        return this.mList.size();
    }

    public synchronized boolean add(SSI1DParamName item) {
        if (item == null) {
            ATLog.e((String)TAG, (String)"ERROR. add(item) - Invalid parameter");
            return false;
        }
        return this.mList.add(item);
    }

    public synchronized boolean add(SSI1DParamName[] items) {
        boolean result = true;
        if (items == null) {
            ATLog.e((String)TAG, (String)"ERROR. add(item) - Invalid parameter");
            return false;
        }
        SSI1DParamName[] sSI1DParamNameArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            SSI1DParamName item = sSI1DParamNameArray[n2];
            result &= this.mList.add(item);
            ++n2;
        }
        return result;
    }

    public byte[] getBytes(int engine) throws ATException {
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        if (this.mList == null || this.mList.size() == 0) {
            ATLog.e((String)TAG, (String)"ERROR. Parameter is null or zero !!!");
            throw new ATException(ResultCode.InvalidParameter);
        }
        for (SSI1DParamName item : this.mList) {
            try {
                writer.write(item.getCommand());
            }
            catch (IOException e) {
                ATLog.e((String)TAG, (String)"ERROR. getBytes() - Failed to write %s parameter name", (Object[])new Object[]{item.toString()});
            }
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            ATLog.e((String)TAG, (String)"ERROR. getBytes() - Failed to flush parameter");
            return null;
        }
        byte[] data = writer.toByteArray();
        try {
            writer.close();
        }
        catch (IOException e) {
            ATLog.e((String)TAG, (String)"ERROR. getBytes() - Failed to close parameter");
            return null;
        }
        return data;
    }
}

