/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.barcode.types;

import com.atid.lib.types.IEnumType;

public enum BarcodePostType implements IEnumType
{
    Off(0, "Post All Off"),
    AustraliaPost(1, "Australian Post"),
    BritishPost(7, "British Post"),
    CanadianPost(30, "Canadian Post"),
    InteliMail(10, "Intelligent Mail Bar Code"),
    JapanPostal(3, "Japanese Post"),
    KixPost(4, "KIX Post"),
    Planet(5, "Planet Code"),
    Postal4i(9, "Postal-4i"),
    Postnet(6, "Postnet"),
    PostnetB(11, "Postnet with B"),
    InfoMail(2, "InfoMail"),
    InfoMail_BritishPost(8, "InfoMail/British Post"),
    InteliMail_PostnetB(20, "Intelligent Mail Bar Code/Postnet with B"),
    Postnet_Postal4i(14, "Postnet/Postal-4i"),
    Postnet_InteliMail(16, "Postnet/Intelligent Mail Bar Code"),
    Postal4i_InteliMail(17, "Postal-4i/Intelligent Mail Bar Code"),
    Postal4i_PostnetB(19, "Postal-4i/Postnet with B"),
    Planet_Postnet(12, "Planet/Postnet"),
    Planet_PostnetB(18, "Planet/Postnet with B"),
    Planet_Postal4i(13, "Planet/Postal-4i"),
    Planet_InteliMail(15, "Planet/Intelligent Mail Bar Code"),
    Planet_Postnet_Postal4i(21, "Planet/Postnet/Postal-4i"),
    Planet_Postnet_InteliMail(22, "Planet/Postnet/Intelligent Mail Bar Code"),
    Planet_Postal4i_InteliMail(23, "Planet/Postal-4i/Intelligent Mail Bar Code"),
    Postnet_Postal4i_InteliMail(24, "Postnet/Postal-4i/Intelligent Mail Bar Code"),
    Planet_Postal4i_PostnetB(25, "Planet/Postal-4i/Postnet with B"),
    Planet_InteliMail_PostnetB(26, "Planet/Intelligent Mail Bar Code/Postnet with B"),
    Postal4i_InteliMail_PostnetB(27, "Postal-4i/Intelligent Mail Bar Code/Postnet with B"),
    Planet_Postal4i_InteliMail_Postnet(28, "Planet/Postal-4i/Intelligent Mail Bar Code/Postnet"),
    Planet_Postal4i_InteliMail_PostnetB(29, "Planet/Postal-4i/Intelligent Mail Bar Code/Postnet with B");

    private final int mCode;
    private final String mName;
    private static final BarcodePostType[] mItems;

    static {
        mItems = BarcodePostType.values();
    }

    private BarcodePostType(int code, String name) {
        this.mCode = code;
        this.mName = name;
    }

    public int getCode() {
        return this.mCode;
    }

    public String toString() {
        return this.mName;
    }

    public static BarcodePostType valueOf(String string) {
        return Enum.valueOf(BarcodePostType.class, string);
    }
}

