/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.reader;

import com.atid.lib.device.IReader;
import com.atid.lib.diagnostics.ATException;
import com.atid.lib.module.barcode.ATBarcode;
import com.atid.lib.module.rfid.hf.ATRfidHf;
import com.atid.lib.module.rfid.uhf.ATRfidUhf;
import com.atid.lib.protocol.IProtocol;
import com.atid.lib.reader.device.ATDevice;
import com.atid.lib.reader.event.ATEAReaderEventManager;
import com.atid.lib.reader.event.IATEAReaderEventListener;
import com.atid.lib.reader.params.NotifyMethod;
import com.atid.lib.reader.params.StoredDataList;
import com.atid.lib.reader.types.BuzzerState;
import com.atid.lib.reader.types.KeyState;
import com.atid.lib.reader.types.KeyType;
import com.atid.lib.reader.types.NotificationState;
import com.atid.lib.reader.types.NotifyTimeType;
import com.atid.lib.reader.types.OperationMode;
import com.atid.lib.reader.types.UsbChargerState;
import com.atid.lib.reader.types.UsbChargerType;
import com.atid.lib.transport.ATransport;
import com.atid.lib.transport.types.ConnectState;
import com.atid.lib.transport.types.ConnectType;
import com.atid.lib.types.ActionState;
import com.atid.lib.types.DeviceType;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.Version;
import com.atid.lib.util.diagnotics.ATLog;
import java.util.Date;
import java.util.Locale;

public abstract class ATEAReader
implements IReader,
ATransport.IConnectStateEventListener {
    protected static final int INFO = 6;
    protected static final int RETRY_COUNT = 3;
    protected static final int DEFALT_BATTERY_CHECK_INTERVAL = 3000;
    protected String TAG = ATEAReader.class.getSimpleName();
    private int mRefCount;
    private int mSessionId;
    private ATEAReaderEventManager mListeners;
    protected ATransport mTransport;
    protected ATDevice mDevice;
    protected ATRfidUhf mRfidUhf;
    protected ATRfidHf mRfidHf;
    protected ATBarcode mBarcode;
    private volatile ConnectState mState;
    private volatile ConnectState mBackupState;
    protected volatile ActionState mAction;
    protected Version mDeviceVersion;
    protected ResultCode mLastError;
    protected int mCheckInterval;
    protected int mFailCount;
    protected long mLastTime;
    protected boolean mIsDisconnecting;

    public ATEAReader(ATransport transport) {
        this.mSessionId = 0;
        this.mRefCount = 0;
        this.mListeners = new ATEAReaderEventManager();
        this.mTransport = transport;
        this.mDevice = null;
        this.mRfidUhf = null;
        this.mRfidHf = null;
        this.mBarcode = null;
        this.mBackupState = this.mState = ConnectState.Disconnected;
        this.mAction = ActionState.Stop;
        this.mDeviceVersion = new Version();
        this.mLastError = ResultCode.NoError;
        this.mCheckInterval = 3000;
        this.mFailCount = 0;
        this.mLastTime = 0L;
        this.mIsDisconnecting = false;
        transport.setStateListener((ATransport.IConnectStateEventListener)this);
    }

    public ATEAReader(int sessionId, ATransport transport) {
        this.mSessionId = sessionId;
        this.mRefCount = 0;
        this.mListeners = new ATEAReaderEventManager();
        this.mTransport = transport;
        this.mDevice = null;
        this.mBackupState = this.mState = ConnectState.Disconnected;
        this.mDeviceVersion = new Version();
        this.mLastError = ResultCode.NoError;
        this.mCheckInterval = 3000;
        this.mFailCount = 0;
        this.mLastTime = 0L;
        this.mIsDisconnecting = false;
        transport.setStateListener((ATransport.IConnectStateEventListener)this);
    }

    protected ConnectState getBackupState() {
        return this.mBackupState;
    }

    public int getSessionId() {
        return this.mSessionId;
    }

    public ATransport getTransport() {
        return this.mTransport;
    }

    public DeviceType getDeviceType() {
        return this.mTransport.getDeviceType();
    }

    public void setDeviceType(DeviceType type) {
        this.mTransport.setDeviceType(type);
    }

    public String getDeviceName() {
        return this.mTransport.getDeviceName();
    }

    public void setDeviceName(String name) {
        this.mTransport.setDeviceName(name);
    }

    public String getAddress() {
        return this.mTransport.getAddress();
    }

    public void setAddress(String address) {
        this.mTransport.setAddress(address);
    }

    public ConnectType getConnectType() {
        return this.mTransport.getConnectType();
    }

    public ConnectState getState() {
        return this.mTransport.getState();
    }

    public void setAutoConnect(boolean enabled) {
        this.mTransport.setAutoConnect(enabled);
    }

    public boolean getAutoConnect() {
        return this.mTransport.getAutoConnect();
    }

    public boolean getDeviceAttached() {
        return this.mTransport.getDeviceAttached();
    }

    public String getVersion() {
        return this.mDeviceVersion.getVersionString();
    }

    public int getVersionHexa() {
        return this.mDeviceVersion.getVersionHexa();
    }

    public ActionState getAction() {
        return this.mAction;
    }

    public void setAction(ActionState state) {
        this.mAction = state;
    }

    public int getCheckInterval() {
        return this.mCheckInterval;
    }

    public void setCheckInterval(int interval) {
        this.mCheckInterval = interval;
    }

    public void checkError() {
        ++this.mFailCount;
        this.mLastTime = System.currentTimeMillis();
        if (this.mFailCount > 3) {
            this.disconnect();
        }
    }

    public void resetError() {
        this.mFailCount = 0;
        this.mLastTime = System.currentTimeMillis();
    }

    public ResultCode getLastError() {
        return this.mLastError;
    }

    public void setLastError(ResultCode code) {
        this.mLastError = code;
    }

    public IProtocol getProtocol() {
        return this.mDevice.getProtocol();
    }

    public ATRfidUhf getRfidUhf() {
        return this.mRfidUhf;
    }

    public ATRfidHf getRfidHf() {
        return this.mRfidHf;
    }

    public ATBarcode getBarcode() {
        return this.mBarcode;
    }

    public void destroy() {
        if (this.mRfidUhf != null) {
            this.mRfidUhf.destroy();
        }
        if (this.mRfidHf != null) {
            this.mRfidHf.destroy();
        }
        if (this.mBarcode != null) {
            this.mBarcode.destroy();
        }
        if (this.mTransport != null) {
            this.mTransport.destroy();
        }
        this.mListeners.destroy();
    }

    public void wakeUp() {
        ++this.mRefCount;
    }

    public void wakeUp(IATEAReaderEventListener listener) {
        this.mListeners.addListener(listener);
        this.wakeUp();
    }

    public void sleep() {
        --this.mRefCount;
        if (this.mRefCount < 0) {
            this.mRefCount = 0;
        }
        this.mBackupState = this.mState;
    }

    public void sleep(IATEAReaderEventListener listener) {
        this.mListeners.removeListener(listener);
        this.sleep();
    }

    protected boolean isEmptyRef() {
        return this.mRefCount == 0;
    }

    public void addListener(IATEAReaderEventListener listener) {
        this.mListeners.addListener(listener);
    }

    public void removeListener(IATEAReaderEventListener listener) {
        this.mListeners.removeListener(listener);
    }

    public void clearListener() {
        this.mListeners.clear();
    }

    public String toString() {
        return String.format(Locale.US, "%s<%s>", this.mTransport.getDeviceType(), this.mTransport.getAddress());
    }

    public synchronized boolean connect() {
        if (this.mDevice == null) {
            this.mLastError = ResultCode.InvalidModule;
            ATLog.e((String)this.TAG, (String)"ERROR. connect() - Failed to invalid module object");
            return false;
        }
        if (!this.mTransport.connect()) {
            this.mLastError = ResultCode.ConnectFail;
            ATLog.e((String)this.TAG, (String)"ERROR. connect() - Failed to connect device");
            return false;
        }
        this.mIsDisconnecting = false;
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. connect()");
        return true;
    }

    public synchronized void listen() {
        if (this.mDevice == null) {
            this.mLastError = ResultCode.InvalidModule;
            ATLog.e((String)this.TAG, (String)"ERROR. listen() - Failed to invalid module object");
            return;
        }
        this.mTransport.listen();
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. listen()");
    }

    public synchronized void disconnect() {
        if (this.mDevice == null) {
            this.mLastError = ResultCode.InvalidModule;
            ATLog.e((String)this.TAG, (String)"ERROR. disconnect() - Failed to invalid module object");
            return;
        }
        if (this.mIsDisconnecting) {
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. disconnect() - Already disconnect!!!");
            return;
        }
        if (this.mTransport != null) {
            this.mTransport.disconnect();
            this.mIsDisconnecting = true;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. disconnect()");
    }

    public abstract boolean initReader();

    public abstract ResultCode reset();

    public abstract ResultCode defaultParameter();

    public abstract ResultCode loadStoredData();

    public abstract ResultCode saveStoredData(StoredDataList var1);

    public abstract ResultCode removeAllStoreadData();

    public abstract OperationMode getOperationMode() throws ATException;

    public abstract void setOperationMode(OperationMode var1) throws ATException;

    public abstract BuzzerState getBuzzer() throws ATException;

    public abstract void setBuzzer(BuzzerState var1) throws ATException;

    public abstract boolean getUseActionKey() throws ATException;

    public abstract void setUseActionKey(boolean var1) throws ATException;

    public abstract int getBatteryState() throws ATException;

    public abstract int getAutoOffTime() throws ATException;

    public abstract void setAutoOffTime(int var1) throws ATException;

    public abstract Date getTime() throws ATException;

    public abstract void setTime(Date var1) throws ATException;

    public String getSerialNo() throws ATException {
        return this.mDeviceVersion.getSerialNo();
    }

    public abstract void setSerialNo(String var1) throws ATException;

    public abstract int getStoredTagCount() throws ATException;

    public abstract NotifyTimeType getButtonNotifyTime() throws ATException;

    public abstract void setButtonNotifyTime(NotifyTimeType var1) throws ATException;

    public abstract NotifyMethod getButtonNotify() throws ATException;

    public abstract void setButtonNotify(NotifyMethod var1) throws ATException;

    public abstract NotifyMethod getAlertNotify() throws ATException;

    public abstract void setAlertNotify(NotifyMethod var1) throws ATException;

    public abstract void onStateChanged(ConnectState var1, Object var2);

    protected void onReaderStateChanged(ConnectState state, Object params) {
        this.mState = state;
        this.mListeners.generateReaderStateChanged(this, state, params);
    }

    protected void onReaderActionChanged(ResultCode code, ActionState action, Object params) {
        this.mAction = action;
        this.mListeners.generateReaderActionChanged(this, code, action, params);
    }

    protected void onReaderOperationModeChanged(OperationMode mode, Object params) {
        this.mListeners.generateReaderOperationModeChanged(this, mode, params);
    }

    protected void onReaderBatteryState(int batteryState, Object params) {
        this.mListeners.generateReaderBatteryState(this, batteryState, params);
    }

    protected void onReaderKeyChanged(KeyType type, KeyState state, Object params) {
        this.mListeners.generateReaderKeyChanged(this, type, state, params);
    }

    protected void onReaderUsbChargerChanged(UsbChargerType type, UsbChargerState state, Object params) {
        this.mListeners.generateReaderUsbChargerChanged(this, type, state, params);
    }

    protected void onReaderNotificationState(NotificationState state, Object params) {
        this.mListeners.generateReaderNotificationState(this, state, params);
    }
}

