/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.barcode.ssi.param;

import com.atid.lib.diagnostics.ATException;
import com.atid.lib.module.barcode.ssi.param.SSI1DParamName;
import com.atid.lib.module.barcode.ssi.param.SSI1DParamValue;
import com.atid.lib.module.barcode.ssi.type.BooklandISBNFormat;
import com.atid.lib.module.barcode.ssi.type.CodabarStartStopCharactersDetection;
import com.atid.lib.module.barcode.ssi.type.Code11CheckDigitVerification;
import com.atid.lib.module.barcode.ssi.type.CouponReport;
import com.atid.lib.module.barcode.ssi.type.DecodeUpcEanJanSupplementals;
import com.atid.lib.module.barcode.ssi.type.GS1DataBarLimitedSecurityLevel;
import com.atid.lib.module.barcode.ssi.type.I2of5CheckDigitVerification;
import com.atid.lib.module.barcode.ssi.type.ISBTConcatenation;
import com.atid.lib.module.barcode.ssi.type.LinearSecurityLevel;
import com.atid.lib.module.barcode.ssi.type.MSICheckDigitAlgorithm;
import com.atid.lib.module.barcode.ssi.type.MSICheckDigits;
import com.atid.lib.module.barcode.ssi.type.Preamble;
import com.atid.lib.module.barcode.ssi.type.UpcEanSecurityLevel;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.diagnotics.ATLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class SSI1DParamValueList {
    private static final String TAG = SSI1DParamValueList.class.getSimpleName();
    private static final int INFO = 6;
    private static final int DEBUG = 2;
    private ArrayList<SSI1DParamValue> mList = new ArrayList();

    public SSI1DParamValueList() {
    }

    public SSI1DParamValueList(SSI1DParamValue item) {
        this.add(item);
    }

    public SSI1DParamValueList(SSI1DParamValue[] item) {
        this.add(item);
    }

    public synchronized int getCount() {
        return this.mList.size();
    }

    public synchronized boolean add(SSI1DParamValue item) {
        if (item == null) {
            ATLog.e((String)TAG, (String)"ERROR. add(item) - Invalid parameter");
            return false;
        }
        return this.mList.add(item);
    }

    public synchronized boolean add(SSI1DParamValue[] items) {
        boolean result = true;
        if (items == null) {
            ATLog.e((String)TAG, (String)"ERROR. add(item) - Invalid parameter");
            return false;
        }
        SSI1DParamValue[] sSI1DParamValueArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            SSI1DParamValue item = sSI1DParamValueArray[n2];
            result &= this.mList.add(item);
            ++n2;
        }
        return result;
    }

    public synchronized boolean add(SSI1DParamName name, Object value) {
        if (name == null || value == null) {
            ATLog.e((String)TAG, (String)"ERROR. add(name,value) - Invalid parameter");
            return false;
        }
        return this.mList.add(new SSI1DParamValue(name, value));
    }

    public synchronized SSI1DParamValue getAt(SSI1DParamName name) throws ATException {
        if (name == null) {
            ATLog.e((String)TAG, (String)"ERROR. getAt() - Invalid parameter");
            throw new ATException(ResultCode.InvalidParameter);
        }
        for (SSI1DParamValue item : this.mList) {
            if (!item.getName().equals((Object)name)) continue;
            return item;
        }
        throw new ATException(ResultCode.NotFoundParameter);
    }

    public synchronized SSI1DParamValue get(int index) throws ATException {
        if (index < 0 || index > this.mList.size()) {
            ATLog.e((String)TAG, (String)"ERROR. get() - out of range !!");
            throw new ATException(ResultCode.InvalidParameter);
        }
        return this.mList.get(index);
    }

    public synchronized Object getValueAt(SSI1DParamName name) throws ATException {
        if (name == null) {
            ATLog.e((String)TAG, (String)"ERROR. getValueAt() - Invalid parameter");
            throw new ATException(ResultCode.InvalidParameter);
        }
        for (SSI1DParamValue item : this.mList) {
            if (!item.getName().equals((Object)name)) continue;
            return item.getValue();
        }
        throw new ATException(ResultCode.NotFoundParameter);
    }

    public synchronized Object getValue(int index) throws ATException {
        if (index < 0 || index > this.mList.size()) {
            ATLog.e((String)TAG, (String)"ERROR. get() - out of range !!");
            throw new ATException(ResultCode.InvalidParameter);
        }
        return this.mList.get(index).getValue();
    }

    public byte[] getBytes(int engine) throws ATException {
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        if (this.mList == null || this.mList.size() == 0) {
            ATLog.e((String)TAG, (String)"ERROR. Parameter is null or zero !!!");
            throw new ATException(ResultCode.InvalidParameter);
        }
        for (SSI1DParamValue value : this.mList) {
            SSI1DParamName name = value.getName();
            try {
                writer.write(name.getCommand());
            }
            catch (IOException e) {
                ATLog.e((String)TAG, (String)"ERROR. getBytes() - Failed to write %s parameter name", (Object[])new Object[]{name.toString()});
                continue;
            }
            switch (name) {
                case Decode_UPC_EAN_JAN_Supplemental_Redundancy: 
                case Set_Length_1_Code128: 
                case Set_Length_2_Code128: 
                case ISBT_Concatenation_Redundancy: 
                case Set_Length_1_Code39: 
                case Set_Length_2_Code39: 
                case Set_Length_1_Code93: 
                case Set_Lenght_2_Code93: 
                case Set_Length_1_Code11: 
                case Set_Length_2_Code11: 
                case Set_Length_1_I2of5: 
                case Set_Length_2_I2of5: 
                case Set_Length_1_D2of5: 
                case Set_Length_2_D2of5: 
                case Set_Length_1_Matrix2of5: 
                case Set_Length_2_Matrix2of5: 
                case Set_Length_1_Codabar: 
                case Set_Length_2_Codabar: 
                case Set_Length_1_MSI: 
                case Set_Length_2_MSI: {
                    writer.write((byte)((Integer)value.getValue() & 0xFF));
                    break;
                }
                case Transmit_UPC_A_Check_Digit: 
                case Transmit_UPC_E_Check_Digit: 
                case Transmit_UPC_E1_Check_Digit: 
                case Convert_UPC_E_to_UPC_A: 
                case Convert_UPC_E1_to_UPC_A: 
                case EAN_8_JAN_8_Extend: 
                case Check_ISBT_Table: 
                case Code32_Prefix: 
                case Code39_Check_Digit_Verification: 
                case Transmit_Code39_Check_Digit: 
                case Code39_Full_Ascii_Conversion: 
                case Transmit_Code_11_Check_Digits: 
                case Transmit_I2of5_Check_Digit: 
                case Convert_I2of5_to_EAN_13: 
                case Matrix2of5_Check_Digit: 
                case Transmit_Matrix2of5_Check_Digit: 
                case CLSI_Editing: 
                case NOTIS_Editing: 
                case Transmit_MSI_Check_Digits: 
                case Convert_GS1_DataBar_to_UPC_EAN: 
                case Bi_Directional_Redundancy: {
                    writer.write((byte)((Boolean)value.getValue() != false ? 1 : 0));
                    break;
                }
                case Bookland_ISBN_Format: {
                    writer.write((byte)((BooklandISBNFormat)((Object)value.getValue())).getCode());
                    break;
                }
                case Decode_UPC_EAN_JAN_Supplementals: {
                    writer.write((byte)((DecodeUpcEanJanSupplementals)((Object)value.getValue())).getCode());
                    break;
                }
                case UPC_EAN_Security_Level: {
                    writer.write((byte)((UpcEanSecurityLevel)((Object)value.getValue())).getCode());
                    break;
                }
                case UPC_A_Preamble: 
                case UPC_E_Preamble: 
                case UPC_E1_Preamble: {
                    writer.write((byte)((Preamble)((Object)value.getValue())).getCode());
                    break;
                }
                case Coupon_Report: {
                    writer.write((byte)((CouponReport)((Object)value.getValue())).getCode());
                    break;
                }
                case ISBT_Concatenation: {
                    writer.write((byte)((ISBTConcatenation)((Object)value.getValue())).getCode());
                    break;
                }
                case Code11_Check_Digit_Verification: {
                    writer.write((byte)((Code11CheckDigitVerification)((Object)value.getValue())).getCode());
                    break;
                }
                case I2of5_Check_Digit_Verification: {
                    writer.write((byte)((I2of5CheckDigitVerification)((Object)value.getValue())).getCode());
                    break;
                }
                case Codabar_Upper_Lower_Start_Stop_Characters_Dectection: {
                    writer.write((byte)((CodabarStartStopCharactersDetection)((Object)value.getValue())).getCode());
                    break;
                }
                case MSI_Check_Digits: {
                    writer.write((byte)((MSICheckDigits)((Object)value.getValue())).getCode());
                    break;
                }
                case MSI_Check_Digit_Algorithm: {
                    writer.write((byte)((MSICheckDigitAlgorithm)((Object)value.getValue())).getCode());
                    break;
                }
                case GS1_DataBar_Limited_Security_Level: {
                    writer.write((byte)((GS1DataBarLimitedSecurityLevel)((Object)value.getValue())).getCode());
                    break;
                }
                case Linear_Security_Level: {
                    writer.write((byte)((LinearSecurityLevel)((Object)value.getValue())).getCode());
                    break;
                }
                default: {
                    ATLog.d((String)TAG, (int)2, (String)"DEBUG. getBytes() - Unknown parameter name [%s] ", (Object[])new Object[]{name.toString()});
                }
            }
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            ATLog.e((String)TAG, (String)"ERROR. getBytes() - Failed to flush parameter");
            throw new ATException(ResultCode.FailedParameter);
        }
        byte[] data = writer.toByteArray();
        try {
            writer.close();
        }
        catch (IOException e) {
            ATLog.e((String)TAG, (String)"ERROR. getBytes() - Failed to close parameter");
            throw new ATException(ResultCode.FailedParameter);
        }
        ATLog.i((String)TAG, (int)6, (String)"INFO. getBytes(%d)", (Object[])new Object[]{engine});
        return data;
    }

    /*
     * Unable to fully structure code
     */
    public static SSI1DParamValueList parseParams(byte[] data, int engine) throws ATException {
        list = new SSI1DParamValueList();
        pos = 0;
        if (data != null) ** GOTO lbl75
        ATLog.e((String)SSI1DParamValueList.TAG, (String)"ERROR. parseParams() - Invalid parameter");
        throw new ATException(ResultCode.InvalidParameter);
lbl-1000:
        // 1 sources

        {
            name = SSI1DParamName.valueOf(data, pos);
            if (name != null) {
                pos += name.getCommand().length;
            } else {
                ++pos;
                continue;
            }
            switch (SSI1DParamValueList.$SWITCH_TABLE$com$atid$lib$module$barcode$ssi$param$SSI1DParamName()[name.ordinal()]) {
                case 3: 
                case 15: 
                case 16: 
                case 19: 
                case 21: 
                case 22: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 32: 
                case 33: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 43: 
                case 44: 
                case 48: 
                case 49: {
                    list.add(name, data[pos++] & 255);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 11: 
                case 12: 
                case 18: 
                case 20: 
                case 23: 
                case 24: 
                case 25: 
                case 31: 
                case 35: 
                case 36: 
                case 41: 
                case 42: 
                case 45: 
                case 46: 
                case 51: 
                case 54: 
                case 56: {
                    list.add(name, data[pos++] > 0);
                    break;
                }
                case 1: {
                    list.add(name, (Object)BooklandISBNFormat.valueOf(data[pos++]));
                    break;
                }
                case 2: {
                    list.add(name, (Object)DecodeUpcEanJanSupplementals.valueOf(data[pos++]));
                    break;
                }
                case 13: {
                    list.add(name, (Object)UpcEanSecurityLevel.valueOf(data[pos++]));
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    list.add(name, (Object)Preamble.valueOf(data[pos++]));
                    break;
                }
                case 14: {
                    list.add(name, (Object)CouponReport.valueOf(data[pos++]));
                    break;
                }
                case 17: {
                    list.add(name, (Object)ISBTConcatenation.valueOf(data[pos++]));
                    break;
                }
                case 30: {
                    list.add(name, (Object)Code11CheckDigitVerification.valueOf(data[pos++]));
                    break;
                }
                case 34: {
                    list.add(name, (Object)I2of5CheckDigitVerification.valueOf(data[pos++]));
                    break;
                }
                case 47: {
                    list.add(name, (Object)CodabarStartStopCharactersDetection.valueOf(data[pos++]));
                    break;
                }
                case 50: {
                    list.add(name, (Object)MSICheckDigits.valueOf(data[pos++]));
                    break;
                }
                case 52: {
                    list.add(name, (Object)MSICheckDigitAlgorithm.valueOf(data[pos++]));
                    break;
                }
                case 53: {
                    list.add(name, (Object)GS1DataBarLimitedSecurityLevel.valueOf(data[pos++]));
                    break;
                }
                case 55: {
                    list.add(name, (Object)LinearSecurityLevel.valueOf(data[pos++]));
                    break;
                }
                default: {
                    ATLog.d((String)SSI1DParamValueList.TAG, (int)2, (String)"DEBUG. parseParams() - Unknown parameter ");
                }
            }
lbl75:
            // 18 sources

            ** while (pos < data.length)
        }
lbl76:
        // 1 sources

        return list;
    }
}

