/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.barcode;

import com.atid.lib.device.IReader;
import com.atid.lib.diagnostics.ATException;
import com.atid.lib.module.barcode.event.ATBarcodeEventManager;
import com.atid.lib.module.barcode.event.IATBarcodeEventListener;
import com.atid.lib.module.barcode.module.ATModuleBarcode;
import com.atid.lib.module.barcode.params.SymbolStateList;
import com.atid.lib.module.barcode.types.BarcodePostType;
import com.atid.lib.module.barcode.types.BarcodeType;
import com.atid.lib.types.ActionState;
import com.atid.lib.types.ModuleBarcodeType;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.diagnotics.ATLog;
import com.atid.lib.util.diagnotics.Dump;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;

public abstract class ATBarcode {
    protected static final int INFO = 6;
    protected static final int MAX_PARAM = 5;
    protected String TAG = ATBarcode.class.getSimpleName();
    protected ATModuleBarcode mModule;
    protected IReader mReader;
    protected BarcodeType[] mBarcodeNames;
    protected byte[] mDefaultOption;
    protected boolean[] mDefaultState;
    protected ATBarcodeEventManager mListeners;

    public ATBarcode(IReader reader) {
        this.mReader = reader;
        this.mModule = null;
        this.mDefaultOption = null;
        this.mListeners = new ATBarcodeEventManager();
    }

    public void destroy() {
        if (this.mListeners != null) {
            this.mListeners.destroy();
        }
    }

    public ModuleBarcodeType getType() {
        return this.mModule == null ? ModuleBarcodeType.None : this.mModule.getType();
    }

    public void addListener(IATBarcodeEventListener listener) {
        this.mListeners.addListener(listener);
    }

    public void removeListener(IATBarcodeEventListener listener) {
        this.mListeners.removeListener(listener);
    }

    public void clearListener() {
        this.mListeners.clear();
    }

    public abstract boolean initMoudle();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultCode startDecode() {
        try {
            this.assertAction();
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (String)"ERROR. startDecode() - Failed to assert action");
            return this.mReader.getLastError();
        }
        ATModuleBarcode aTModuleBarcode = this.mModule;
        synchronized (aTModuleBarcode) {
            this.mReader.setAction(ActionState.Decoding);
            this.mReader.setLastError(this.mModule.startDecode());
            if (this.mReader.getLastError() != ResultCode.NoError) {
                ATLog.e((String)this.TAG, (String)"ERROR. startDecode() - Failed to start decode");
                this.mReader.checkError();
                return this.mReader.getLastError();
            }
            this.mReader.resetError();
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. startDecode()");
            return ResultCode.NoError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultCode stop() {
        try {
            this.assertModule();
        }
        catch (ATException e) {
            ATLog.e((String)this.TAG, (String)"ERROR. stop() - Failed to assert module");
            return this.mReader.getLastError();
        }
        ATModuleBarcode aTModuleBarcode = this.mModule;
        synchronized (aTModuleBarcode) {
            this.mReader.setLastError(this.mModule.stopAction());
            if (this.mReader.getLastError() != ResultCode.NoError) {
                ATLog.e((String)this.TAG, (String)"ERROR. stop() - Failed to stop action");
                this.mReader.checkError();
                return this.mReader.getLastError();
            }
            this.mReader.resetError();
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. stop()");
            return ResultCode.NoError;
        }
    }

    public abstract String getVersion() throws ATException;

    public void defaultSymbol() throws ATException {
        int block = (int)Math.ceil((double)this.mBarcodeNames.length / 5.0);
        int len = 0;
        byte[] send = null;
        int i = 0;
        while (i < block) {
            len = (i + 1) * 5 > this.mBarcodeNames.length ? this.mBarcodeNames.length : (i + 1) * 5;
            send = this.getBytes(this.mBarcodeNames, this.mDefaultState, i * 5, len);
            try {
                this.mModule.setBarcodeParam(send);
            }
            catch (ATException e) {
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. defaultSymbol() - Failed to set symbol state", (Object[])new Object[0]);
                throw e;
            }
            ++i;
        }
        this.mModule.setCharset(Charset.defaultCharset());
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. defaultSymbol()");
    }

    public void defaultOption() throws ATException {
        if (this.mDefaultOption != null) {
            try {
                this.mModule.setBarcodeParam(this.mDefaultOption);
            }
            catch (ATException e) {
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. defaultOption() - Failed to set barcode option", (Object[])new Object[0]);
                throw e;
            }
        } else {
            ATLog.d((String)this.TAG, (int)6, (String)"DEBUG. defaultOption() - default opiont is empty");
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. defaultOption()");
    }

    public void enableAllSymbol(boolean enabled) throws ATException {
        int block = (int)Math.ceil((double)this.mBarcodeNames.length / 5.0);
        int len = 0;
        byte[] send = null;
        int i = 0;
        while (i < block) {
            len = (i + 1) * 5 > this.mBarcodeNames.length ? this.mBarcodeNames.length : (i + 1) * 5;
            send = this.getBytes(this.mBarcodeNames, enabled, i * 5, len);
            try {
                this.mModule.setBarcodeParam(send);
            }
            catch (ATException e) {
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. enableAllSymbol(%s) - Failed to set symbol state", (Object[])new Object[]{enabled});
                throw e;
            }
            ++i;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. enableAllSymbol(%s)", (Object[])new Object[]{enabled});
        if (this.mModule.getType() == ModuleBarcodeType.AT2DSE4710) {
            send = null;
            byte[] byArray = new byte[3];
            byArray[0] = -16;
            byArray[1] = 88;
            send = byArray;
            try {
                this.mModule.setBarcodeParam(send);
            }
            catch (ATException e) {
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. enableAllSymbol(%s) - Failed to set UPC Composite mode(Never Linked)", (Object[])new Object[]{enabled});
            }
        }
    }

    public SymbolStateList getSymbolState() throws ATException {
        int block = (int)Math.ceil((double)this.mBarcodeNames.length / 5.0);
        int len = 0;
        byte[] send = null;
        byte[] recv = null;
        SymbolStateList list = new SymbolStateList();
        int i = 0;
        while (i < block) {
            len = (i + 1) * 5 > this.mBarcodeNames.length ? this.mBarcodeNames.length : (i + 1) * 5;
            send = this.getBytes(this.mBarcodeNames, i * 5, len);
            try {
                recv = this.mModule.getBarcodeParam(send);
            }
            catch (ATException e) {
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getSymbolState() - Failed to get symbol state", (Object[])new Object[0]);
                throw e;
            }
            list.addAll(this.getSymbolState(recv));
            ++i;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getSymbolState() - [%d]", (Object[])new Object[]{list.getCount()});
        return list;
    }

    public void setSymbolState(SymbolStateList list) throws ATException {
        int block = (int)Math.ceil((double)list.getCount() / 5.0);
        int len = 0;
        byte[] send = null;
        int i = 0;
        while (i < block) {
            len = (i + 1) * 5 > list.getCount() ? list.getCount() : (i + 1) * 5;
            send = this.getBytes(list, i * 5, len);
            try {
                this.mModule.setBarcodeParam(send);
            }
            catch (ATException e) {
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setSymbolState(%d) - Failed to set symbol state", (Object[])new Object[]{list.getCount()});
                throw e;
            }
            ++i;
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setSymbolState(%d)", (Object[])new Object[]{list.getCount()});
    }

    public abstract boolean isSuportSelPost();

    public abstract BarcodePostType getSymbolPostState() throws ATException;

    public abstract void setSymbolPostState(BarcodePostType var1) throws ATException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBarcodeParam(byte[] names) throws ATException {
        this.assertAction(names);
        ATModuleBarcode aTModuleBarcode = this.mModule;
        synchronized (aTModuleBarcode) {
            byte[] params = null;
            try {
                params = this.mModule.getBarcodeParam(names);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getBarcodeParam([%s]) - Failed to get barcode param [%s]", (Object[])new Object[]{Dump.dump((byte[])names), this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. getBarcodeParam([%s]) - [%s]", (Object[])new Object[]{Dump.dump((byte[])names), Dump.dump((byte[])params)});
            return params;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBarcodeParam(byte[] params) throws ATException {
        this.assertAction(params);
        ATModuleBarcode aTModuleBarcode = this.mModule;
        synchronized (aTModuleBarcode) {
            try {
                this.mModule.setBarcodeParam(params);
            }
            catch (ATException e) {
                this.setException(e);
                ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setBarcodeParam([%s]) - Failed to set barcode param [%s]", (Object[])new Object[]{Dump.dump((byte[])params), this.mReader.getLastError()});
                throw e;
            }
            this.mReader.resetError();
            ATLog.i((String)this.TAG, (int)6, (String)"INFO. setBarcodeParam([%s])", (Object[])new Object[]{Dump.dump((byte[])params)});
        }
    }

    public String getBarcodeParamString(String names) throws ATException {
        byte[] sendBytes = null;
        byte[] resBytes = null;
        try {
            sendBytes = names.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e1) {
            ATLog.e((String)this.TAG, (String)"ERROR. getBarcodeParamString([%s]) - Failed to invalid parameter", (Object[])new Object[]{names});
            throw new ATException(ResultCode.InvalidParameter);
        }
        resBytes = this.getBarcodeParam(sendBytes);
        String params = "";
        try {
            params = new String(resBytes, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. getBarcodeParamString() - Failed to invalid response data", (Object[])new Object[0]);
            throw new ATException(ResultCode.InvalidResponseData);
        }
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getBarcodeParamString() - [%s]", (Object[])new Object[]{params});
        return params;
    }

    public void setBarcodeParamString(String params) throws ATException {
        byte[] sendBytes = null;
        try {
            sendBytes = params.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            ATLog.e((String)this.TAG, (Throwable)e, (String)"ERROR. setBarcodeParamString([%s]) - Failed to invalid parameter", (Object[])new Object[]{params});
            throw new ATException(ResultCode.InvalidParameter);
        }
        this.setBarcodeParam(sendBytes);
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setBarcodeParamString([%s])", (Object[])new Object[]{params});
    }

    public Charset getCharset() throws ATException {
        if (this.mModule == null) {
            throw new ATException(ResultCode.InvalidModule);
        }
        Charset charset = this.mModule.getCharset();
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. getCharset(%s)", (Object[])new Object[]{charset.name()});
        return charset;
    }

    public void setCharset(Charset charset) throws ATException {
        if (this.mModule == null) {
            throw new ATException(ResultCode.InvalidModule);
        }
        this.mModule.setCharset(charset);
        ATLog.i((String)this.TAG, (int)6, (String)"INFO. setCharset(%s)", (Object[])new Object[]{charset.name()});
    }

    protected void assertModule() throws ATException {
        this.assertModule(null);
    }

    protected void assertModule(byte[] data) throws ATException {
        if (this.mModule == null) {
            this.mReader.setLastError(ResultCode.InvalidModule);
            ATLog.e((String)this.TAG, (String)"ERROR. assertModule() - Failed to invalid module object%s", (Object[])new Object[]{data == null ? "" : String.format(Locale.US, " [%s]", Dump.dump((byte[])data))});
            throw new ATException(ResultCode.InvalidModule);
        }
        if (this.mModule.getType() == ModuleBarcodeType.None) {
            this.mReader.setLastError(ResultCode.NotSupported);
            ATLog.e((String)this.TAG, (String)"ERROR. assertModule() - Failed to not supported%s", (Object[])new Object[]{data == null ? "" : String.format(Locale.US, " [%s]", Dump.dump((byte[])data))});
            throw new ATException(this.mReader.getLastError());
        }
    }

    protected void assertAction() throws ATException {
        this.assertAction(null);
    }

    protected void assertAction(byte[] data) throws ATException {
        this.assertModule(data);
        if (this.mReader.getAction() != ActionState.Stop) {
            this.mReader.setLastError(ResultCode.InOperation);
            ATLog.e((String)this.TAG, (String)"ERROR. assertAction() - Failed to in operation%s", (Object[])new Object[]{data == null ? "" : String.format(Locale.US, " [%s]", Dump.dump((byte[])data))});
            throw new ATException(this.mReader.getLastError());
        }
    }

    protected void setException(ATException e) {
        this.mReader.setLastError(e.getCode());
        this.mReader.checkError();
    }

    public void PumpEvent(int event, byte[] data) {
        if (this.mModule == null) {
            return;
        }
        this.mModule.PumpEvent(event, data);
    }

    protected byte[] getBytes(BarcodeType[] names) {
        return this.getBytes(names, 0, names.length);
    }

    protected byte[] getBytes(BarcodeType[] names, int length) {
        return this.getBytes(names, 0, length);
    }

    protected abstract byte[] getBytes(BarcodeType[] var1, int var2, int var3);

    protected abstract byte[] getBytes(BarcodeType[] var1, boolean[] var2, int var3, int var4);

    protected abstract byte[] getBytes(BarcodeType[] var1, boolean var2, int var3, int var4);

    protected byte[] getBytes(SymbolStateList list) {
        return this.getBytes(list, 0, list.getCount());
    }

    protected byte[] getBytes(SymbolStateList list, int length) {
        return this.getBytes(list, 0, length);
    }

    protected abstract byte[] getBytes(SymbolStateList var1, int var2, int var3);

    protected abstract SymbolStateList getSymbolState(byte[] var1);

    protected String getString(BarcodeType[] names) {
        StringBuilder builder = new StringBuilder();
        BarcodeType[] barcodeTypeArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            BarcodeType name = barcodeTypeArray[n2];
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(name.toString());
            ++n2;
        }
        return builder.toString();
    }
}

