/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.module.barcode.ssi.param;

import com.atid.lib.diagnostics.ATException;
import com.atid.lib.module.barcode.ssi.param.SSI2DParamName;
import com.atid.lib.types.ResultCode;
import com.atid.lib.util.diagnotics.ATLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class SSI2DParamNameList {
    private static final String TAG = SSI2DParamNameList.class.getSimpleName();
    private ArrayList<SSI2DParamName> mList = new ArrayList();

    public SSI2DParamNameList() {
    }

    public SSI2DParamNameList(SSI2DParamName item) {
        this.add(item);
    }

    public SSI2DParamNameList(SSI2DParamName[] items) {
        this.add(items);
    }

    public synchronized int getCount() {
        return this.mList.size();
    }

    public synchronized boolean add(SSI2DParamName item) {
        if (item == null) {
            ATLog.e((String)TAG, (String)"ERROR. add(item) - Invalid parameter");
            return false;
        }
        return this.mList.add(item);
    }

    public synchronized boolean add(SSI2DParamName[] items) {
        boolean result = true;
        if (items == null) {
            ATLog.e((String)TAG, (String)"ERROR. add(item) - Invalid parameter");
            return false;
        }
        SSI2DParamName[] sSI2DParamNameArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            SSI2DParamName item = sSI2DParamNameArray[n2];
            result &= this.mList.add(item);
            ++n2;
        }
        return result;
    }

    public byte[] getBytes(int engine) throws ATException {
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        if (this.mList == null || this.mList.size() == 0) {
            ATLog.e((String)TAG, (String)"ERROR. Parameter is null or zero !!!");
            throw new ATException(ResultCode.InvalidParameter);
        }
        for (SSI2DParamName item : this.mList) {
            try {
                writer.write(item.getCommand());
            }
            catch (IOException e) {
                ATLog.e((String)TAG, (String)"ERROR. getBytes() - Failed to write %s parameter name", (Object[])new Object[]{item.toString()});
            }
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            ATLog.e((String)TAG, (String)"ERROR. getBytes() - Failed to flush parameter");
            return null;
        }
        byte[] data = writer.toByteArray();
        try {
            writer.close();
        }
        catch (IOException e) {
            ATLog.e((String)TAG, (String)"ERROR. getBytes() - Failed to close parameter");
            return null;
        }
        return data;
    }
}

