/*
 * Decompiled with CFR 0.152.
 */
package com.atid.lib.reader.params;

public class NotifyMethod {
    public static final int BEEP = 0;
    public static final int VIBRATE = 1;
    public static final int LIGHT = 2;
    public static final int MAX_METHOD = 3;
    private final String[] mNames = new String[]{"Beep", "Vibrate", "Light"};
    private boolean[] mIsMethods;

    public NotifyMethod() {
        this.mIsMethods = new boolean[3];
    }

    public NotifyMethod(boolean beep, boolean vibrate, boolean light) {
        this.mIsMethods = new boolean[]{beep, vibrate, light};
    }

    public NotifyMethod(int value) {
        this.mIsMethods = new boolean[3];
        this.setValue(value);
    }

    public String getName(int index) {
        return this.mNames[index];
    }

    public boolean getMethod(int index) {
        return this.mIsMethods[index];
    }

    public void setMethods(int index, boolean enabled) {
        this.mIsMethods[index] = enabled;
    }

    public int getValue() {
        int value = 0;
        int i = 0;
        while (i < 3) {
            if (this.mIsMethods[i]) {
                value += 1 << i;
            }
            ++i;
        }
        return value;
    }

    public void setValue(int value) {
        int i = 0;
        while (i < 3) {
            this.mIsMethods[i] = (value & 1 << i) > 0;
            ++i;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < 3) {
            if (this.mIsMethods[i]) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(this.mNames[i]);
            }
            ++i;
        }
        return builder.toString();
    }
}

