//
//  EADeviceBluetooth.h
//  EARfidFramework
//
//  Created by ATID 
//  Copyright © 2016년 Alluser.net Corp. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <ExternalAccessory/ExternalAccessory.h>
#import <EARfidFramework/EARfidFramework.h>

extern NSString *EADSessionDataReceivedNotification;

@interface EADeviceBluetooth : EADevice<EAAccessoryDelegate, NSStreamDelegate> {
    //EAAccessory *_accessory;
    //EASession *_session;
    //NSString *_protocolString;
    
    NSMutableData *_writeData;
    NSMutableData *_readData;
    
    id<EADeviceInitializeDelegate> mInitCallback;
}

+ (EADeviceBluetooth *)sharedController;

- (void)setupControllerForAccessory:(EAAccessory *)accessory withProtocolString:(NSString *)protocolString delegate:(id<EADeviceInitializeDelegate>)callback;
- (BOOL)openSession;
- (void)disconnect;
- (NSString *)name;
- (NSString *)address;
- (void)writeData:(NSData *)data;

- (NSUInteger)readBytesAvailable;
- (NSData *)readData:(NSUInteger)bytesToRead;

@property (nonatomic, strong) EASession *session;
@property (nonatomic, strong) EAAccessory *accessory;
@property (nonatomic, strong) NSString *protocolString;
@property (weak, nonatomic) id<EADeviceReadDataDelegate> delegate;

@end


