package com.atid.app.atx.usb.inventory.barcode.data;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;

import com.atid.lib.types.DeviceType;
import com.atid.lib.util.diagnotics.ATLog;

import android.content.Context;
import android.content.SharedPreferences;

public class GlobalData {

	private static final String TAG = GlobalData.class.getSimpleName();
	private static final int INFO = ATLog.L2;
	
	public static final String KEY_BARCODE_CHARSET = "barcode charset";
	
	private static final String DEFAULT_VALUE_BARCODE_CHARSET = Charset.defaultCharset().name();

	
	// ------------------------------------------------------------------------
	// Global Data
	// ------------------------------------------------------------------------
	
	private static Charset BarcodeCharset = Charset.forName(DEFAULT_VALUE_BARCODE_CHARSET);
	
	private static HashMap<String, Object> mMap = new HashMap<String, Object>();
	
	// ------------------------------------------------------------------------
	// Load/Save Configuration
	// ------------------------------------------------------------------------

	private static Object getData(String key){
		Object item = null;
				
		if(key == null) {
			ATLog.e(TAG, "ERROR. getData() - Key is null !!!");
			return item;
		}
		synchronized(mMap){
			if(mMap.get(key) != null)
				item = mMap.get(key);
			else {
				ATLog.e(TAG, "ERROR. getData(%s) - Not Found data !!!", key);
			}
		}
		return item;
	}

	private static void removeData(String key){
				
		synchronized(mMap){
			if( mMap.get(key) != null ) {
				mMap.remove(key);
			} else {
				ATLog.e(TAG, "ERROR. removeData(%s) - Not Found data !!!", key);
			}

		}
	}

	private static void putData(String key, Object value){

		synchronized(mMap){
			
			if( key != null && value != null)
				mMap.put(key, value);
			else
				ATLog.e(TAG, "ERROR. putData() - Key or Value is null !!!");
		}
	}

	public static synchronized Object getConfig(Context context, DeviceType device, String address, String key) throws Exception{
		
		//String pakageName = context.getPackageName();
		//SharedPreferences prefs = context.getSharedPreferences(pakageName, Context.MODE_PRIVATE);
		
		String name = String.format(Locale.US, "%d%s%s", device.getCode(), address.toString(), key.toString());
		Object data = getData(name);
		if(data == null){
			if(key.compareToIgnoreCase(KEY_BARCODE_CHARSET) == 0) {
				BarcodeCharset = Charset.forName(DEFAULT_VALUE_BARCODE_CHARSET);
				putData(name, BarcodeCharset);
			} else {
				ATLog.e(TAG, "ERROR. getConfig(%s, %s, %s) - Unknown Key",
						device.toString(), address, key);
			}
		}
		return data;
	}

	public static synchronized void putConfig(DeviceType device, String address, String key , Object value){
		if(value == null) {
			ATLog.e(TAG, "ERROR. putConfig() - Value is null !!!");
			return;
		}
		String name = String.format(Locale.US, "%d%s%s", device.getCode(), address, key);
		putData(name, value);
	}

	// Load Config
	public static synchronized void loadConfig(Context context, DeviceType device , String address) {
		String key = null;
		String pakageName = context.getPackageName();
		SharedPreferences prefs = context.getSharedPreferences(pakageName, Context.MODE_PRIVATE);
		
		if(address == null) {
			ATLog.e(TAG, "ERROR. MAC address is null !!!");
			return;
		}
		
		key = String.format(Locale.US, "%d%s%s", device.getCode(), address, KEY_BARCODE_CHARSET);
		String charSetName = prefs.getString(key, Charset.defaultCharset().name());
		BarcodeCharset = Charset.forName(charSetName);
		putData(key, BarcodeCharset);
		ATLog.i(TAG, INFO, "INFO. loadConfig() - DeviceType[%s] Address [%s] Barcode Character Set : %s", 
				device.toString(), address, BarcodeCharset.name());
		
		ATLog.i(TAG, INFO, "INFO. loadConfig()");
	}

	// Remove Config
	public static synchronized boolean removeConfig(Context context, DeviceType device , String address) {
		boolean result = true;
		
		String key = null;
		String pakageName = context.getPackageName();
		SharedPreferences prefs = context.getSharedPreferences(pakageName, Context.MODE_PRIVATE);
		SharedPreferences.Editor editor = prefs.edit();
		
		key = String.format(Locale.US, "%d%s%s", device.getCode(), address, KEY_BARCODE_CHARSET);
		removeData(key);
		editor.remove(key);
		ATLog.i(TAG, INFO, "INFO. removeConfig() - DeviceType[%s] Address [%s] Barcode Character Set : %s", 
				device.toString(), address, KEY_BARCODE_CHARSET);
		
		result = editor.commit();
		ATLog.i(TAG, INFO, "INFO. removeConfig() - [%s]", result);
		return result;
	}

	
	// Save Config
	public static synchronized boolean saveConfig(Context context, DeviceType device , String address) {
		boolean result = true;
		Object item = null;
		
		String key = null;
		String pakageName = context.getPackageName();
		SharedPreferences prefs = context.getSharedPreferences(pakageName, Context.MODE_PRIVATE);
		SharedPreferences.Editor editor = prefs.edit();
		
		key = String.format(Locale.US, "%d%s%s", device.getCode(), address, KEY_BARCODE_CHARSET);
		item = getData(key);
		if(item != null){
			BarcodeCharset = (Charset)getData(key);	
		} else {
			BarcodeCharset = Charset.forName(DEFAULT_VALUE_BARCODE_CHARSET);
		}
		editor.putString(key, BarcodeCharset.name());
		ATLog.i(TAG, INFO, "INFO. saveConfig() - DeviceType[%s] Address [%s] Barcode Character Set : %s", 
				device.toString(), address, BarcodeCharset.name());
		
		result = editor.commit();
		ATLog.i(TAG, INFO, "INFO. saveConfig() - [%s]", result);
		return result;
	}
}
