//
//  SymbolSettingViewController.swift
//  
//
//  Created by 류은주 on 2018. 2. 14..
//
let PICKER_VIEW_UPCA_COUPON = 0
let PICKER_VIEW_CODE39_CHECKCHAR = 1
let PICKER_VIEW_CODABAR_CHECKCHAR = 2
let PICKER_VIEW_CODABAR_CONCATENATION = 3
let PICKER_VIEW_MSI_CHECKCHAR = 4
let PICKER_VIEW_2D = 5
let PICKER_VIEW_AUSTRALIAN = 6

import UIKit

class SymbolSettingViewController: UIViewController, UITableViewDataSource, UITableViewDelegate, UIPickerViewDelegate, UIPickerViewDataSource, EAReaderDelegate {
  
    @IBOutlet weak var symbolTableView: UITableView!
    @IBOutlet weak var symbolSettingPickerView: UIPickerView!
    @IBOutlet weak var pickerViewTopView: UIView!
    
    var appDelegate = UIApplication.shared.delegate as! AppDelegate
    var devicetype = 0
    
    var picker_upcaCoupon : NSArray?
    var picker_code39_checkchar : NSArray?
    var picker_codabar_checkchar : NSArray?
    var picker_codabar_concatemation : NSArray?
    var picker_msi_checkchar : NSArray?
    var picker_2D : NSArray?
    var picker_Australian_Post : NSArray?
    
    var selectedSymbol: Int?
    var symbolParamData : NSArray?
    
    var topviewflag = 0
    
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        let center = NotificationCenter.default
        center.addObserver(self, selector: #selector(self.bluetoothDisconnected), name: NSNotification.Name.init(rawValue: "BluetoothDisconnected"), object: nil)
        
        if (appDelegate.mReader?.barcodedeviceget() == 0) || (appDelegate.mReader?.barcodedeviceget() == 2) {
            devicetype = 0
        }
        else {
            devicetype = 1
        }
        
        picker_upcaCoupon = ["Off", "Allow Concatenation", "Require Concatenation"]
        picker_code39_checkchar = ["No Check Character", "Validate, but Don’t Transmit", "Validate and Transmit"]
        picker_codabar_checkchar = ["No Check Character", "Validate Modulo 16, but Don’t Transmit", "Validate Modulo 16 and Transmit"]
        picker_codabar_concatemation = ["Off", "On", "Require"]
        picker_msi_checkchar = ["Validate Type 10, but Don’t Transmit", "Validate Type 10 and Transmit", "Validate 2 Type 10 Characters, but Don’t Transmit", "Validate 2 Type 10 Characters and Transmit", "Validate Type 10 then Type 11 Character, but Don’t Transmit", "Validate Type 10 then Type 11 Character and Transmit", "Disable MSI Check Characters"]
        picker_2D = ["Off", "Australian Post On", "InfoMail On", "Japanese Post On", "KIX Post On", "Planet Code On", "Postnet On", "British Post On", "InfoMail and British Post On", "Postal-4i On", "Intelligent Mail Bar Code On", "Postnet with B and B’ Fields On", "Planet and Postnet On", "Planet and Postal-4i On", "Postnet and Postal-4i On", "Planet and Intelligent Mail Bar Code On", "Postnet and Intelligent Mail Bar Code On", "Postal-4i and Intelligent Mail Bar Code On", "Planet and Postnet with B and B’ Fields On", "Postal-4i and Postnet with B and B’ Fields On", "Intelligent Mail Bar Code and Postnet with B and B’ Fields On", "Planet, Postnet, and Postal-4i On", "Planet, Postnet, and Intelligent Mail Bar Code On", "Planet, Postal-4i, and Intelligent Mail Bar Code On", "Postnet, Postal-4i, and Intelligent Mail Bar Code On", "Planet, Postal-4i, and Postnet with B and B’ Fields On", "Planet, Intelligent Mail Bar Code, and Postnet with B and B’ Fields On", "Postal-4i, Intelligent Mail Bar Code, and Postnet with B and B’ Fields On", "Planet, Postal-4i, Intelligent Mail Bar Code, and Postnet On", "Planet, Postal-4i, Intelligent Mail Bar Code, and Postnet with B and B’ Fields On", "Canadian Post On"]
        picker_Australian_Post = ["Bar Output", "Numeric N Table", "Alphanumeric C Table", "Combination N and C Tables"]


    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        var paramData = [Any]()
        if selectedSymbol == 0 {
            paramData = [UPCACheckDigit.rawValue, UPCANumberSystem.rawValue, UPCA2DigitAdd.rawValue, UPCA5DigitAdd.rawValue, UPCAAddReq.rawValue, UPCAAddSep.rawValue, UPCACouponCode.rawValue, CouponGS1DataBarOutput.rawValue]
        }
        else if selectedSymbol == 1 {
            paramData = [UPCE0Expand.rawValue, UPCE0AddReq.rawValue, UPCE0AddSep.rawValue, UPCE0CheckDigit.rawValue, UPCE0NumberSystem.rawValue,UPCE02DigitAdd.rawValue, UPCE05DigitAdd.rawValue]
        }
        else if selectedSymbol == 3 {
            paramData = [EAN8CheckDigit.rawValue, EAN82DigitAdd.rawValue, EAN85DigitAdd.rawValue, EAN8AddReq.rawValue, EAN8AddSep.rawValue]
        }
        else if selectedSymbol == 4 {
            paramData = [ConvertUPCAtoEAN13.rawValue, EAN13CheckDigit.rawValue, EAN132DigitAdd.rawValue, EAN135DigitAdd.rawValue, EAN13AddReq.rawValue, EAN13AddSep.rawValue]
        }
        else if selectedSymbol == 5 {
            paramData = [IsbtConcatenation.rawValue, Code128LengthMin.rawValue, Code128LengthMax.rawValue, Code128Append.rawValue, Code128CodePage.rawValue]
        }
        else if selectedSymbol == 6 {
            paramData = [Code39StartStopChar.rawValue, Code39CheckChar.rawValue, Code39LengthMin.rawValue, Code39LengthMax.rawValue, Code39Append.rawValue, Code39FullAscii.rawValue, Code39CodePage.rawValue]
        }
        else if selectedSymbol == 8 {
            paramData = [Code93LengthMin.rawValue, Code93LengthMax.rawValue, Code93Append.rawValue, Code93CodePage.rawValue]
        }
        else if selectedSymbol == 9 {
            paramData = [Code11CheckDigit.rawValue, Code11LengthMin.rawValue, Code11LengthMax.rawValue]
        }
        else if selectedSymbol == 10 {
            paramData = [I2of5CheckDigit.rawValue, I2of5LengthMin.rawValue, I2of5LengthMax.rawValue]
        }
        else if selectedSymbol == 11 {
            paramData = [CodabarStartStopChar.rawValue, CodabarCheckChar.rawValue, CodabarConcatenation.rawValue, CodabarLengthMin.rawValue, CodabarLengthMax.rawValue]
        }
        else if selectedSymbol == 13 {
            paramData = [MSICheckChar.rawValue, MSILengthMin.rawValue, MSILengthMax.rawValue]
        }
        else if selectedSymbol == 14 {
            paramData = [X2of5LengthMin.rawValue, X2of5LengthMax.rawValue]
        } else if selectedSymbol == 15 {
            paramData = [PDF417LengthMin.rawValue, PDF417LengthMax.rawValue]
        }
        else if selectedSymbol == 17 {
            paramData = [MicroPDFLengthMin.rawValue, MicroPDFLengthMax.rawValue]
        }
        else if selectedSymbol == 18 {
            paramData = [MatrixLengthMin.rawValue, MatrixLengthMax.rawValue, MatrixAppend.rawValue, MatrixCodePage.rawValue]
        }
        else if selectedSymbol == 19 {
            paramData = [MaxiCodeLengthMin.rawValue, MaxiCodeLengthMax.rawValue]
        }
        else if selectedSymbol == 20 {
            paramData = [QRCodeLengthMin.rawValue, QRCodeLengthMax.rawValue, QRCodeAppend.rawValue, QRCodePage.rawValue]
        }
        else if selectedSymbol == 21 {
            paramData = [AztecCodeLengthMin.rawValue, AztecCodeLengthMax.rawValue, AztecAppend.rawValue, AztecCodePage.rawValue]
        }
        else if selectedSymbol == 22 {
            paramData = [NEC2of5CheckDigit.rawValue, NEC2of5LengthMin.rawValue, NEC2of5LengthMax.rawValue]
        }
        else if selectedSymbol == 23 {
            paramData = [R2of5LengthMin.rawValue, R2of5LengthMax.rawValue]
        }
        else if selectedSymbol == 24 {
            paramData = [A2of5LengthMin.rawValue, A2of5LengthMax.rawValue]
        } else if selectedSymbol == 25 {
            paramData = [GS1128LengthMin.rawValue, GS1128LengthMax.rawValue]
        }
        else if selectedSymbol == 28 {
            paramData = [RSSExpLengthMin.rawValue, RSSExpLengthMax.rawValue]
        }
        else if selectedSymbol == 29 {
            paramData = [CodablockALengthMin.rawValue, CodablockALengthMax.rawValue]
        }
        else if selectedSymbol == 30 {
            paramData = [CodablockFLengthMin.rawValue, CodablockFLengthMax.rawValue]
        }
        else if selectedSymbol == 31 {
            paramData = [UPCEANVersion.rawValue, ComCodeLengthMin.rawValue, ComCodeLengthMax.rawValue]
        }
        else if selectedSymbol == 33 {
            paramData = [ChinaPostLengthMin.rawValue, ChinaPostLengthMax.rawValue]
        }
        else if selectedSymbol == 34 {
            paramData = [KoreaPostLengthMin.rawValue, KoreaPostLengthMax.rawValue, KoreaPostCheckDigit.rawValue]
        }
        else if selectedSymbol == 35 {
            paramData = [PostalCodes.rawValue, PlanetCodeCheckDigit.rawValue, PostnetCheckDigit.rawValue, AustralianPostInterpretation.rawValue]
        }
        else if selectedSymbol == 36 {
            paramData = [HanXinCodeLengthMin.rawValue, HanXinCodeLengthMax.rawValue]
        }
        symbolParamData = self.appDelegate.mReader?.getBarcodeParam(paramData)! as NSArray?
    }

    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        NotificationCenter.default.removeObserver(self, name: NSNotification.Name(rawValue: "BluetoothDisconnected"), object: nil)
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    

    /*
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    */
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        print("symbolParamData!.count \(symbolParamData!.count)")
        return symbolParamData!.count
        
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell : SymbolSettingTableViewCell = tableView.dequeueReusableCell(withIdentifier: "SymbolCell", for: indexPath) as! SymbolSettingTableViewCell

        let paramValue = symbolParamData![indexPath.row] as? EAParamValue
        cell.symbolItem.text = EAParamName.getName((paramValue?.paramName)!)
       
        if selectedSymbol == 0 {
            if (indexPath.row >= 0) && (indexPath.row < 4) || (indexPath.row == 5) {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                }
                else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
            else if indexPath.row == 4 {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Not Required"
                }
                else {
                    cell.symbolItemValue.text = "Required"
                }
            }
            else if indexPath.row == 6 {
                cell.symbolItemValue.text = picker_upcaCoupon?[Int(paramValue!.value)] as? String
            }
            else if indexPath.row == 7 {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "GS1 Output Off"
                }
                else {
                    cell.symbolItemValue.text = "GS1 Output On"
                }
            }
        }else if selectedSymbol == 1 {
            if indexPath.row == 1 {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Not Required"
                }
                else {
                    cell.symbolItemValue.text = "Required"
                }
            }
            else {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                }
                else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
        }else if selectedSymbol == 3 {
            if indexPath.row == 3 {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Not Required"
                }
                else {
                    cell.symbolItemValue.text = "Required"
                }
            }
            else {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                }
                else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
        }
        else if selectedSymbol == 4 {
            if indexPath.row == 4 {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Not Required"
                }
                else {
                    cell.symbolItemValue.text = "Required"
                }
            }
            else {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                }
                else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
        } else if (selectedSymbol == 5) || (selectedSymbol == 31) {
            if (indexPath.row == 0) || (indexPath.row == 3) {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                }
                else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
            else {
                cell.symbolItemValue.text = "\(String(describing: paramValue!.value))"
            }
        }else if selectedSymbol == 6 {
            if indexPath.row == 0 {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Don't Transmit"
                }
                else {
                    cell.symbolItemValue.text = "Transmit"
                }
            }
            else if indexPath.row == 1 {
                cell.symbolItemValue.text = picker_code39_checkchar?[Int(paramValue!.value)] as? String
            }
            else if (indexPath.row == 4) || (indexPath.row == 5) {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                }
                else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
            else {
                cell.symbolItemValue.text = "\(String(describing: paramValue!.value))"
            }
        }else if (selectedSymbol == 8) || (selectedSymbol == 34) {
            if indexPath.row == 2 {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                }
                else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
            else {
                cell.symbolItemValue.text = "\(String(describing: paramValue!.value))"
            }
        }
        else if selectedSymbol == 9 {
            if indexPath.row == 0 {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "One Check Digit"
                }
                else {
                    cell.symbolItemValue.text = "Two Check Digits"
                }
            }
            else {
                cell.symbolItemValue.text = "\(String(describing: paramValue!.value))"
            }
        }else if (selectedSymbol == 10) || (selectedSymbol == 22) {
            if indexPath.row == 0 {
                cell.symbolItemValue.text = picker_code39_checkchar?[Int(paramValue!.value)] as? String
            }
            else {
                cell.symbolItemValue.text = "\(String(describing: paramValue!.value))"
            }
        }
        else if selectedSymbol == 11 {
            if indexPath.row == 0 {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Don’t Transmit"
                }
                else {
                    cell.symbolItemValue.text = "Transmit"
                }
            }
            else if indexPath.row == 1 {
                cell.symbolItemValue.text = picker_codabar_checkchar?[Int(paramValue!.value)] as? String
            }
            else if indexPath.row == 2 {
                cell.symbolItemValue.text = picker_codabar_concatemation?[Int(paramValue!.value)] as? String
            }
            else {
                cell.symbolItemValue.text = "\(String(describing: paramValue!.value))"
            }
        }else if selectedSymbol == 13 {
            if indexPath.row == 0 {
                cell.symbolItemValue.text = picker_msi_checkchar?[Int(paramValue!.value)] as? String
            }
            else {
                cell.symbolItemValue.text = "\(String(describing: paramValue!.value))"
            }
        }
        else if (selectedSymbol == 14) || (selectedSymbol == 15) || (selectedSymbol == 17) || (selectedSymbol == 19) || (selectedSymbol == 23) || (selectedSymbol == 24) || (selectedSymbol == 25) || (selectedSymbol == 28) || (selectedSymbol == 29) || (selectedSymbol == 30) || (selectedSymbol == 33) || (selectedSymbol == 36) {
            cell.symbolItemValue.text = "\(String(describing: paramValue!.value))"
        }else if (selectedSymbol == 18) || (selectedSymbol == 20) || (selectedSymbol == 21) {
            if indexPath.row == 2 {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Disable"
                }
                else {
                    cell.symbolItemValue.text = "Enable"
                }
            }
            else {
                cell.symbolItemValue.text = "\(String(describing: paramValue!.value))"
            }
        }
        else if selectedSymbol == 35 {
            if (indexPath.row == 1) || (indexPath.row == 2) {
                if paramValue?.value == 0 {
                    cell.symbolItemValue.text = "Don’t Transmit"
                }
                else {
                    cell.symbolItemValue.text = "Transmit"
                }
            }
            else if indexPath.row == 0 {
                cell.symbolItemValue.text = picker_2D?[Int(paramValue!.value)] as? String
            }
            else if indexPath.row == 3 {
                cell.symbolItemValue.text = picker_Australian_Post?[Int(paramValue!.value)] as? String
            }
        }
        
        return cell
    }

    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
           let paramValue = symbolParamData![indexPath.row] as? EAParamValue
        if selectedSymbol == 0 {
            if indexPath.row == 6 {
//                let paramValue = symbolParamData![indexPath.row] as? EAParamValue
                symbolSettingPickerView.tag = PICKER_VIEW_UPCA_COUPON
                topviewflag = indexPath.row
                symbolSettingPickerView.reloadAllComponents()
                symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
                symbolSettingPickerView.isHidden = false
                pickerViewTopView.isHidden = false
            }
            else if (indexPath.row >= 0) && (indexPath.row < 6) || (indexPath.row == 7) {
//                let paramValue = symbolParamData![indexPath.row] as? EAParamValue
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                }
                else {
                    paramValue?.value = 0
                }
            }
        } else if (selectedSymbol! > 0) && (selectedSymbol! < 5) {
//            let paramValue = symbolParamData![indexPath.row] as? EAParamValue
            if paramValue?.value == 0 {
                paramValue?.value = 1
            }
            else {
                paramValue?.value = 0
            }
        } else if (selectedSymbol == 5) || (selectedSymbol == 31) {
//            var paramValue = symbolParamData![indexPath.row] as? EAParamValue
            if (indexPath.row == 0) || (indexPath.row == 3) {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                }
                else {
                    paramValue?.value = 0
                }
            } else {
//                var alert: UIAlertView?
                if selectedSymbol == 5 {
//                    alert = UIAlertView(title: "Code 128:", message: "Please enter a number to set", delegate: self, cancelButtonTitle: "Cancel", otherButtonTitles: "")
//
                    let alert = UIAlertController(title: "Code 128:", message: "Please enter a number to set", preferredStyle: .alert)
                    alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                        textField.keyboardType = .numberPad
                    })
                    let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        let textField: UITextField? = alert.textFields?.first
                        var paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                        paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                        self.symbolTableView.reloadData()
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    alert.addAction(cancel)
                    alert.addAction(ok)
                    
                    DispatchQueue.main.async(execute: {() -> Void in
                        self.present(alert, animated: true) {() -> Void in }
                    })
                }else if selectedSymbol == 31 {
                    let alert = UIAlertController(title: "EAN/UCC Composite Code:", message: "Please enter a number to set(1~2435)", preferredStyle: .alert)
                    alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                        textField.keyboardType = .numberPad
                    })
                    let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        let textField: UITextField? = alert.textFields?.first
                        var paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                        paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                        self.symbolTableView.reloadData()
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    alert.addAction(cancel)
                    alert.addAction(ok)
                    
                    DispatchQueue.main.async(execute: {() -> Void in
                        self.present(alert, animated: true) {() -> Void in }
                    })
                }
            }
        }else if selectedSymbol == 6 {
//            let paramValue = symbolParamData![indexPath.row] as? EAParamValue
            if (indexPath.row == 0) || (indexPath.row == 4) || (indexPath.row == 5) {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                }
                else {
                    paramValue?.value = 0
                }
            } else if indexPath.row == 1 {
                symbolSettingPickerView.tag = PICKER_VIEW_CODE39_CHECKCHAR
                topviewflag = indexPath.row
                symbolSettingPickerView.reloadAllComponents()
                symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
                symbolSettingPickerView.isHidden = false
                pickerViewTopView.isHidden = false
            } else {
                let alert = UIAlertController(title: "Code 39:", message: "Please enter a number to set", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            }
        } else if (selectedSymbol == 8) || (selectedSymbol == 34) {
//            let paramValue = symbolParamData![indexPath.row] as? EAParamValue
            if indexPath.row == 2 {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                }
                else {
                    paramValue?.value = 0
                }
            } else {
                if selectedSymbol == 8 {
                    let alert = UIAlertController(title: "Code 93:", message: "Please enter a number to set", preferredStyle: .alert)
                    alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                        textField.keyboardType = .numberPad
                    })
                    let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        let textField: UITextField? = alert.textFields?.first
                        let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                        paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                        self.symbolTableView.reloadData()
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    alert.addAction(cancel)
                    alert.addAction(ok)
                    
                    DispatchQueue.main.async(execute: {() -> Void in
                        self.present(alert, animated: true) {() -> Void in }
                    })
                } else if selectedSymbol == 34 {
                    let alert = UIAlertController(title: "Korea Post:", message: "Please enter a number to set(2~80)", preferredStyle: .alert)
                    alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                        textField.keyboardType = .numberPad
                    })
                    let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        let textField: UITextField? = alert.textFields?.first
                        let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                        paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                        self.symbolTableView.reloadData()
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    alert.addAction(cancel)
                    alert.addAction(ok)
                    
                    DispatchQueue.main.async(execute: {() -> Void in
                        self.present(alert, animated: true) {() -> Void in }
                    })
                }
            }
        } else if selectedSymbol == 9 {
            if indexPath.row == 0 {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                }
                else {
                    paramValue?.value = 0
                }
            }
            else {
                let alert = UIAlertController(title: "Code 11:", message: "Please enter a number to set(1~80)", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            }
        } else if (selectedSymbol == 10) || (selectedSymbol == 22) {
            if indexPath.row == 0 {
                symbolSettingPickerView.tag = PICKER_VIEW_CODE39_CHECKCHAR
                topviewflag = indexPath.row
                symbolSettingPickerView.reloadAllComponents()
                symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
                symbolSettingPickerView.isHidden = false
                pickerViewTopView.isHidden = false
            }
            else {
                if selectedSymbol == 10 {
                    let alert = UIAlertController(title: "Interleaved 2 of 5:", message: "Please enter a number to set(2~80)", preferredStyle: .alert)
                    alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                        textField.keyboardType = .numberPad
                    })
                    let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        let textField: UITextField? = alert.textFields?.first
                        let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                        paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                        self.symbolTableView.reloadData()
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    alert.addAction(cancel)
                    alert.addAction(ok)
                    
                    DispatchQueue.main.async(execute: {() -> Void in
                        self.present(alert, animated: true) {() -> Void in }
                    })
                } else if selectedSymbol == 22 {
                    let alert = UIAlertController(title: "NEC 2 of 5:", message: "Please enter a number to set(2~80)", preferredStyle: .alert)
                    alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                        textField.keyboardType = .numberPad
                    })
                    let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        let textField: UITextField? = alert.textFields?.first
                        let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                        paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                        self.symbolTableView.reloadData()
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    alert.addAction(cancel)
                    alert.addAction(ok)
                    
                    DispatchQueue.main.async(execute: {() -> Void in
                        self.present(alert, animated: true) {() -> Void in }
                    })
                }
            }
        }else if selectedSymbol == 11 {
            if indexPath.row == 0 {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                }
                else {
                    paramValue?.value = 0
                }
            } else if indexPath.row == 1 {
                symbolSettingPickerView.tag = PICKER_VIEW_CODABAR_CHECKCHAR
                topviewflag = indexPath.row
                symbolSettingPickerView.reloadAllComponents()
                symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
                symbolSettingPickerView.isHidden = false
                pickerViewTopView.isHidden = false
            } else  if indexPath.row == 2 {
                symbolSettingPickerView.tag = PICKER_VIEW_CODABAR_CONCATENATION
                topviewflag = indexPath.row
                symbolSettingPickerView.reloadAllComponents()
                symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
                symbolSettingPickerView.isHidden = false
                pickerViewTopView.isHidden = false
            } else {
                let alert = UIAlertController(title: "Codabar:", message: "Please enter a number to set(2~60)", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            }
        } else if selectedSymbol == 13 {
            if indexPath.row == 0 {
                symbolSettingPickerView.tag = PICKER_VIEW_MSI_CHECKCHAR
                topviewflag = indexPath.row
                symbolSettingPickerView.reloadAllComponents()
                symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
                symbolSettingPickerView.isHidden = false
                pickerViewTopView.isHidden = false
            } else {
                let alert = UIAlertController(title: "MSI:", message: "Please enter a number to set(4~48)", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            }
        } else if selectedSymbol == 14 {
            let alert = UIAlertController(title: "Matrix 2 of 5:", message: "Please enter a number to set(1~80)", preferredStyle: .alert)
            alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                textField.keyboardType = .numberPad
            })
            let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                let textField: UITextField? = alert.textFields?.first
                let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                self.symbolTableView.reloadData()
                alert.dismiss(animated: true) {() -> Void in }
            })
            let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                alert.dismiss(animated: true) {() -> Void in }
            })
            alert.addAction(cancel)
            alert.addAction(ok)
            
            DispatchQueue.main.async(execute: {() -> Void in
                self.present(alert, animated: true) {() -> Void in }
            })
        } else if selectedSymbol == 15 {
            let alert = UIAlertController(title: "PDF417:", message: "Please enter a number to set(1~2750)", preferredStyle: .alert)
            alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                textField.keyboardType = .numberPad
            })
            let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                let textField: UITextField? = alert.textFields?.first
                let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                self.symbolTableView.reloadData()
                alert.dismiss(animated: true) {() -> Void in }
            })
            let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                alert.dismiss(animated: true) {() -> Void in }
            })
            alert.addAction(cancel)
            alert.addAction(ok)
            
            DispatchQueue.main.async(execute: {() -> Void in
                self.present(alert, animated: true) {() -> Void in }
            })
        } else if selectedSymbol == 17 {
            let alert = UIAlertController(title: "MicroPDF417:", message: "Please enter a number to set(1~366)", preferredStyle: .alert)
            alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                textField.keyboardType = .numberPad
            })
            let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                let textField: UITextField? = alert.textFields?.first
                let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                self.symbolTableView.reloadData()
                alert.dismiss(animated: true) {() -> Void in }
            })
            let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                alert.dismiss(animated: true) {() -> Void in }
            })
            alert.addAction(cancel)
            alert.addAction(ok)
            
            DispatchQueue.main.async(execute: {() -> Void in
                self.present(alert, animated: true) {() -> Void in }
            })
        } else if selectedSymbol == 18 {
            if indexPath.row == 2 {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                }
                else {
                    paramValue?.value = 0
                }
            } else {
                if indexPath.row == 3 {
                    let alert = UIAlertController(title: "Data Matrix:", message: "Please enter a number to set", preferredStyle: .alert)
                    alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                        textField.keyboardType = .numberPad
                    })
                    let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        let textField: UITextField? = alert.textFields?.first
                        let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                        paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                        self.symbolTableView.reloadData()
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    alert.addAction(cancel)
                    alert.addAction(ok)
                    
                    DispatchQueue.main.async(execute: {() -> Void in
                        self.present(alert, animated: true) {() -> Void in }
                    })
                }
                else {
                    let alert = UIAlertController(title: "Data Matrix:", message: "Please enter a number to set(1~3116)", preferredStyle: .alert)
                    alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                        textField.keyboardType = .numberPad
                    })
                    let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        let textField: UITextField? = alert.textFields?.first
                        let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                        paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                        self.symbolTableView.reloadData()
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    alert.addAction(cancel)
                    alert.addAction(ok)
                    
                    DispatchQueue.main.async(execute: {() -> Void in
                        self.present(alert, animated: true) {() -> Void in }
                    })
                }
            }
        } else if (selectedSymbol == 19) || (selectedSymbol == 23) || (selectedSymbol == 24) || (selectedSymbol == 25) || (selectedSymbol == 28) || (selectedSymbol == 29) || (selectedSymbol == 30) || (selectedSymbol == 33) || (selectedSymbol == 36) {
            if selectedSymbol == 19 {
                let alert = UIAlertController(title: "Maxi Code:", message: "Please enter a number to set(1~150)", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            } else if selectedSymbol == 23 {
                let alert = UIAlertController(title: "Straight 2 of 5 Industrial:", message: "Please enter a number to set(1~48)", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            } else if selectedSymbol == 24 {
                let alert = UIAlertController(title: "Straight 2 of 5 IATA:", message: "Please enter a number to set(1~48)", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            } else if selectedSymbol == 25 {
                let alert = UIAlertController(title: "GS1-128:", message: "Please enter a number to set(1~80)", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            } else if selectedSymbol == 28 {
                let alert = UIAlertController(title: "RSSI Expanede:", message: "Please enter a number to set(4~74)", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            } else if selectedSymbol == 29 {
                let alert = UIAlertController(title: "Codablock A:", message: "Please enter a number to set(1~600)", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            } else if selectedSymbol == 30 {
                let alert = UIAlertController(title: "Codablock F:", message: "Please enter a number to set(1~2048)", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            } else if selectedSymbol == 33 {
                let alert = UIAlertController(title: "China Post:", message: "Please enter a number to set(2~80)", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
            } else if selectedSymbol == 36 {
                let alert = UIAlertController(title: "China Sensible:", message: "Please enter a number to set(1~7833)", preferredStyle: .alert)
                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                    textField.keyboardType = .numberPad
                })
                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    let textField: UITextField? = alert.textFields?.first
                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                    self.symbolTableView.reloadData()
                    alert.dismiss(animated: true) {() -> Void in }
                })
                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                    alert.dismiss(animated: true) {() -> Void in }
                })
                alert.addAction(cancel)
                alert.addAction(ok)
                
                DispatchQueue.main.async(execute: {() -> Void in
                    self.present(alert, animated: true) {() -> Void in }
                })
//            } else if selectedSymbol == 35 {
//                let alert = UIAlertController(title: "2D Code:", message: "Please enter a number to set(1~30)", preferredStyle: .alert)
//                alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
//                    textField.keyboardType = .numberPad
//                })
//                let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
//                    let textField: UITextField? = alert.textFields?.first
//                    let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
//                    paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
//                    self.symbolTableView.reloadData()
//                    alert.dismiss(animated: true) {() -> Void in }
//                })
//                let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
//                    alert.dismiss(animated: true) {() -> Void in }
//                })
//                alert.addAction(cancel)
//                alert.addAction(ok)
//
//                DispatchQueue.main.async(execute: {() -> Void in
//                    self.present(alert, animated: true) {() -> Void in }
//                })
            }
        }else if selectedSymbol == 20 {
            if indexPath.row == 2 {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                }
                else {
                    paramValue?.value = 0
                }
            } else {
                if indexPath.row == 3 {
                    let alert = UIAlertController(title: "QR Code:", message: "Please enter a number to set", preferredStyle: .alert)
                    alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                        textField.keyboardType = .numberPad
                    })
                    let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        let textField: UITextField? = alert.textFields?.first
                        let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                        paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                        self.symbolTableView.reloadData()
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    alert.addAction(cancel)
                    alert.addAction(ok)
                    
                    DispatchQueue.main.async(execute: {() -> Void in
                        self.present(alert, animated: true) {() -> Void in }
                    })
                } else {
                    let alert = UIAlertController(title: "QR Code:", message: "Please enter a number to set(1~7089)", preferredStyle: .alert)
                    alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                        textField.keyboardType = .numberPad
                    })
                    let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        let textField: UITextField? = alert.textFields?.first
                        let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                        paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                        self.symbolTableView.reloadData()
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    alert.addAction(cancel)
                    alert.addAction(ok)
                    
                    DispatchQueue.main.async(execute: {() -> Void in
                        self.present(alert, animated: true) {() -> Void in }
                    })
                }
            }
        } else if selectedSymbol == 21 {
            if indexPath.row == 2 {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                }
                else {
                    paramValue?.value = 0
                }
            }
            else {
                if indexPath.row == 3 {
                    let alert = UIAlertController(title: "Aztec:", message: "Please enter a number to set", preferredStyle: .alert)
                    alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                        textField.keyboardType = .numberPad
                    })
                    let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        let textField: UITextField? = alert.textFields?.first
                        let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                        paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                        self.symbolTableView.reloadData()
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    alert.addAction(cancel)
                    alert.addAction(ok)
                    
                    DispatchQueue.main.async(execute: {() -> Void in
                        self.present(alert, animated: true) {() -> Void in }
                    })
                }
                else {
                    let alert = UIAlertController(title: "Aztec:", message: "Please enter a number to set(1~3832)", preferredStyle: .alert)
                    alert.addTextField(configurationHandler: {(_ textField: UITextField) -> Void in
                        textField.keyboardType = .numberPad
                    })
                    let ok = UIAlertAction(title: "OK", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        let textField: UITextField? = alert.textFields?.first
                        let paramValue = self.symbolParamData![indexPath.row] as? EAParamValue
                        paramValue?.value = UInt32(Int32(Int(textField!.text ?? "") ?? 0))
                        self.symbolTableView.reloadData()
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    let cancel = UIAlertAction(title: "Cancel", style: .default, handler: {(_ action: UIAlertAction) -> Void in
                        alert.dismiss(animated: true) {() -> Void in }
                    })
                    alert.addAction(cancel)
                    alert.addAction(ok)
                    
                    DispatchQueue.main.async(execute: {() -> Void in
                        self.present(alert, animated: true) {() -> Void in }
                    })
                }
            }
        } else if selectedSymbol == 35 {
            if (indexPath.row == 1) || (indexPath.row == 2) {
                if paramValue?.value == 0 {
                    paramValue?.value = 1
                }
                else {
                    paramValue?.value = 0
                }
            }
            else if (indexPath.row == 0) || (indexPath.row == 3) {
                if indexPath.row == 0 {
                    symbolSettingPickerView.tag = PICKER_VIEW_2D
                }
                else {
                    symbolSettingPickerView.tag = PICKER_VIEW_AUSTRALIAN
                }
                topviewflag = indexPath.row
                symbolSettingPickerView.reloadAllComponents()
                symbolSettingPickerView.selectRow(Int(paramValue!.value), inComponent: 0, animated: false)
                symbolSettingPickerView.isHidden = false
                pickerViewTopView.isHidden = false
            }
        }


        symbolTableView.reloadData()
    }
    func numberOfComponents(in pickerView: UIPickerView) -> Int {
        return 1
    }
    func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        if symbolSettingPickerView.tag == PICKER_VIEW_UPCA_COUPON {
            return picker_upcaCoupon!.count
        }
        else if symbolSettingPickerView.tag == PICKER_VIEW_CODE39_CHECKCHAR {
            return picker_code39_checkchar!.count
        }
        else if symbolSettingPickerView.tag == PICKER_VIEW_CODABAR_CHECKCHAR {
            return picker_codabar_checkchar!.count
        }
        else if symbolSettingPickerView.tag == PICKER_VIEW_CODABAR_CONCATENATION {
            return picker_codabar_concatemation!.count
        }
        else if symbolSettingPickerView.tag == PICKER_VIEW_MSI_CHECKCHAR {
            return picker_msi_checkchar!.count
        }
        else if symbolSettingPickerView.tag == PICKER_VIEW_2D {
            return picker_2D!.count
        }
        else if symbolSettingPickerView.tag == PICKER_VIEW_AUSTRALIAN {
            return picker_Australian_Post!.count
        }
        else {
            return picker_code39_checkchar!.count
        }
    }
    func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String? {
        if symbolSettingPickerView.tag == PICKER_VIEW_UPCA_COUPON {
            return picker_upcaCoupon?[row] as? String
        }else if symbolSettingPickerView.tag == PICKER_VIEW_CODE39_CHECKCHAR {
            return picker_code39_checkchar?[row] as? String
        }else if symbolSettingPickerView.tag == PICKER_VIEW_CODABAR_CHECKCHAR {
            return picker_codabar_checkchar?[row] as? String
        }else if symbolSettingPickerView.tag == PICKER_VIEW_CODABAR_CONCATENATION {
            return picker_codabar_concatemation?[row] as? String
        }else if symbolSettingPickerView.tag == PICKER_VIEW_MSI_CHECKCHAR {
            return picker_msi_checkchar?[row] as? String
        }else if symbolSettingPickerView.tag == PICKER_VIEW_2D {
            return picker_2D?[row] as? String
        }else if symbolSettingPickerView.tag == PICKER_VIEW_AUSTRALIAN {
            return picker_Australian_Post?[row] as? String
        }else {
            return picker_upcaCoupon?[row] as? String
        }
    }
    func pickerView(_ pickerView: UIPickerView, viewForRow row: Int, forComponent component: Int, reusing view: UIView?) -> UIView {
        var retval = (view as? Any) as? UILabel
        if retval == nil {
            retval = UILabel(frame: CGRect(x: 0.0, y: 0.0, width: pickerView.rowSize(forComponent: component).width, height: pickerView.rowSize(forComponent: component).height))
        }
        retval?.isOpaque = false
        retval?.backgroundColor = UIColor.clear
        retval?.font = UIFont.systemFont(ofSize: 15)
        if component == 0 {
            retval?.textAlignment = NSTextAlignment.center
            if symbolSettingPickerView.tag == PICKER_VIEW_UPCA_COUPON {
                retval?.text = picker_upcaCoupon?[row] as? String
            }
            else if symbolSettingPickerView.tag == PICKER_VIEW_CODE39_CHECKCHAR {
                retval?.text = picker_code39_checkchar?[row] as? String
            }
            else if symbolSettingPickerView.tag == PICKER_VIEW_CODABAR_CHECKCHAR {
                retval?.text = picker_codabar_checkchar?[row] as? String
            }
            else if symbolSettingPickerView.tag == PICKER_VIEW_CODABAR_CONCATENATION {
                retval?.text = picker_codabar_concatemation?[row] as? String
            }
            else if symbolSettingPickerView.tag == PICKER_VIEW_MSI_CHECKCHAR {
                retval?.text = picker_msi_checkchar?[row] as? String
            }
            else if symbolSettingPickerView.tag == PICKER_VIEW_2D {
                retval?.text = picker_2D?[row] as? String
            }
            else if symbolSettingPickerView.tag == PICKER_VIEW_AUSTRALIAN {
                retval?.text = picker_Australian_Post?[row] as? String
            }
            else {
                retval?.text = picker_upcaCoupon?[row] as? String
            }
        }
        else {
            retval?.textAlignment = NSTextAlignment.left
            retval?.text = " .\(row)"
        }
        return retval ?? UIView()
    }
    @IBAction func saveBtnTapped(_ sender: UIButton) {
        let res = appDelegate.mReader?.setBarcodeParam(symbolParamData as! [Any])
        if res == ResultNoError {
            let dialog = UIAlertController(title: "Success", message: "Saved successfully", preferredStyle: .alert)
            let action = UIAlertAction(title: "OK", style: UIAlertActionStyle.default)
            dialog.addAction(action)
            self.present(dialog, animated: true, completion: nil)
        } else {
            let dialog = UIAlertController(title: "Error", message: "Failed to save", preferredStyle: .alert)
            let action = UIAlertAction(title: "OK", style: UIAlertActionStyle.default)
            dialog.addAction(action)
            self.present(dialog, animated: true, completion: nil)
            symbolTableView.reloadData()
        }
    }
    @IBAction func pickerTopViewCancelTapped(_ sender: UIButton) {
        hideSubView()
    }
    @IBAction func pickerTopViewSaveTapped(_ sender: UIButton) {
        let paramValue = symbolParamData![topviewflag] as? EAParamValue
        let idx: Int = symbolSettingPickerView.selectedRow(inComponent: 0)
        paramValue?.value = UInt32(idx)
        symbolTableView.reloadData()
        hideSubView()
    }
    func hideSubView() {
        symbolSettingPickerView.isHidden = true
        pickerViewTopView.isHidden = true
    }
    
    @objc func bluetoothDisconnected(_ notification: Notification){
        DispatchQueue.main.async(execute: {() -> Void in
            self.appDelegate.mPeripheral = nil
            self.performSegue(withIdentifier: "Barcode", sender: nil)
        })
    }
}
