//
//  InventoryViewController.swift
//  
//
//  Created by 류은주 on 2017. 12. 7..
//
let TABLE_VIEW_CONNECT = 0
let TABLE_VIEW_LOAD = 1

import UIKit

class StoredDataViewController: UIViewController, CBCentralManagerDelegate, CBPeripheralDelegate, UITableViewDataSource,  UITableViewDelegate, EADeviceInitializeDelegate, EAReaderDelegate
{

    @IBOutlet weak var storedTableView: UITableView!
    @IBOutlet weak var countLabel: UILabel!
    @IBOutlet weak var storedcountLabel: UILabel!
    @IBOutlet weak var loadBtn: UIButton!
    @IBOutlet weak var clearBtn: UIButton!
    @IBOutlet weak var removeBtn: UIButton!
    @IBOutlet weak var cancelBarItem: UIBarButtonItem!
    
    var appDelegate = UIApplication.shared.delegate as! AppDelegate
    var mQueue: DispatchQueue?
    var peripheralArray: NSMutableArray = []
    var mapTags = [AnyHashable: Any]()
    var mapBarcodes = [AnyHashable: Any]()
    var storedData = [AnyHashable]()
    var storedDataCount: Int32 = 0
    var mTotalDataCount = 0
    
    var mDevice = EADeviceBluetoothLe()
    weak var readerDelegate: EAReaderDelegate?
    
     var wrongdeviceflag = 0;
    
    fileprivate let data = NSMutableData()

    
//    var HUD = MBProgressHUD()
    var hudProgress = MBProgressHUD()
    
    var isDeviceOn = false
    var connectprocess = false
    var connectName = ""
    
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        
        
        let center = NotificationCenter.default
        center.addObserver(self, selector: #selector(bluetoothDisconnected), name: NSNotification.Name.init(rawValue: "BluetoothDisconnected"), object: nil)
        let wrongnoti = NotificationCenter.default
        wrongnoti.addObserver(self, selector: #selector(self.wrongdeviceconnected), name: NSNotification.Name.init(rawValue: "wrongdeviceconnected"), object: nil)
        
    }

    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        if appDelegate.mPeripheral != nil{
            viewmode(mode: true)
        } else {
            viewmode(mode: false)
        }
        storedTableView.reloadData()
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        if appDelegate.mReader?.getAction() != CommandStop {
            appDelegate.mReader?.stop()
        }
         NotificationCenter.default.removeObserver(self, name: NSNotification.Name(rawValue: "BluetoothDisconnected"), object: nil)
        NotificationCenter.default.removeObserver(self, name: NSNotification.Name(rawValue: "wrongdeviceconnected"), object: nil)
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    

    /*
    // MARK: - Navigation

    // In a storybodard-based application, you will often want to do a little preparation before navigation
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    */
    
    @objc   func changedActionState(_ action: CommandType) {
        if appDelegate.mReader?.getAction() != CommandStop {
            cancelBarItem.isEnabled = false
        } else {
            cancelBarItem.isEnabled = true
        }
    }
    
    @objc  func readTagResult(_ tag: String, rssi: Float, phase: Float) {
        mTotalDataCount += 1
        var item = mapTags[tag] as? EADataItem
        if item != nil {
            item?.count += 1
        } else {
            item = EADataItem()
            item?.barcodeType = BarcodeType(rawValue: 0)
            item?.doublecheck = ""
            item?.barcode = ""
            item?.count = 1
            item?.tag = tag
            storedData.append(item!)
            mapTags[tag] = item
        }

        countLabel.text = "Count: \(Int(mTotalDataCount))"
        let currProgress = (Int(mTotalDataCount) * 100) / Int(storedDataCount)
        let percent = "\(currProgress)% (\(Int(mTotalDataCount))/\(Int(storedDataCount)))"
        hudProgress.detailsLabelText = percent
        if currProgress >= 100 {
            hudProgress.hide(true)
            hudProgress.removeFromSuperview()
            appDelegate.isload = 0
        }
        storedTableView.reloadData()
    }
    @objc func barcodeScan(_ barcodeType: BarcodeType, codeId: String, barcode: String) {
        mTotalDataCount += 1
        let comparestr = "\(barcodeType)\(barcode)"
        var item = mapBarcodes[comparestr] as? EADataItem
        if item != nil {
            item?.count += 1
        }
        else {
            item = EADataItem()
            item?.barcodeType = barcodeType
            item?.barcode = barcode
            item?.doublecheck = comparestr
            item?.count = 1
            item?.tag = ""
            storedData.append(item!)
            mapBarcodes[comparestr] = item
        }
        countLabel.text = "Count: \(Int(mTotalDataCount))"
        let currProgress = (Int(mTotalDataCount) * 100) / Int(storedDataCount)
        let percent = "\(currProgress)% (\(Int(mTotalDataCount))/\(Int(storedDataCount)))"
        hudProgress.detailsLabelText = percent
        if currProgress >= 100 {
            hudProgress.hide(true)
            hudProgress.removeFromSuperview()
            appDelegate.isload = 0
        }
        storedTableView.reloadData()
    }
    func centralManagerDidUpdateState(_ central: CBCentralManager) {
        if central.state == .poweredOff {
            NotificationCenter.default.post(name: NSNotification.Name("BluetoothDisconnected"), object: self)
        }
        
        guard central.state  == .poweredOn else {
            // In a real app, you'd deal with all the states correctly
            return
        }
        // The state must be CBCentralManagerStatePoweredOn...
        // ... so start scanning
        scan()
    }
    
    /** Scan for peripherals - specifically for our service's 128bit CBUUID
     */
    func scan() {
        
        appDelegate.mCentralManager?.scanForPeripherals(withServices: nil, options: [
            CBCentralManagerScanOptionAllowDuplicatesKey : NSNumber(value: true as Bool)
            ]
        )
        
        print("Scanning started")
    }
    
    func centralManager(_ central: CBCentralManager, didDiscover peripheral: CBPeripheral, advertisementData: [String : Any], rssi RSSI: NSNumber) {
        if (peripheral.name == connectName) {
            isDeviceOn = true
        }
        if (( peripheral.name?.range(of: "AT188") != nil) || ( peripheral.name?.range(of: "AT388") != nil)) {
            // Ok, it's in range - have we already seen it?
            
            if appDelegate.mPeripheral != peripheral {
                // Save a local copy of the peripheral, so CoreBluetooth doesn't get rid of it
                
                // And connect
                print("Discover to peripheral \(peripheral)")
                
                if peripheralArray.count < 1 {
                    peripheralArray.addObjects(from: [peripheral])
                    DispatchQueue.main.async(execute: {() -> Void in
                        self.storedTableView.reloadData()
                    })
                } else {
                    var check = 0
                    for i in 0...peripheralArray.count-1{
                        if peripheral.name == (peripheralArray[i] as AnyObject).name{
                            check = 1
                        }
                    }
                    
                    if check == 0 {
                        peripheralArray.addObjects(from: [peripheral])
                        DispatchQueue.main.async(execute: {() -> Void in
                            self.storedTableView.reloadData()
                        })
                    }
                }
            }
        }
    }
    
    func centralManager(_ central: CBCentralManager, didConnect peripheral: CBPeripheral) {
        print("Peripheral Connected")
        
        data.length = 0
        
        mDevice = EADeviceBluetoothLe(peripheral: peripheral, delegate: self as EADeviceInitializeDelegate)
        // Stop scanning
        appDelegate.mCentralManager?.stopScan()
        
        print("Scanning stopped")
        
        
    }
    
    func centralManager(_ central: CBCentralManager, didDisconnectPeripheral peripheral: CBPeripheral, error: Error?) {
       DispatchQueue.main.async(execute: {() -> Void in
            NotificationCenter.default.post(name: NSNotification.Name("BluetoothDisconnected"), object: self)
//            self.bluetoothDisconnected()
            //            self.connect.setTitle("Disconnecnt", for: UIControlState.disabled)
            //            self.connect.isHidden = true
        })
        print("Disconnect Success")
        viewinitial()
        viewmode(mode: false)
    }
    func peripheral(_ peripheral: CBPeripheral, didUpdateValueFor characteristic: CBCharacteristic, error: Error?) {
        guard error == nil else {
            print("Error discovering services: \(error!.localizedDescription)")
            return
        }
        
        guard let stringFromData = NSString(data: characteristic.value!, encoding: String.Encoding.utf8.rawValue) else {
            print("Invalid data")
            return
        }
        
        // Have we got everything we need?
        if stringFromData.isEqual(to: "EOM") {
            // We have, so show the data,
            //            textView.text = String(data: data.copy() as! Data, encoding: String.Encoding.utf8)
            
            // Cancel our subscription to the characteristic
            peripheral.setNotifyValue(false, for: characteristic)
            
            // and disconnect from the peripehral
            appDelegate.mCentralManager?.cancelPeripheralConnection(peripheral)
        } else {
            // Otherwise, just add the data on to what we already have
            data.append(characteristic.value!)
            
            // Log it
            print("Received: \(stringFromData)")
        }
    }
    
    /** The peripheral letting us know whether our subscribe/unsubscribe happened or not
     */
    func peripheral(_ peripheral: CBPeripheral, didUpdateNotificationStateFor characteristic: CBCharacteristic, error: Error?) {
        print("Error changing notification state: \(String(describing: error?.localizedDescription))")
        
        // Exit if it's not the transfer characteristic
        //        guard characteristic.uuid.isEqual(transferCharacteristicUUID) else {
        //            return
        //        }
        
        // Notification has started
        if (characteristic.isNotifying) {
            print("Notification began on \(characteristic)")
        } else { // Notification has stopped
            print("Notification stopped on (\(characteristic))  Disconnecting")
            appDelegate.mCentralManager?.cancelPeripheralConnection(peripheral)
        }
    }
    func didCompleteInitialize(_ error: Error!) {
        appDelegate.mReader = EAReader(device: mDevice, delegate: readerDelegate)
        print("didCompleteInitialize finish")
        appDelegate.mReader?.setDelegate(self)
        
        DispatchQueue.main.async(execute: {() -> Void in
            if(self.wrongdeviceflag == 0){
                self.loadBtn.setTitle("LOAD", for: UIControlState.normal)
                self.viewinitial()
                self.viewmode(mode: true)
                self.appDelegate.mReader?.setTagDataType(TAG_DATA_TYPE_ASCII)
                self.storedTableView.reloadData()
                self.storedDataCount = (self.appDelegate.mReader?.storedCount())!
                self.storedcountLabel.text = "Stored Count: \(self.storedDataCount)"
            }else {
                self.loadBtn.setTitle("SEARCH", for: UIControlState.normal)
//                self.disconnect()
                self.wrongdeviceflag = 0;
            }
            
            self.hudProgress.hide(true)
        })
    }
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if(storedTableView.tag == TABLE_VIEW_LOAD){
            return storedData.count
        } else {
            return peripheralArray.count
        }
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell : StoredTableViewCell = tableView.dequeueReusableCell(withIdentifier: "StoredCell", for: indexPath) as! StoredTableViewCell
        if(storedTableView.tag == TABLE_VIEW_LOAD){
            let item = storedData[indexPath.row] as? EADataItem
            if item != nil {
                if item?.tag == "" {
                    cell.tagValue.text = item?.barcode
                } else {
                    cell.tagValue.text = item?.tag
                }
                if ((item?.barcodeType)!.rawValue) != 0 {
                    cell.codeID.text = EABarcodeType.getString((item?.barcodeType)!)
                } else {
                    cell.codeID.text = ""
                }
                cell.tagCount.text = "\(String(describing: item!.count))"
            }
        } else {
            cell.tagValue.text = (peripheralArray[indexPath.item] as AnyObject).name
            cell.tagCount.text = ""
            cell.codeID.text = ""
        }
        return cell
    }
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if(storedTableView.tag == TABLE_VIEW_CONNECT){
//        appDelegate.mCentralManager?.stopScan()
//        appDelegate.mCentralManager?.connect(peripheralArray[indexPath.item] as! CBPeripheral, options: nil)
//        appDelegate.mPeripheral = peripheralArray[indexPath.item] as? CBPeripheral
//        appDelegate.devicename = (peripheralArray[indexPath.item] as AnyObject).name
//
//            DispatchQueue.main.async(execute: {() -> Void in
//                self.hudProgress = MBProgressHUD.showAdded(to: self.view, animated: true);
//                self.hudProgress.labelText = "Connecting..."
//                self.hudProgress.show(true)
//            })
            isDeviceOn = false
            if(connectprocess == true) {
                return
            } else {
                connectprocess = true
                appDelegate.mCentralManager?.stopScan()
                connectName = (peripheralArray[indexPath.item] as AnyObject).name
                startScanDevice()
                DispatchQueue.main.asyncAfter(deadline: DispatchTime.now() + Double(1 * Double(NSEC_PER_SEC)) / Double(NSEC_PER_SEC), execute: {() -> Void in
                    self.connectDevice(indexPath.row)
                })
            }
        }
    }
    func viewmode(mode:Bool){
        if(mode == true){
            self.storedTableView.tag = TABLE_VIEW_LOAD
            self.loadBtn.setTitle("LOAD", for: UIControlState.normal)
        } else {
            self.storedTableView.tag = TABLE_VIEW_CONNECT
            self.loadBtn.setTitle("SEARCH", for: UIControlState.normal)
        }
//        DispatchQueue.global(qos: .default).async(execute: {() -> Void in
        
                DispatchQueue.main.async(execute: {() -> Void in
                    self.clearBtn.isHidden = !mode
                    self.removeBtn.isHidden = !mode
                    self.cancelBarItem.isEnabled = mode
                    self.countLabel.isHidden = !mode
                    self.storedcountLabel.isHidden = !mode
                self.storedTableView.reloadData()
            })
//        })
    }
    func viewinitial(){
        
        storedData.removeAll()
        mapTags.removeAll()
        mapBarcodes.removeAll()
        mTotalDataCount = 0
        DispatchQueue.main.async(execute: {() -> Void in
        self.countLabel.text = String (format:"Count: %d",self.mTotalDataCount)
        })
        self.peripheralArray.removeAllObjects()
    }
    func disconnect() {
        if appDelegate.mReader != nil {
            appDelegate.mReader?.disconnect()
            appDelegate.mReader = nil
        }
        
        // cc 종료 확인 필요........
        if appDelegate.mPeripheral != nil {
            appDelegate.mCentralManager?.cancelPeripheralConnection(appDelegate.mPeripheral!)
            appDelegate.mPeripheral = nil
        }
    }
    @objc func bluetoothDisconnected(_ notification: Notification){
    
        hudProgress.hide(true)
        hudProgress.removeFromSuperview()
            
        appDelegate.mReader = nil
        appDelegate.mPeripheral = nil
        let dialog = UIAlertController(title: "Connect State", message: "BT Disconnected!!!", preferredStyle: .alert)
        let action = UIAlertAction(title: "OK", style: UIAlertActionStyle.default)
        dialog.addAction(action)
        self.present(dialog, animated: true, completion: nil)
        
//        performSegue(withIdentifier: "BTConnect", sender: nil)
    }
//    func bluetoothDisconnected(){
//        appDelegate.mReader = nil
//        appDelegate.mPeripheral = nil
//        let dialog = UIAlertController(title: "Connect State", message: "BT Disconnected!!!", preferredStyle: .alert)
//        let action = UIAlertAction(title: "OK", style: UIAlertActionStyle.default)
//        dialog.addAction(action)
//        self.present(dialog, animated: true, completion: nil)
//    }

    @IBAction func cancelBarItemTapped(_ sender: UIBarButtonItem) {
//        appDelegate.mReader?.disconnect()
//
//        if appDelegate.mPeripheral != nil {
//            appDelegate.mCentralManager?.cancelPeripheralConnection(appDelegate.mPeripheral!)
//            appDelegate.mPeripheral = nil
//        }
        disconnect()
    }
    @IBAction func loadBtnTapped(_ sender: UIButton) {
        if(storedTableView.tag == TABLE_VIEW_CONNECT){
        if loadBtn.currentTitle == "SEARCH" {
            peripheralArray.removeAllObjects()
            mQueue = DispatchQueue(label: "com.atid.bluetooth")
            appDelegate.mCentralManager = CBCentralManager(delegate: self, queue: mQueue)
            DispatchQueue.main.async(execute: {() -> Void in
                self.loadBtn.setTitle("STOP", for: UIControlState.normal)
            })
        } else {
            appDelegate.mCentralManager?.stopScan()
            if peripheralArray.count >= 1{
                for i in 0...peripheralArray.count-1 {
                    print("Array: \(peripheralArray[i])")
                }
            }
            DispatchQueue.main.async(execute: {() -> Void in
                self.loadBtn.setTitle("SEARCH", for: UIControlState.normal)
            })
        }
        } else {
            if storedDataCount == 0 {
                return
            }
            appDelegate.isload = 1
            viewinitial()
   
            hudProgress = MBProgressHUD(view: navigationController?.view)
            hudProgress.labelText = "Loading..."
            hudProgress.progress = 0.0
            hudProgress.detailsLabelText = "0%"
            DispatchQueue.global(qos: .default).async(execute: {() -> Void in
                self.appDelegate.mReader?.loadStoredData()
                DispatchQueue.main.async(execute: {() -> Void in
                    self.hudProgress.show(true)
                    self.navigationController?.view.addSubview(self.hudProgress)
                })
            })
            
        }
    }
    @IBAction func clearBtnTapped(_ sender: UIButton) {
        storedData.removeAll()
        mapTags.removeAll()
        mapBarcodes.removeAll()
        storedTableView.reloadData()
        mTotalDataCount = 0
        countLabel.text = String (format:"Count: %d ",mTotalDataCount)
    }
    
    @IBAction func removeBtnTapped(_ sender: UIButton) {
        if storedDataCount == 0 {
            return
        }
        
        hudProgress = MBProgressHUD(view: navigationController?.view)
        hudProgress.labelText = "Removing..."
        hudProgress.show(true)
        navigationController?.view.addSubview(hudProgress)
        DispatchQueue.global(qos: .default).async(execute: {() -> Void in
            self.appDelegate.mReader?.deleteAllStoredData()
            DispatchQueue.main.async(execute: {() -> Void in
                self.storedDataCount = (self.appDelegate.mReader?.storedCount())!
                self.viewinitial()
                self.storedcountLabel.text = "Stored Count: \(self.storedDataCount)"
                self.self.storedTableView.reloadData()
                self.hudProgress.hide(true)
                self.hudProgress.removeFromSuperview()
            })
        })
        
    }

    @objc func wrongdeviceconnected(_ notification: Notification) {
//        appDelegate.mReader?.disconnect()
        
//        if appDelegate.mPeripheral != nil {
//            appDelegate.mCentralManager?.cancelPeripheralConnection(appDelegate.mPeripheral!)
//            appDelegate.mPeripheral = nil
//        }
        wrongdeviceflag = 1
    }
    func startScanDevice() {
        // Make Scan Peripheral Option...
        let options = [
            CBCentralManagerScanOptionAllowDuplicatesKey : (0)
        ]
        //        bleready = 1
        // Start Scan Peripheral Device
        appDelegate.mCentralManager?.scanForPeripherals(withServices: nil, options: options)
        //    }
    }
    func connectDevice(_ index: Int) {
        appDelegate.mCentralManager?.stopScan()
        DispatchQueue.main.async(execute: {() -> Void in
            self.loadBtn.setTitle("SEARCH", for: UIControlState.normal)
        })
        if isDeviceOn != true {
            let Alert = UIAlertController(title: "Device Power Off", message: "Please check the power of device you want to connect", preferredStyle: .alert)
            let action = UIAlertAction(title: "OK", style: UIAlertActionStyle.default)
            Alert.addAction(action)
            self.present(Alert, animated: true, completion: nil)

            connectprocess = false
            
//            peripheralArray.removeAllObjects()
//            storedTableView.reloadData()
            return
        }
        
        navigationController?.view.addSubview(hudProgress)
        DispatchQueue.global(qos: .default).async(execute: {
            self.appDelegate.mCentralManager?.connect(self.peripheralArray[index] as! CBPeripheral, options: nil)
            self.appDelegate.mPeripheral = self.peripheralArray[index] as? CBPeripheral
            self.appDelegate.devicename = (self.peripheralArray[index] as AnyObject).name
            
            DispatchQueue.main.async(execute: {() -> Void in
                self.hudProgress = MBProgressHUD.showAdded(to: self.view, animated: true);
                self.hudProgress.labelText = "Connecting..."
                self.hudProgress.show(true)
            })
            self.connectprocess = false
        })
    }
}

class EADataItem: NSObject {
    var barcodeType: BarcodeType = BarcodeTypeNoRead
    var barcode = ""
    var doublecheck = ""
    var tag = ""
    var count: Int = 0
}
